{ Advanced\Fractal - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    A fractal painter triggered by a timer.
                Use Alt+F4 to close this program.

    Task.       Try out your own fractals.  You will need to learn
                how to control recursive procedures.  To get pretty
                shapes, you need some knowledge of trigonometry.
}

unit Tree;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure foo(x, y, size : integer; angle : real);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}



procedure TForm1.foo(x, y, size : integer; angle : real);
var x2, y2 : Integer;
begin
  if size > 2 then
  begin
    canvas.pen.width := size div 4;
    if canvas.pen.width < 1 then canvas.pen.width := 1;
    canvas.moveto(x, y);
    canvas.lineto(round(x - size * sin(angle)), round(y - size * cos(angle)));

    foo(round(x - size * sin(angle)),
        round(y - size * cos(angle)),
        6 * size div 8,
        angle + 0.6 + random(100) / 200);

    foo(round(x - size * sin(angle)),
        round(y - size * cos(angle)),
        6 * size div 8,
        angle - 0.6 + random(100) / 200)
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  randomize;
  cursor := crNone
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  canvas.pen.color := $1000 * random(256) + random(256);
  { CALL THE RECURSIVE FRACTAL IMAGE                               }
  {   X              Y       Size          Angle }
  foo(random(width), height, random(height div 4), -random(100) / 300)
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  { ERASE PREVIOUS PICTURE BY DRAWING A BIG RECTANGLE }
  canvas.pen.color := clBlack;
  canvas.brush.color := clBlack;
  canvas.rectangle(0, 0, width, height);

  canvas.pen.color := $1000 * random(256) + random(256);
  { CALL THE RECURSIVE FRACTAL IMAGE                               }
  {   X            Y              Size   Angle }
  foo(random(width), height, height div 4, -random(100) / 300)
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  { ERASE PREVIOUS PICTURE BY DRAWING A BIG RECTANGLE }
  canvas.pen.color := clBlack;
  canvas.brush.color := clBlack;
  canvas.rectangle(0, 0, width, height);
end;

end.

