{ Advanced\Erd - Example program from http://www.SoftwareForEducation.com/ }

{
    Example    An entity relationship diagram editor.

               A new class called TErd is created based on TPaintBox.
               These objects are created at run time by right clicking.
               This technique is very powerful and many problems can be
               solved this way.

    Task 1     Add a diamond shaped box to represent a relationship.

    Task 2     Add a new object that knows how to draw links between
               existing objects.
}

unit Edrf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, ExtCtrls, StdCtrls;

type
  TThingy = (entity, attribute, primary, foreign);

  TErd = class(TPaintBox)
    next : TErd;
    prev : TErd;

    constructor create(aOwner : TComponent); override;
    destructor destroy; override;

    procedure paint; override;
    procedure MouseDown(Button: TMouseButton;
                        Shift: TShiftState;
                        X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;
                        X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
                      X, Y: Integer); override;
    procedure DblClick; override;
  private
    startX, startY : Integer;
    startW, startH : Integer;
    caption : string;
    thingy  : TThingy;
  end;

  TFormMain = class(TForm)
    PopupMenuMain: TPopupMenu;
    NewEntity1: TMenuItem;
    PopupMenuAttribute: TPopupMenu;
    Delete1: TMenuItem;
    Caption1: TMenuItem;
    N4: TMenuItem;
    Attribute1: TMenuItem;
    PrimaryKey1: TMenuItem;
    ForeignKey1: TMenuItem;
    N5: TMenuItem;
    NewAttribute1: TMenuItem;
    PopupMenuEntity: TPopupMenu;
    Caption2: TMenuItem;
    N3: TMenuItem;
    Delete2: TMenuItem;
    procedure FormDestroy(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure NewEntity1Click(Sender: TObject);
    procedure Caption1Click(Sender: TObject);
    procedure Entity1Click(Sender: TObject);
    procedure Attribute1Click(Sender: TObject);
    procedure PrimaryKey1Click(Sender: TObject);
    procedure ForeignKey1Click(Sender: TObject);
    procedure NewLink1Click(Sender: TObject);
    procedure LinlTo1Click(Sender: TObject);
    procedure NewAttribute1Click(Sender: TObject);
    procedure Caption2Click(Sender: TObject);
    procedure Delete2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    printing : boolean;

    head    : TErd;
    curr    : TErd;
    thePrev : TErd;

    XX, YY : Integer;
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}


procedure TErd.MouseDown(Button: TMouseButton;
                         Shift: TShiftState;
                         X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X, Y);

  startX := X;
  startY := Y;
  startW := width;
  startH := height;

  FormMain.curr := self;

  if shift = [ssRight] then
  begin
    if thingy = entity then
    begin
      FormMain.popupMenuEntity.popUp(FormMain.left + self.left + X,
                                     FormMain.top + self.top + Y)
    end
    else
    begin
      FormMain.popupMenuAttribute.popUp(FormMain.left + self.left + X,
                                        FormMain.top + self.top + Y)
    end
  end;
end;

procedure TErd.MouseMove(Shift: TShiftState;
                         X, Y: Integer);
begin
  inherited MouseMove(Shift, X, Y);

  if Shift = [] then
  begin
    if (X > width - 10) AND (Y > height - 10) then
    begin
      cursor := crSizeNWSE
    end
    else
    begin
      cursor := crDefault
    end
  end;

  if Shift = [ssLeft] then
  begin
    if cursor = crDefault then
    begin
      left := left - (startX - X);
      top  := top  - (startY - Y);
    end
    else
    begin
      width  := startW - (startX - X);
      height := startH - (startY - Y);
    end
  end;
end;

procedure TErd.MouseUp(Button: TMouseButton; Shift: TShiftState;
                       X, Y: Integer);
begin
  inherited MouseUp(Button, Shift, X, Y);

  if top  < 0 then top  := 0;
  if left < 0 then left := 0;

  if top  > formMain.clientHeight - height then
    top := formMain.clientHeight - height;
  if left > formMain.clientWidth - width   then
    left := formMain.clientWidth - width;

  if width  < 10 then width  := 10;
  if height < 10 then height := 10;

  formMain.invalidate
end;

procedure TErd.DblClick;
begin
  inherited DblClick;

  if thingy = entity then
  begin
    formMain.thePrev := self
  end
  else
  begin
    messageDlg('Attributes must be linked to an entity.', mtError, [mbOK], 0)
  end
end;

constructor TErd.create(aOwner : TComponent);
begin
  inherited create(aOwner);

  popupMenu := Nil;
  caption   := '';
  thingy    := attribute;      { Default }

  if FormMain.head = Nil then
  begin
    next := Nil;
    prev := Nil;
    FormMain.head := self;
    FormMain.curr := self;
    FormMain.InsertControl(Self)
  end
  else
  begin
    next := FormMain.head;
    prev := Nil;
    next.prev := self;
    FormMain.head := self;
    FormMain.curr := self;
    FormMain.InsertControl(Self)
  end;

  top    := random(FormMain.ClientHeight);
  left   := random(FormMain.ClientWidth);
  width  := 100;
  height := 40
end;

destructor TErd.destroy;
begin
  if FormMain.head = Nil then
  begin
    messageDlg('This can never happen.', mtError, [mbOK], 0)
  end
  else if (next = Nil) AND (prev = Nil) then
  begin
    FormMain.RemoveControl(Self);
    FormMain.head := Nil;
    FormMain.curr := Nil
  end
  else if prev = Nil then
  begin
    FormMain.RemoveControl(Self);
    FormMain.head := next;
    FormMain.head.prev := Nil
  end
  else if next = Nil then
  begin
    FormMain.RemoveControl(Self);
    prev.next := Nil
  end
  else
  begin
    FormMain.RemoveControl(Self);
    prev.next := next;
    next.prev := prev
  end;

  inherited destroy
end;

procedure TErd.paint;
begin
  inherited paint;

  canvas.pen.color   := clBlack;
  canvas.brush.color := clWhite;

  if thingy = entity then
  begin
    canvas.rectangle(0, 0, Width, Height);
    canvas.textOut(width  div 2 - canvas.TextWidth(caption)  div 2,
                   height div 2 - canvas.TextHeight(caption) div 2,
                   caption);
  end
  else if thingy = attribute then
  begin
    canvas.ellipse(0, 0, Width, Height);
    canvas.textOut(width  div 2 - canvas.TextWidth(caption)  div 2,
                   height div 2 - canvas.TextHeight(caption) div 2,
                   caption);
  end
  else if thingy = primary then
  begin
    canvas.ellipse(0, 0, Width, Height);
    canvas.textOut(width  div 2 - canvas.TextWidth(caption)  div 2,
                   height div 2 - canvas.TextHeight(caption) div 2,
                   caption);

    canvas.moveTo(width  div 2 - canvas.TextWidth(caption)  div 2,
                  height div 2 + canvas.TextHeight(caption) div 2 + 1);
    canvas.lineTo(width  div 2 + canvas.TextWidth(caption)  div 2,
                  height div 2 + canvas.TextHeight(caption) div 2 + 1);

    canvas.moveTo(width  div 2 - canvas.TextWidth(caption)  div 2,
                  height div 2 + canvas.TextHeight(caption) div 2 + 4);
    canvas.lineTo(width  div 2 + canvas.TextWidth(caption)  div 2,
                  height div 2 + canvas.TextHeight(caption) div 2 + 4);
  end
  else if thingy = foreign then
  begin
    canvas.ellipse(0, 0, Width, Height);
    canvas.textOut(width  div 2 - canvas.TextWidth(caption)  div 2,
                   height div 2 - canvas.TextHeight(caption) div 2,
                   caption);

    canvas.moveTo(width  div 2 - canvas.TextWidth(caption)  div 2,
                  height div 2 + canvas.TextHeight(caption) div 2 + 1);
    canvas.lineTo(width  div 2 + canvas.TextWidth(caption)  div 2,
                  height div 2 + canvas.TextHeight(caption) div 2 + 1);
  end;

  if not formMain.printing then
  begin
    canvas.rectangle(width - 4, height - 4, width, height)
  end
end;

procedure TFormMain.FormDestroy(Sender: TObject);
var scan, pDel : TErd;
begin
  scan := head;

  while scan <> nil do
  begin
    pDel := scan;
    scan := scan.next;
    pDel.free
  end
end;

procedure TFormMain.Delete1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.Free
  end;
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  curr    := nil;
  head    := nil;
  thePrev := nil;

  printing := false
end;

procedure TFormMain.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if shift = [ssRight] then
  begin
    popupMenuMain.popUp(FormMain.left + X,
                        FormMain.top + Y)
  end;

  XX := X;
  YY := Y
end;

procedure TFormMain.NewEntity1Click(Sender: TObject);
Var aNew : TErd;
begin
  aNew := TErd.create(FormMain);
  aNew.Left := XX;
  aNew.Top  := YY;
  aNew.Thingy := entity
end;

procedure TFormMain.Caption1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.caption := InputBox('Label', '', curr.caption);
  end;

  curr.invalidate
end;

procedure TFormMain.Entity1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.thingy := entity
  end;

  curr.invalidate
end;

procedure TFormMain.Attribute1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.thingy := attribute
  end;

  curr.invalidate
end;

procedure TFormMain.PrimaryKey1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.thingy := primary
  end;

  curr.invalidate
end;

procedure TFormMain.ForeignKey1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.thingy := foreign
  end;

  curr.invalidate
end;

procedure TFormMain.NewLink1Click(Sender: TObject);
begin
  {}
end;

procedure TFormMain.LinlTo1Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    if curr.thingy = entity then
    begin
      thePrev := curr
    end
    else
    begin
      messageDlg('Attributes must be linked to an entity.', mtError, [mbOK], 0)
    end
  end;
end;

procedure TFormMain.NewAttribute1Click(Sender: TObject);
Var aNew : TErd;
begin
  aNew := TErd.create(FormMain);
  aNew.Left := XX;
  aNew.Top  := YY;
  aNew.Thingy := attribute
end;

procedure TFormMain.Caption2Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.caption := InputBox('Label', '', curr.caption);
  end;

  curr.invalidate
end;

procedure TFormMain.Delete2Click(Sender: TObject);
begin
  if curr <> Nil then
  begin
    curr.Free
  end
end;

end.
