{ Advanced\Editor - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    A text editor with selectable font.  Printing is possible
               and some attempt has been made to number the pages correctly
               taking the font size into account.  The font is saved along
               with the editor text.

    TASKS      If you need to print more than one page of text, this
               program illustrates techniques.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Printers, StdCtrls, FileCtrl, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    SaveDialog2: TSaveDialog;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    New1: TMenuItem;
    Label1: TLabel;
    FontDialog1: TFontDialog;
    Edit1: TMenuItem;
    FontName1: TMenuItem;
    PrintDialog1: TPrintDialog;
    Print1: TMenuItem;
    N2: TMenuItem;
    procedure SaveAs1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure FontName1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure saveFile(aName : String);
    procedure loadFile(aName : String);
  end;

var
  Form1: TForm1;
  Modified : Boolean;

implementation

{$R *.DFM}

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  if saveDialog2.execute then
  begin
    saveFile(saveDialog2.fileName);
  end;

  memo1.modified := false
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  if caption = 'Untitled' then
  begin
    SaveAs1Click(Sender);
  end
  else
  begin
    saveFile(caption);
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Form1.Left := Screen.Width div 2 - Form1.Width div 2;
  Form1.Top := 60;
  Label1.Caption := 'New File';
  caption := 'Untitled';
  memo1.modified := false;
  Memo1.Left := 7;
  Memo1.Top := 7;
  Memo1.Width := (Form1.Width -19);
  Memo1.Height := (Form1.Height-70);
end;

procedure TForm1.Open1Click(Sender: TObject);

        procedure openTheFile;
        begin
          if openDialog1.execute then
          begin
            loadFile(openDialog1.fileName)
          end;

          memo1.modified := false
        end;

var response : word;
begin
  if memo1.modified then
  begin
    response := messageDlg('Save Changes Before Exiting?', mtWarning, [mbYes, mbNo, mbcancel], 0);

    if response = mrYes then
    begin
      Save1Click(Sender);
      Label1.Caption := 'Saved';
      openTheFile
    end
    else if response = mrNo then
    begin
      openTheFile
    end
    else if response = mrCancel then
    begin
      { Do nothing }
    end
  end
  else
  begin
    openTheFile
  end
end;

procedure TForm1.Exit1Click(Sender: TObject);
var response : word;
begin
  if memo1.modified then
  begin
    response := messageDlg('Save Changes Before Exiting?', mtWarning, [mbYes, mbNo, mbcancel], 0);

    if response = mrYes then
    begin
      Save1Click(Sender);
      CLOSE;
    end
    else if response = mrNo then
    begin
      CLOSE
    end
    else if response = mrCancel then
    begin
      { Do nothing }
    end
  end
  else
  begin
    CLOSE
  end
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  if memo1.modified then
  begin
    Label1.Caption := 'Modified';
  end
  else
  begin
    Label1.Caption := 'Unchanged';
  end
end;

procedure TForm1.New1Click(Sender: TObject);
Var Response : Word;
begin
if memo1.modified then
  begin
    response := messageDlg('Save Changes Before Exiting?', mtWarning, [mbYes, mbNo, mbcancel], 0);

    if response = mrYes then
    begin
      Save1Click(Sender);
      New1Click(Sender);
    end
    else if response = mrNo then
    begin
     Modified := false;
     Memo1.Lines.Clear;

     Label1.Caption := 'New File';
     Form1.Caption := 'Untitled'
    end
    else if response = mrCancel then
    begin
      { Do nothing }
    end
  end
  else
  begin
    modified := false;
    Form1.Caption := 'Untitled';
    Memo1.Lines.Clear;

    Label1.Caption := 'New File';
  end;
end;

procedure TForm1.FontName1Click(Sender: TObject);
begin
  if FontDialog1.execute then
  begin
    memo1.Font := fontdialog1.font;
  end
end;

procedure TForm1.Print1Click(Sender: TObject);
var
  MyFile     : TextFile;
  i          : Integer;
  textHeight : Integer;
  lineCount  : Integer;

        procedure startPage(n : integer);
        begin
(*        Writeln(MyFile, 'Page ' + IntToStr(n + 1));
          Writeln(MyFile); { Blank Line }                   *)
        end;

begin
  if printDialog1.execute then
  begin
    printer.canvas.font := memo1.font;
    textHeight := printer.canvas.textHeight('Any Old Sample Text');
(*  lineCount  := printer.pageHeight div textHeight - 4;   *)
    lineCount  := printer.pageHeight div textHeight - 2;

    AssignPrn(MyFile);
    Rewrite(MyFile);

    i := 0;
    while i < memo1.lines.count do
    begin
      if (i mod lineCount) = 0 then
      begin
        startPage(i div lineCount);
      end;

      Writeln(MyFile, memo1.lines[i]);
      i := i + 1;

      { Page Throw }
      if (i mod lineCount) = 0 then
      begin
        System.CloseFile(MyFile);

        AssignPrn(MyFile);
        Rewrite(MyFile)
      end
    end;

    System.CloseFile(MyFile);
  end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  Memo1.Left := 7;
  Memo1.Top := 7;
  Memo1.Width := (Form1.Width -19);
  Memo1.Height := (Form1.Height-70);
end;

procedure TForm1.saveFile(aName : String);
var f : textFile;
begin
  memo1.lines.saveToFile(aName);
  caption := aName;
  memo1.modified := false;

  { Save Font }
  assignFile(f, ChangeFileExt(aName, '.FNT'));
  reWrite(f);

  writeln(f, memo1.font.name);
  writeln(f, memo1.font.size);
  if fsBold      in memo1.font.style then writeln(f, 'Bold')      else writeln(f);
  if fsItalic    in memo1.font.style then writeln(f, 'Italic')    else writeln(f);
  if fsUnderline in memo1.font.style then writeln(f, 'Underline') else writeln(f);
  if fsStrikeOut in memo1.font.style then writeln(f, 'StrikeOut') else writeln(f);
  writeln(f, memo1.font.color);

  closeFile(f)
end;

procedure TForm1.loadFile(aName : String);
var f : textFile;
    s : string;
    n : longInt;
begin
  memo1.lines.loadFromFile(aName);
  caption := openDialog1.fileName;

  { Load Font }
  assignFile(f, ChangeFileExt(aName, '.FNT'));
  reSet(f);

  { FONT NAME }
  readln(f, s);
  memo1.font.name := s;

  { FONT SIZE }
  readln(f, n);
  memo1.font.size := n;

  { FONT STYLE }
  memo1.font.style := [];   { Empty Set }
  readln(f, s);
  if s = 'Bold'   then memo1.font.style := memo1.font.style + [fsBold];

  readln(f, s);
  if s = 'Italic' then memo1.font.style := memo1.font.style + [fsItalic];

  readln(f, s);
  if s = 'Underline' then memo1.font.style := memo1.font.style + [fsUnderline];

  readln(f, s);
  if s = 'StrikeOut' then memo1.font.style := memo1.font.style + [fsStrikeOut];

  { FONT COLOR }
  readln(f, n);
  memo1.font.color := n;

  closeFile(f)
end;

end.

