{ Advanced\DragDrop - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    Dragging and dropping.  Text example.  Ddrop_f.

    TASKS      Write your own drag and drop program.  For example
               drag some text from one label to another.
}

unit Ddrop_f;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure Label1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Label2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Label1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  { Begin dragging if there is a left mouse press. }
  if shift = [ssLeft] then
  begin
    (sender as TLabel).beginDrag(true)
  end
end;

procedure TForm1.Label2DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  { If dragging is taking place and the source object is label1 then
    set Accept to true.  This changes the mouse cursor to the drag-drop
    shape.  Any other source will not be accepted and a no-entry mouse
    cursor will appear. }
  if (source as TLabel) = label1 then
  begin
    accept := true
  end
  else
  begin
    accept := false
  end
end;

procedure TForm1.Label2DragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  { This code process the drop event.  If the source object is Label1
    the drop code runs.  Any other source will be ignored.  The code
    below copies the source label caption to the sender label caption.
    The source label caption is set to Foo to make something visible
    happen on the screen. }
  if (Source as TLabel) = Label1 then
  begin
    (Sender as TLabel).Caption := 'Drop succeeded.  ' +
                                  (Source as TLabel).Caption;
    (Source as TLabel).Caption := 'Foo.'
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  { Reset the label captions to their start up values. }
  label1.caption := 'Drag this text from here.';
  label2.caption := 'Drop it here.';
end;

end.
