{ Advanced\DragDrop - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    Dragging and dropping.  Graphics example.

    TASKS      Write your own drag and drop program.  For example
               drag some text from one label to another.
}

unit D2drop_f;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    PaintBox2: TPaintBox;
    Label1: TLabel;
    procedure PaintBox1Paint(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure PaintBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  TPaintBox(Sender).Canvas.Brush.Color := clRed;
  TPaintBox(Sender).Canvas.Ellipse(3,
                                   3,
                                   TPaintBox(Sender).Width - 3,
                                   TPaintBox(Sender).Height - 3);
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  PaintBox1.Canvas.Pen.Color := random(256) * $10000 +
                                random(256) * $100 +
                                random(256);
  PaintBox1.Invalidate;
  PaintBox1.beginDrag(false)
end;

procedure TForm1.PaintBox2DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if TPaintBox(Source) = PaintBox1 then
  begin
    accept := true
  end
  else
  begin
    accept := false
  end;
end;

procedure TForm1.PaintBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  if TPaintBox(Source) = PaintBox1 then
  begin
    TPaintBox(Sender).Canvas.pen.color   := TPaintBox(Source).Canvas.pen.color;
    TPaintBox(Sender).invalidate;
  end
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  paintBox1.canvas.pen.width := 5;
  paintBox2.canvas.pen.width := 5
end;

end.
