{ Advanced\Drag - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    Drag and resize a graphic object using the mouse.
                This program implements snap to grid.

    Task.       Extend the program to display your own college
                or school timetable.  You might find this is
                almost impossible because of the amount of code
                that has to be written.  The solution is to create
                your own paintBox which knows how to be moved and
                resized.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  myMode = (chNone, chDay, chDuration, chStart);

  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    PaintBox1: TPaintBox;
    PaintBox2: TPaintBox;
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PaintBox1Paint(Sender: TObject);
    procedure PaintBox2Paint(Sender: TObject);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  startX, startY, startWidth : Integer;
  chMode : myMode;

implementation

{$R *.DFM}

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if shift = [ssLeft] then
  begin
    startX := X;
    startY := Y;
    startWidth := paintBox1.Width
  end
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Shift = [] then
  begin
    if X > paintBox1.Width - 5 then
    begin
      paintBox1.cursor := crSizeWE;
      chMode := chDuration
    end
    else if X < 5 then
    begin
      paintBox1.cursor := crSizeWE;
      chMode := chStart
    end
    else if Y < 5 then
    begin
      paintBox1.cursor := crSizeNS;
      chMode := chDay
    end
    else
    begin
      paintBox1.cursor := crDefault;
      chMode := chNone
    end
  end;

  if Shift = [ssLeft] then
  begin
    case chMode of
      chStart:
      begin
        paintBox1.left := paintBox1.left - (startX - X);
        paintBox1.left  := (paintBox1.left  div  5) *  5;
      end;

      chDuration:
      begin
        paintBox1.width := startWidth - (startX - X);
        paintBox1.width := (paintBox1.width div  5) *  5
      end;

      chDay:
      begin
        paintBox1.top  := paintBox1.top  - (startY - Y)
      end
    end
  end
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  paintBox1.Canvas.Brush.Color := clSilver;
  paintBox1.Canvas.Rectangle(0, 0, paintBox1.Width, paintBox1.Height);
  paintBox1.Canvas.TextOut(2, 1,  'DCS2');
  paintBox1.Canvas.TextOut(2, 16, 'Prog 4');
  paintBox1.Canvas.TextOut(2, 31, 'Bauers')
end;

procedure TForm1.PaintBox2Paint(Sender: TObject);
Var i : Integer;
begin
  with paintBox2.canvas do
  begin
    brush.color := clWhite;
    pen.color := clGray;
    rectangle(0, 0, paintBox2.Width, paintBox2.Height);

    for i := 0 to 8 do
    begin
      moveto(0, i * 48);
      lineto(paintBox2.width, i * 48)
    end;

    for i := 0 to 288 do
    begin
      if i mod 12 = 0 then
      begin
        pen.color := clBlack
      end
      else if i mod 6 = 0 then
      begin
        pen.color := clGray
      end
      else
      begin
        pen.color := clSilver
      end;

      moveto(5*i, 0);
      lineto(5*i, paintBox2.height)
    end;
    pen.color := clBlack
  end
end;

procedure TForm1.PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  paintBox1.left  := (paintBox1.left  div  5) *  5;
  paintBox1.top   := (paintBox1.top   div 48) * 48;
  paintBox1.width := (paintBox1.width div  5) *  5;
  if paintBox1.Width < 5 then paintBox1.Width := 5
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  paintBox1.left  := (paintBox1.left  div  5) *  5;
  paintBox1.top   := (paintBox1.top   div 48) * 48;
  paintBox1.width := (paintBox1.width div  5) *  5
end;

end.
