{ Advanced\Dec2Bin - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    Decimal to binary number conversion.  The binary is
               shown in four byte chunks.  The input is range checked.

    TASKS      Write a program that converts binary to decimal.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    LabelInput: TLabel;
    EditInput: TEdit;
    LabelOutput: TLabel;
    LabelOutputLabel: TLabel;
    procedure EditInputChange(Sender: TObject);
    procedure EditInputKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }

    Function Convert(decimalNumber : Longint) : String;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Function TForm1.Convert(decimalNumber : longInt) : String;
Var i  : longInt;
    s  : String;
    s2 : String;
begin
  s := '';
  i := decimalNumber;

  repeat
    if (i mod 2 = 0) then
    begin
      s := '0' + s
    end
    else
    begin
      s := '1' + s
    end;

    i := i div 2;
  until i = 0;

  for i := length(s) to 15 do
  begin
    s := '0' + s
  end;

  s2 := '';

  for i := 1 to length(s) do
  begin
    s2 := s2 + s[i];

    if i mod 4 = 0 then
    begin
      s2 := s2 + ' '
    end
  end;

  result := s2
end;

procedure TForm1.EditInputChange(Sender: TObject);
var i : Integer;
    ok : boolean;
begin
  if length(editInput.Text) > 5 then
  begin
    ok := false
  end
  else
  begin
    ok := true
  end;

  if ok then
  begin
    for i := 1 to length(editInput.Text) do
    begin
      if not (editInput.Text[i] in ['0'..'9']) then
      begin
        ok := false;
        break
      end
    end
  end;

  if length(editInput.Text) = 0 then
  begin
    labelOutput.caption := '';
  end
  else if (length(editInput.Text) > 0) AND ok then
  begin
    if strToInt(editInput.Text) > 65535 then
    begin
      labelOutput.caption := 'Error in input data.';
    end
    else
    begin
      labelOutput.caption := convert(strToInt(editInput.Text))
    end
  end
  else
  begin
    labelOutput.caption := 'Error in input data.';
    messageBeep(0)
  end
end;

procedure TForm1.EditInputKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_RETURN then
  begin
    editInput.clear
  end
end;

end.
