{ Advanced\BullDisp - Example program from http://www.SoftwareForEducation.com/ }

{
    Example    A design aid.  Design text characters from A..Z and 0..9
               as well as space, period and hyphen.  Click on the
               triangles to turn them on or off.

    Task 1     Complete this program.  Add load and save buttons so the
               character designs can be kept between program runs.

    Task 2     Write another program that uses these designs to display
               text typed in, on a display of three rows and 20 columns.
               This program should load the designs from the first program.
}

unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

Const
  SPACE  = 36;
  HYPHEN = 37;
  STOP   = 38;

type
  TFormMain = class(TForm)
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    Image8: TImage;
    Image9: TImage;
    Image10: TImage;
    Image11: TImage;
    Image12: TImage;
    Image13: TImage;
    Image14: TImage;
    Image15: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    ButtonStore: TButton;
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ButtonStoreClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }

    data : array[0..38] of array[1..8] of BYTE;
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

        procedure setLabel(n : Integer);
        begin
          if sender = Image1 then
          begin
            label1.caption := intToStr(n)
          end
          else if sender = Image2 then
          begin
            label2.caption := intToStr(n)
          end
          else if sender = Image3 then
          begin
            label3.caption := intToStr(n)
          end
          else if sender = Image4 then
          begin
            label4.caption := intToStr(n)
          end
          else if sender = Image5 then
          begin
            label5.caption := intToStr(n)
          end
          else if sender = Image6 then
          begin
            label6.caption := intToStr(n)
          end
          else if sender = Image7 then
          begin
            label7.caption := intToStr(n)
          end
          else if sender = Image8 then
          begin
            label8.caption := intToStr(n)
          end
          else if sender = Image9 then
          begin
            label9.caption := intToStr(n)
          end
          else if sender = Image10 then
          begin
            label10.caption := intToStr(n)
          end
          else if sender = Image11 then
          begin
            label11.caption := intToStr(n)
          end
          else if sender = Image12 then
          begin
            label12.caption := intToStr(n)
          end
          else if sender = Image13 then
          begin
            label13.caption := intToStr(n)
          end
          else if sender = Image14 then
          begin
            label14.caption := intToStr(n)
          end
          else if sender = Image15 then
          begin
            label15.caption := intToStr(n)
          end;
        end;

Var n : Integer;
begin
  with (sender as TImage) do
  begin
    if (y > 25) AND (x > 10) AND (x < 30) then { BOTTOM SECTION (4) }
    begin
      if canvas.pixels[x, y] = clRed then
      begin
        Canvas.Brush.Color := clBtnFace;
        Canvas.Polygon([Point(1, 39),
                        Point(20, 20),
                        Point(39, 39),
                        Point(1, 39)]);
      end
      else
      begin
        Canvas.Brush.Color := clRed;
        Canvas.Polygon([Point(1, 39),
                        Point(20, 20),
                        Point(39, 39),
                        Point(1, 39)]);
      end
    end;

    if (y < 15) AND (x > 10) AND (x < 30) then { TOP SECTION (1) }
    begin
      if canvas.pixels[x, y] = clRed then
      begin
        Canvas.Brush.Color := clBtnFace;
        Canvas.Polygon([Point(1, 1),
                        Point(20, 20),
                        Point(39, 1),
                        Point(1, 1)]);
      end
      else
      begin
        Canvas.Brush.Color := clRed;
        Canvas.Polygon([Point(1, 1),
                        Point(20, 20),
                        Point(39, 1),
                        Point(1, 1)]);
      end
    end;

    if (x < 15) AND (y > 10) AND (y < 30) then { LEFT SECTION (8) }
    begin
      if canvas.pixels[x, y] = clRed then
      begin
        Canvas.Brush.Color := clBtnFace;
        Canvas.Polygon([Point(1, 1),
                        Point(20, 20),
                        Point(1, 39),
                        Point(1, 1)]);
      end
      else
      begin
        Canvas.Brush.Color := clRed;
        Canvas.Polygon([Point(1, 1),
                        Point(20, 20),
                        Point(1, 39),
                        Point(1, 1)]);
      end
    end;

    if (x > 25) AND (y > 10) AND (y < 30) then { RIGHT SECTION (2) }
    begin
      if canvas.pixels[x, y] = clRed then
      begin
        Canvas.Brush.Color := clBtnFace;
        Canvas.Polygon([Point(39, 1),
                        Point(20, 20),
                        Point(39, 39),
                        Point(39, 1)]);
      end
      else
      begin
        Canvas.Brush.Color := clRed;
        Canvas.Polygon([Point(39, 1),
                        Point(20, 20),
                        Point(39, 39),
                        Point(39, 1)]);
      end
    end;

    n := 0;

    if canvas.pixels[20, 10] = clRed then { Top }
    begin
      n := n + 1
    end;

    if canvas.pixels[30, 20] = clRed then { Right }
    begin
      n := n + 2
    end;

    if canvas.pixels[20, 30] = clRed then { Bottom }
    begin
      n := n + 4
    end;

    if canvas.pixels[10, 20] = clRed then { Left }
    begin
      n := n + 8
    end;

    setLabel(n);

    canvas.pen.color := clBlack;
    canvas.moveto(0, 0);
    canvas.lineto(39, 0);
    canvas.lineto(39, 39);
    canvas.lineto(0, 39);
    canvas.lineto(0, 0);
    canvas.lineto(40, 40);
    canvas.moveto(40, 0);
    canvas.lineto(0, 40);
  end
end;

procedure TFormMain.FormActivate(Sender: TObject);
begin
  With Image1 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image2 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image3 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image4 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image5 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image6 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image7 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image8 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image9 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image10 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image11 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image12 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image13 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image14 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;

  With Image15 Do
  Begin
    Canvas.Brush.Color := ClBtnFace;
    Canvas.rectangle(0, 0, Width, Height);
    Canvas.MoveTo(0, 0);
    Canvas.LineTo(40, 40);
    Canvas.MoveTo(40, 0);
    Canvas.LineTo(0, 40);
  End;
end;

procedure TFormMain.Button1Click(Sender: TObject);
begin
  Print
end;

procedure TFormMain.ButtonStoreClick(Sender: TObject);
Var theChar : Char;
begin
  if edit1.text = '' then
  begin
    messageDlg('Enter a character first.', mtError, [mbOK], 0);
    exit
  end;

  theChar := edit1.text[1];

  if theChar in ['A'..'Z'] then
  begin
    data[ord(theChar) - ord('A')][1] := strToInt(label1.Caption)  + 16 * strToInt(label2.Caption);
    data[ord(theChar) - ord('A')][2] := strToInt(label3.Caption)  + 16 * strToInt(label4.Caption);
    data[ord(theChar) - ord('A')][3] := strToInt(label4.Caption)  + 16 * strToInt(label6.Caption);
    data[ord(theChar) - ord('A')][4] := strToInt(label5.Caption)  + 16 * strToInt(label8.Caption);
    data[ord(theChar) - ord('A')][5] := strToInt(label6.Caption)  + 16 * strToInt(label10.Caption);
    data[ord(theChar) - ord('A')][6] := strToInt(label11.Caption) + 16 * strToInt(label12.Caption);
    data[ord(theChar) - ord('A')][7] := strToInt(label13.Caption) + 16 * strToInt(label14.Caption);
    data[ord(theChar) - ord('A')][8] := strToInt(label15.Caption);
  end
  else if theChar in ['0'..'9'] then
  begin
    data[ord(theChar) - ord('0')][1] := strToInt(label1.Caption)  + 16 * strToInt(label2.Caption);
    data[ord(theChar) - ord('0')][2] := strToInt(label3.Caption)  + 16 * strToInt(label4.Caption);
    data[ord(theChar) - ord('0')][3] := strToInt(label4.Caption)  + 16 * strToInt(label6.Caption);
    data[ord(theChar) - ord('0')][4] := strToInt(label5.Caption)  + 16 * strToInt(label8.Caption);
    data[ord(theChar) - ord('0')][5] := strToInt(label6.Caption)  + 16 * strToInt(label10.Caption);
    data[ord(theChar) - ord('0')][6] := strToInt(label11.Caption) + 16 * strToInt(label12.Caption);
    data[ord(theChar) - ord('0')][7] := strToInt(label13.Caption) + 16 * strToInt(label14.Caption);
    data[ord(theChar) - ord('0')][8] := strToInt(label15.Caption);
  end
  else if theChar = ' ' then
  begin
    data[SPACE][1] := strToInt(label1.Caption)  + 16 * strToInt(label2.Caption);
    data[SPACE][2] := strToInt(label3.Caption)  + 16 * strToInt(label4.Caption);
    data[SPACE][3] := strToInt(label4.Caption)  + 16 * strToInt(label6.Caption);
    data[SPACE][4] := strToInt(label5.Caption)  + 16 * strToInt(label8.Caption);
    data[SPACE][5] := strToInt(label6.Caption)  + 16 * strToInt(label10.Caption);
    data[SPACE][6] := strToInt(label11.Caption) + 16 * strToInt(label12.Caption);
    data[SPACE][7] := strToInt(label13.Caption) + 16 * strToInt(label14.Caption);
    data[SPACE][8] := strToInt(label15.Caption);
  end
  else if theChar = '-' then
  begin
    data[HYPHEN][1] := strToInt(label1.Caption)  + 16 * strToInt(label2.Caption);
    data[HYPHEN][2] := strToInt(label3.Caption)  + 16 * strToInt(label4.Caption);
    data[HYPHEN][3] := strToInt(label4.Caption)  + 16 * strToInt(label6.Caption);
    data[HYPHEN][4] := strToInt(label5.Caption)  + 16 * strToInt(label8.Caption);
    data[HYPHEN][5] := strToInt(label6.Caption)  + 16 * strToInt(label10.Caption);
    data[HYPHEN][6] := strToInt(label11.Caption) + 16 * strToInt(label12.Caption);
    data[HYPHEN][7] := strToInt(label13.Caption) + 16 * strToInt(label14.Caption);
    data[HYPHEN][8] := strToInt(label15.Caption);
  end
  else if theChar = '.' then
  begin
    data[STOP][1] := strToInt(label1.Caption)  + 16 * strToInt(label2.Caption);
    data[STOP][2] := strToInt(label3.Caption)  + 16 * strToInt(label4.Caption);
    data[STOP][3] := strToInt(label4.Caption)  + 16 * strToInt(label6.Caption);
    data[STOP][4] := strToInt(label5.Caption)  + 16 * strToInt(label8.Caption);
    data[STOP][5] := strToInt(label6.Caption)  + 16 * strToInt(label10.Caption);
    data[STOP][6] := strToInt(label11.Caption) + 16 * strToInt(label12.Caption);
    data[STOP][7] := strToInt(label13.Caption) + 16 * strToInt(label14.Caption);
    data[STOP][8] := strToInt(label15.Caption);
  end
  else
  begin
    messageDlg('Use A..Z,  0..9,  Space, Hyphen or Full stop.', mtError, [mbOK], 0)
  end
end;

procedure TFormMain.FormKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    'A' :
    begin
      if data[1][1] AND 1 <> 0 then
      begin
        image1.canvas.brush.color := clBlack;
        image1.canvas.polygon([point(0, 0), point(39, 0), point(20, 20)])
      end
      else
      begin
        image1.canvas.brush.color := clBtnFace;
        image1.canvas.polygon([point(0, 0), point(39, 0), point(20, 20)])
      end
    end;
    'B' :
    begin
      if data[1][1] AND 1 <> 0 then
      begin
        image1.canvas.brush.color := clBlack;
        image1.canvas.polygon([point(0, 0), point(39, 0), point(20, 20)])
      end
      else
      begin
        image1.canvas.brush.color := clBtnFace;
        image1.canvas.polygon([point(0, 0), point(39, 0), point(20, 20)])
      end
    end;
  end
end;

end.
