{ Advanced\Bub_Link\Finished - Example program from http://www.SoftwareForEducation.com/ }

{ ================================================================ }
{
    Example    BUBBLE SORT A LINKED LIST.  USE DYNAMICALLY CREATED
               OBJECTS.  KEEP A COUNT OF CREATED AND FREED OBJECTS
               TO ENSURE NO RESOURCE LEAKAGE.

    Task       ADD INSERTION AND QUICK SORT PROCEDURES/FUNCTIONS
               COMPARE THE PERFORMANCE OF THESE METHODS ON RANDOM,
               PARTIALLY SORTED AND SORTED DATA.

    TNode       Contains an integer number.

    TListNode   Is used to build up the linked list.
                When a TListNode is freed, it frees the TNode it
                points to.

    TList       Maintains pointers to the head, current and tail
                items in the list.  When a TList is freed, it frees
                all its TListNodes in the linked list.

    TStopClock  Inherits properties from TLabel.  It adds the
                ability to time processes.
}
{ ================================================================ }

unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

const
  MAX = 10;                     { Determines the amount of data     }
                                { Use a small value while debugging }
                                { Use a large value for timing the  }
                                { different sorting algorithms.     }

{ ================================================================ }

type

{ ===== TStopClock =============================================== }

  TStopClock = class(TLabel)

  private
    { Private declarations }
  public
    { Public declarations }

    theTime : TDateTime;       { add the ability to work with time }

    constructor create(AOwner : TComponent); override;
    destructor  destroy; override;

    procedure start;    { Start timing                             }
    procedure stop;     { Stop timing and display the elapsed time }
  end;

{ ===== TNode ==================================================== }

  TNode = class(TObject)        { In real life this might contain  }
    data : Integer;             { complex and large data.          }

    constructor create(theData : Integer);
    destructor  destroy; override;
  end;

{ ===== TListNode ================================================ }

  TListNode = class(TObject) { Linked list is assembled from these }
    node : TNode;            { Pointer to the data node            }
    next : TListNode;        { Used to join up the list            }
    prev : TListNode;        { Used to join up the list            }

    constructor create;
    destructor  destroy; override;
  end;

{ ===== TList ==================================================== }

  TList = class(TObject)
    head : TListNode;
    curr : TListNode;
    tail : TListNode;

    constructor create;
    destructor  destroy; override;

    procedure   bubbleSort;
    procedure   insertionSort;
    procedure   qSort(aHead, aTail : TListNode);
  end;

{ ===== TForm1 =================================================== }

  TForm1 = class(TForm)
    ButtonBubbleSort: TButton;
    ButtonRandomise: TButton;
    ButtonHead: TButton;
    ButtonFastBack: TButton;
    ButtonBack: TButton;
    ButtonForward: TButton;
    ButtonFastForward: TButton;
    ButtonTail: TButton;
    Label1: TLabel;
    ButtonInsertion: TButton;
    ButtonQuick: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonBubbleSortClick(Sender: TObject);
    procedure ButtonHeadClick(Sender: TObject);
    procedure ButtonFastBackClick(Sender: TObject);
    procedure ButtonFastForwardClick(Sender: TObject);
    procedure ButtonBackClick(Sender: TObject);
    procedure ButtonForwardClick(Sender: TObject);
    procedure ButtonTailClick(Sender: TObject);
    procedure ButtonRandomiseClick(Sender: TObject);
    procedure ButtonInsertionClick(Sender: TObject);
    procedure ButtonQuickClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    list      : TList;
    stopClock : TStopClock;
  end;

var
  Form1: TForm1;

{ ================================================================ }

implementation

{$R *.DFM}

Var cCount : longInt;

{ ===== TStopClock =============================================== }

constructor TStopClock.create(AOwner : TComponent);
begin
  inherited create(AOwner);

  inc(cCount);

  left := 8;
  top  := 150;
  font.name := 'Times New Roman';
  font.size := 28;
  caption := 'Stop Clock'
end;

{ ===== TStopClock =============================================== }

destructor TStopClock.destroy;
begin
  dec(cCount);

  inherited destroy
end;

{ ===== TStopClock =============================================== }

procedure TStopClock.start;
begin
  theTime := time;
  caption := 'Timing Now';
  update
end;

{ ===== TStopClock =============================================== }

procedure TStopClock.stop;
begin
  theTime := time - theTime;
  caption := timeToStr(theTime);
end;

{ ===== TNode ==================================================== }

constructor TNode.create(theData : Integer);
begin
  inc(cCount);

  data := theData
end;

{ ===== TNode ==================================================== }

destructor  TNode.destroy;
begin
  dec(cCount);

  inherited destroy
end;

{ ===== TListNode ================================================ }

constructor TListNode.create;
begin
  inc(cCount);

  node := TNode.Create(random(16000));
  next := Nil;
  prev := Nil;
end;

{ =====TListNode ================================================= }

destructor  TListNode.destroy;
begin
  dec(cCount);

  node.Free;

  inherited destroy
end;

{ ===== TList ==================================================== }

constructor TList.create;
var i : Integer;
begin
  inc(cCount);

  head := Nil;
  curr := Nil;
  tail := Nil;

  head := TListNode.Create;      { Create the first listNode }
  head.prev := Nil;
  head.next := Nil;
  curr := head;
  tail := head;

  for i := 1 to MAX do           { Create all the rest }
  begin
    tail.next := TListNode.Create;
    tail.next.prev := tail;
    tail.next.next := Nil;
    tail := tail.next;
  end
end;

{ ===== TList ==================================================== }

destructor  TList.destroy;
var pDel, scan : TListNode;
begin
  dec(cCount);

  scan := head;          { This code deletes all linked list items }

  while scan <> Nil do
  begin
    pDel := scan;
    scan := scan.next;
    pDel.free;
  end;

  head := Nil;
  curr := Nil;
  tail := Nil;

  inherited destroy;
end;

{ ===== TList ==================================================== }

procedure TList.insertionSort;
begin
end;

{ ===== TList ==================================================== }

procedure TList.bubbleSort;
var allSorted  : boolean;
    scan       : TListNode;
    temp       : TNode;
begin
  repeat
    scan := head;
    allSorted := True;

    while (scan <> Nil) and (scan.next <> Nil) do
    begin
      if scan.node.data > scan.next.node.data then
      begin
        temp := scan.node;
        scan.node := scan.next.node;
        scan.next.node := temp;

        allSorted := false;
      end;

      scan := scan.next
    end
  until allSorted;
end;

{ ===== TList ==================================================== }

procedure TList.qSort(aHead, aTail : TListNode);
begin
end;

{ ===== TList ==================================================== }

{ ===== TForm1 =================================================== }

procedure TForm1.FormCreate(Sender: TObject);
begin
  cCount := 0;

  randomize;

  stopClock := TStopClock.Create(Form1);
  Form1.InsertControl(stopClock);

  list   := TList.Create;             { Create the empty linked List }
  messageDlg('Component Count = ' + intToStr(cCount), mtInformation,
             [mbOK], 0);

  ButtonHeadClick(Sender);
end;

{ ===== TForm1 =================================================== }

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Form1.RemoveControl(stopClock);
  stopClock.free;

  list.free;

  messageDlg('Component Count = ' + intToStr(cCount), mtInformation,
             [mbOK], 0)
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonBubbleSortClick(Sender: TObject);
begin
  stopClock.start;
  list.bubbleSort;
  stopClock.stop;
  ButtonHeadClick(Sender);
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonHeadClick(Sender: TObject);
begin
  list.curr := list.head;

  If list.curr = Nil then
  begin
    Label1.Caption := 'Nil'
  end
  else
  begin
    Label1.Caption := intToStr(list.curr.node.data)
  end
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonFastBackClick(Sender: TObject);
var i : Integer;
begin
  for i := 0 to 49 do
    if list.curr.prev <> nil then
      list.curr := list.curr.prev;

  If list.curr = Nil then
  begin
    Label1.Caption := 'Nil'
  end
  else
  begin
    Label1.Caption := intToStr(list.curr.node.data)
  end
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonFastForwardClick(Sender: TObject);
var i : Integer;
begin
  for i := 0 to 49 do
    if list.curr.next <> nil then
      list.curr := list.curr.next;

  If list.curr = Nil then
  begin
    Label1.Caption := 'Nil'
  end
  else
  begin
    Label1.Caption := intToStr(list.curr.node.data)
  end
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonBackClick(Sender: TObject);
begin
  if list.curr.prev <> nil then
    list.curr := list.curr.prev;

  If list.curr = Nil then
  begin
    Label1.Caption := 'Nil'
  end
  else
  begin
    Label1.Caption := intToStr(list.curr.node.data)
  end
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonForwardClick(Sender: TObject);
begin
  if list.curr.next <> nil then
    list.curr := list.curr.next;

  If list.curr = Nil then
  begin
    Label1.Caption := 'Nil'
  end
  else
  begin
    Label1.Caption := intToStr(list.curr.node.data)
  end
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonTailClick(Sender: TObject);
begin
  list.curr := list.tail;

  If list.curr = Nil then
  begin
    Label1.Caption := 'Nil'
  end
  else
  begin
    Label1.Caption := intToStr(list.curr.node.data)
  end
end;

{ ===== TForm1 =================================================== }

procedure TForm1.ButtonRandomiseClick(Sender: TObject);
var scan : TListNode;
begin
  scan := list.head;

  while scan <> Nil do
  begin
    scan.node.data := random(16000);
    scan := scan.next;
  end;

  ButtonHeadClick(Sender);
end;

{ ================================================================ }

procedure TForm1.ButtonInsertionClick(Sender: TObject);
begin
  stopClock.start;
  list.insertionSort;
  stopClock.stop;
  ButtonHeadClick(Sender);
end;

procedure TForm1.ButtonQuickClick(Sender: TObject);
begin
  list.qSort(list.Head, list.Tail)
end;

end.

{ ================================================================ }
