{ Advanced\BinTree - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.   This is a skeleton for a program that builds a binary
               tree.  There are skeleton procedures to display the
               tree in pre, post, reverse and normal order.

    Task.      Complete this program.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

const
  TAB = Chr(9);

type
  TreeNode = Class(TObject)
    Item  : String;
    Count : Integer;
    left  : TreeNode;   { Pointer to the left  branch sub tree }
    right : TreeNode;   { Pointer to the right branch sub tree }
  end;

  TForm1 = class(TForm)
    PanelMemo: TPanel;
    Memo1: TMemo;
    PanelButtons: TPanel;
    ButtonBuild: TButton;
    ButtonInOrder: TButton;
    ButtonReverseOrder: TButton;
    ButtonPostOrder: TButton;
    ButtonPre: TButton;
    ButtonClose: TButton;
    OpenDialog1: TOpenDialog;
    procedure ButtonBuildClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonInOrderClick(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonReverseOrderClick(Sender: TObject);
    procedure ButtonPostOrderClick(Sender: TObject);
    procedure ButtonPreClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Root : TreeNode;

    function  deleteOldTree(Node : TreeNode) : TreeNode;
    function  treeInsert(Node : TreeNode;  Item : String) : TreeNode;
    procedure inOrder(Node : TreeNode);
    procedure revOrder(Node : TreeNode);
    procedure postOrder(Node : TreeNode);
    procedure preOrder(Node : TreeNode);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ----------------------------------------------------------------------- }

Function TForm1.deleteOldTree(Node : TreeNode) : TreeNode;
Begin
  if Node <> Nil then
  begin
    Node.Left  := deleteOldTree(Node.Left);
    Node.Right := deleteOldTree(Node.Right);

    Node.Free;
  end;

  deleteOldTree := Nil;
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.inOrder(Node : TreeNode);

Begin
  { Add your code here }
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.revOrder(Node : TreeNode);

Begin
  { Add your code here }
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.postOrder(Node : TreeNode);

Begin
  { Add your code here }
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.preOrder(Node : TreeNode);

Begin
  { Add your code here }
End;

{ ----------------------------------------------------------------------- }

function TForm1.treeInsert(Node : TreeNode;  Item : String) : TreeNode;

Var pNew : TreeNode;

Begin
  { Add your code here }

  { Remove this line when you write your own code }  result := Nil;
End;


procedure TForm1.ButtonBuildClick(Sender: TObject);

Var F    : TextFile;
    Line : String;

begin
  if OpenDialog1.Execute then
  begin
    Root := deleteOldTree(Root);

    memo1.clear;

    assignFile(F, OpenDialog1.FileName);
    reset(F);

    While Not Eof(F) Do
    Begin
      Readln(F, Line);
      memo1.lines.add(Line);
      Root := treeInsert(Root, Line);
    End;

    closeFile(F);

    memo1.lines.Insert(0, '');
    memo1.lines.Insert(0, 'DATA LOADED FROM FILE');

    memo1.selStart := 0;
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Root := Nil;
end;

procedure TForm1.ButtonInOrderClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('In-Order' + TAB + TAB + 'COUNT');
  memo1.lines.add('');
  inOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ButtonReverseOrderClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('Reverse-Order' + TAB + 'COUNT');
  memo1.lines.add('');
  revOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.ButtonPostOrderClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('Post-Order' + TAB + 'COUNT');
  memo1.lines.add('');
  postOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.ButtonPreClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('Pre-Order' + TAB + TAB + 'COUNT');
  memo1.lines.add('');
  preOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Root := deleteOldTree(Root);
end;

end.

