{ Advanced\BinTree\Complete - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    This is a complete version of a program that
                builds a binary tree.  There are finished
                procedures to display the tree in pre, post,
                reverse and normal order.

    Task.       Add code that places text into the memo control
                to explain what the procedures are doing.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

const
  TAB = Chr(9);

type
  TreeNode = Class(TObject)
    Item  : String;
    Count : Integer;
    left  : TreeNode;
    right : TreeNode;
  end;

  TForm1 = class(TForm)
    PanelMemo: TPanel;
    Memo1: TMemo;
    PanelButtons: TPanel;
    ButtonBuild: TButton;
    ButtonInOrder: TButton;
    ButtonReverseOrder: TButton;
    ButtonPostOrder: TButton;
    ButtonPre: TButton;
    ButtonClose: TButton;
    OpenDialog1: TOpenDialog;
    procedure ButtonBuildClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonInOrderClick(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonReverseOrderClick(Sender: TObject);
    procedure ButtonPostOrderClick(Sender: TObject);
    procedure ButtonPreClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Root : TreeNode;

    function  deleteOldTree(Node : TreeNode) : TreeNode;
    function  treeInsert(Node : TreeNode;  Item : String) : TreeNode;
    procedure inOrder(Node : TreeNode);
    procedure revOrder(Node : TreeNode);
    procedure postOrder(Node : TreeNode);
    procedure preOrder(Node : TreeNode);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ----------------------------------------------------------------------- }

Function TForm1.deleteOldTree(Node : TreeNode) : TreeNode;
Begin
  if Node <> Nil then
  begin
    Node.Left  := deleteOldTree(Node.Left);
    Node.Right := deleteOldTree(Node.Right);

    Node.Free;
  end;

  deleteOldTree := Nil;
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.inOrder(Node : TreeNode);

Begin
  if Node <> Nil then
  begin
    inOrder(Node.Left);
    memo1.lines.add(Node.Item + TAB + TAB + intToStr(Node.Count));
    inOrder(Node.Right);
  end
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.revOrder(Node : TreeNode);

Begin
  if Node <> Nil then
  begin
    revOrder(Node.Right);
    memo1.lines.add(Node.Item + TAB + TAB + intToStr(Node.Count));
    revOrder(Node.left);
  end
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.postOrder(Node : TreeNode);

Begin
  if Node <> Nil then
  begin
    postOrder(Node.Left);
    postOrder(Node.Right);
    memo1.lines.add(Node.Item + TAB + TAB + intToStr(Node.Count));
  end
End;

{ ----------------------------------------------------------------------- }

Procedure TForm1.preOrder(Node : TreeNode);

Begin
  if Node <> Nil then
  begin
    memo1.lines.add(Node.Item + TAB + TAB + intToStr(Node.Count));
    preOrder(Node.Left);
    preOrder(Node.Right);
  end
End;

{ ----------------------------------------------------------------------- }

function TForm1.treeInsert(Node : TreeNode;  Item : String) : TreeNode;
Begin
  if Node = Nil then
  begin
    Node       := TreeNode.Create;           { Create the new tree Node   }
    Node.Item  := Item;                      { Store the item             }
    Node.Count := 1;                         { So far there is one item   }
    Node.Left  := Nil;                       { Set Left pointer to Nil    }
    Node.Right := Nil;                       { Set Right pointer to Nil   }
    Result     := Node;                      { Return the address of pNew }
  end
  else if Node.Item < Item then              { Insert into right sub tree }
  begin
    Node.Right := treeInsert(Node.Right, Item);
    treeInsert := Node;
  end
  else if Node.Item > Item then              { Insert into left sub tree  }
  Begin
    Node.Left := treeInsert(Node.Left, Item);
    treeInsert := Node;
  End
  Else                                       { Increment the item counter }
  Begin
    Node.Count := Node.Count + 1;
    treeInsert := Node;
  End
End;


procedure TForm1.ButtonBuildClick(Sender: TObject);

Var F    : TextFile;
    Line : String;

begin
  if OpenDialog1.Execute then
  begin
    Root := deleteOldTree(Root);

    memo1.clear;

    assignFile(F, OpenDialog1.FileName);
    reset(F);

    While Not Eof(F) Do
    Begin
      Readln(F, Line);
      memo1.lines.add(Line);
      Root := treeInsert(Root, Line);
    End;

    closeFile(F);

    memo1.lines.Insert(0, '');
    memo1.lines.Insert(0, 'DATA BEFORE TREE INSERTION');

    memo1.selStart := 0;          
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Root := Nil;
end;

procedure TForm1.ButtonInOrderClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('In-Order' + TAB + TAB + 'COUNT');
  memo1.lines.add('');
  inOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ButtonReverseOrderClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('Reverse-Order' + TAB + 'COUNT');
  memo1.lines.add('');
  revOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.ButtonPostOrderClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('Post-Order' + TAB + 'COUNT');
  memo1.lines.add('');
  postOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.ButtonPreClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.add('Pre-Order' + TAB + TAB + 'COUNT');
  memo1.lines.add('');
  preOrder(Root);

  memo1.selStart := 0;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Root := deleteOldTree(Root);
end;

end.
