{ Advanced\BCDClock - Example program from http://www.SoftwareForEducation.com/ }

{
        Example     This program implements a simulation of
                    a clock that displays time in Binary Coded
                    Decimal.  The clock uses twenty "light emitting
                    diodes" to display the time.  The hours are
                    shown in yellow lights.  The minutes are shown
                    in green.  The seconds are shown in red.  The
                    display is updated every second.

        Task        Design, code and test your own clock.
}

unit Clockf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    w, h : integer;

    procedure hh(x : Integer);
    procedure hl(x : Integer);
    procedure mh(x : Integer);
    procedure ml(x : Integer);
    procedure sh(x : Integer);
    procedure sl(x : Integer);

    procedure doRect(where, onOff : Integer; aColour : TColor);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.doRect(where, onOff : Integer; aColour : TColor);
begin
  if onOff = 1 then
  begin
    canvas.pen.color := clWhite;
    canvas.brush.color := aColour;
  end
  else
  begin
    canvas.pen.color := clWhite;
    canvas.brush.color := clBlack;
  end;

  canvas.rectangle(1 + where * w, 1, 1 + where * w + w, h - 1)
end;

procedure TForm1.hh(x : Integer);
begin
  if (x AND 1) <> 0 then doRect(01, 1, clYellow) else doRect(01, 0, clYellow);
  if (x AND 2) <> 0 then doRect(00, 1, clYellow) else doRect(00, 0, clYellow);
end;

procedure TForm1.hl(x : Integer);
begin
  if (x AND 1) <> 0 then doRect(06, 1, clYellow) else doRect(06, 0, clYellow);
  if (x AND 2) <> 0 then doRect(05, 1, clYellow) else doRect(05, 0, clYellow);
  if (x AND 4) <> 0 then doRect(04, 1, clYellow) else doRect(04, 0, clYellow);
  if (x AND 8) <> 0 then doRect(03, 1, clYellow) else doRect(03, 0, clYellow);
end;

procedure TForm1.mh(x : Integer);
begin
  if (x AND 1) <> 0 then doRect(10, 1, clLime) else doRect(10, 0, clLime);
  if (x AND 2) <> 0 then doRect(09, 1, clLime) else doRect(09, 0, clLime);
  if (x AND 4) <> 0 then doRect(08, 1, clLime) else doRect(08, 0, clLime);
end;

procedure TForm1.ml(x : Integer);
begin
  if (x AND 1) <> 0 then doRect(15, 1, clLime) else doRect(15, 0, clLime);
  if (x AND 2) <> 0 then doRect(14, 1, clLime) else doRect(14, 0, clLime);
  if (x AND 4) <> 0 then doRect(13, 1, clLime) else doRect(13, 0, clLime);
  if (x AND 8) <> 0 then doRect(12, 1, clLime) else doRect(12, 0, clLime);
end;

procedure TForm1.sh(x : Integer);
begin
  if (x AND 1) <> 0 then doRect(19, 1, clRed) else doRect(19, 0, clRed);
  if (x AND 2) <> 0 then doRect(18, 1, clRed) else doRect(18, 0, clRed);
  if (x AND 4) <> 0 then doRect(17, 1, clRed) else doRect(17, 0, clRed);
end;

procedure TForm1.sl(x : Integer);
begin
  if (x AND 1) <> 0 then doRect(24, 1, clRed) else doRect(24, 0, clRed);
  if (x AND 2) <> 0 then doRect(23, 1, clRed) else doRect(23, 0, clRed);
  if (x AND 4) <> 0 then doRect(22, 1, clRed) else doRect(22, 0, clRed);
  if (x AND 8) <> 0 then doRect(21, 1, clRed) else doRect(21, 0, clRed);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  w := form1.clientWidth div 25;
  form1.clientHeight := w + 4;
  h := w + 4
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var s : string;
begin
  { This will fail if your computer does not display
    time in HH:MM:SS 24 hour clock layout. }

  s := timeToStr(time);

  hh(ord(s[1]) - ord('0'));
  hl(ord(s[2]) - ord('0'));

  mh(ord(s[4]) - ord('0'));
  ml(ord(s[5]) - ord('0'));

  sh(ord(s[7]) - ord('0'));
  sl(ord(s[8]) - ord('0'))
end;

end.
