{ Advanced\Appstart - Example program from http://www.SoftwareForEducation.com/ }

{
    Example    A program to launch other programs.

    Task       Add your own programs to this launcher.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ShellAPI, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    SpeedButton2: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    procedure errorCheck(aHandle : THandle);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.errorCheck(aHandle : THandle);
var s : String;
begin
  case aHandle of
     0 : s := 'System was out of memory, executable file was corrupt, or relocations were invalid.';
     1 : s := 'Unknown launch error.';
     2 : s := 'File was not found.';
     3 : s := 'Path was not found.';
     4 : s := 'Unknown launch error.';
     5 : s := 'Could not dynamically link to a task, or there was a sharing or network-protection error.';
     6 : s := 'Library required separate data segments for each task.';
     7 : s := 'Unknown launch error.';
     8 : s := 'There was insufficient memory to start the application.';
     9 : s := 'Unknown launch error.';
    10 : s := 'Windows version was incorrect.';
    11 : s := 'Executable file was invalid. Not a Windows application or error in the .EXE image.';
    12 : s := 'Application was designed for a different operating system.';
    13 : s := 'Application was designed for MS-DOS 4.0.';
    14 : s := 'Type of executable file was unknown.';
    15 : s := 'Could not load real-mode application developed for an earlier version of Windows.';
    16 : s := 'Could not load second instance of an exe file containing multiple non read-only data segments.';
    17 : s := 'Unknown launch error.';
    18 : s := 'Unknown launch error.';
    19 : s := 'Could not load compressed exe file. Decompresse before loading.';
    20 : s := 'Invalid dynamic-link library. A required DLL was corrupt.';
    21 : s := 'Application requires Windows 32-bit extensions.';
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30 : s := 'Unknown launch error.';
    31 : s := 'There is no association for the specified file type or action.';
    32 : s := 'Unknown launch error.';
  else
     s := '';
  end;

  if s <> '' then
  begin
    messageDlg(s, mtError, [mbOK], 0)
  end
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var outcome : THandle;
begin
  { ShellExecute returns a result code indicating success
    or what went wrong when launching an application. }
  outcome := ShellExecute(Handle, Nil, 'WINFILE.EXE', Nil, Nil, SW_SHOWMAXIMIZED);

  { the errorCheck procedure displays a text error message
    based on the code returned by shellExecute. }
  errorCheck(outcome)
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
var outcome : THandle;
begin
  { ShellExecute returns a result code indicating success
    or what went wrong when launching an application. }
  outcome := ShellExecute(Handle, Nil, 'PBRUSH.EXE', Nil, Nil, SW_SHOWMAXIMIZED);

  { the errorCheck procedure displays a text error message
    based on the code returned by shellExecute. }
  errorCheck(outcome)
end;

end.
