{ Add2Tail - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    A double linked list program.  This example adds
               items to the tail of the list.

    TASKS      Add buttons to add at the head,  delete from the head and tail.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  listNode = class(TObject)
    item : String;
    next : listNode;
    prev : listNode;
  end;

  TForm1 = class(TForm)
    ButtonAddToTail: TButton;
    EditAdd: TEdit;
    LabelTextToAdd: TLabel;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure ButtonAddToTailClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    head : listNode;
    curr : listNode;
    tail : listNode;

    procedure updateListView;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.updateListView;
Var Scan : listNode;
begin
  memo1.clear;

  scan := head;

  while scan <> Nil do
  begin
    memo1.lines.add(scan.item);

    scan := scan.next
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  head := Nil;
  curr := Nil;
  tail := Nil;
end;

procedure TForm1.ButtonAddToTailClick(Sender: TObject);
Var pNew : listNode;
begin
  if curr = Nil then
  begin
    pNew := listNode.Create;
    pNew.item := editAdd.text;
    pNew.next := Nil;
    pNew.prev := Nil;

    head := pNew;
    curr := pNew;
    tail := pNew
  end
  else
  begin
    pNew := listNode.Create;
    pNew.item := editAdd.text;
    pNew.next := Nil;
    pNew.prev := Tail;

    tail.next := pNew;

    curr := pNew;
    tail := pNew
  end;

  updateListView;

  editAdd.setFocus;
  editAdd.selectAll
end;

end.
