{ 17String - Example program from http://www.SoftwareForEducation.com/ }

{
      Example    Cutting up text strings.

      Task       Learn how to cut up and re-assemble text strings.
                 For example the input string might be '234 * 12'
                 Cut this into three parts and do the calculation.

      Advanced   A more complex input could be '(2 + 3) * 27'.
                 Consider the complexity of processing any valid
                 mathematical expression.
}

unit Stringf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    EditInput: TEdit;
    Label3: TLabel;
    EditSeparator: TEdit;
    Button1: TButton;
    LabelHead: TLabel;
    LabelTail: TLabel;
    LabelRest: TLabel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function head(const ip : string; const separator : char) : String;
    function rest(const ip : string; const separator : char) : String;
    function tail(const ip : string; const separator : char) : String;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This function copies the input string to the result string character
  by charcater until the separator character is found.  The separator
  character is not copied.  Copying starts from the first character.    }
function TForm1.head(const ip : string; const separator : char) : String;
var out : String;   { The output answer is stored here.                 }
    i   : Integer;  { i is used to point to each character in turn.     }
begin
  out := '';                         { Start off with a blank answer.   }
  for i := 1 to length(ip) do        { For every position in the input  }
  begin
    if ip[i] <> separator then       { If it is not the separator then  }
    begin
      out := out + ip[i]             { Copy the input to the output.    }
    end
    else
    begin
      break                          { break out of this loop becuase   }
    end                              { the separator was found.         }
  end;

  result := out                      { Function returns output          }
end;

{ This function copies the input string to the result string character
  by charcater after the separator character has been found.  The
  separator character is not copied.  Copying starts from the
  separator first character.  The separator is not copied.              }
function TForm1.rest(const ip : string; const separator : char) : String;
var out : String;   { The output answer is stored here.                 }
    i   : Integer;  { i is used to point to each character in turn.     }
    foo : boolean;  { A flag that is set when the separator is found.   }
begin
  foo := false;
  out := '';                         { Start off with a blank answer.   }
  for i := 1 to length(ip) do        { For every position in the input  }
  begin
    if foo then                      { If the copy flag is set then     }
    begin
      out := out + ip[i]             { copy the input to the output.    }
    end;

    if ip[i] = separator then        { If it is the separator then      }
    begin
      foo := true                    { Set the copy flag.               }
    end
  end;

  result := out                      { Function returns output          }
end;

{ This function copies the input string to the result string character
  by charcater until the separator character is found.  The separator
  character is not copied.  Copying starts from the last character.     }
function TForm1.tail(const ip : string; const separator : char) : String;
var out : String;   { The output answer is stored here.                 }
    i   : Integer;  { i is used to point to each character in turn.     }
begin
  out := '';                         { Start off with a blank answer.   }
  for i := length(ip) downto 1 do    { For every position in the input  }
  begin
    if ip[i] <> separator then       { If it is not the separator then  }
    begin
      out := ip[i] + out             { Copy the input to the output.    }
    end
    else
    begin
      break                          { break out of this loop becuase   }
    end                              { the separator was found.         }
  end;

  result := out                      { Function returns output          }
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if length(editSeparator.text) = 1 then
  begin
    labelHead.caption := 'Head : ' + head(editInput.text, editSeparator.text[1]);
    labelRest.caption := 'Rest : ' + rest(editInput.text, editSeparator.text[1]);
    labelTail.caption := 'Tail : ' + tail(editInput.text, editSeparator.text[1]);
  end
  else
  begin
    messageDlg('There must be exactly one separator character.', mtError, [mbOK], 0)
  end
end;

end.
