{ 15UpCase - Example program from http://www.SoftwareForEducation.com/ }

{ Example         This is a FILTER program.

                  Filters read input bytes or chars from a file,
                  process them in some way and write the output
                  to a new file.  This example converts lower
                  case chars to upper case.

  Tasks           1) Read input chars and count them.
                  2) Read input lines and count them.
                  3) Count the words in a text file.
                  4) Convert upper case text to lower case.
                  5) Count occurrences of the letters a..z and A..Z.
                  6) Count the occurrences of letter pairs like ch or st. }

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus;

type
  TFormMain = class(TForm)
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Memo1: TMemo;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    ButtonConvert: TButton;
    Label1: TLabel;
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ButtonConvertClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    procedure Convert;
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.Open1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    memo1.clear;
    memo1.lines.loadFromFile(OpenDialog1.FileName);
  end
end;

procedure TFormMain.Exit1Click(Sender: TObject);
begin
  Close
end;

procedure TFormMain.ButtonConvertClick(Sender: TObject);
begin
  Memo1.Lines.SaveToFile('In.Txt');
  Memo1.Clear;

  if fileExists('in.txt') then
  begin
    Convert
  end
  else
  begin
    memo1.lines.add('Could not convert.  In.Txt was missing.');
    memo1.lines.add('')
  end;

  if fileExists('Out.Txt') then
  begin
    Memo1.Lines.LoadFromFile('Out.Txt');
  end
  else
  begin
    memo1.lines.add('Could not load Out.Txt.  Out.Txt was missing.');
    memo1.lines.add('')
  end
end;

procedure TFormMain.Convert;
Var iii, ooo     : file of char;
    chIn, chOut  : char;
begin
  assignFile(iii, 'in.txt');
  reset(iii);
  assignFile(ooo, 'out.txt');
  rewrite(ooo);

  while not eof(iii) do
  begin
    read(iii, chIn);

    if chIn in ['a'..'z'] then
    begin
      chOut := chr(ord(chIn) + ord('A') - ord('a'))
    end
    else
    begin
      chOut := chIn
    end;

    write(ooo,chOut);
  end;

  closeFile(ooo);
  closeFile(iii)
end;

end.

