{ 14FileRW - Example program from http://www.SoftwareForEducation.com/ }

{ Example  A program to demonstrate writing to
           and reading from text files on disk.

  Task     Write a program that takes input text
           and writes it to a file as a web page.
           Use a Web Browser to view the results.

           <HTML>

           <HEAD>
           <TITLE>Title Goes Here</TITLE>
           </HEAD>

           <BODY>
           <H1>Main Heading Goes Here</H1>
           Body text goes here.  Use an edit control to input
           the title.  Use a memo control to input any body
           text you like.  Use a second edit control for
           inputting the main heading.
           </BODY>

           </HTML>                           }

unit File_rwf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

{ By using a constant value, you can change the file name throughout
  the whole program by changing this single line below. }
const
  theFileName = 'foo.txt';

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    ButtonSave: TButton;
    ButtonLoad: TButton;
    ButtonView: TButton;
    Memo1: TMemo;
    procedure ButtonSaveClick(Sender: TObject);
    procedure ButtonLoadClick(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    procedure save;
    procedure load;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ===============================================================
  Name      : SAVE
  Input     : None
  Process   : Write three lines from the edit controls to a text file.
  Output    : Create the text file if it does not esist.
              Overwrite the text file if it does esist.
              Write three lines to the text file.
              The lines might have zero length.
  Test data : Test this procedure under the following data conditions.
              1) The file does not exist.
              2) The file exists.  }
procedure TForm1.save;
Var ooo : textFile;
begin
  assignFile(ooo, theFileName);
  reWrite(ooo);

  writeln(ooo, edit1.text);
  writeln(ooo, edit2.text);
  writeln(ooo, edit3.text);

  closeFile(ooo);
end;

{ ===============================================================
  Name      : LOAD
  Input     : None
  Process   : Read three lines from a text file.
              The text file must exist.
              Store the three lines into the three edit controls.
  Output    : None if the file does not exist.
              Three lines of text if the file does exist
              and it contains three lines.
  Test data : Test this procedure under the following data conditions.
              1) The file does not exist.
              2) The file exists but is empty.
              3) The file exists but contains only one line.
              4) The file exists but contains only two lines.
              5) The file exists and contains three lines.
              6) The file exists contains more than three lines. }
procedure TForm1.load;
Var ooo : textFile;
    s   : string;
begin
  { Check that the file exists.
    Read the file if it does.
    Error message if it does not. }
  if fileExists(theFileName) then
  begin
    assignFile(ooo, theFileName); { in current drive and directory }
    reSet(ooo);

    { Read the first line if the file is not empty. }
    if not eof(ooo) then
    begin
      readln(ooo, s);
      edit1.text := s;
    end;

    { Read the second line if not at the end of the file. }
    if not eof(ooo) then
    begin
      readln(ooo, s);
      edit2.text := s;
    end;

    { Read the third line if not at the end of the file. }
    if not eof(ooo) then
    begin
      readln(ooo, s);
      edit3.text := s;
    end;

    closeFile(ooo);
  end
  else
  begin
    { Error message. }
    messageDlg('File does not exists.', mtError, [mbOK], 0)
  end
end;

procedure TForm1.ButtonSaveClick(Sender: TObject);
begin
  save
end;

procedure TForm1.ButtonLoadClick(Sender: TObject);
begin
  load
end;

procedure TForm1.ButtonViewClick(Sender: TObject);
begin
  memo1.clear;
  memo1.lines.loadFromFile(theFileName)
end;

end.

