{ 13Calc - Example program from http://www.SoftwareForEducation.com/ }

{ ==================================================================== }
{    EXAMPLE    Here is a simple calculator program.
                It does Plus and Minus calculations.

     TASK       Study the program to understand it and then
                add to the calculator to do Times, Divide,
                Square root and if you are keen try X to the Y
                and other functions.                                   }
{ ==================================================================== }

unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

{ ==================================================================== }

type
  modeType = (none, plus, minus);               { Add more modes here. }

  TForm1 = class(TForm)
    EditDisplay: TEdit;
    ButtonPlus: TButton;
    ButtonMinus: TButton;
    ButtonEquals: TButton;
    ButtonClear: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
    procedure ButtonPlusClick(Sender: TObject);
    procedure ButtonEqualsClick(Sender: TObject);
    procedure ButtonMinusClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }  { You type these in. }
    mode        : modeType;
    resultSoFar : Real;

    procedure calculate;
  end;

{ ==================================================================== }

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ==================================================================== }

procedure TForm1.Calculate;
begin
  { Do a calcualtion based on the mode. }
  if mode = none then
  begin
    resultSoFar := strToFloat(editDisplay.text);
  end
  else if mode = plus then
  begin
    resultSoFar := resultSoFar + strToFloat(editDisplay.text);
  end
  else if mode = minus then
  begin
    resultSoFar := resultSoFar - strToFloat(editDisplay.text);
  end;

  { Refresh the answer / input display. }
  editDisplay.text := floatTOStr(resultSoFar);
  editDisplay.setFocus;
  editDisplay.selectAll;
end;

{ ==================================================================== }
{ Ensure that the initial values are OK. }
{ This happens when the form is created. }
procedure TForm1.FormCreate(Sender: TObject);
begin
  resultSoFar := 0.0;
  mode        := none;
end;

{ ==================================================================== }
{ CLEAR BUTTON                                                         }
{ Clear the displays.                                                  }
{ Set the result so far to zero.                                       }
procedure TForm1.ButtonClearClick(Sender: TObject);
begin
  mode := none;
  resultSoFar := 0.0;
  editDisplay.setFocus;
  editDisplay.clear;
end;

{ ==================================================================== }
{ PLUS BUTTON                                                          }
{ Perform the calculation so far and set the mode to PLUS.             }
procedure TForm1.ButtonPlusClick(Sender: TObject);
begin
  calculate;
  mode := plus;
end;

{ ==================================================================== }
{ EQUALS BUTTON                                                        }
{ Perform the calculation so far and set the mode to NONE.             }
procedure TForm1.ButtonEqualsClick(Sender: TObject);
begin
  calculate;
  mode := none;
end;

{ ==================================================================== }
{ MINUS BUTTON                                                         }
{ Perform the calculation so far and set the mode to MINUS.            }
procedure TForm1.ButtonMinusClick(Sender: TObject);
begin
  calculate;
  mode := minus;
end;

{ ==================================================================== }

{ ADD BUTTONS AND PROCEDURES FOR Times, Divide, Square root, Etc.      }

end.

{ ==================================================================== }

