{ 10Lotto - Example program from http://www.SoftwareForEducation.com/ }

{ A lottery ball chooser. }

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    ButtonChoose: TButton;
    procedure ButtonChooseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This procedure has been modularised by using procedures
  and functions within other procedures and functions.

  This procedure runs when ButtonChoose is clicked.       }

procedure TForm1.ButtonChooseClick(Sender: TObject);

Var balls : array[1..6] of 0..49;{ Storage space for 6 balls.    }
                                 { Storage may contain values    }
                                 { between 0 and 49 only.        }
                                 { 0 signifies an unchosen ball. }

    { = SUB PROCEDURES ========================================= }
    procedure setUpColours;
    begin
      Canvas.Brush.Color := clBtnFace;
      Canvas.Font.Color := clRed;
    end;
    { ========================================================== }
    procedure clearOldNumbers;
    var i : 1..6;
    begin
      { Un-choose the lottery numbers. }
      for i := 1 to 6 do
      begin
        balls[i] := 0;    { Clear the array of lotteryNumbers; }
      end;                { 0 signifies an unchosen ball.      }
    end;
    { ========================================================== }
    procedure chooseSixNumbers;
        { = THIS FUNCTION IS NESTED INSIDE A PROCEDURE ========= }
        function notDuplicate(aBall : Integer) : boolean;
        var i         : 1..6;
            duplicate : boolean;
        begin
          duplicate := false;

          for i := 1 to 6 do
          begin
            if balls[i] = aBall then
            begin
              duplicate := true;
              break
            end
          end;

          notDuplicate := not duplicate
        end;
        { ====================================================== }
    var i    : 1..6;
        ball : 1..49;
    begin
      { Make 6 choices. }
      for i := 1 to 6 do
      begin
        { Keep choosing until it is not a duplicate. }
        repeat
          ball := 1 + random(49);    { A number between 1 and 49. }
        until notDuplicate(ball);

        balls[i] := ball;            { Save the ball. }
      end;
    end;
    { ========================================================== }
    procedure showBalls(aColumnPosition : Integer; aColHeading : string);
    var i : 1..6;
    begin
      { Show unsorted balls on screen. }
      canvas.TextOut(aColumnPosition, 20 * 0, aColHeading);
      for i := 1 to 6 do
      begin
        canvas.TextOut(aColumnPosition, 20 * i, intToStr(balls[i]) + '    ')
      end
    end;
    { ========================================================== }
    procedure sortBalls;    { Uses the bubble sort.              }
    var i         : 1..5;
        allSorted : boolean;
        ball      : 1..49;
    begin
      { Sort the balls. }
      { Repeat until all the balls are sorted. }
      repeat
        allSorted := true;

        { scan the pairs of balls }
        for i := 1 to 5 do
        begin
          { Compare pairs of balls and swap them if they are out of order. }
          if balls[i] > balls[i + 1] then
          begin
            { SWAP }
            ball := balls[i];
            balls[i] := balls[i + 1];
            balls[i + 1] := ball;

            allSorted := false
          end
        end
      until allSorted;
    end;
    { = END OF SUB PROCEDURES ================================== }

{ = MAIN PROCEDURE ============================================= }
begin
  setUpColours;                 { Set the display colours.       }
  clearOldNumbers;              { Clear the old ball choices.    }
  chooseSixNumbers;             { Make the new choices.          }
  showBalls(10, 'Unsorted');    { Display the choices.           }
  sortBalls;                    { Sort the balls. Ascending.     }
  showBalls(80, 'Sorted');      { Display the choices.           }
end;
{ = END OF MAIN PROCEDURE ====================================== }

{ = THIS PROCEDURE GIVES A RANDOM STARTING NUMBER ============== }
procedure TForm1.FormCreate(Sender: TObject);
begin
  randomize
end;
{ ============================================================== }

end.

{ ============================================================== }

