{ 09While - Example program from http://www.SoftwareForEducation.com/ }

{     EXAMPLE    A WHILE loop is demonstrated. The repetition
                 continues as long as the value of X1 is not
                 zero.

      TASK       Write your own program containing a while loop.

                 The while loop repeats zero or more times.
                 It is used when the number of repetitions
                 is not known in advance.                             }
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    ButtonPaint: TButton;
    procedure ButtonPaintClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ====================================================================
  This procedure runs when ButtonPaint is clicked.

  Input           : None.
  Process         : Erase the previous picture by drawing
                    a white rectangle.
                    Repeat until X1 is zero.
                    Select random values for X1, Y1, X2, Y2.
                    Select a random colour built from random
                    amounts of Blue, Green and Red.
                    Draw a line from X1, Y1 to X2, Y2 in the colour.
  Test data       : None.  Repetition should continue until X1 is Zero.
  Expected Output : Random lines in random colours.
  Actual Output   : As expected.
  Action Needed   : None.                                                }

procedure TForm1.ButtonPaintClick(Sender: TObject);
Var X1, Y1, X2, Y2 : Integer;
    Colour : TColor;
begin
  X1 := 1;  { Make sure X1 is not zero or the procedure will never run. }

  { Clear the previous drawings. }
  image1.canvas.rectangle(0, 0, image1.width, image1.height);

  { Draw random lines in random colours until by chance X1 = 1 }
  while X1 <> 0 do
  begin
    { Get some random values for line drawing. }
    X1 := random(image1.width);
    Y1 := random(image1.height);
    X2 := random(image1.width);
    Y2 := random(image1.height);

    { Get a random colour. }
    Colour := random($100) + $100 * random($100) + $10000 * random($100);

    { Set the pen colour and draw the line. }
    image1.canvas.pen.color := Colour;
    image1.canvas.moveTo(X1, Y1);
    image1.canvas.lineTo(X2, Y2);
  end;
end;

{ ====================================================================
  This procedure runs once when the program first starts up.            }
procedure TForm1.FormCreate(Sender: TObject);
begin
  { Make the first random number random. }
  randomize
end;

end.

