{ 08For - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE

    Repetition, using a For Loop, is
    demonstrated here.  Painting text
    onto a canvas is demonstrated.

    A procedure is used to do some complex processing.
    The for loop repeats this complex processing.

    A variable called Counter is used.
    This is an Integer (whole number) variable.

    TASK ONE (Beginners)

    Do your own repetition to any
    design you like.

    TASK TWO (Advanced)

    Display 'Hello' repeatedly in a circular
    shape.  Use the PI, SIN and COS functions.
}
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    procedure doText(atX, atY : Integer);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ Input           : X and Y screen position.
  Process         : Hello is displayed with a black background with
                    A big red 'H'
                    A smaller 'e' in pale blue
                    A smaller lime coloured 'l'
                    A still smaller 'l' in yellow
                    A very small o in blue.
  Test Data       : Test using a variety of X and Y values.
  Expected Output : Described above.
  Actual Output   : As expected.
  Action Needed   : None.                                               }

procedure TForm1.doText(atX, atY : Integer);
begin
  Form1.Canvas.Brush.Color := clBlack;
  Form1.Canvas.Font.Size := 40;
  Form1.Canvas.Font.Color := clRed;
  Form1.Canvas.TextOut(atX * 40, atY * 30, 'H');
  Form1.Canvas.Font.Size := 30;
  Form1.Canvas.Font.Color := clTeal;
  Form1.Canvas.TextOut(40 + atX * 40, atY * 30, 'e');
  Form1.Canvas.Font.Size := 20;
  Form1.Canvas.Font.Color := clLime;
  Form1.Canvas.TextOut(60 + atX * 40, atY * 30, 'l');
  Form1.Canvas.Font.Size := 15;
  Form1.Canvas.Font.Color := clYellow;
  Form1.Canvas.TextOut(70 + atX * 40, atY * 30, 'l');
  Form1.Canvas.Font.Size := 12;
  Form1.Canvas.Font.Color := clBlue;
  Form1.Canvas.TextOut(80 + atX * 40, atY * 30, 'o');
end;

{ This procedure runs when Button1 is clicked.

  Input           : None.
  Process         : Repeat 10 times counting from 1 to 10.
                    Call the doText procedure.  Pass the value
                    of the counter into the doText procedure call.
  Test Data       : None.
  Expected Output : None.  The doText procedure generates the output.
  Actual Output   : None.
  Action Needed   : None.                                               }

procedure TForm1.Button1Click(Sender: TObject);
Var Counter : Integer;
begin
  For Counter := 1 To 10 Do
  Begin
    doText(Counter, Counter);
  End
end;

end.

