{ 07Anim - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE   This program uses two image controls and
              timers.  Use windows paintbrush to draw
              both images.  There is a desert island
              and a shark fin.

              One timer moves the shark fin image to
              the right about three times per second.

              The man's face is altered slightly about
              once per second.

    TASK      Set up your own animation.
              Get on-line help on Timage to find out
              how to display images.                           }
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Image2: TImage;
    Image1: TImage;
    Timer2: TTimer;
    Button1: TButton;
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ =================================================================
  This procedure runs on every clock tick of timer1.

  Input           : None.
  Process         : Move image2 two pixels to the right.
                    Close the program if the image moves beyond 169.
  Test Data       : There is no input data.
  Expected Output : Sharks fin moves right until the program closes.
  Actual Output   : As expected.
  Action Needed   : None.                                             }

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  image2.Left := image2.Left + 2;

  if image2.Left > 169 then    { Close the program when the image }
  begin                        { gets to the right of the screen. }
    close
  end
end;

{ =================================================================
  This procedure runs on every clock tick of timer2.

  Input           : None.
  Process         : If the brush colour is gray them make it white.
                    If the brush colour is white them make it gray.
                    Draw an ellipse using the brush colour.
  Test Data       : There is no input data.
  Expected Output : The man should blink.
  Actual Output   : As expected.
  Action Needed   : None.                                             }

procedure TForm1.Timer2Timer(Sender: TObject);
begin
  { Change the colour that is used to paint the man's eye. }
  if image1.canvas.brush.color = clGray then
  begin
    image1.canvas.brush.color := clWhite
  end
  else
  begin
    image1.canvas.brush.color := clGray
  end;

  { Draw a very small ellipse. The eye. }
  image1.canvas.ellipse(85, 74, 89, 78)
end;

{ =================================================================
  This procedure runs if button1 is clicked.

  Input           : None.
  Process         : Close the program.
  Test Data       : There is no input data.
  Expected Output : The program should close.
  Actual Output   : As expected.
  Action Needed   : None.                                             }

procedure TForm1.Button1Click(Sender: TObject);
begin
  close
end;

end.

