{ 04RTotal - Example program from http://www.SoftwareForEducation.com/ }

{ EXAMPLE    Add the input numbers and display the running total.
             Note the rounding off errors!
  TASK 1     Count the input numbers as they are entered.
             Display this count.
  Task 2     Work out the average of the input numbers.
             Display the average.                                   }
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TFormMain = class(TForm)
    EditInput: TEdit;
    ButtonAdd: TButton;
    LabelRunningTotal: TLabel;
    LabelAnswer: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ButtonAddClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    runningTotal : Real;   { Real numbers look like this 123.456 }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

{ This procedure runs once when the program first starts up.
  It initialises the runningTotal variable to zero.           }
procedure TFormMain.FormCreate(Sender: TObject);
begin
  runningTotal := 0;
end;

{ ======================================================================
  This procedure runs when the button is clicked.

  Input           : A text string taken from edit1.
  Process         : Convert the text string to its number equivalent.
                    Add the number to the running total.
                    Convert the answer back into text.
                    Display the result on the labelAnswer caption.
                    Focus the edit control ready for the next number input.
  Test Data       : Any numerical text item such as '12.26'
                    Test for overflows using very large numbers.
  Expected Output : Running total with the new number added.
                    Large number addition causes overflow errors.
                    Non numerical input causes the program to fail.
  Actual Output   : The numbers are totalled correctly unless there is
                    an overflow or non numerical input.
  Action Needed   : None.  The procedure works correctly.   }

procedure TFormMain.ButtonAddClick(Sender: TObject);
begin
  { strToFloat conterts a text string to a floating point real number }
  { floatToStr conterts a floating point real number to a text string }
  runningTotal := runningTotal + strToFloat(editInput.Text);
  labelAnswer.caption := floatToStr(runningTotal);

  editInput.setFocus;    { Make editInput ready for the next number. }
  editInput.selectAll;   { All data in editInput is highlighted.     }
end;

end.
