{ 03Volume - Example program from http://www.SoftwareForEducation.com/ }

{
      EXAMPLE    Multiplying three numbers to find a volume.

      TASK 1     Write a program to find the area of a triangle
                 given the base and height.

      TASK 2     Write a program to find the area of a circle
                 given the radius.  Look up the Pi function.

      TASK 3     Write a program to find the volume of a cylinder
                 given its height and diameter.

      MORE       There are many related problems that can be solved
                 with programs of this type.
}



unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TFormMain = class(TForm)
    GroupBoxTankVolume: TGroupBox;
    EditHeight: TEdit;
    EditWidth: TEdit;
    EditDepth: TEdit;
    ButtonTankVolume: TButton;
    LabelHeight: TLabel;
    LabelWidth: TLabel;
    LabelDepth: TLabel;
    LabelAnswer: TLabel;
    procedure ButtonTankVolumeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

{ This procedure runs when ButonTankVolume is pressed.

  Input           : Three real numbers in text format.
  Process         : Convert the three text represenataions of the real
                    numbers into there numerical equivalents.
  Test data       : 3, 4, 5 in each of the edit boxes.
                    Also test with big negative numbers.
                    Also test with zero values.
                    Also test with big positive numbers.
  Expected output : 60 for the simple test.
  Actual output   : 60
  Action needed   : None.                                                 }
procedure TFormMain.ButtonTankVolumeClick(Sender: TObject);
begin
  { Displays the answer on the caption of labelAnswer.                    }
  { Format float converts a real number into text.  The layout is         }
  { controled with a format string.  In this case it is '0.00'            }
  { This gives two digits after the decimal point.                        }
  labelAnswer.Caption :=
    'Volume = ' +                    { Display this text.                 }
    formatFloat('0.00',              { Controls number layout e.g. 27.23  }
      strToFloat(editHeight.text) *  { Convert text to real and multiply. }
      strToFloat(editWidth.text)  *  { Convert text to real and multiply. }
      strToFloat(editDepth.text)     { Convert text to real and multiply. }
    ) +
    ' metres cubed.'                 { Join this text to the end.         }
end;

end.

