unit MainForm;

{
1997 May 13  V1.1.0  Testbed for DiskList component (Delphi 3.0)
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DiskList, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    DiskListView1: TDiskListView;
    procedure FormShow(Sender: TObject);
    procedure DiskListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
  // here's where I chose to do the ScanDrives.  In a real program, I might use
  // a timer triggered by the form's Create method.  The key thing is that a
  // window must exist (even if it's not visible) when ScanDrives is called.
  DiskListView1.ScanDrives;
end;

procedure TForm1.DiskListView1Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  s: string;
  i: integer;
begin
  s := DiskListView1.SelectedDrives;
  if length (s) = 1
    then Caption := 'Drive '
    else Caption := 'Drives ';
  for i := 1 to Length (s) do
    Caption := Caption + s [i] + ': ';
end;

end.
