unit MainForm;


{
Simple program to test and demonstrate the PieChart unit

Revision history:

V1.2.0  1997 Feb 08  Update for a right-click response on the pie chart
V1.3.0  1997 May 12  Version for Delphi 3.0
V1.3.2  1997 May 17  For PieChart V1.3.2 - colour updates
V1.4.0  1997 Dec 05  Compile with Delphi 3.02
                     For PieChart V1.4.0 - handles negative data
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, PieChart, MultiColour;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    PieChart1: TPieChart;
    procedure FormCreate(Sender: TObject);
    procedure PieChart1DblClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure PieChart1RightClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    str: TStringList;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  str := TStringList.Create;
  with str do                    // add objects in random numeric order
    begin
    AddObject (' 8 Merville', pointer (0));
    AddObject ('-11 Basic', pointer (1));
    AddObject (' 13 Thorwald', pointer (2));
    AddObject ('2.3 Decus', pointer (3));
    AddObject ('7 Storuman', pointer (4));
    AddObject ('5 Turbo', pointer (5));
    AddObject ('3.5 Pascal', pointer (6));
    AddObject ('3 Perl', pointer (7));
  end;
  PieChart1.NumColours := SpinEdit1.Value;
  PieChart1.SetDataAndLabels (str);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  str.Free;
end;

procedure TForm1.PieChart1DblClick(Sender: TObject);
var
  i: integer;
begin
  // Convert object pointer back to useful information, here the index
  // into a TStrings object attached to a list box.  Note that the full
  // string as stored is displayed, including the number part
  i := integer(PieChart1.ClickedObject);
  ShowMessage ('Double click: ' + str.Strings [i]);
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
var
  s: string;
  space: integer;
begin
  // if the list box is doubled clicked, find the item currently
  // selected (i.e. at ItemIndex), and remove any numeric part
  with ListBox1 do
    begin
    s := Items [ItemIndex];
    space := Pos (' ', s);
    if space = 0
    then s := ''
    else s := Trim (Copy (s, space, 999));
    ShowMessage (s);
    end;
end;

procedure TForm1.PieChart1RightClick(Sender: TObject);
var
  i: integer;
begin
  // Convert object pointer back to useful information, here the index
  // into a TStrings object attached to a list box.  Note that the full
  // string as stored is displayed, including the number part
  i := integer(PieChart1.ClickedObject);
  ShowMessage ('Right click: ' + str.Strings [i]);
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  PieChart1.NumColours := SpinEdit1.Value;
end;

end.

