unit VideoCapture;

{
Revision history:

V1.0.0  1997 Jun 07  First version put in library
V1.0.2  1997 Oct 18  Add WM_CAP_GET/SET_VIDEOFORMAT
}

interface

uses
  Windows, Messages;

// UNICODE
//
// The Win32 version of AVICAP on NT supports UNICODE applications:
// for each API or message that takes a char or string parameter, there are
// two versions, ApiNameA and ApiNameW. The default name ApiName is #defined
// to one or other depending on whether UNICODE is defined. Apps can call
// the A and W apis directly, and mix them.
//
// The 32-bit AVICAP on NT uses unicode exclusively internally.
// ApiNameA() will be implemented as a call to ApiNameW() together with
// translation of strings.

// Defines start of the message range

const
  WM_CAP_START             = WM_USER;
  WM_CAP_DRIVER_CONNECT    = WM_CAP_START + 10;
  WM_CAP_DRIVER_DISCONNECT = WM_CAP_START + 11;
  WM_CAP_FILE_SAVEDIB      = WM_CAP_START + 25;
  WM_CAP_GET_VIDEOFORMAT   = WM_CAP_START + 44;
  WM_CAP_SET_VIDEOFORMAT   = WM_CAP_START + 45;
  WM_CAP_GRAB_FRAME        = WM_CAP_START + 60;
  WM_CAP_SEQUENCE          = WM_CAP_START + 62;

(*
Video Capture: A Minimal Approach

Video capture digitizes a stream of video and audio data, and
stores it on a hard disk or some other type of persistent
storage device. This section describes how to add a simple
form of video capture to an application using three statements
of code. It also describes how to end or abort a capture
session by sending messages to the capture window.

An AVICap capture window handles the details of streaming
audio and video capture to AVI files. This frees your
application from involvement in the AVI file format, video and
audio buffer management, and the low-level access of video and
audio device drivers. AVICap provides a flexible interface for
applications. You can add video capture to your application,
using only the following lines of code:

hWndC = capCreateCaptureWindow ( "My Own Capture Window",
    WS_CHILD | WS_VISIBLE , 0, 0, 160, 120, hwndParent, nID);

SendMessage (hWndC, WM_CAP_DRIVER_CONNECT, 0 /* wIndex */, 0L);

SendMessage (hWndC, WM_CAP_SEQUENCE, 0, 0L);

In C, a macro interface is also available that provides an
alternative to using the SendMessage function and improves
the readability of an application. The following example uses
the macro interface to add video capture to an application.

hWndC = capCreateCaptureWindow (	"My Own Capture Window",
    WS_CHILD | WS_VISIBLE ,	0, 0, 160, 120, hwndParent, nID);

capDriverConnect (hWndC, 0);

capCaptureSequence (hWndC);

After your application creates a capture window of the AVICap
window class and connects it to a video driver, the capture
window is ready to capture data. At this point, your
application can simply send the WM_CAP_SEQUENCE message (or
the capCaptureSequence macro) to begin capturing.

Using default settings, WM_CAP_SEQUENCE initiates the capture
of video and audio input to a file named CAPTURE.AVI. Capture
continues until one of the following events occurs:

 The user presses the esc key or a mouse button.

 Your application stops or aborts capture operation.

 The disk becomes full.

In an application, you can stop streaming captured data to a
file by sending the WM_CAP_STOP (or the capCaptureStop macro)
message to a capture window. You can also abort the capture
operation by sending the WM_CAP_ABORT message (or the
capCaptureAbort macro) to a capture window.
*)

function capCreateCaptureWindow (
        lpszWindowName: LPCSTR;
        dwStyle: DWORD;
        x: integer;  y: integer;  nWidth: integer;  nHeight: integer;
        hwndParent: HWND;  nID: integer): HWND; stdcall;

implementation

function capCreateCaptureWindow; external 'AVICAP32.DLL' name 'capCreateCaptureWindowA';

end.
