unit LED;

{
V1.0.0  1997 May 03  First version
V1.1.0  1997 May 12  Version for Delphi 3.0
                     Add clipping region for background transparency
                     Make height and width 17 pixels
                     Compile as Delphi Design & Runtime package
V1.1.2  1997 Oct 19  Only invalidate if colour is changed
                     Remove need for DJT's run-time package,
                     .. will need a $R LED.dcr in your form unit
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
  min_height = 17;
  min_width = 17;

type
  TLED = class(TGraphicControl)
  private
    { Private declarations }
    FColour: TColor;
    FBitmap: TBitmap;
  protected
    { Protected declarations }
    procedure Paint;  override;
    procedure SetColour (colour: TColor);
  public
    { Public declarations }
    constructor Create (AOwner: TComponent);  override;
    destructor Destroy;  override;
  published
    { Published declarations }
    property Height default min_height;
    property Width default min_width;
    property Colour: TColor read FColour write SetColour default clLime;
  end;

procedure Register;


implementation

procedure Register;
begin
  RegisterComponents('Davids', [TLED]);
end;

constructor TLED.Create (AOwner: TComponent);
begin
  Inherited Create (AOwner);
  Width := min_width;
  Height := min_height;
  FColour := clLime;
  // because we compile and define the package as run-time (as well as design
  // time), the bitmap resource will be available in the .DPL file
  FBitmap := TBitmap.Create;
  try
    FBitmap.LoadFromResourceName (HInstance, 'TLED');
  except
  end;
end;

destructor TLED.Destroy;
begin
  FBitmap.Free;
  Inherited Destroy;
end;

procedure TLED.SetColour (colour: TColor);
begin
  if FColour <> colour then
    begin
    FColour := colour;
    Invalidate;
    end;
end;

procedure TLED.Paint;
var
  present_colour: TColor;
  clip_region: THandle;
begin
  with Canvas do
    begin
    // define a circular clipping region just bigger than the LED
    // don't understand why the corodinates refer to the underlying canvas
    clip_region := CreateEllipticRgn (Left, Top,
                       Left + FBitmap.Width + 3, Top + FBitmap.Width + 3);
    // apply this clipping region
    SelectClipRgn (Canvas.handle, clip_region);
    // copy the bitmap image of the LED
    Draw (1, 1, FBitmap);
    // see what the colour is at the centre
    present_colour := Pixels [9, 9];
    if present_colour <> FColour then    // need to change the colour
      begin
      Brush.Color := FColour;
      FloodFill (8, 8, present_colour, fsSurface);
      end;
    end;
end;

end.

