unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, TreeScan, ExtCtrls;

type
  TForm1 = class(TForm)
    ButtonScan: TButton;
    ListBoxFiles: TListBox;
    ButtonExit: TButton;
    ListBoxFolders: TListBox;
    Label2: TLabel;
    Label3: TLabel;
    Panel1: TPanel;
    Label4: TLabel;
    LabelFolders: TLabel;
    LabelFiles: TLabel;
    chkHiddenFiles: TCheckBox;
    chkHiddenFolders: TCheckBox;
    ButtonMult: TButton;
    TreeScanner1: TTreeScanner;
    procedure ButtonScanClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
    procedure TreeScanner1FileFound(Sender: TObject);
    procedure TreeScanner1DirectoryFound(Sender: TObject);
    procedure TreeScanner1DirectoryDone(Sender: TObject);
    procedure chkHiddenFoldersClick(Sender: TObject);
    procedure chkHiddenFilesClick(Sender: TObject);
    procedure TreeScanner1SearchDone(Sender: TObject);
    procedure ButtonMultClick(Sender: TObject);
  private
    { Private declarations }
    folder_count: integer;
    file_count: integer;
    procedure ScanTree;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  win_dir: array [0..132] of char;
begin
  GetWindowsDirectory (@win_dir, 132);
  TreeScanner1.InitialDirectory := win_dir;
  chkHiddenFolders.Checked := TreeScanner1.FindHiddenFolders;
  chkHiddenFiles.Checked := TreeScanner1.FindHiddenFiles;
end;

procedure TForm1.ScanTree;
var
  saved_cursor: TCursor;
  saved_scan_caption: string;
  saved_mult_caption: string;
begin
  // prepare visual aspects of starting a scan
  saved_scan_caption := ButtonScan.Caption;
  saved_mult_caption := ButtonMult.Caption;
  ButtonScan.Caption := '&Stop';
  ButtonMult.Caption := '&Stop';
  saved_cursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  ListBoxFolders.Items.Clear;
  ListBoxFiles.Items.Clear;
  folder_count := 0;
  file_count := 0;

  // do the scan itself
  TreeScanner1.ScanTree;

  // restore the visual elements which were changed
  Screen.Cursor := saved_cursor;
  ButtonScan.Caption := saved_scan_caption;
  ButtonMult.Caption := saved_mult_caption;
end;

procedure TForm1.ButtonMultClick(Sender: TObject);
begin
  if TreeScanner1.SearchInProgress then
    begin
    TreeScanner1.Continue := False;
    Exit;
    end;
  TreeScanner1.FileMaskCommaText := '*.gid *.fts';
  ScanTree;
end;

procedure TForm1.ButtonScanClick(Sender: TObject);
begin
  if TreeScanner1.SearchInProgress then
    begin
    TreeScanner1.Continue := False;
    Exit;
    end;
  TreeScanner1.FileMask := '*.gid';
  ScanTree;
end;

procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  TreeScanner1.Continue := False;
  Close;
end;

procedure TForm1.TreeScanner1FileFound(Sender: TObject);
begin
  with TreeScanner1 do
    ListBoxFiles.Items.Add (Format ('%10.0n   %s', [FileSize + 0.0, FileFound]));
  Inc (file_count);
end;

procedure TForm1.TreeScanner1DirectoryFound(Sender: TObject);
begin
  ListBoxFolders.Items.Add (TreeScanner1.FileFound);
  Inc (folder_count);
end;

procedure TForm1.TreeScanner1DirectoryDone(Sender: TObject);
begin
  LabelFolders.Caption := IntToStr (folder_count);
  LabelFiles.Caption := IntToStr (file_count);
end;

procedure TForm1.chkHiddenFoldersClick(Sender: TObject);
begin
  TreeScanner1.FindHiddenFolders := chkHiddenFolders.Checked;
end;

procedure TForm1.chkHiddenFilesClick(Sender: TObject);
begin
  TreeScanner1.FindHiddenFiles := chkHiddenFiles.Checked;
end;

procedure TForm1.TreeScanner1SearchDone(Sender: TObject);
begin
  MessageBeep (0);
end;

end.

