unit MainForm;

{
Revision history:

V1.0.0  1997 Apr 27  First version
V1.1.0  1997 May 12  Version for Delphi 3.0
                     Add compile-time live data, but don't save it
V1.1.2  1997 May 18  Make RowSelect true by default
V1.1.4  1998 Feb 23  Add file version information column
                     Make alignments automatic to fill test form
V1.1.6  1998 Mar 15  Autosize columns
                     Add product version as well as file version
V1.1.8  1998 Mar 16  More defensive programming for text compare errors
                     Columns widths set from header text
V1.1.10 1998 Mar 31  Add Begin/End update around adding sub-items
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, FileList, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Label1: TLabel;
    FileListView1: TFileListView;
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
var
  s: TSearchRec;
  filesize: integer;
  dir: string;
begin
  Timer1.Enabled := False;

  dir := ExtractFilePath (ExpandFileName ('.\'));
  Label1.Caption := 'Scanning ' + dir + '...';
  FileListView1.Items.BeginUpdate;
  if FindFirst ('*.*', faArchive + faReadOnly, s) = 0 then
  repeat
    FileListView1.AddFile (ExtractFilePath (ExpandFileName('.\')) + s.Name, filesize);
  until FindNext (s) <> 0;
  FindClose (s);
  FileListView1.SortType := stData;
  FileListView1.SortType := stNone;
  FileListView1.Items.EndUpdate;
  Label1.Caption := 'The FileListView below shows all the normal files in ' +
                     dir + '  The default for the FileListView is to sort ' +
                     'on the file size, however, the sort type must be ' +
                     'changed to stData and back to stNone in order to ' +
                     'force the sorting to actually happen.  ' +
                     'Try clicking on a column header.';
end;

end.

