;
; Converts some or all instructions in a file to "db"
;
; Mikael Klasson aka Fluff
; fluff@geocities.com
; http://fluff.home.ml.org
;

.386p
code32 segment para public use32
	assume cs:code32, ds:code32

include pmode.inc
include dazmit.inc
include argc.inc

public	_main

MAX_LINELEN	EQU	1024
VERSIONSTRING	EQU	'v0.80'

;
; C O D E 
;
_main:
	mov	dazmitsegsize,1 	; assume 32 bits as default

	mov	al,-1
	lea	edx,infname-260
argslopstr:
	add	edx,260
argslop:
	inc	eax
	call	_getarg
	jc	argsdone

	cmp	bl,1
	jb	argslopstr
	mov	ecx,-1
	je	argswitch
	cmp	bl,2
	ja	showhelpmsg
	mov	ecx,[edx]
argswitch:
	movzx	ebx,bh
	mov	switchvalues[ebx*4],ecx
	jmp	argslop

argsdone:
	cmp	edx,offset outfname
	jbe	showhelpmsg

	lea	edx,infname
	call	_openfile
	jc	_openerr
	mov	ax,v86r_bx
	mov	fin,ax

	lea	edx,outfname
	call	_createfile
	jc	_createerr
	mov	ax,v86r_bx
	mov	fout,ax

	cmp	switch_s,16
	jne	mainlop
	mov	dazmitsegsize,0


mainlop:
	lea	edx,buffer
	mov	ebx,0
rllop:
	mov	ecx,1
	call	_readfile
	jc	hiteof
	or	eax,eax
	jz	hiteof
	inc	ebx
	mov	al,[edx]
	inc	edx
	or	al,al
	jz	lineok
	cmp	al,10
	je	lineok
	cmp	al,';'
	je	lineok
	jmp	rllop
hiteof:
	mov	eof,-1
lineok:
	mov	linelen,ebx
	or	ebx,ebx
	jz	_end
	mov	dword ptr [edx],0
	mov	ecx,ebx
	lea	esi,buffer

	mov	ebx,curoffset
	call	_assemble
	add	curoffset,ecx

	lea	edi,linebuf

	jecxz	nextline

	cmp	switch_a,0
	jne	conv
	test	dazmitcpu,P_3DNOW
	jnz	conv
	cmp	switch_m,0
	je	nextline
	test	dazmitcpu,P_MMX
	jz	nextline

conv:
	lea	esi,dazmitbuf
	mov	dword ptr [edi],009626409h	; 9,'db',9
	add	edi,4
	mov	byte ptr [edi],'0'
	inc	edi
	jmp	lopstart

lop:
	mov	word ptr [edi],'0,'
	add	edi,2
lopstart:

	lodsb

	push	eax
	shr	al,4
	call	pn
	pop	eax
	push	offset pnok
pn:
	and	al,0fh
	cmp	al,10
	sbb	al,69h
	das
	stosb
	ret

pnok:
	mov	byte ptr [edi],'h'
	inc	edi

	loop	lop

	mov	word ptr [edi],03b09h		; 9,';'
	add	edi,2

nextline:
	mov	ecx,linelen
	lea	esi,buffer
	rep	movsb
	mov	ecx,edi
	sub	ecx,offset linebuf
	lea	edx,linebuf
	call	_writefile

	cmp	eof,0
	je	mainlop
	jmp	_end


showhelpmsg:
	lea	edx,initstr
	call	_puts

_end:
	jmp	_exit


_openerr:
	lea	edx,openerrstr
	call	_puts
	jmp	_exit

_createerr:
	lea	edx,createerrstr
	call	_puts
	jmp	_exit

_readerr:
	lea	edx,readerrstr
	call	_puts
	jmp	_exit


;
_puts:
	pushad
	add	edx,_code32a
	mov	eax,edx
	and	eax,0fh
	shr	edx,4
	mov	v86r_ds,dx
	mov	v86r_dx,ax
	mov	v86r_ah,9
	mov	al,21h
	int	33h
	popad
	ret


;
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error opening file
;   CF=0 - File opened succesfully
;     V86R_BX - file handle
_openfile:
	pushad
	add	edx,_code32a
	mov	eax,edx
	shr	edx,4
	and	eax,0fh
	mov	v86r_dx,ax
	mov	v86r_ds,dx
	mov	v86r_ax,3d02h
	mov	al,21h
	int	33h
	mov	ax,v86r_ax
	mov	v86r_bx,ax
	popad
	ret


;
; Create file
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error creating file
;   CF=0 - File created succesfully
;     V86R_BX - file handle
_createfile:
	pushad
	add	edx,_code32a
	mov	eax,edx
	shr	edx,4
	and	eax,0fh
	mov	v86r_dx,ax
	mov	v86r_ds,dx
	mov	v86r_ax,3c00h
	mov	v86r_cx,20h
	mov	al,21h
	int	33h
	mov	ax,v86r_ax
	mov	v86r_bx,ax
	popad
	ret


;
; In:
;   V86R_BX - file handle
;   CF=1 - Error closing file
;   CF=0 - File closed succesfully
_closefile:
	push	eax
	mov	v86r_ax,3e00h
	mov	al,21h
	int	33h
	pop	eax
	ret


;
; In:
;   EDX -> buffer to read to
;   CX - number of bytes to read
; Out:
;   CF=1 - Error reading file
;     EAX - ?
;   CF=0 - Read went fine
;     EAX - number of bytes read
_readfile:
	pushad
	mov	ax,fin
	mov	v86r_bx,ax
	add	edx,_code32a
	mov	eax,edx
	shr	eax,4
	and	edx,0fh
	mov	v86r_ds,ax
	mov	v86r_dx,dx
	mov	v86r_cx,cx
	mov	v86r_ax,3f00h
	mov	al,21h
	int	33h
	movzx	eax,v86r_ax
	mov	[esp+28],eax
	popad
	ret


;
; Write to file
; In:
;   EDX -> buffer to write from
;   CX - number of bytes to write
; Out:
;   CF=1 - Error writing file
;     EAX - ?
;   CF=0 - Write went fine
;     EAX - number of bytes written
_writefile:
	pushad
	mov	ax,fout
	mov	v86r_bx,ax
	add	edx,_code32a
	mov	eax,edx
	shr	edx,4
	and	eax,0fh
	mov	v86r_ds,dx
	mov	v86r_dx,ax
	mov	v86r_cx,cx
	mov	v86r_ax,4000h
	mov	al,21h
	int	33h
	movzx	eax,v86r_ax
	mov	[esp+28],eax
	popad
	ret


;
initstr 	db	'De3dNow ',VERSIONSTRING,' (C) 1998 Mikael Klasson aka Fluff (fluff@geocities.com)',13,10
		db	'Usage: De3DNow [-a] [-m] [-s 16|32] INFILE.EXT OUTFILE.EXT',13,10,10
		db	'Args:',13,10
		db	'  a == Assemble all instructions',13,10
		db	'  m == Assemble MMX instructions',13,10
		db	'  s == Segment size (32 is default)',13,10,36

openerrstr	db	'Error: Couldn''t open file!',13,10,36
createerrstr	db	'Error: Couldn''t create file!',13,10,36
readerrstr	db	'Error: Couldn''t read from file!',13,10,36

fin		dw	?
fout		dw	?

eof		dd	0
linelen 	dd	?

align	16
curoffset	dd	100h

infname 	db	260 dup(?)
outfname	db	260 dup(?)
buffer		db	MAX_LINELEN dup(?)
linebuf 	db	MAX_LINELEN * 2 dup(?)


;
code32 ends
end

