;
; DazmIt v1.13 (C) 1997-1998 Mikael Klasson
; fluff@geocities.com
; http://fluff.home.ml.org
;
; Feel free to use this in freeware stuff as long as you give me credits
; for it. Read README.TXT for [slightly] more info. Questions? Comments?
; Email me.

.386p
code32 segment para public use32
	assume cs:code32, ds:code32

include pmode.inc
include dazmit.inc
include dazmit.equ

PUTZEROS	EQU	0
VERSIONSTRING	EQU	'v1.13'
SEGSIZE 	EQU	0      ; 0 == 16 bit, 1 == 32 bit

PRINTARGS	EQU	0
PRINTOPC	EQU	0
PRINTSTUFF	EQU	0

;
; In:
;	EBX == Offset to where this instructions starts (used w/ rel offsets)
;	ESI -> Buffer to read instruction from (e.g -> "mov ax,cx")
; Out:
;	ECX == Length in bytes
;	dazmitbuf == Instruction bytes
;	dazmitcpu == minimum cpu required for current instruction
;	CF == 1 if an error was found
;	CF == 0 if no error
;
_assemble:
	pushad

	mov	___assemble_curoffset,ebx
	mov	al,dazmitsegsize
	mov	addressbits,al
	mov	databits,al

	call	_ltrim

; find length of mnemonic
	push	esi
__assemble_mnelen_lop:
	lodsb
	cmp	al,' '
	je	__assemble_mnelen_end
	cmp	al,13
	je	__assemble_mnelen_end
	cmp	al,10
	je	__assemble_mnelen_end
	cmp	al,9
	je	__assemble_mnelen_end
	cmp	al,0
	je	__assemble_mnelen_end
	cmp	al,';'
	jne	__assemble_mnelen_lop
__assemble_mnelen_end:
	lea	edx,[esi-1]
	pop	esi
	sub	edx,esi

; edx == strlen( mnemonic );
	lea	edi,mnemonics
	mov	ebp,-1
__assemble_lop:
	inc	ebp
	movzx	ecx,byte ptr [edi]
	jecxz	__assemble_err
	cmp	ecx,edx
	jne	__assemble_lop_1
	push	esi
	push	edi
	inc	edi
	repe	cmpsb
	pop	edi
	pop	esi
__assemble_lop_1:
	movzx	ebx,byte ptr [edi]
	lea	edi,[edi+ebx+1]
	jne	__assemble_lop
	or	ecx,ecx
	jnz	__assemble_lop

	add	esi,ebx
	call	_ltrim

	lea	eax,mnemonics_special
__assemble_mnespec_lop:
	xor	ebx,ebx
	cmp	word ptr [eax],0
	je	__assemble_mnespec_done
	cmp	bp,[eax]
	je	__assemble_mnespec_found16
	inc	ebx
	cmp	bp,[eax+2]
	je	__assemble_mnespec_found32
	add	eax,2*2
	jmp	__assemble_mnespec_lop
__assemble_mnespec_found32:
	mov	bp,[eax]
__assemble_mnespec_found16:
	cmp	bl,dazmitsegsize
	je	__assemble_mnespec_done
	mov	al,1
	sub	al,dazmitsegsize
	mov	databits,al
__assemble_mnespec_done:


; esi -> first arg

	mov	arg1type,O_NONE
	mov	arg2type,O_NONE
	mov	arg3type,O_NONE

	call	_arglen
	jz	__assemble_argsdone
IF	PRINTARGS
	call	_pcrlf
	call	_pcrlf
	mov	eax,'ar1:'
	call	_pc4
ENDIF
	push	ecx
	call	_argtype
IF	PRINTARGS
	xchg	eax,ebx
	call	_pd
	xchg	eax,ebx
	push	eax
	mov	al,':'
	call	_pc
	pop	eax
	call	_pw
	call	_pcrlf
ENDIF
	mov	arg1type,al
	mov	arg1size,ah
	mov	arg1data1,bl
	mov	arg1data2,bh
	mov	arg1data3,ecx
	mov	arg1data4,edx
	pop	ecx

	lea	esi,[esi+ecx+1]
	call	_ltrim

; esi -> 2nd arg

	call	_arglen
	jz	__assemble_argsdone
IF	PRINTARGS
	mov	eax,'ar2:'
	call	_pc4
ENDIF
	push	ecx
	call	_argtype
IF	PRINTARGS
	xchg	eax,ebx
	call	_pd
	xchg	eax,ebx
	push	eax
	mov	al,':'
	call	_pc
	pop	eax
	call	_pw
	call	_pcrlf
ENDIF
	mov	arg2type,al
	mov	arg2size,ah
	mov	arg2data1,bl
	mov	arg2data2,bh
	mov	arg2data3,ecx
	mov	arg2data4,edx
	pop	ecx

	lea	esi,[esi+ecx+1]
	call	_ltrim

; esi -> 3rd arg

	call	_arglen
	jz	__assemble_argsdone
IF	PRINTARGS
	mov	eax,'ar3:'
	call	_pc4
ENDIF
	push	ecx
	call	_argtype
IF	PRINTARGS
	xchg	eax,ebx
	call	_pd
	xchg	eax,ebx
	push	eax
	mov	al,':'
	call	_pc
	pop	eax
	call	_pw
	call	_pcrlf
ENDIF
	mov	arg3type,al
	mov	arg3size,ah
	mov	arg3data1,bl
	mov	arg3data2,bh
	mov	arg3data3,ecx
	mov	arg3data4,edx
	pop	ecx

; ebp == instructionnumber (see dazmit.equ)
__assemble_argsdone:

; allow "imul reg,imm" to equal "imul reg,reg,imm"
	cmp	ebp,M_IMUL
	jne	__assemble_imulfixok
	cmp	arg3type,O_NONE
	jne	__assemble_imulfixok
	cmp	arg2type,O_OM8EXP
	je	__assemble_imulfix
	cmp	arg2type,O_OM8
	je	__assemble_imulfix
	cmp	arg2type,O_1
	je	__assemble_imulfix
	cmp	arg2type,O_3
	je	__assemble_imulfix
	cmp	arg2type,O_OM1632
	jne	__assemble_imulfixok
__assemble_imulfix:
	mov	al,arg2type
	mov	arg3type,al
	mov	al,arg2size
	mov	arg3size,al
	mov	al,arg2data1
	mov	arg3data1,al
	mov	al,arg2data2
	mov	arg3data2,al
	mov	eax,arg2data3
	mov	arg3data3,eax
	mov	eax,arg2data4
	mov	arg3data4,eax

	mov	al,arg1type
	mov	arg2type,al
	mov	al,arg1size
	mov	arg2size,al
	mov	al,arg1data1
	mov	arg2data1,al
	mov	al,arg1data2
	mov	arg2data2,al
	mov	eax,arg1data3
	mov	arg2data3,eax
	mov	eax,arg1data4
	mov	arg2data4,eax
__assemble_imulfixok:

	mov	mneword3dnow,0
	cmp	ebp,M_3DNOWFIRST
	jb	__assemble_not3dnow
	cmp	ebp,M_3DNOWLAST
	ja	__assemble_not3dnow
	mov	mneword3dnow,bp
	mov	ebp,M_3DNOW
__assemble_not3dnow:

	lea	edi,opcodes
__assemble_seekopcode_lop:
	movzx	ecx,byte ptr [edi]
	jecxz	__assemble_err
	cmp	word ptr [edi+ecx+SIZEOF_OPCODE-2],bp
	je	__assemble_opcodefound
__assemble_opcodenotfound:
	lea	edi,[edi+ecx+SIZEOF_OPCODE]
	jmp	__assemble_seekopcode_lop

__assemble_opcodefound:
	mov	al,[edi+ecx+SIZEOF_OPCODE-4]
	cmp	al,OB_R0
	jb	__assemble_opcodefound_not_OB_RX
	cmp	al,OB_R7
	ja	__assemble_opcodefound_not_OB_RX
	sub	al,OB_R0
	mov	ebx,1
	cmp	arg1type,O_ST
	je	__assemble_OB_RX_use2ndarg
	mov	ah,[edi+ecx+1]
	and	ah,0f8h
	cmp	ah,O_ACCx
	je	__assemble_OB_RX_use2ndarg
	xor	ebx,ebx
__assemble_OB_RX_use2ndarg:
	cmp	argdata1[ebx],al
	jne	__assemble_opcodenotfound
__assemble_opcodefound_not_OB_RX:

	mov	al,[edi+1+ecx+SIZEOF_OPCODE-3]
	mov	dazmitcpu,al

	mov	al,arg1type
	mov	bh,[edi+1+ecx]
	call	_findcompatiblearg
	jc	__assemble_opcodenotfound
	mov	al,arg2type
	mov	bh,[edi+1+ecx+1]
	call	_findcompatiblearg
	jc	__assemble_opcodenotfound
	mov	al,arg3type
	mov	bh,[edi+1+ecx+2]
	call	_findcompatiblearg
	jc	__assemble_opcodenotfound

	lea	esi,[edi+1]
	lea	edi,dazmitbuf

	mov	al,dazmitsegsize
	cmp	al,databits
	jne	__assemble_datasizeprefix

	mov	al,dazmitsegsize
	add	al,3
	cmp	al,O_S_32
	je	__assemble_segsize1
	sub	al,2
__assemble_segsize1:
	mov	ah,byte ptr [esi+ecx]
	and	ah,07h
	cmp	ah,O_S_1632
	jne	__assemble_datasize_n1
	cmp	al,arg1size
	je	__assemble_datasizeprefix
__assemble_datasize_n1:
	mov	ah,byte ptr [esi+ecx+1]
	and	ah,07h
	cmp	ah,O_S_1632
	jne	__assemble_datasize_n2
	cmp	al,arg2size
	je	__assemble_datasizeprefix
__assemble_datasize_n2:
	mov	ah,byte ptr [esi+ecx+2]
	and	ah,07h
	cmp	ah,O_S_1632
	jne	__assemble_nodatasizeprefix
	cmp	al,arg3size
	jne	__assemble_nodatasizeprefix
__assemble_datasizeprefix:

	inc	ecx
	mov	al,066h
	stosb
	mov	al,1
	sub	al,dazmitsegsize
	mov	databits,al


; make sure 16-bit regs haven't been expanded to 32 bits
	xor	ebx,ebx
__assemble_verifyregs_lop:
	lea	eax,[esi+ecx-1]
	mov	al,[eax+ebx]
	and	al,07h
	cmp	al,O_S_1632
	jne	__assemble_verifyregs_ok
	mov	al,argtype[ebx]
	mov	ah,al
	and	al,0f8h
	cmp	al,O_Rx
	je	__assemble_verifyregs
	cmp	al,O_ACCx
	jne	__assemble_verifyregs_ok
__assemble_verifyregs:
	and	ah,07h
	sub	ah,2
	cmp	ah,databits
	jne	__assemble_err
__assemble_verifyregs_ok:
	inc	ebx
	cmp	ebx,2
	jbe	__assemble_verifyregs_lop

__assemble_nodatasizeprefix:
	mov	al,dazmitsegsize
	cmp	al,addressbits
	je	__assemble_noaddsizeprefix
	inc	ecx
	mov	al,067h
	stosb
__assemble_noaddsizeprefix:

IF	PRINTOPC
	call	_pcrlf
	mov	eax,'opc:'
	call	_pc4
ENDIF

	push	ecx
	movzx	ecx,byte ptr [esi-1]
	rep	movsb
	dec	esi
	pop	ecx

	mov	al,[esi+SIZEOF_OPCODE-4]
	cmp	al,OB_NONE
	je	__assemble_modrm_done
	cmp	al,OB_SR
	je	__assemble_ob_sr
	cmp	al,OB_R7
	jbe	__assemble_modrm_done
	cmp	al,OB_7
	ja	__assemble_err
	sub	al,OB_0
	shl	al,3
	mov	modrm,al
	xor	ebx,ebx
	jmp	__assemble_rm

__assemble_ob_sr:
	xor	ebx,ebx
	cmp	byte ptr [esi+1],O_LAST_REG
	jbe	__assemble_ob_sr_reg1st
	inc	ebx
__assemble_ob_sr_reg1st:
	mov	al,argdata1[ebx]
	shl	al,3
	mov	modrm,al
	neg	ebx
	inc	ebx
	jmp	__assemble_rm

__assemble_rm:
	cmp	byte ptr [esi+ebx+1],O_LAST_REG
	ja	__assemble_rm_mem
__assemble_rm_noshift:
	mov	al,argdata1[ebx]
	add	modrm,al
	jmp	__assemble_modrm_ok
__assemble_rm_mem:
	cmp	argdata2[ebx],0
	jne	__assemble_rm_noshift
	mov	al,argdata1[ebx]
	add	al,0c0h
	add	modrm,al
	jmp	__assemble_modrm_ok

__assemble_modrm_ok:
	mov	al,modrm
	stosb			; output modr/m byte
	inc	ecx

	cmp	addressbits,1
	jne	__assemble_modrm_done
        cmp     al,0c0h
        jae     __assemble_modrm_done
        and     al,007h
	cmp	al,4		; SIB
	jne	__assemble_modrm_done
	mov	al,___argtype_sib
        stosb                   ; output sib byte
	inc	ecx

__assemble_modrm_done:
        xor     ebx,ebx
__assemble_imm_lop:
	cmp	argtype[ebx],O_NONE
	je	__assemble_done
	mov	al,[esi+1+ebx]
	and	al,0f8h
	cmp	al,O_OMx
	je	__assemble_imm_lop_imm
	cmp	al,O_OMxEXP
	je	__assemble_imm_lop_imm
	cmp	al,O_OFFSx
	je	__assemble_imm_offs
	cmp	al,O_RELx
	je	__assemble_imm_lop_imm
	cmp	argdata2[ebx],1 	; mem modr/m operand
	je	__assemble_imm_modrm
	cmp	argdata2[ebx],3 	; direct far ptr
	jne	__assemble_imm_lop_end
__assemble_imm_dfar:
	push	esi
	mov	edx,ecx
	mov	cl,argsize[ebx]
	lea	esi,argdata4[ebx*4]
	jmp	__assemble_imm_checkimmbits2

__assemble_imm_modrm:
	cmp	argdata4[ebx*4],0
	je	__assemble_imm_lop_end
	push	esi
	mov	edx,ecx
	mov	cl,byte ptr argdata4[ebx*4]
	shr	cl,4
	inc	cl
	jmp	__assemble_imm_checkimmbits

__assemble_imm_offs:
	mov	databits,0		; ugly hack
	cmp	addressbits,0
	je	__assemble_imm_lop_imm
	mov	databits,1

__assemble_imm_lop_imm:
	push	esi
	mov	edx,ecx
	mov	cl,[esi+1+ebx]
__assemble_imm_checkimmbits:
	lea	esi,argdata3[ebx*4]
__assemble_imm_checkimmbits2:
	mov	ch,al
	and	cl,07h
	cmp	cl,O_S_1632
	jne	__assemble_imm_lop_not1632
	mov	cl,O_S_16
	cmp	databits,0
	je	__assemble_imm_lop_not1632
	mov	cl,O_S_32
__assemble_imm_lop_not1632:
	dec	cl
	mov	eax,1
	shl	eax,cl

	cmp	ch,O_RELx
	jne	__assemble_imm_lop_notrel
	mov	ecx,argdata3[ebx*4]
	sub	ecx,___assemble_curoffset
	sub	ecx,edx
	sub	ecx,eax
	mov	argdata3[ebx*4],ecx

__assemble_imm_lop_notrel:
	mov	ecx,eax
	rep	movsb
	lea	ecx,[edx+eax]
	pop	esi

	cmp	argdata2[ebx],3 	; direct far ptr
	jne	__assemble_imm_lop_end

	mov	eax,argdata3[ebx*4]
	stosw
	add	ecx,2

__assemble_imm_lop_end:
	inc	ebx
	cmp	ebx,2
	jbe	__assemble_imm_lop

	jmp	__assemble_done

__assemble_err:
	xor	ecx,ecx
	stc
	jmp	__assemble_end

__assemble_done:
	cmp	mneword3dnow,0
	je	__assemble_done_exit
	mov	bx,mneword3dnow
	lea	esi,suffixes3dnow
__assemble_3dnowlop:
	lodsb
	or	al,al
	jz	__assemble_err
	mov	dx,[esi]
	cmp	bx,dx
	jne	__assemble_3dnowlop
	stosb
	inc	ecx

__assemble_done_exit:
	clc
__assemble_end:
	mov	[esp+6*4],ecx
	popad
	ret

argtype 	label	byte
arg1type	db	?
arg2type	db	?
arg3type	db	?

argsize 	label	byte
arg1size	db	?
arg2size	db	?
arg3size	db	?

argdata1	label	byte
arg1data1	db	?
arg2data1	db	?
arg3data1	db	?

argdata2	label	byte
arg1data2	db	?
arg2data2	db	?
arg3data2	db	?

argdata3	label	dword
arg1data3	dd	?
arg2data3	dd	?
arg3data3	dd	?

argdata4	label	dword
arg1data4	dd	?
arg2data4	dd	?
arg3data4	dd	?

modrm		db	?

___assemble_curoffset	dd	?


;
; In:
;	AL  == Original argtype
;	BH  == Instruction-def's argtype
;	ECX == opcode's length in bytes
; Out:
;
_findcompatiblearg:
	push	edx
	mov	ah,al
	lea	esi,compatibleargs
	mov	bl,0	; compatible arg not found
__findcompatibleargslop:
	cmp	bh,al
	jne	__findcomparglop
	cmp	bh,O_REL8
	jne	__findcomparg_done
	mov	edx,arg1data3
	sub	edx,___assemble_curoffset
	sub	edx,ecx
	dec	edx
	cmp	edx,127
	jg	__findcomparglop
	cmp	edx,-128
	jge	__findcomparg_done

__findcomparglop:
	lodsb
	or	al,al
	jnz	__findcomparg_neol1
	mov	bl,0
	cmp	byte ptr [esi],0
	je	__findcomparg_err	; eol
	jmp	__findcomparglop
__findcomparg_neol1:
	cmp	bl,0
	jne	__findcompatibleargslop
	cmp	ah,al
	jne	__findcomparglop
	mov	bl,1
	jmp	__findcomparglop

__findcomparg_err:
	stc
	jmp	__findcomparg_exit

__findcomparg_done:
	clc
__findcomparg_exit:
	pop	edx
	ret


;
; In:
;	EBX == Offset to where this instructions starts (added to rel offsets)
;	ESI -> Buffer to read bytes from
;	ECX -> Max # bytes to parse (e.g bytes left 'til EOF)
; Out:
;	ECX = Instruction's length in bytes
;	ASCIZ dazmitbuf = e.g "mov ax,cx",0
;
_parseinstruction:
	pushad
	mov	___endofbuffer,0
	mov	startoffset,ebx
	mov	startofinput,esi
	lea	ecx,[esi+ecx]
	mov	endofinput,ecx
	lea	ebp,dazmitbuf
	mov	al,dazmitsegsize
	mov	databits,al
	mov	addressbits,al
	mov	longestmatch,1		; # of bytes to skip if no match found
	mov	commentfunc,offset _ret
__parseinstruction_prefix:
	lea	edi,opcodes
	cmp	esi,endofinput
	jae	__parseinstruction_afterend
__parseinstruction_next:
	cmp	byte ptr [edi],0
	je	__parseinstruction_nonefound
	push	esi
	push	edi
	movzx	ecx,byte ptr [edi]
	inc	edi
__parseinstruction_lop:
	mov	al,[edi]
	cmp	al,[esi]
	jne	__parseinstruction_lop_end
	inc	edi
	inc	esi
	cmp	esi,endofinput
	ja	__parseinstruction_lop_end_eof
	mov	longestmatch,2			; not good!!! foof is 4 bytes!
	loop	__parseinstruction_lop
	pop	oldedi
	pop	oldesi
	mov	al,[edi-1]
	mov	lastopcodebyte,al
	mov	edx,[edi]
	mov	opr1type,dl
	mov	opr2type,dh
	shr	edx,16
	mov	opr3type,dl
	mov	opcbyte,dh

	cmp	opcbyte,OB_DATASIZE
	jne	__parseinstruction_not_OB_DATASIZE
	mov	al,dazmitsegsize
	neg	al
	inc	al
	mov	databits,al
	jmp	__parseinstruction_prefix
__parseinstruction_not_OB_DATASIZE:
	cmp	opcbyte,OB_ADDRESSIZE
	jne	__parseinstruction_not_OB_ADDRESSIZE
	mov	al,dazmitsegsize
	neg	al
	inc	al
	mov	addressbits,al
	jmp	__parseinstruction_prefix
__parseinstruction_not_OB_ADDRESSIZE:

	mov	cx,[edi+MAX_OPERANDS+1+1]
	mov	mneword,cx
	xor	edx,edx
	cmp	opcbyte,OB_NONE
	je	__parseinstruction_ok
	cmp	opcbyte,OB_SR
	je	__parseinstruction_OB_SR
	cmp	opcbyte,OB_R7
	jbe	__parseinstruction_OB_RX
	cmp	opcbyte,OB_7
	jbe	__parseinstruction_OB_SR
	cmp	opcbyte,OB_ESC
	je	__parseinstruction_OB_SR
	jmp	__parseinstruction_end

__parseinstruction_OB_RX:
	mov	bl,opcbyte
	sub	bl,OB_R0
	mov	opcodetable_x,bl
	jmp	__parseinstruction_ok

__parseinstruction_OB_SR:
	cmp	esi,endofinput
	jae	__parseinstruction_endinsideinst
	lodsb
	mov	addressingbyte,al
	mov	bl,al
	and	bl,03fh
	mov	cl,bl
	shr	bl,3
	mov	opcodetable_x,bl

	cmp	opr1type,O_M16
	jb	__parseinstruction_OB_X_not_mem
	cmp	opr1type,O_M
	ja	__parseinstruction_OB_X_not_mem
__parseinstruction_OB_X_mem:
	mov	bl,al
	shr	bl,6
	cmp	bl,3
	je	__parseinstruction_OB_X_wronginst
	jmp	__parseinstruction_OB_X_not_mem2
__parseinstruction_OB_X_not_mem:
	cmp	opr2type,O_M16
	jb	__parseinstruction_OB_X_not_mem2
	cmp	opr2type,O_M
	jbe	__parseinstruction_OB_X_mem
__parseinstruction_OB_X_not_mem2:

	cmp	opcbyte,OB_0
	jb	__parseinstruction_OB_SR_not_OB_X
	cmp	opcbyte,OB_7
	ja	__parseinstruction_OB_SR_not_OB_X

	mov	bl,opcbyte
	sub	bl,OB_0
	cmp	bl,opcodetable_x
	jne	__parseinstruction_OB_X_wronginst
	mov	opcodetable_x,bl
	jmp	__parseinstruction_OB_SR_not_OB_X
__parseinstruction_OB_X_wronginst:
	push	oldesi
	push	oldedi
	jmp	__parseinstruction_lop_end
__parseinstruction_OB_SR_not_OB_X:
	and	cl,7
	mov	opcodetable_y,cl

	mov	bl,al
	shr	bl,6
	cmp	bl,1
	jb	__parseinstruction_go
	je	__parseinstruction_40
	cmp	bl,3
	jb	__parseinstruction_80
	mov	bl,opr1type

	cmp	bl,O_RM8
	jb	__parseinstruction_try2ndopr
	cmp	bl,O_RM32
	ja	__parseinstruction_use1stopr
__parseinstruction_try2ndopr:
	cmp	opr2type,O_RM8
	jb	__parseinstruction_use1stopr
	cmp	opr2type,O_RM32
	ja	__parseinstruction_use1stopr
	mov	bl,opr2type
__parseinstruction_use1stopr:

	and	bl,7
	lea	edx,addressing8_c0
	cmp	bl,2
	jb	__parseinstruction_ok
	lea	edx,addressing16_c0
	je	__parseinstruction_ok
	cmp	bl,4
	lea	edx,addressing32_c0
	jb	__parseinstruction_ok

	lea	edx,addressingmmx_c0
	cmp	bl,5
	je	__parseinstruction_ok

	cmp	databits,0
	lea	edx,addressing16_c0
	je	__parseinstruction_ok
	lea	edx,addressing32_c0
	jmp	__parseinstruction_ok
__parseinstruction_80:
	add	edx,8
__parseinstruction_40:
	add	edx,8
__parseinstruction_go:
	movzx	ecx,addressbits
	mov	edx,addressing[edx+ecx*4]

__parseinstruction_ok:
	movzx	ecx,mneword
	cmp	ecx,M_3DNOW
	je	__parseinstruction_nomnemonic
	call	_putmnemonic
	cmp	opr1type,O_NONE
	je	__parseinstruction_end
__parseinstruction_nomnemonic:
	call	_parseall
	jmp	__parseinstruction_end

__parseinstruction_lop_end_eof:
	mov	___endofbuffer,1
__parseinstruction_lop_end:
	pop	edi esi
	movzx	eax,byte ptr [edi]
	lea	edi,[edi+eax+SIZEOF_OPCODE]
	jmp	__parseinstruction_next

__parseinstruction_poppopafterend:
	add	esp,4*2 		; compensate for "push esi edi"

__parseinstruction_nonefound:
	call	_puterror
	add	esi,longestmatch
	cmp	esi,endofinput
	jbe	__parseinstruction_end
	mov	esi,endofinput
	jmp	__parseinstruction_end

__parseinstruction_end:
	mov	eax,commentdata
	call	[commentfunc]

	cmp	___endofbuffer,1
	je	__parseinstruction_afterend
	mov	byte ptr [ebp],0
	sub	esi,startofinput
	mov	endofinput,esi
	popad
	mov	ecx,endofinput
	clc
	ret

__parseinstruction_endinsideinst:
	call	_puterror
	jmp	__parseinstruction_afterend

__parseinstruction_afterend:
	mov	byte ptr [ebp],0
	mov	esi,startofinput
	sub	endofinput,esi
	popad
	mov	ecx,endofinput
	stc
	ret

___endofbuffer	db	?


;
_tab:
	push	eax ecx
	mov	ecx,7
	sub	cl,mnemoniclength
	jnc	__tab_shortmnemonic
	xor	cl,cl
__tab_shortmnemonic:
	and	cl,07h
	inc	cl
__tab_tablop:
	mov	al,' '
	call	_putb
	loop	__tab_tablop
	pop	ecx eax
	ret


;
_parseall:
	push	eax ebx ecx
	mov	bl,[edi]
	mov	bh,[edi+1]
	mov	cl,[edi+MAX_OPERANDS]
	cmp	cl,OB_NONE
	je	__parseall_OB_NONE
	cmp	cl,OB_SR
	je	__parseall_OB_SR
	cmp	cl,OB_R7
	jbe	__parseall_OB_NONE
	cmp	cl,OB_7
	jbe	__parseall_OB_SR
	jmp	__parseall_end

__parseall_OB_NONE:
	call	_tab
	mov	cx,bx
	xor	bh,bh
	call	_parseoperand
	mov	bl,ch
	mov	bh,1
	cmp	bl,O_NONE
	je	__parseall_end
	mov	al,','
	call	_putb
	call	_parseoperand
	jmp	__parseall_end

__parseall_3DNOW:
	push	esi ebp
	xor	bh,bh
	call	_parseoperand
	mov	bh,1
	call	_parseaddressing
	lodsb
	pop	ebp esi

	push	ebx ecx
	lea	ebx,suffixes3dnow-3
__parseall_3DNOW_lop:
	add	ebx,3
	mov	ah,[ebx]
	or	ah,ah
	jz	__parseall_3DNOW_undef
	cmp	ah,al
	jne	__parseall_3DNOW_lop
	movzx	ecx,word ptr [ebx+1]
	call	_putmnemonic
	call	_tab
	pop	ecx ebx

	xor	bh,bh
	call	_parseoperand
	mov	bh,1
	mov	al,','
	call	_putb
	call	_parseaddressing
	lodsb
	jmp	__parseall_end

__parseall_3DNOW_undef:
	pop	ecx ebx
	call	_puterror
	jmp	__parseall_end

__parseall_OB_SR:
	cmp	mneword,M_3DNOW
	je	__parseall_3DNOW
	call	_tab
	cmp	bl,bh
	jbe	__parseall_1st_last
	mov	bl,bh
	xor	bh,bh
	call	_parseaddressing
	cmp	bl,O_NONE
	je	__parseall_end
	mov	bh,1
	mov	al,','
	call	_putb
	call	_parseoperand
	jmp	__parseall_OB_SR_2done
__parseall_1st_last:
	xor	bh,bh
	call	_parseoperand
	mov	bh,1
	cmp	bl,O_NONE
	je	__parseall_end
	mov	al,','
	call	_putb
	call	_parseaddressing
__parseall_OB_SR_2done:
	cmp	opr3type,O_NONE
	je	__parseall_end
	mov	al,','
	call	_putb
	mov	bl,opr3type
	mov	bh,2
	call	_parseoperand

__parseall_end:
	pop	ecx ebx eax
	ret


;
; In:
;	BH = operand-number being parsed ( 0 == 1st, 1 == 2nd )
;	EDX -> addressingXX_XX
;
_parseaddressing:
	push	eax ebx ecx edx edi
	mov	___origaddressing,edx
	movzx	ecx,opcodetable_y
	jecxz	__parseaddressing_first
	xor	eax,eax
__parseaddressing_find_lop:
	mov	al,[edx]
	and	al,7fh
	lea	edx,[edx+eax+2]
	loop	__parseaddressing_find_lop
__parseaddressing_first:
	mov	bl,[edx]
	lea	ecx,[edx+2]
	mov	al,[edx+1]
	mov	offsetsize,al

	mov	al,opr1type
	cmp	al,O_FAR1632
	je	__parseaddressing_notno2ndopr

	cmp	mneword,M_SGDT
	je	__parseaddressing_lop
	cmp	mneword,M_SIDT
	je	__parseaddressing_lop
	cmp	mneword,M_INVLPG
	je	__parseaddressing_lop

	test	bl,80h
	jnz	__parseaddressing_sib
	cmp	byte ptr [ecx],'['
	jne	__parseaddressing_lop
__parseaddressing_sib:
	movzx	eax,bh
	cmp	operandtypes[eax],O_RM8
	jb	__parseaddressing_error
	cmp	operandtypes[eax],O_M
	jbe	__parseaddressing_noterror
	cmp	operandtypes[eax],O_OFFSx
	jb	__parseaddressing_error
	cmp	operandtypes[eax],O_OFFS1632
	ja	__parseaddressing_error
__parseaddressing_noterror:

	cmp	mneword,M_MOVSX
	je	__parseaddressing_movXx
	cmp	mneword,M_MOVZX
	jne	__parseaddressing_notmovXx
__parseaddressing_movXx:
	mov	al,opr2type
	jmp	__parseaddressing_notno2ndopr
__parseaddressing_notmovXx:

	cmp	bh,0
	jne	__parseaddressing_lop

	cmp	opr2type,O_NONE
	je	__parseaddressing_dontskipsize
	cmp	opr2type,O_MMX64
	jbe	__parseaddressing_lop
	cmp	opr2type,O_ACC8
	jb	__parseaddressing_dontskipsize
	cmp	opr2type,O_ACC1632
	jbe	__parseaddressing_lop
__parseaddressing_dontskipsize:

	mov	al,opr1type
__parseaddressing_notno2ndopr:
	call	_putsize

__parseaddressing_lop:
	test	bl,80h
	jz	__parseaddressing_lop_lop
	cmp	esi,endofinput
	jae	__parseaddressing_endinsideinst
	push	edx
	mov	edi,edx
	mov	dl,opcodetable_x
	push	edx
	lea	edx,regs32
	mov	al,'['
	call	_putb
	lodsb				; SIB
	mov	bl,al
	and	al,7
	cmp	al,5
	jne	__parseaddressing_sib_ebpbasereg
	mov	ah,addressingbyte
	shr	ah,6
	or	ah,ah
	jnz	__parseaddressing_sib_ebpbasereg
	mov	offsetsize,4
	jmp	__parseaddressing_sib_index
__parseaddressing_sib_ebpbasereg:
	mov	opcodetable_x,al
	call	_parseregs
	mov	al,'+'
	call	_putb
__parseaddressing_sib_index:
	mov	cl,bl
	shr	cl,6
	and	bl,3fh
	shr	bl,3
	cmp	bl,4
	jne	__parseaddressing_sib_index_not_esp
	cmp	byte ptr [ebp-1],'+'
	jne	__parseaddressing_sib_index_esp
	dec	ebp
	mov	byte ptr [ebp],0
	jmp	__parseaddressing_sib_noscale
__parseaddressing_sib_index_esp:
	pop	edx
	mov	opcodetable_x,dl
	pop	edx
	cmp	offsetsize,0
	je	__parseaddressing_offsetput
	jmp	__parseaddressing_offset

__parseaddressing_sib_index_not_esp:
	mov	opcodetable_x,bl
	call	_parseregs
__parseaddressing_sib_checkscale:
	cmp	cl,0
	je	__parseaddressing_sib_noscale
	mov	al,1
	shl	al,cl
	add	al,'0'
	mov	ah,'*'
	call	_putw
__parseaddressing_sib_noscale:
	pop	edx
	mov	opcodetable_x,dl
	pop	edx
	cmp	offsetsize,0
	je	__parseaddressing_offsetput
	mov	al,'+'
	call	_putb
	jmp	__parseaddressing_offset

__parseaddressing_lop_lop:
	mov	al,[ecx]
	inc	ecx
	call	_putb
	dec	bl
	jnz	__parseaddressing_lop_lop

__parseaddressing_offset:
	mov	bl,offsetsize
	cmp	bl,0
	je	__parseaddressing_end
	xor	eax,eax
	cmp	esi,endofinput
	jae	__parseaddressing_endinsideinst
	lodsb
	cmp	bl,1
	je	__parseaddressing_8bitoffset
	cmp	esi,endofinput
	jae	__parseaddressing_endinsideinst
	movzx	ecx,byte ptr [esi]
	inc	esi
	shl	ecx,8
	or	eax,ecx
	cmp	bl,2
	je	__parseaddressing_16bitoffset
	lea	ecx,[esi+1]
	cmp	ecx,endofinput
	jae	__parseaddressing_endinsideinst
	movzx	ecx,word ptr [esi]
	add	esi,2
	shl	ecx,16
	or	eax,ecx
	cmp	bl,4
	jne	__parseaddressing_end

__parseaddressing_32bitoffset:
	xchg	al,bl
	mov	al,'0'
	call	_putb
	xchg	bl,al
	mov	dazmitputzeros,-1
	call	_puthexd
	jmp	__parseaddressing_offsetput

__parseaddressing_8bitoffset:
	xchg	al,bl
	mov	al,'0'
	call	_putb
	xchg	bl,al
	mov	dazmitputzeros,-1
	call	_puthexb
	jmp	__parseaddressing_offsetput

__parseaddressing_16bitoffset:
	xchg	al,bl
	mov	al,'0'
	call	_putb
	xchg	bl,al
	mov	dazmitputzeros,-1
	call	_puthexw

__parseaddressing_offsetput:
	mov	al,']'
	call	_putb
__parseaddressing_end:
	pop	edi edx ecx ebx eax
	ret

__parseaddressing_endinsideinst:
	mov	___endofbuffer,1
__parseaddressing_error:
	call	_puterror
	jmp	__parseaddressing_end

___origaddressing	dd	?


;
; In:
;	BL = operand-value to be parsed
;	BH = operandnumber (0 == 1st operand, 1 == 2nd)
_parseoperand:
	push	eax ebx edx
	cmp	bl,O_ACC8
	jne	__parseoperand_not_O_ACC8
	mov	ax,'al'
	call	_putw
	jmp	__parseoperand_end

__parseoperand_not_O_ACC8:
	cmp	bl,O_ACC16
	jne	__parseoperand_not_O_ACC16
__parseoperand_O_ACC16:
	mov	ax,'ax'
	call	_putw
	jmp	__parseoperand_end

__parseoperand_not_O_ACC16:
	cmp	bl,O_ACC32
	jne	__parseoperand_not_O_ACC32
__parseoperand_O_ACC32:
	mov	ax,'ea'
	call	_putw
	mov	al,'x'
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_ACC32:
	cmp	bl,O_ACC1632
	jne	__parseoperand_not_O_ACC1632
	cmp	databits,0
	je	__parseoperand_O_ACC16
	jmp	__parseoperand_O_ACC32

__parseoperand_not_O_ACC1632:
	cmp	bl,O_OFFS16
	jne	__parseoperand_not_O_OFFS16
__parseoperand_O_OFFS16:
	mov	opcodetable_y,0
	lea	edx,addressing16_offs
	call	_parseaddressing
	jmp	__parseoperand_end

__parseoperand_not_O_OFFS16:
	cmp	bl,O_OFFS32
	jne	__parseoperand_not_O_OFFS32
__parseoperand_O_OFFS32:
	mov	opcodetable_y,0
	lea	edx,addressing32_offs
	call	_parseaddressing
	jmp	__parseoperand_end

__parseoperand_not_O_OFFS32:
	cmp	bl,O_OFFS1632
	jne	__parseoperand_not_O_OFFS1632
	cmp	addressbits,0
	je	__parseoperand_O_OFFS16
	jmp	__parseoperand_O_OFFS32

__parseoperand_not_O_OFFS1632:
	cmp	bl,O_R8
	jne	__parseoperand_not_O_R8
	lea	edx,regs8
	jmp	__parseoperand_regs

__parseoperand_not_O_R8:
	cmp	bl,O_R16
	jne	__parseoperand_not_O_R16
__parseoperand_O_R16:
	lea	edx,regs16
	jmp	__parseoperand_regs

__parseoperand_not_O_R16:
	cmp	bl,O_R32
	jne	__parseoperand_not_O_R32
__parseoperand_O_R32:
	lea	edx,regs32
	jmp	__parseoperand_regs

__parseoperand_not_O_R32:
	cmp	bl,O_R1632
	jne	__parseoperand_not_O_R1632
	cmp	databits,0
	je	__parseoperand_O_R16
	jmp	__parseoperand_O_R32

__parseoperand_not_O_R1632:
	cmp	bl,O_RM8
	jne	__parseoperand_not_O_RM8
	lea	edx,regs8
	jmp	__parseoperand_regs

__parseoperand_not_O_RM8:
	cmp	bl,O_RM16
	jne	__parseoperand_not_O_RM16
__parseoperand_O_RM16:
	lea	edx,regs16
	jmp	__parseoperand_regs

__parseoperand_not_O_RM16:
	cmp	bl,O_RM32
	jne	__parseoperand_not_O_RM32
__parseoperand_O_RM32:
	lea	edx,regs32
	jmp	__parseoperand_regs

__parseoperand_not_O_RM32:
	cmp	bl,O_RM1632
	jne	__parseoperand_not_O_RM1632
	cmp	databits,0
	je	__parseoperand_O_RM16
	jmp	__parseoperand_O_RM32

__parseoperand_not_O_RM1632:
	cmp	bl,O_SEGR
	jne	__parseoperand_not_O_SEGR
	cmp	bh,0
	jne	__parseoperand_segr_notfirst
	cmp	mneword,M_MOV
	je	__parseoperand_segr_testcs
	cmp	mneword,M_POP
	jne	__parseoperand_segr_notfirst
__parseoperand_segr_testcs:
	cmp	opcodetable_x,1
	je	__parseoperand_illegal

__parseoperand_segr_notfirst:
	cmp	opcodetable_x,5
	ja	__parseoperand_illegal
	lea	edx,regsseg
	jmp	__parseoperand_regs

__parseoperand_not_O_SEGR:
	cmp	bl,O_OM8
	jne	__parseoperand_not_O_OM8
	cmp	esi,endofinput
	jae	__parseoperand_endinsideinst
	mov	al,'0'
	call	_putb
	lodsb
	mov	dazmitputzeros,PUTZEROS
	call	_puthexb
	mov	commentfunc,offset _comment8
	mov	commentdata,eax
	jmp	__parseoperand_end

__parseoperand_not_O_OM8:
	cmp	bl,O_OM16
	jne	__parseoperand_not_O_OM16
__parseoperand_O_OM16:
	lea	eax,[esi+1]
	cmp	eax,endofinput
	jae	__parseoperand_endinsideinst
	cmp	mneword,M_PUSH
	jne	__parseoperand_O_OM16_notpush
	mov	ax,'w.'
	call	_putw
__parseoperand_O_OM16_notpush:
	mov	al,'0'
	call	_putb
	lodsw
	mov	dazmitputzeros,PUTZEROS
	call	_puthexw
	mov	commentfunc,offset _comment16
	mov	commentdata,eax
	jmp	__parseoperand_end

__parseoperand_not_O_OM16:
	cmp	bl,O_OM32
	jne	__parseoperand_not_O_OM32
__parseoperand_O_OM32:
	lea	eax,[esi+3]
	cmp	eax,endofinput
	jae	__parseoperand_endinsideinst
	cmp	mneword,M_PUSH
	jne	__parseoperand_O_OM32_notpush
	mov	ax,'d.'
	call	_putw
__parseoperand_O_OM32_notpush:
	mov	al,'0'
	call	_putb
	lodsd
	mov	dazmitputzeros,PUTZEROS
	call	_puthexd
	mov	commentfunc,offset _comment32
	mov	commentdata,eax
	jmp	__parseoperand_end

__parseoperand_not_O_OM32:
	cmp	bl,O_OM1632
	jne	__parseoperand_not_O_OM1632
	cmp	databits,0
	je	__parseoperand_O_OM16
	jmp	__parseoperand_O_OM32

__parseoperand_not_O_OM1632:
	cmp	bl,O_OM8EXP
	jne	__parseoperand_not_O_OM8EXP
	cmp	esi,endofinput
	jae	__parseoperand_endinsideinst
	cmp	mneword,M_PUSH
	jne	__parseoperand_O_OM8EXP_notpush
	mov	ax,'w.'
	cmp	databits,0
	je	__parseoperand_O_OM8EXP_push16
	mov	ax,'d.'
__parseoperand_O_OM8EXP_push16:
	call	_putw
__parseoperand_O_OM8EXP_notpush:
	mov	al,'0'
	call	_putb
	lodsb
	cbw
	cwde
	mov	dazmitputzeros,PUTZEROS
	cmp	databits,0
	jne	__parseoperand_O_OM8EXP_32
	call	_puthexw
	mov	commentfunc,offset _comment16
	mov	commentdata,eax
	jmp	__parseoperand_end
__parseoperand_O_OM8EXP_32:
	call	_puthexd
	mov	commentfunc,offset _comment32
	mov	commentdata,eax
	jmp	__parseoperand_end

__parseoperand_not_O_OM8EXP:
	cmp	bl,O_DX
	jne	__parseoperand_not_O_DX
	mov	ax,'dx'
	call	_putw
	jmp	__parseoperand_end

__parseoperand_not_O_DX:
	cmp	bl,O_REL8
	jne	__parseoperand_not_O_REL8
	cmp	mneword,M_LOOP
	je	__parseoperand_O_REL8_noshort
	mov	eax,'shor'
	call	_putd
	mov	ax,'t '
	call	_putw
__parseoperand_O_REL8_noshort:
	cmp	esi,endofinput
	jae	__parseoperand_endinsideinst
	mov	al,'0'
	call	_putb
	lodsb
	movsx	eax,al
	add	eax,startoffset
	add	eax,esi
	sub	eax,startofinput
	mov	dazmitputzeros,-1
	call	_puthexd
	jmp	__parseoperand_end

__parseoperand_not_O_REL8:
	cmp	bl,O_REL16
	jne	__parseoperand_not_O_REL16
__parseoperand_O_REL16:
	lea	eax,[esi+1]
	cmp	eax,endofinput
	jae	__parseoperand_endinsideinst
	mov	al,'0'
	call	_putb
	lodsw
	movsx	eax,ax
	add	eax,startoffset
	add	eax,esi
	sub	eax,startofinput
	mov	dazmitputzeros,-1
	call	_puthexd
	jmp	__parseoperand_end

__parseoperand_not_O_REL16:
	cmp	bl,O_REL32
	jne	__parseoperand_not_O_REL32
__parseoperand_O_REL32:
	lea	eax,[esi+3]
	cmp	eax,endofinput
	jae	__parseoperand_endinsideinst
	mov	al,'0'
	call	_putb
	lodsd
	add	eax,startoffset
	add	eax,esi
	sub	eax,startofinput
	mov	dazmitputzeros,-1
	call	_puthexd
	jmp	__parseoperand_end

__parseoperand_not_O_REL32:
	cmp	bl,O_REL1632
	jne	__parseoperand_not_O_REL1632
	cmp	databits,0
	je	__parseoperand_O_REL16
	jmp	__parseoperand_O_REL32

__parseoperand_not_O_REL1632:
	cmp	bl,O_DFAR1632
	jne	__parseoperand_not_O_DFAR1632
	cmp	databits,0
	jne	__parseoperand_O_DFAR32

__parseoperand_O_DFAR16:
	lea	eax,[esi+3]
	cmp	eax,endofinput
	jae	__parseoperand_endinsideinst
	mov	al,'0'
	call	_putb
	lodsw
	mov	bx,ax
	lodsw
	mov	dazmitputzeros,-1
	call	_puthexw
	mov	ax,':0'
	call	_putw
	mov	ax,bx
	mov	dazmitputzeros,-1
	call	_puthexw
	jmp	__parseoperand_end

__parseoperand_O_DFAR32:
	lea	eax,[esi+5]
	cmp	eax,endofinput
	jae	__parseoperand_endinsideinst
	mov	al,'0'
	call	_putb
	lodsd
	mov	ebx,eax
	lodsw
	mov	dazmitputzeros,-1
	call	_puthexw
	mov	ax,':0'
	call	_putw
	mov	eax,ebx
	mov	dazmitputzeros,-1
	call	_puthexd
	jmp	__parseoperand_end

__parseoperand_not_O_DFAR1632:
	cmp	bl,O_1
	jne	__parseoperand_not_O_1
	mov	al,'1'
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_1:
	cmp	bl,O_3
	je	__parseoperand_end

__parseoperand_not_O_3:
	cmp	bl,O_CL
	jne	__parseoperand_not_O_CL
	mov	ax,'cl'
	call	_putw
	jmp	__parseoperand_end

__parseoperand_not_O_CL:
	cmp	bl,O_CR
	jne	__parseoperand_not_O_CR
	cmp	opcodetable_x,1
	je	__parseoperand_illegal
	cmp	opcodetable_x,4
	ja	__parseoperand_illegal
	mov	ax,'cr'
	call	_putw
	mov	al,opcodetable_x
	add	al,'0'
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_CR:
	cmp	bl,O_DR
	jne	__parseoperand_not_O_DR
	cmp	opcodetable_x,4
	je	__parseoperand_illegal
	cmp	opcodetable_x,5
	je	__parseoperand_illegal
	mov	ax,'dr'
	call	_putw
	mov	al,opcodetable_x
	add	al,'0'
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_DR:
	cmp	bl,O_TR
	jne	__parseoperand_not_O_TR
	cmp	opcodetable_x,3
	jb	__parseoperand_illegal
	mov	ax,'tr'
	call	_putw
	mov	al,opcodetable_x
	add	al,'0'
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_TR:
	cmp	bl,O_FPUR
	jne	__parseoperand_not_O_FPUR
	mov	ax,'st'
	call	_putw
	mov	al,'0'
	add	al,opcodetable_x
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_FPUR:
	cmp	bl,O_ST
	jne	__parseoperand_not_O_ST
	mov	ax,'st'
	call	_putw
	mov	al,'0'
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_ST:
	cmp	bl,O_MMX32
	je	__parseoperand_O_MMX
	cmp	bl,O_MMX64
	jne	__parseoperand_not_O_MMX
__parseoperand_O_MMX:
	mov	ax,'mm'
	call	_putw
	mov	al,'0'
	add	al,opcodetable_x
	call	_putb
	jmp	__parseoperand_end

__parseoperand_not_O_MMX:


__parseoperand_illegal:
	call	_putillegal
	jmp	__parseoperand_end

__parseoperand_endinsideinst:
	mov	___endofbuffer,1
	call	_puterror
	jmp	__parseoperand_end

__parseoperand_regs:
	call	_parseregs
__parseoperand_end:
	pop	edx ebx eax
	ret


;
; In:
;	AL = oprXbyte
_putsize:
	push	eax
	push	ebx
	mov	ebx,eax

	mov	ah,'?'

	and	al,7
	cmp	al,1
	je	__putsize_byte
	cmp	al,2
	je	__putsize_word
	cmp	al,3
	je	__putsize_dword
	cmp	al,5
	je	__putsize_qword
	cmp	al,6
	je	__putsize_tword
	cmp	al,4
	jne	__putsize_nosize

	cmp	bl,O_FAR1632
	je	__putsize_FAR1632
	cmp	databits,0
	je	__putsize_word
__putsize_dword:
	mov	ah,'d'
	jmp	__putsize_end

__putsize_byte:
	mov	ah,'b'
	jmp	__putsize_end

__putsize_word:
	mov	ah,'w'
	jmp	__putsize_end

__putsize_qword:
	mov	ah,'q'
	jmp	__putsize_end

__putsize_tword:
	mov	ah,'t'
	jmp	__putsize_end

__putsize_FAR1632:
	mov	ah,'f'
	cmp	databits,0
	je	__putsize_end
	mov	ah,'p'

__putsize_end:
	mov	al,'.'
	call	_putw
__putsize_nosize:
	pop	ebx
	pop	eax
	ret


;
; In:
;	EDX -> regs-table
;
_parseregs:
	pushad
	movzx	eax,opcodetable_x
	movzx	ecx,byte ptr [edx]
	mul	cl
	lea	esi,[eax+edx+1]
__parseregs_lop:
	lodsb
	call	_putb
	loop	__parseregs_lop
	mov	[esp+2*4],ebp
	popad
	ret


;
;
; In:
;	ECX = Mnemonic index
;
_putmnemonic:
	pushad
	cmp	databits,0
	je	__putmnemonic_notspecial
	lea	esi,mnemonics_special-2
__putmnemonic_testspecial_lop:
	add	esi,2
	lodsw
	or	ax,ax
	jz	__putmnemonic_notspecial
	cmp	ax,cx
	jne	__putmnemonic_testspecial_lop
	mov	cx,[esi]
__putmnemonic_notspecial:
	lea	esi,mnemonics
	jcxz	__putmnemonic_found
	xor	eax,eax
__putmnemonic_lop:
	lodsb
	add	esi,eax
	loop	__putmnemonic_lop
__putmnemonic_found:
	xor	eax,eax
	lodsb
	mov	ecx,eax
	mov	mnemoniclength,al
__putmnemonic_printlop:
	lodsb
	mov	[ebp],al
	inc	ebp
	loop	__putmnemonic_printlop
	mov	[esp+2*4],ebp
	popad
	ret


;
_puterror:
_putillegal:
	push	eax
	mov	ax,'??'
	call	_putw
	mov	al,'?'
	call	_putb
	pop	eax
	ret


;
_comment8:
	call	_commentinit
	jc	_ret
	call	_putb
	mov	al,''''
	call	_putb
	ret


;
_comment16:
	call	_commentinit
	jc	_ret
	rol	ax,8
	call	_putb
	mov	al,ah
	call	_putb
	mov	al,''''
	call	_putb
	ret


;
_comment32:
	call	_commentinit
	jc	_ret
	rol	ax,8
	rol	eax,16
	rol	ax,8
	call	_putb
	mov	al,ah
	call	_putb
	shr	eax,16
	call	_putb
	mov	al,ah
	call	_putb
	mov	al,''''
	call	_putb
	ret


;
_commentinit:
	cmp	dazmitcomments,0
	je	_stc&ret
	cmp	dazmitcomments,2
	je	_commentinit_all
	cmp	mneword,M_MOV
	je	_commentinit_all
	cmp	mneword,M_ADD
	je	_commentinit_all
	cmp	mneword,M_SUB
	je	_commentinit_all
	cmp	mneword,M_PUSH
	je	_commentinit_all
	cmp	mneword,M_CMOVO
	jb	_stc&ret
	cmp	mneword,M_CMOVG
	ja	_stc&ret
_commentinit_all:
	cmp	mneword,M_INT
	je	_stc&ret

	push	eax ecx
	mov	ecx,ebp
	sub	ecx,offset dazmitbuf
	and	ecx,7
	neg	ecx
	add	ecx,8
__commentinit_tablop:
	mov	al,' '
	call	_putb
	loop	__commentinit_tablop

	mov	ax,'; '
	call	_putw
	mov	al,''''
	call	_putb
	pop	ecx eax
_clc&ret:
	clc
	ret

_stc&ret:
	stc
	ret


;
_putd:
	push	eax
	shr	eax,16
	call	_putw
	pop	eax

_putw:
	mov	[ebp],ah
	mov	[ebp+1],al
	add	ebp,2
	ret


;
; char output
_putb:
	or	al,al
	jnz	__putb_nz
	mov	al,' '
__putb_nz:
	mov	[ebp],al
	inc	ebp
	ret


;
; hex output
_puthexd:
	push	eax
	shr	eax,16
	call	_puthexw
	pop	eax

_puthexw:
	push	eax
	shr	eax,8
	call	_puthexb
	pop	eax

_puthexb:
	push	eax
	shr	eax,4
	call	_puthexn
	pop	eax

_puthexn:
	push	eax
	and	al,0fh
	or	al,al
	jnz	__puthexn_notzero
	cmp	dazmitputzeros,0
	je	__puthexn_end
__puthexn_notzero:
	mov	dazmitputzeros,-1
	add	al,90h
	daa
	adc	al,40h
	daa
	mov	[ebp],al
	inc	ebp
__puthexn_end:
	pop	eax
	ret


;
; _ltrim();
; In:
;	ESI -> string
; Out:
;	EAX == number of chars trimmed
;	ESI -> string w/out preceeding spaces/tabs
_ltrim:
	push	esi
__ltrim_lop:
	lodsb
	cmp	al,' '
	je	__ltrim_lop
	cmp	al,9
	je	__ltrim_lop
	dec	esi
	pop	eax
	neg	eax
	add	eax,esi
	ret


;
; _arglen();
; In:
;	ESI -> arguments
; Out:
;	ECX == chars until CR, LF, ';', ',' or '\0'
;	ZF set if ECX = 0
_arglen:
	push	eax
	push	esi
	mov	ecx,-1
__arglen_lop:
	lodsb
	inc	ecx
	cmp	al,13
	je	__arglen_lop_end
	cmp	al,10
	je	__arglen_lop_end
	cmp	al,';'
	je	__arglen_lop_end
	cmp	al,','
	je	__arglen_lop_end
	or	al,al
	jnz	__arglen_lop
__arglen_lop_end:
	pop	esi
	pop	eax
	or	ecx,ecx
	ret


;
; _argtype();
; In:
;	ESI -> arguments
;	ECX =  length of argumentstring in chars
; Out:
;	AL =   type (see operand types in dazmit.equ)
;	AH =   size (see operand types in dazmit.equ)
;	BL =   data1 (regnum for regs, addnum for addressing etc)
;	BH =   data2 (0 == reg, 1 == modr/m, 2 == imm, 3 == direct far ptr)
;	ECX =  data3 (imm data / offset for addressing / direct seg or sel)
;	EDX =  data4 (direct offset (O_DFAR1632), max bits in disp for mem)
_argtype:
	pushad

	mov	___argtype_data3,0
	mov	___argtype_farptr,0
	mov	___argtype_type,O_NONE

	or	ecx,ecx
	jle	__argtype_done

	mov	___argtype_size,O_S_UNKNOWNSIZE
	mov	___argtype_type,O_ERROR
	cmp	ecx,2
	jb	__argtype_nosize
	cmp	word ptr [esi],'.b'
	je	__argtype_byte
	cmp	word ptr [esi],'.w'
	je	__argtype_word
	cmp	word ptr [esi],'.d'
	je	__argtype_dword
	cmp	word ptr [esi],'.q'
	je	__argtype_qword
	cmp	word ptr [esi],'.t'
	je	__argtype_tword
	cmp	word ptr [esi],'.f'
	je	__argtype_farptr
	cmp	word ptr [esi],'.p'
	jne	__argtype_nosize
__argtype_pptr:
	mov	___argtype_size,O_S_32
	mov	___argtype_farptr,1
	jmp	__argtype_sizeok
__argtype_farptr:
	mov	___argtype_size,O_S_16
	mov	___argtype_farptr,1
	jmp	__argtype_sizeok
__argtype_tword:
	mov	___argtype_size,O_S_80
	jmp	__argtype_sizeok
__argtype_qword:
	mov	___argtype_size,O_S_64
	jmp	__argtype_sizeok
__argtype_dword:
	mov	___argtype_size,O_S_32
	jmp	__argtype_sizeok
__argtype_word:
	mov	___argtype_size,O_S_16
	jmp	__argtype_sizeok
__argtype_byte:
	mov	___argtype_size,O_S_8

__argtype_sizeok:
	add	esi,2
	sub	ecx,2
	jz	__argtype_done

__argtype_nosize:
	jecxz	__argtype_done
	mov	al,[esi]
	cmp	al,'['
	je	__argtype_mem
	cmp	al,'-'
	je	__argtype_imm
	cmp	al,'+'
	je	__argtype_imm
	cmp	al,'~'
	je	__argtype_imm
	cmp	al,'('
	je	__argtype_imm
	cmp	al,'0'
	jb	__argtype_done
	cmp	al,'9'
	jbe	__argtype_imm

	mov	bx,O_S_8 shl 8 + O_R8
	lea	edx,regs8
	call	_findreg
	jnc	__argtype_regdone

	mov	bx,O_S_16 shl 8 + O_R16
	lea	edx,regs16
	call	_findreg
	jnc	__argtype_regdone

	mov	bx,O_S_32 shl 8 + O_R32
	lea	edx,regs32
	call	_findreg
	jnc	__argtype_regdone

	mov	bx,O_S_16 shl 8 + O_SEGR
	lea	edx,regsseg
	call	_findreg
	jnc	__argtype_regdone

	mov	bx,O_S_64 shl 8 + O_FPUR
	cmp	word ptr [esi],'ts'
	jne	__argtype_reg_not_fpu
	mov	al,[esi+2]
	sub	al,'0'
	jnc	__argtype_regdone
__argtype_reg_not_fpu:

	mov	bx,O_S_64 shl 8 + O_MMX64
	cmp	word ptr [esi],'mm'
	jne	__argtype_reg_not_mmx
	mov	al,[esi+2]
	sub	al,'0'
	jnc	__argtype_regdone
__argtype_reg_not_mmx:

	jmp	__argtype_done

__argtype_regdone:
	mov	ah,bl
	and	ah,0f8h
	cmp	ah,O_Rx
	jne	__argtype_regdone_noiconv

	cmp	bh,1
	jne	__argtype_regdone_not_8bits
	cmp	al,0
	jne	__argtype_regdone_8_not_al
	mov	bl,O_ACC8
__argtype_regdone_8_not_al:
	cmp	al,1
	jne	__argtype_regdone_not_8bits
	mov	bl,O_CL
__argtype_regdone_not_8bits:

	cmp	bh,2
	jne	__argtype_regdone_not_16bits
	cmp	al,0
	jne	__argtype_regdone_16_not_ax
	mov	bl,O_ACC16
__argtype_regdone_16_not_ax:
	cmp	al,2
	jne	__argtype_regdone_not_16bits
	mov	bl,O_DX
__argtype_regdone_not_16bits:

	cmp	bh,3
	jne	__argtype_regdone_not_32bits
	cmp	al,0
	jne	__argtype_regdone_not_32bits
	mov	bl,O_ACC32
__argtype_regdone_not_32bits:

__argtype_regdone_noiconv:
	cmp	bh,5
	jne	__argtype_regdone_not_64bits
	cmp	bl,O_FPUR
	jne	__argtype_regdone_not_64bits
	cmp	al,0
	jne	__argtype_regdone_not_64bits
	mov	bl,O_ST
__argtype_regdone_not_64bits:

__argtype_regdone_noconv:
	mov	edx,2
	cmp	bh,O_S_16
	jbe	@@lt32bits
	inc	edx
@@lt32bits:
	add	esi,edx
	sub	ecx,edx
	jz	@@regsok
	push	eax
	call	_ltrim
	sub	ecx,eax
	pop	eax
	jg	__argtype_err
@@regsok:

	mov	___argtype_type,bl
	mov	___argtype_size,bh
	mov	___argtype_data1,al
	mov	___argtype_data2,0	; reg
	jmp	__argtype_done

__argtype_mem:
	mov	___argtype_data1,0
	xor	ebx,ebx

	call	_getxprwithregs
	jc	__argtype_err
	mov	___argtype_data3,eax

	or	bl,dl
	jnz	__argtype_err
	test	ebx,0ffffh
	jnz	__argtype_mem_16bitregs

	mov	___argtype_sib,0
	test	edx,0ffffh
	jnz	__argtype_err
	or	edx,edx
	jnz	__argtype_mem_32bitregs
	or	ebx,ebx
	jz	__argtype_mem_nosib
	test	ebx,0fe100000h
	jz	__argtype_mem_16bitregs
	mov	___argtype_sib,20h
__argtype_mem_32bitregs:
; SIB
	mov	force32bitdisp,0

	test	ebx,0fe000000h
	jz	__argtype_mem_sib_nobasemul
	xchg	ebx,edx
	test	ebx,0fe000000h		; multipliers for both base and index?
	jnz	__argtype_err
__argtype_mem_sib_nobasemul:
	test	edx,0fe000000h
	jz	__argtype_mem_sib_mulok
	mov	eax,edx
	shr	eax,24
	test	al,1
	jnz	__argtype_mem_sib_mulodd
__argtype_mem_sib_muleven:
	cmp	al,2
	jne	__argtype_mem_sib_mulnot2
	or	ebx,ebx
	jnz	__argtype_mem_sib_mul2with2regs
	and	edx,001ffffffh
	mov	ebx,edx
	and	___argtype_sib,0dfh
	jmp	__argtype_mem_sib_mulok
__argtype_mem_sib_mul2with2regs:
	or	___argtype_sib,040h
	jmp	__argtype_mem_sib_mulok

__argtype_mem_sib_mulnot2:
	cmp	al,4
	jne	__argtype_mem_sib_mulnot4
	or	___argtype_sib,080h
	jmp	__argtype_mem_sib_mul4or8

__argtype_mem_sib_mulnot4:
	cmp	al,8
	jne	__argtype_err
	or	___argtype_sib,0c0h
__argtype_mem_sib_mul4or8:
	and	___argtype_sib,0dfh
	or	ebx,ebx
	jnz	__argtype_mem_sib_mulok
	mov	force32bitdisp,1
	or	___argtype_sib,05h
	mov	___argtype_data1,04h	; modr/m byte
	jmp	__argtype_mem_sib_mulok

__argtype_mem_sib_mulodd:
	or	ebx,ebx
	jnz	__argtype_err
	mov	ebx,edx
	and	ebx,000ffffffh
	or	ebx,001000000h
	sub	edx,001000000h
	dec	al
	and	___argtype_sib,0dfh
	jmp	__argtype_mem_sib_muleven

__argtype_mem_sib_mulok:
	test	edx,100000h
	jz	__argtype_mem_sib_noxchg
	test	ebx,100000h
	jnz	__argtype_err
__argtype_mem_sib_xchg:
	xchg	ebx,edx
__argtype_mem_sib_notesp:

__argtype_mem_sib_noxchg:
	test	ebx,0fe000000h
	jnz	__argtype_err

	push	ebx
	push	edx

	and	ebx,0ffffffh
	and	edx,0ffffffh

	shr	ebx,16
	shr	edx,16
	bsf	ebx,ebx
	bsf	edx,edx
	shl	edx,3
	or	___argtype_sib,dl
	or	___argtype_sib,bl

	pop	ebx		; no, this _IS_ the correct order dumbass!
	pop	edx		;  I'd have to xchg ebx,edx otherwise

	mov	addressbits,1		; 32-bit addressing

	cmp	force32bitdisp,1
	je	__argtype_mem_force32bitdisp

	mov	___argtype_data1,04h	; modr/m byte
	mov	___argtype_data4,0	; max bits in disp
	cmp	___argtype_data3,0
	je	__argtype_mem_done

	mov	___argtype_data1,44h	; modr/m byte
	mov	___argtype_data4,8	; max bits in disp
	cmp	___argtype_data3,127
	jg	__argtype_mem_32bitdisp
	cmp	___argtype_data3,-128
	jge	__argtype_mem_done

__argtype_mem_32bitdisp:
	mov	___argtype_data1,84h	; modr/m byte
__argtype_mem_force32bitdisp:
	mov	___argtype_data4,32	; max bits in disp
	jmp	__argtype_mem_done


__argtype_mem_16bitregs:
	sub	ebx,001000000h
	or	edx,edx
	jz	__argtype_mem_nosib
	sub	edx,001000000h

__argtype_mem_nosib:
	or	ebx,edx

	lea	esi,azmitaddressing-6
__argtype_mem_addressinglop:
	add	esi,6
	mov	eax,[esi]
	or	eax,eax
	jnz	__argtype_mem_nz
	cmp	byte ptr [esi+4],0
	je	__argtype_err
__argtype_mem_nz:
	cmp	eax,ebx
	jne	__argtype_mem_addressinglop
	movzx	ecx,byte ptr [esi+4]	  ; max bits in disp
	mov	eax,___argtype_data3
	or	cl,cl
	jnz	__argtype_mem_not0bits
	or	eax,eax
	jz	__argtype_mem_immbitsok
__argtype_mem_not0bits:
	cmp	cl,8
	jne	__argtype_mem_not8bits
	cmp	eax,255
	jg	__argtype_mem_addressinglop
	cmp	eax,-128
	jge	__argtype_mem_immbitsok
__argtype_mem_not8bits:
	cmp	cl,16
	jne	__argtype_mem_not16bits
	cmp	eax,65535
	jg	__argtype_mem_addressinglop
	cmp	eax,-32768
	jge	__argtype_mem_immbitsok
__argtype_mem_not16bits:
	cmp	cl,32
	jne	__argtype_mem_addressinglop
__argtype_mem_immbitsok:
	mov	___argtype_data4,ecx

	mov	al,[esi+5]	; modr/m byte
	mov	___argtype_data1,al
	cmp	esi,offset azmitaddressing_offs16
	je	__argtype_mem_done
	mov	addressbits,0	; 16-bit addressing
	cmp	esi,offset azmitaddressing32bit
	jb	__argtype_mem_done
	mov	addressbits,1	; 32-bit addressing
	jmp	__argtype_mem_done

__argtype_mem_done:
	mov	al,O_Mx
	or	ebx,ebx
	jnz	__argtype_mem_notoffs
	mov	al,O_OFFSx
__argtype_mem_notoffs:
	cmp	___argtype_farptr,1
	jne	__argtype_mem_notfarptr
	mov	al,O_FARx
__argtype_mem_notfarptr:
	or	al,___argtype_size
	mov	___argtype_type,al
	mov	___argtype_data2,1
	jmp	__argtype_done

__argtype_imm:
	call	_getxprwithregs
	jc	__argtype_err
	or	ebx,edx
	jnz	__argtype_err		; no regs allowed
	mov	___argtype_data3,eax
	jecxz	__argtype_imm_notfarptr
	cmp	byte ptr [esi],':'
	jne	__argtype_imm_notfarptr
	inc	esi
	dec	ecx
	jecxz	__argtype_err
	call	_getxprwithregs
	jc	__argtype_err
	or	ebx,edx
	jnz	__argtype_err		; no regs allowed
	mov	___argtype_data4,eax
	mov	___argtype_data2,3	; DFAR

	mov	___argtype_type,O_DFAR16
	mov	___argtype_size,2
	cmp	eax,65535
	jg	__argtype_dfar_not16bits
	cmp	eax,-32768
	jge	__argtype_done
__argtype_dfar_not16bits:
	mov	___argtype_type,O_DFAR32
	mov	___argtype_size,3
	jmp	__argtype_done

__argtype_imm_notfarptr:
	mov	bx,O_S_8 shl 8 + O_1
	cmp	eax,1
	je	__argtype_imm_done
	mov	bx,O_S_8 shl 8 + O_3
	cmp	eax,3
	je	__argtype_imm_done
	mov	bx,O_S_8 shl 8 + O_OM8
	cmp	eax,255
	jg	__argtype_imm_not8bits
	cmp	eax,-128
	jge	__argtype_imm_done
__argtype_imm_not8bits:
	mov	bx,O_S_16 shl 8 + O_OM16
	cmp	eax,65535
	jg	__argtype_imm_not16bits
	cmp	eax,-32768
	jge	__argtype_imm_done
__argtype_imm_not16bits:

	mov	bx,O_S_32 shl 8 + O_OM32
__argtype_imm_done:
	mov	___argtype_type,bl
	mov	___argtype_size,bh
	mov	___argtype_data2,2	; imm
	jmp	__argtype_done

__argtype_err:
	mov	___argtype_type,O_ERROR
__argtype_done:
	popad
	mov	al,___argtype_type
	mov	ah,___argtype_size
	mov	bl,___argtype_data1
	mov	bh,___argtype_data2
	mov	ecx,___argtype_data3
	mov	edx,___argtype_data4
	ret

___argtype_type 	db	?
___argtype_size 	db	?
___argtype_data1	db	?
___argtype_data2	db	?
___argtype_data3	dd	?
___argtype_data4	dd	?
___argtype_sib		db	?

___argtype_farptr	db	?

force32bitdisp	db	?


;
; _getxprwithregs();
; In:
;	ECX == length of buffer
;	ESI -> ASCIZ expression
; Out:
;	ESI -> next unused char in buffer
;	ECX == remaining length of buffer
;	CF == 1 if an error was found
;	CF == 0 if no error
;		EAX == number
;		EBX == reg1
;			[23..00]: reg, see _getireg()
;			[31..24]: multiplier
;		EDX == reg2
;			[23..00]: reg, see _getireg()
;			[31..24]: multiplier
_getxprwithregs:
	xor	eax,eax
	xor	ebx,ebx
	xor	edx,edx
	jecxz	_clc&ret

	push	edi
	lea	edi,dazmitbuf
@@trimlop:
	sub	ecx,1
	jc	@@trimdone
	lodsb
	cmp	al,' '
	je	@@trimlop
	cmp	al,9
	je	@@trimlop
	stosb
	jmp	@@trimlop
@@trimdone:
	lea	esi,dazmitbuf
	mov	ecx,edi
	sub	ecx,esi
	pop	edi

	cmp	byte ptr [esi],'['
	jne	@@notsb
	inc	esi
	dec	ecx
	jz	_stc&ret
@@notsb:

	call	_getxpr
	mov	ebx,0
	mov	edx,0
	jnc	_ret
	cmp	getxprerr,GETXPR_ERR_GENERIC
	ja	_stc&ret

	mov	@@imm,eax
	mov	xprreg1,0
	mov	xprreg2,0


	cmp	byte ptr [esi],']'
	je	@@done

	mov	bl,'+'
	mov	al,[esi-1]
	cmp	al,'['
	je	@@lop
	mov	bl,al
	cmp	bl,'+'
	je	@@lop
	cmp	bl,'-'
	je	@@lop
	cmp	bl,'*'
	jne	@@err

	push	ecx
	push	esi
	dec	esi
	mov	ecx,esi
@@premullop:
	dec	esi
	mov	al,[esi]
	cmp	al,'*'
	je	@@premullop
	cmp	al,'/'
	je	@@premullop
	cmp	al,'0'
	jb	@@start
	cmp	al,'9'
	jbe	@@premullop
@@start:
	inc	esi
	sub	ecx,esi
	call	_getxpr
	pop	esi
	pop	ecx
	test	eax,0ffffff00h
	jnz	@@err
	mov	bh,al
	jmp	@@premul

@@lop:
	mov	bh,1
@@premul:
	call	_getireg
	jc	@@err
	or	eax,0ff000000h
	shrd	edx,eax,24
	shr	eax,24
	imul	bh
	or	ah,ah
	jz	@@no
	inc	ah
	jnz	@@err
@@no:
	shld	eax,edx,24
	cmp	bl,'-'
	je	@@addreg
	xor	eax,0ff000000h
	add	eax,001000000h
@@addreg:
	mov	bl,[esi]
	inc	esi
	dec	ecx
	jnz	@@mullop
	cmp	bl,']'
	jne	@@err
	call	_addreg
	jmp	@@exit
@@mullop:
	cmp	bl,'*'
	je	@@mulreg
@@addregnow:
	call	_addreg
	jc	@@err
	or	ecx,ecx
	jl	@@err

	call	_getxpr
	cmp	bl,'+'
	je	@@addimm
	cmp	bl,'-'
	jne	@@err
	neg	eax
@@addimm:
	pushfd
	add	@@imm,eax
	popfd
	mov	bl,[esi-1]
	jnc	@@done
	cmp	ecx,1
	jne	@@lop
	jmp	@@done		; maybe I should make sure b.[esi] == ']'?

@@mulreg:
	or	ecx,ecx
	jle	@@addregnow
	xchg	ebx,eax
	call	_getnumber
	jc	@@err
	test	eax,0ffffff00h
	jnz	@@err
	shld	eax,ebx,8
	imul	ah
	or	ah,ah
	jz	@@no2
	inc	ah
	jnz	@@err
@@no2:
	shl	ebx,8
	shld	eax,ebx,24
	jmp	@@addreg

@@done:
	clc
@@exit:
	mov	ebx,xprreg1
	mov	edx,xprreg2
	mov	eax,@@imm
	ret

@@err:
	stc
	jmp	@@exit

@@imm	dd	?


;
; _getxpr();
; In:
;	ECX == length of buffer
;	ESI -> ASCIZ expression
; Out:
;	ESI -> next unused char in buffer
;	ECX == remaining length of buffer
;	CF == 1 if an error was found
;	CF == 0 if no error
;		EAX == number

; Errors returned by _getxpr();

GETXPR_ERR_NONE 	EQU	0	; no error
GETXPR_ERR_GENERIC	EQU	1	; generic error
GETXPR_ERR_MISSENDPAR	EQU	2	; missing end-parenthesis
GETXPR_ERR_DIVBYZERO	EQU	3	; division by zero
GETXPR_ERR_MISSOPD	EQU	4	; missing operand

_getxpr:
	push	edx
	push	ebx
	push	ebp
	push	edi

	mov	getxprerr,GETXPR_ERR_NONE

	xor	ebx,ebx
	call	_getxpr_ior
	xchg	eax,ebx
	jc	@@err
	jecxz	@@exit
@@err:
	cmp	getxprerr,GETXPR_ERR_NONE
	jne	@@veryerr
	mov	getxprerr,GETXPR_ERR_GENERIC
@@veryerr:
	stc
@@exit:
	pop	edi
	pop	ebp
	pop	ebx
	pop	edx
	ret


;
; _getxpr_*();
;
; All _getxpr_OPERATOR functions have the following in- and outdata.
;
; In:
;	ECX == length of buffer
;	ESI -> ASCIZ expression
; Out:
;	ESI -> next unused char in buffer
;	ECX == remaining length of buffer
;	CF == 1 if an error was found
;	CF == 0 if no error
;		EBX == number
;
__getxpr_err_missopd:
	mov	getxprerr,GETXPR_ERR_MISSOPD
	stc
	ret


;
_getxpr_ior:
	call	_getxpr_xor
	jc	_stc&ret
@@lop:
	jecxz	_clc&ret
	cmp	byte ptr [esi],'|'
	jne	_clc&ret
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_xor
	pop	eax
	jc	@@err
	or	ebx,eax
	jmp	@@lop
@@err:
	or	ebx,eax
	stc
	ret


;
_getxpr_xor:
	call	_getxpr_and
	jc	_stc&ret
@@lop:
	jecxz	_clc&ret
	cmp	byte ptr [esi],'^'
	jne	_clc&ret
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_and
	pop	eax
	jc	@@err
	xor	ebx,eax
	jmp	@@lop
@@err:
	xor	ebx,eax
	stc
	ret

;
_getxpr_and:
	call	_getxpr_sht
	jc	_stc&ret
@@lop:
	jecxz	_clc&ret
	cmp	byte ptr [esi],'&'
	jne	_clc&ret
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_sht
	pop	eax
	jc	@@err
	and	ebx,eax
	jmp	@@lop
@@err:
	and	ebx,eax
	stc
	ret


;
_getxpr_sht:
	call	_getxpr_add
	jc	_stc&ret
@@lop:
	jecxz	_clc&ret
	cmp	byte ptr [esi],'<'
	je	@@shl
	cmp	byte ptr [esi],'>'
	jne	_clc&ret

	cmp	byte ptr [esi+1],'>'
	jne	_clc&ret
	add	esi,2
	sub	ecx,2
	jle	__getxpr_err_missopd
	push	ebx
	call	_getxpr_add
	pop	eax
	pushfd
	xchg	ecx,eax
	xchg	ebx,ecx
	shr	ebx,cl
	xchg	eax,ecx
	popfd
	jnc	@@lop
	stc
	ret

@@shl:
	cmp	byte ptr [esi+1],'<'
	jne	_clc&ret
	add	esi,2
	sub	ecx,2
	jle	__getxpr_err_missopd
	push	ebx
	call	_getxpr_add
	pop	eax
	pushfd
	xchg	ecx,eax
	xchg	ebx,ecx
	shl	ebx,cl
	xchg	eax,ecx
	popfd
	jnc	@@lop
	stc
	ret


;
_getxpr_add:
	call	_getxpr_mul
	jc	_stc&ret
@@lop:
	jecxz	_clc&ret
	cmp	byte ptr [esi],'+'
	je	@@add
	cmp	byte ptr [esi],'-'
	jne	_clc&ret

	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_mul
	pop	eax
	jc	@@suberr
	xchg	eax,ebx
	sub	ebx,eax
	jmp	@@lop
@@suberr:
	xchg	eax,ebx
	sub	ebx,eax
	stc
	ret

@@add:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_mul
	pop	eax
	jc	@@adderr
	add	ebx,eax
	jmp	@@lop
@@adderr:
	add	ebx,eax
	stc
	ret


;
_getxpr_mul:
	call	_getxpr_num
	jc	_stc&ret
@@lop:
	jecxz	_clc&ret
	cmp	byte ptr [esi],'*'
	je	@@mul
	cmp	byte ptr [esi],'/'
	je	@@div
	cmp	byte ptr [esi],'%'
	jne	_clc&ret

	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_num
	pop	eax
	pushfd
	cdq
	or	ebx,ebx
	jz	@@div0			; div by 0
	idiv	ebx
	mov	ebx,edx
	popfd
	jnc	@@lop
	stc
	ret
@@div0:
	mov	getxprerr,GETXPR_ERR_DIVBYZERO
	popfd
	stc
	ret

@@mul:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_num
	pop	eax
	jc	@@mulerr
	imul	ebx
	xchg	ebx,eax
	jmp	@@lop
@@mulerr:
	imul	ebx
	xchg	ebx,eax
	stc
	ret

@@div:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	push	ebx
	call	_getxpr_num
	pop	eax
	pushfd
	cdq
	or	ebx,ebx
	jz	@@div0			; div by 0
	idiv	ebx
	xchg	ebx,eax
	popfd
	jnc	@@lop
	stc
	ret


;
_getxpr_num:
	call	_ltrim
	sub	ecx,eax
	jle	_clc&ret

	cmp	byte ptr [esi],'+'
	je	@@plus
	cmp	byte ptr [esi],'-'
	je	@@minus
	cmp	byte ptr [esi],'~'
	je	@@not

	call	_getxpr_pow
	ret

@@not:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	call	_getxpr_num
	jc	_stc&ret
	not	ebx
	clc
	ret

@@plus:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	call	_getxpr_num
	ret

@@minus:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd
	call	_getxpr_num
	jc	_stc&ret
	neg	ebx
	clc
	ret


;
_getxpr_pow:
	call	_getxpr_unm
	jc	_stc&ret
	jecxz	_clc&ret
@@lop:
	cmp	byte ptr [esi],'*'
	jne	_clc&ret
	cmp	byte ptr [esi+1],'*'
	jne	_clc&ret

	add	esi,2
	sub	ecx,2
	jle	__getxpr_err_missopd
	push	ebx
	call	_getxpr_unm
	pop	eax
	jc	_stc&ret
	push	ecx
	mov	ecx,ebx
	mov	ebx,eax
	mov	eax,1
	jecxz	@@zero
@@powlop:
	imul	ebx
	loop	@@powlop
@@zero:
	pop	ecx
	xchg	ebx,eax
	jmp	@@lop


;
_getxpr_unm:
	call	_ltrim
	sub	ecx,eax
	jle	_clc&ret

	xor	eax,eax
	xor	ebx,ebx

	cmp	byte ptr [esi],'('
	je	@@par
	call	_getnumber
	xchg	ebx,eax
	jc	_stc&ret		; set getxprerr to UNKNOWNCHAR?
	call	_ltrim
	sub	ecx,eax
	jnc	_clc&ret
	xor	ecx,ecx
	clc
	ret

@@par:
	inc	esi
	dec	ecx
	jz	__getxpr_err_missopd

	call	_getxpr_ior		; lowest priority
	jc	@@missendpar

	call	_ltrim
	sub	ecx,eax
	jle	@@missendpar

	cmp	byte ptr [esi],')'
	jne	@@missendpar
	inc	esi
	dec	ecx
	clc
	ret

@@missendpar:
	mov	getxprerr,GETXPR_ERR_MISSENDPAR
	stc
	ret


;
; registers in expression
;	[23..00]: reg, see _getireg()
;	[31..24]: multiplier
xprreg1 	dd	?
xprreg2 	dd	?

;
; _addreg();
; In:
;	EAX == reg to add
;		[23..00]: reg, see _getireg()
;		[31..24]: multiplier
; Out:
;	CF == 1 if an error was found
;	CF == 0 if no error
;	      xprreg* has been updated
_addreg:
	push	ebx
	push	ecx
	push	edx
	mov	ebx,eax
	and	ebx,0ffffffh
	lea	edx,xprreg1
	mov	ecx,xprreg1
	and	ecx,0ffffffh
	jecxz	__addreg_found
	cmp	ecx,ebx
	je	__addreg_found
	lea	edx,xprreg2
	mov	ecx,xprreg2
	and	ecx,0ffffffh
	jecxz	__addreg_found
	cmp	ecx,ebx
	jne	__addreg_err
__addreg_found:
	and	[edx],0ff000000h
	add	[edx],eax
__addreg_done:
	clc
	jmp	__addreg_exit
__addreg_err:
	stc
__addreg_exit:
	pop	edx
	pop	ecx
	pop	ebx
	ret


;
; _getnumber();
; In:
;	ECX == length of buffer
;	ESI -> buffer
; Out:
;	ECX == remaining chars in buffer
;	ESI -> next unused char in buffer
;	CF == 1 if an error was found
;	CF == 0 if no error
;	      EAX == number
_getnumber:
	push	ebx
	push	edx
	push	edi

	push	ecx
	push	esi

	push	ecx
	push	esi
	mov	dl,0	; dec is default
	mov	dh,10	; max digit value + 1 for current base
	mov	___getnumber_suf,'D'
__getnumber_verifydigit_lop:
	lodsb
	call	_asc2bin
	jc	__getnumber_verifydigit_lop_end
	loop	__getnumber_verifydigit_lop
	jmp	__getnumber_base_testb
__getnumber_verifydigit_lop_end:
	and	al,0dfh
	cmp	al,'H'
	jne	__getnumber_base_noth
	mov	edx,16 shl 8 + 1
	mov	___getnumber_suf,'H'
	jmp	__getnumber_baseok
__getnumber_base_noth:
	cmp	al,'B'
	jne	__getnumber_base_notb
	mov	edx,2 shl 8 + 2
	mov	___getnumber_suf,'B'
	jmp	__getnumber_baseok
__getnumber_base_notb:
	cmp	al,'O'
	jne	__getnumber_base_noto
	mov	edx,8 shl 8 + 3
	mov	___getnumber_suf,'O'
	jmp	__getnumber_baseok
__getnumber_base_noto:
	dec	esi
__getnumber_base_testb:
	mov	al,[esi-1]
	and	al,0dfh
	cmp	al,'B'
	jne	__getnumber_baseok
	mov	edx,2 shl 8 + 2
	mov	___getnumber_suf,'B'

__getnumber_baseok:
	mov	eax,esi
	pop	esi
	pop	ecx
	push	eax	; push ptr to next unused char in buffer
	movzx	edi,dh
	xor	ebx,ebx
	mov	dl,1

__getnumber_lop:
	lodsb
	call	_asc2bin
	jc	__getnumber_done
	cmp	ah,dh
	jae	__getnumber_err
	imul	ebx,edi
	movzx	eax,ah
	add	ebx,eax
	xor	dl,dl
	loop	__getnumber_lop

__getnumber_done:
	pop	esi

	pop	eax
	pop	ecx
	sub	eax,esi
	jz	__getnumber_err2
	add	ecx,eax

	mov	eax,ebx
	clc
	jmp	__getnumber_exit

__getnumber_err:
	cmp	al,'0'
	jb	__getnumber_done
	or	dl,dl
	jnz	__getnumber_forceerr
	and	al,0dfh
	cmp	al,___getnumber_suf
	je	__getnumber_done
__getnumber_forceerr:
	pop	esi
	pop	esi
	pop	ecx
	xor	eax,eax
__getnumber_err2:
	stc
__getnumber_exit:
	pop	edi
	pop	edx
	pop	ebx
	ret

___getnumber_suf db	 ?


;
; _asc2bin();
; In:
;	AL == ASCII character to be translated into a numerical value
; Out:
;	CF == 1 if unknown character
;	      AH == AL
;	CF == 0 if everything's ok
;	      AH == binary value
_asc2bin:
	mov	ah,al
	cmp	al,'0'
	jb	_stc&ret
	cmp	al,'9'
	jbe	__asc2bin_dec
	and	ah,0dfh
	cmp	ah,'A'
	jb	_stc&ret
	cmp	ah,'F'
	ja	_stc&ret
	sub	ah,'A'-10-'0'
__asc2bin_dec:
	sub	ah,'0'
	clc
	ret


;
; _getireg();
; In:
;	ECX == length of buffer
;	ESI -> buffer
; Out:
;	ECX == remaining chars in buffer
;	ESI -> next unused char in buffer
;	CF == 1 if an error was found
;	CF == 0 if no error
;		EAX = one bit set
;		[3..0]	 = low 8 bit regs
;		[7..4]	 = high 8 bit regs
;		[15..8]  = 16 bit regs
;		[23..16] = 32 bit regs
_getireg:
	push	ebx
	push	edx
	xor	ebx,ebx

	lea	edx,regs8
	call	_findreg
	jc	__getireg_check16
	bts	ebx,eax
	jmp	__getireg_done

__getireg_check16:
	lea	edx,regs16
	call	_findreg
	jc	__getireg_check32
	add	eax,8
	bts	ebx,eax
	jmp	__getireg_done

__getireg_check32:
	lea	edx,regs32
	call	_findreg
	jc	__getireg_err
	add	eax,16
	bts	ebx,eax
	inc	esi		; regnames are 3 chars long
	dec	ecx

__getireg_done:
	add	esi,2		; most regnames are 2 chars long
	sub	ecx,2
	xchg	eax,ebx
	clc
__getireg_end:
	pop	edx
	pop	ebx
	ret

__getireg_err:
	stc
	jmp	__getireg_end


;
; _findreg();
; In:
;	ESI -> buffer
;	EDX -> regsXX table
; Out:
;	CF = 1 if no match found
;	CF = 0 if match found
;	    EAX = regnum
_findreg:
	pushad
	movzx	ecx,byte ptr [edx]
	lea	edi,[edx+1]
	sub	edi,ecx
	mov	eax,-1
__findreg_lop:
	inc	eax
	add	edi,ecx
	cmp	byte ptr [edi],0
	je	__findreg_err
	pushad
	repe	cmpsb
	popad
	jne	__findreg_lop
	clc
	mov	[esp+7*4],eax
	popad
	ret

__findreg_err:
	stc
	popad
	ret


;
_pd:
	push	eax
	shr	eax,16
	call	_pw
	pop	eax
_pw:
	push	eax
	shr	ax,8
	call	_pb
	pop	eax
_pb:
	push	eax
	shr	al,4
	call	_pn
	pop	eax
_pn:
IF	AZMITDEBUG
	push	eax
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	mov	v86r_ah,2
	mov	v86r_dl,al
	mov	al,21h
	int	33h
	pop	eax
ENDIF
	ret


;
_pc4:
IF	AZMITDEBUG
	push	eax
	rol	eax,8
	call	_pc
	rol	eax,8
	call	_pc
	rol	eax,8
	call	_pc
	rol	eax,8
	call	_pc
	pop	eax
ENDIF
	ret


;
_pc:
IF	AZMITDEBUG
	push	eax
	mov	v86r_ah,2
	mov	v86r_dl,al
	mov	al,21h
	int	33h
	pop	eax
ENDIF
	ret


;
_pcrlf:
IF	AZMITDEBUG
	push	eax
	mov	v86r_ah,2
	mov	v86r_dl,13
	mov	al,21h
	int	33h
	mov	v86r_ah,2
	mov	v86r_dl,10
	mov	al,21h
	int	33h
	pop	eax
ENDIF
	ret


;
; D A T A 
;
;--------------- regs start -----------------------------

regs8		label	byte
	db	2	; length of strings
	db	'al'
	db	'cl'
	db	'dl'
	db	'bl'
	db	'ah'
	db	'ch'
	db	'dh'
	db	'bh'
	db	0	; end of list

regs16		label	byte
	db	2	; length of strings
	db	'ax'
	db	'cx'
	db	'dx'
	db	'bx'
	db	'sp'
	db	'bp'
	db	'si'
	db	'di'
	db	0	; end of list

regs32		label	byte
	db	3	; length of strings
	db	'eax'
	db	'ecx'
	db	'edx'
	db	'ebx'
	db	'esp'
	db	'ebp'
	db	'esi'
	db	'edi'
	db	0	; end of list

regsseg 	label	byte
	db	2	; length of strings
	db	'es'
	db	'cs'
	db	'ss'
	db	'ds'
	db	'fs'
	db	'gs'
	db	0	; end of list

;--------------- regs end -------------------------------

addressing	label	dword
	dd	offset addressing16_0,	addressing32_0
	dd	offset addressing16_40, addressing32_40
	dd	offset addressing16_80, addressing32_80

;--------------- addressing start -----------------------
; format
;	db	strlen,offsetbytes,str
;	bit 7 of strlen set -> SIB follows (only applies to 32-bit addressing)
;
addressing16_0	label	byte
	db	7, 0, '[bx+si]'
	db	7, 0, '[bx+di]'
	db	7, 0, '[bp+si]'
	db	7, 0, '[bp+di]'
	db	4, 0, '[si]'
	db	4, 0, '[di]'
	db	1, 2, '['
	db	4, 0, '[bx]'

addressing16_40 label	byte
	db	7, 1, '[bx+si+'
	db	7, 1, '[bx+di+'
	db	7, 1, '[bp+si+'
	db	7, 1, '[bp+di+'
	db	4, 1, '[si+'
	db	4, 1, '[di+'
	db	4, 1, '[bp+'
	db	4, 1, '[bx+'

addressing16_80 label	byte
	db	7, 2, '[bx+si+'
	db	7, 2, '[bx+di+'
	db	7, 2, '[bp+si+'
	db	7, 2, '[bp+di+'
	db	4, 2, '[si+'
	db	4, 2, '[di+'
	db	4, 2, '[bp+'
	db	4, 2, '[bx+'

addressing16_offs	label	byte
	db	1, 2, '['

addressing32_0	label	byte
	db	5,   0, '[eax]'
	db	5,   0, '[ecx]'
	db	5,   0, '[edx]'
	db	5,   0, '[ebx]'
	db	128, 0, ''
	db	1,   4, '['
	db	5,   0, '[esi]'
	db	5,   0, '[edi]'

addressing32_40 label	byte
	db	5,   1, '[eax+'
	db	5,   1, '[ecx+'
	db	5,   1, '[edx+'
	db	5,   1, '[ebx+'
	db	128, 1, ''
	db	5,   1, '[ebp+'
	db	5,   1, '[esi+'
	db	5,   1, '[edi+'

addressing32_80 label	byte
	db	5,   4, '[eax+'
	db	5,   4, '[ecx+'
	db	5,   4, '[edx+'
	db	5,   4, '[ebx+'
	db	128, 4, ''
	db	5,   4, '[ebp+'
	db	5,   4, '[esi+'
	db	5,   4, '[edi+'

addressing32_offs	label	byte
	db	1, 4, '['


addressing8_c0	label	byte
	db	2,   0, 'al'
	db	2,   0, 'cl'
	db	2,   0, 'dl'
	db	2,   0, 'bl'
	db	2,   0, 'ah'
	db	2,   0, 'ch'
	db	2,   0, 'dh'
	db	2,   0, 'bh'

addressing16_c0 label	byte
	db	2,   0, 'ax'
	db	2,   0, 'cx'
	db	2,   0, 'dx'
	db	2,   0, 'bx'
	db	2,   0, 'sp'
	db	2,   0, 'bp'
	db	2,   0, 'si'
	db	2,   0, 'di'

addressing32_c0 label	byte
	db	3,   0, 'eax'
	db	3,   0, 'ecx'
	db	3,   0, 'edx'
	db	3,   0, 'ebx'
	db	3,   0, 'esp'
	db	3,   0, 'ebp'
	db	3,   0, 'esi'
	db	3,   0, 'edi'

addressingmmx_c0 label	byte
	db	3,   0, 'mm0'
	db	3,   0, 'mm1'
	db	3,   0, 'mm2'
	db	3,   0, 'mm3'
	db	3,   0, 'mm4'
	db	3,   0, 'mm5'
	db	3,   0, 'mm6'
	db	3,   0, 'mm7'

;--------------- addressing end -------------------------

;------------ azmit addressing start -------
; format
;	dd	used registers (see _getireg)
;	db	max imm value in bits (i.e 16 == 16 bit value)
;	db	modrm byte
;	...
;	dd	0	; end of list (part 1)
;	db	0	; end of list (part 2)
azmitaddressing label	byte
	dd	00004800h		; [bx+si]
	db	00,00h
	dd	00008800h		; [bx+di]
	db	00,01h
	dd	00006000h		; [bp+si]
	db	00,02h
	dd	0000a000h		; [bp+di]
	db	00,03h
	dd	00004000h		; [si]
	db	00,04h
	dd	00008000h		; [di]
	db	00,05h
azmitaddressing_offs16	label
	dd	00000000h		; [offs16]
	db	16,06h
	dd	00000800h		; [bx]
	db	00,07h

	dd	00004800h		; [bx+si+disp8]
	db	08,40h
	dd	00008800h		; [bx+di+disp8]
	db	08,41h
	dd	00006000h		; [bp+si+disp8]
	db	08,42h
	dd	0000a000h		; [bp+di+disp8]
	db	08,43h
	dd	00004000h		; [si+disp8]
	db	08,44h
	dd	00008000h		; [di+disp8]
	db	08,45h
	dd	00002000h		; [bp+disp8]
	db	08,46h
	dd	00000800h		; [bx+disp8]
	db	08,47h

	dd	00004800h		; [bx+si+disp16]
	db	16,80h
	dd	00008800h		; [bx+di+disp16]
	db	16,81h
	dd	00006000h		; [bp+si+disp16]
	db	16,82h
	dd	0000a000h		; [bp+di+disp16]
	db	16,83h
	dd	00004000h		; [si+disp16]
	db	16,84h
	dd	00008000h		; [di+disp16]
	db	16,85h
	dd	00002000h		; [bp+disp16]
	db	16,86h
	dd	00000800h		; [bx+disp16]
	db	16,87h

; 32-bit addressing

azmitaddressing32bit	label		; everything after this is 32-bit addressing

	dd	00010000h		; [eax]
	db	00,00h
	dd	00020000h		; [ecx]
	db	00,01h
	dd	00040000h		; [edx]
	db	00,02h
	dd	00080000h		; [ebx]
	db	00,03h
;	 dd	 00000000h		 ; SIB
;	 db	 00,04h
	dd	00000000h		; [offs32]
	db	32,05h
	dd	00400000h		; [esi]
	db	00,06h
	dd	00800000h		; [edi]
	db	00,07h

	dd	00010000h		; [eax+disp8]
	db	08,40h
	dd	00020000h		; [ecx+disp8]
	db	08,41h
	dd	00040000h		; [edx+disp8]
	db	08,42h
	dd	00080000h		; [ebx+disp8]
	db	08,43h
;	 dd	 00000000h		 ; SIB+disp8
;	 db	 08,44h
	dd	00200000h		; [ebp+disp8]
	db	08,45h
	dd	00400000h		; [esi+disp8]
	db	08,46h
	dd	00800000h		; [edi+disp8]
	db	08,47h

	dd	00010000h		; [eax+disp32]
	db	32,80h
	dd	00020000h		; [ecx+disp32]
	db	32,81h
	dd	00040000h		; [edx+disp32]
	db	32,82h
	dd	00080000h		; [ebx+disp32]
	db	32,83h
;	 dd	 00000000h		 ; SIB+disp32
;	 db	 32,84h
	dd	00200000h		; [ebp+disp32]
	db	32,85h
	dd	00400000h		; [esi+disp32]
	db	32,86h
	dd	00800000h		; [edi+disp32]
	db	32,87h


	dd	0			; end of list (part 1)
	db	0			; end of list (part 2)

;------------ azmit addressing end ---------

;--------------- mnemonics start ------------------------
; format
;	size	count	desc
;	db	1	strlen
;	db	x	str
;
mnemonics	label	byte
	db	3, 'mov'
	db	4, 'xchg'
	db	4, 'push'
	db	3, 'pop'
	db	5, 'pusha'
	db	4, 'popa'
	db	5, 'pushf'
	db	4, 'popf'
	db	3, 'lea'
	db	3, 'lds'
	db	3, 'les'
	db	3, 'lfs'
	db	3, 'lgs'
	db	3, 'lss'
	db	2, 'in'
	db	3, 'out'
	db	5, 'movsb'
	db	5, 'movsw'
	db	4, 'insb'
	db	4, 'insw'
	db	5, 'outsb'
	db	5, 'outsw'
	db	5, 'cmpsb'
	db	5, 'cmpsw'
	db	5, 'scasb'
	db	5, 'scasw'
	db	5, 'lodsb'
	db	5, 'lodsw'
	db	5, 'stosb'
	db	5, 'stosw'
	db	4, 'repe'
	db	5, 'repne'
	db	5, 'xlatb'
	db	3, 'inc'
	db	3, 'dec'
	db	3, 'mul'
	db	4, 'imul'
	db	3, 'div'
	db	4, 'idiv'
	db	3, 'neg'
	db	3, 'adc'
	db	3, 'add'
	db	3, 'and'
	db	3, 'cmp'
	db	2, 'or'
	db	3, 'sbb'
	db	3, 'sub'
	db	3, 'xor'
	db	3, 'aaa'
	db	3, 'daa'
	db	3, 'das'
	db	3, 'aas'
	db	3, 'aad'
	db	3, 'aam'
	db	3, 'jmp'
	db	4, 'call'
	db	3, 'ret'
	db	4, 'retf'
	db	4, 'test'
	db	2, 'ja'
	db	3, 'jae'
	db	2, 'jb'
	db	3, 'jbe'
	db	2, 'jz'
	db	2, 'jg'
	db	3, 'jge'
	db	2, 'jl'
	db	3, 'jle'
	db	3, 'jnz'
	db	3, 'jno'
	db	3, 'jnp'
	db	3, 'jns'
	db	2, 'jo'
	db	2, 'jp'
	db	2, 'js'
	db	4, 'jcxz'
	db	4, 'loop'
	db	5, 'loope'
	db	6, 'loopne'
	db	4, 'int3'
	db	3, 'int'
	db	4, 'into'
	db	4, 'iret'
	db	3, 'cli'
	db	3, 'sti'
	db	3, 'not'
	db	3, 'sar'
	db	3, 'shl'
	db	3, 'shr'
	db	3, 'rcl'
	db	3, 'rcr'
	db	3, 'rol'
	db	3, 'ror'
	db	2, 'bt'
	db	3, 'btc'
	db	3, 'btr'
	db	3, 'bts'
	db	3, 'bsf'
	db	3, 'bsr'
	db	3, 'clc'
	db	3, 'stc'
	db	3, 'cmc'
	db	3, 'cld'
	db	3, 'std'
	db	4, 'lahf'
	db	4, 'sahf'
	db	4, 'wait'
	db	3, 'hlt'
	db	4, 'lock'
	db	3, 'nop'
	db	3, 'esc'
	db	4, 'clts'
	db	4, 'sgdt'
	db	4, 'sidt'
	db	3, 'str'
	db	3, 'ltr'
	db	4, 'sldt'
	db	4, 'lldt'
	db	4, 'arpl'
	db	3, 'lar'
	db	3, 'lsl'
	db	4, 'verr'
	db	4, 'verw'
	db	4, 'lmsw'
	db	4, 'smsw'
	db	5, 'movzx'
	db	5, 'movsx'
	db	3, 'cbw'
	db	3, 'cwd'
	db	5, 'bound'
	db	5, 'enter'
	db	5, 'leave'
	db	4, 'seta'
	db	5, 'setae'
	db	4, 'setb'
	db	5, 'setbe'
	db	4, 'setz'
	db	4, 'setg'
	db	5, 'setge'
	db	4, 'setl'
	db	5, 'setle'
	db	5, 'setnz'
	db	5, 'setno'
	db	5, 'setnp'
	db	5, 'setns'
	db	4, 'seto'
	db	4, 'setp'
	db	4, 'sets'
	db	7, 'cmpxchg'
	db	4, 'xadd'
	db	5, 'bswap'
	db	4, 'invd'
	db	6, 'wbinvd'
	db	6, 'invlpg'
	db	3, 'es:'
	db	3, 'cs:'
	db	3, 'ss:'
	db	3, 'ds:'
	db	3, 'fs:'
	db	3, 'gs:'
	db	6, 'pushad'
	db	5, 'popad'
	db	6, 'pushfd'
	db	5, 'popfd'
	db	5, 'movsd'
	db	4, 'insd'
	db	5, 'outsd'
	db	5, 'cmpsd'
	db	5, 'scasd'
	db	5, 'lodsd'
	db	5, 'stosd'
	db	5, 'iretd'
	db	4, 'cwde'
	db	3, 'cdq'
	db	4, 'salc'
	db	10, 'loadall286'
	db	10, 'loadall386'
	db	9, 'cmpxchg8b'
	db	5, 'cpuid'
	db	5, 'rdtsc'
	db	5, 'rdmsr'
	db	5, 'wrmsr'
	db	3, 'rsm'
	db	5, 'rdpmc'

	db	6, 'fsetpm'
	db	3, 'fld'
	db	3, 'fst'
	db	4, 'fstp'
	db	4, 'fild'
	db	4, 'fist'
	db	5, 'fistp'
	db	4, 'fbld'
	db	5, 'fbstp'
	db	4, 'fxch'
	db	4, 'fld1'
	db	6, 'fldl2t'
	db	6, 'fldl2e'
	db	5, 'fldpi'
	db	6, 'fldlg2'
	db	6, 'fldln2'
	db	4, 'fldz'
	db	4, 'fcom'
	db	5, 'fcomp'
	db	6, 'fcompp'
	db	5, 'fucom'
	db	6, 'fucomp'
	db	7, 'fucompp'
	db	5, 'ficom'
	db	6, 'ficomp'
	db	4, 'ftst'
	db	4, 'fxam'
	db	5, 'fstsw'
	db	6, 'fnstsw'
	db	4, 'fadd'
	db	5, 'faddp'
	db	5, 'fiadd'
	db	4, 'fsub'
	db	5, 'fsubp'
	db	5, 'fisub'
	db	5, 'fsubr'
	db	6, 'fsubrp'
	db	6, 'fisubr'
	db	4, 'fmul'
	db	5, 'fmulp'
	db	5, 'fimul'
	db	4, 'fdiv'
	db	5, 'fdivp'
	db	5, 'fidiv'
	db	5, 'fdivr'
	db	6, 'fdivrp'
	db	6, 'fidivr'
	db	5, 'fptan'
	db	7, 'fsincos'
	db	4, 'fsin'
	db	4, 'fcos'
	db	6, 'fpatan'
	db	5, 'f2xm1'
	db	5, 'fyl2x'
	db	7, 'fyl2xp1'
	db	5, 'finit'
	db	6, 'fninit'
	db	5, 'fstcw'
	db	6, 'fnstcw'
	db	5, 'fldcw'
	db	7, 'fincstp'
	db	7, 'fdecstp'
	db	4, 'fnop'
	db	5, 'fclex'
	db	6, 'fnclex'
	db	6, 'fstenv'
	db	7, 'fnstenv'
	db	6, 'fldenv'
	db	5, 'fsave'
	db	6, 'fnsave'
	db	6, 'frstor'
	db	5, 'fsqrt'
	db	6, 'fscale'
	db	4, 'fabs'
	db	4, 'fchs'
	db	5, 'fprem'
	db	6, 'fprem1'
	db	7, 'frndint'
	db	7, 'fxtract'

	db	5, 'icebp'
	db	3, 'ud2'

	db	5, 'cmovo'
	db	6, 'cmovno'
	db	5, 'cmovb'
	db	6, 'cmovae'
	db	5, 'cmovz'
	db	6, 'cmovnz'
	db	6, 'cmovbe'
	db	5, 'cmova'
	db	5, 'cmovs'
	db	6, 'cmovns'
	db	5, 'cmovp'
	db	6, 'cmovnp'
	db	5, 'cmovl'
	db	6, 'cmovge'
	db	6, 'cmovle'
	db	5, 'cmovg'
	db	6, 'fcmovb'
	db	6, 'fcmovz'
	db	7, 'fcmovbe'
	db	6, 'fcmovu'
	db	7, 'fcmovae'
	db	7, 'fcmovnz'
	db	6, 'fcmova'
	db	7, 'fcmovnu'
	db	5, 'fcomi'
	db	6, 'fcomip'
	db	6, 'fucomi'
	db	7, 'fucomip'

	db	4, 'shld'
	db	4, 'shrd'

	db	4, 'foof'

	db	4, 'lgdt'
	db	4, 'lidt'

	db	6, 'fxsave'
	db	7, 'fxrstor'

	db	4, 'movd'
	db	4, 'movq'

	db	5, 'paddb'
	db	5, 'paddw'
	db	5, 'paddd'
	db	6, 'paddsb'
	db	6, 'paddsw'
	db	7, 'paddusb'
	db	7, 'paddusw'
	db	5, 'psubb'
	db	5, 'psubw'
	db	5, 'psubd'
	db	6, 'psubsb'
	db	6, 'psubsw'
	db	7, 'psubusb'
	db	7, 'psubusw'
	db	6, 'pmulhw'
	db	6, 'pmullw'
	db	7, 'pmaddwd'
	db	7, 'pcmpeqb'
	db	7, 'pcmpeqw'
	db	7, 'pcmpeqd'
	db	7, 'pcmpgtb'
	db	7, 'pcmpgtw'
	db	7, 'pcmpgtd'
	db	8, 'packuswb'
	db	8, 'packsswb'
	db	8, 'packssdw'
	db	9, 'punpckhbw'
	db	9, 'punpckhwd'
	db	9, 'punpckhdq'
	db	9, 'punpcklbw'
	db	9, 'punpcklwd'
	db	9, 'punpckldq'
	db	4, 'pand'
	db	5, 'pandn'
	db	3, 'por'
	db	4, 'pxor'
	db	5, 'psllw'
	db	5, 'pslld'
	db	5, 'psllq'
	db	5, 'psrlw'
	db	5, 'psrld'
	db	5, 'psrlq'
	db	5, 'psraw'
	db	5, 'psrad'
	db	4, 'emms'

	db	7, 'pavgusb'
	db	5, 'pfadd'
	db	5, 'pfsub'
	db	6, 'pfsubr'
	db	5, 'pfacc'
	db	7, 'pfcmpge'
	db	7, 'pfcmpgt'
	db	7, 'pfcmpeq'
	db	5, 'pfmin'
	db	5, 'pfmax'
	db	5, 'pi2fd'
	db	5, 'pf2id'
	db	5, 'pfrcp'
	db	7, 'pfrsqrt'
	db	5, 'pfmul'
	db	8, 'pfrcpit1'
	db	8, 'pfrsqit1'
	db	8, 'pfrcpit2'
	db	7, 'pmulhrw'
	db	5, 'femms'
	db	8, 'prefetch'

	db	8, 'sysenter'
	db	7, 'sysexit'

	db	5, 'jecxz'
	db	4, 'umov'

	db	4, 'feni'
	db	5, 'fneni'
	db	5, 'ffree'

	db	2, 'jc'
	db	3, 'jnc'
	db	2, 'je'
	db	3, 'jne'
	db	3, 'jnb'
	db	3, 'jna'
	db	3, 'jnl'
	db	3, 'jng'

	db	4, 'setc'
	db	5, 'setnc'
	db	4, 'sete'
	db	5, 'setne'
	db	5, 'setnb'
	db	5, 'setna'
	db	5, 'setnl'
	db	5, 'setng'

	db	5, 'cmovc'
	db	6, 'cmovnc'
	db	6, 'cmovnb'
	db	5, 'cmove'
	db	6, 'cmovne'
	db	6, 'cmovna'
	db	6, 'cmovnl'
	db	6, 'cmovng'

	db	6, 'fcmovc'
	db	7, 'fcmovnc'
	db	7, 'fcmovnb'
	db	6, 'fcmove'
	db	7, 'fcmovne'
	db	7, 'fcmovna'

	db	0	; end of list


;------------------
; format
;	dw	16-bit mnemonic (default)
;	dw	32-bit mnemonic
;	...
;	dw	0	; end of list
mnemonics_special	label	word
	dw	M_PUSHA,	M_PUSHAD
	dw	M_POPA, 	M_POPAD
	dw	M_PUSHF,	M_PUSHFD
	dw	M_POPF, 	M_POPFD
	dw	M_MOVSW,	M_MOVSD
	dw	M_INSW, 	M_INSD
	dw	M_OUTSW,	M_OUTSD
	dw	M_CMPSW,	M_CMPSD
	dw	M_SCASW,	M_SCASD
	dw	M_LODSW,	M_LODSD
	dw	M_STOSW,	M_STOSD
	dw	M_IRET, 	M_IRETD
	dw	M_CBW,		M_CWDE
	dw	M_CWD,		M_CDQ
	dw	M_JCXZ, 	M_JECXZ
	dw	0	; end of list

;--------------- mnemonics end --------------------------

;--------------- opcodes start --------------------------
; format
;	size	count	desc
;	db	1	number of bytes in opcode
;	db	x	opcode-bytes
;	db	1	type of 1st operand
;	db	1	type of 2nd operand
;	db	1	type of 3rd operand
;	db	1	opcode-table byte
;	db	1	minimum processor	0 == All processors
;						1 == 80186
;						2 == 80286
;						3 == 80386
;						4 == 80486
;						5 == 80586 Pentium
;						6 == 80686 PentiumPro
;						7 == 80786 Pentium II
;	dw	1	mnemonic index
;
SIZEOF_OPCODE	EQU	1+0+1+1+1+1+1+2
MAX_OPERANDS	EQU	3

opcodes 	label	byte
	db	1,090h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_NOP

	db	4,0f0h,00fh,0c7h,0c8h,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0c9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0cah,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0cbh,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0cch,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0cdh,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0ceh,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF
	db	4,0f0h,00fh,0c7h,0cfh,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_FOOF

	db	2,00fh,0aeh,O_M,O_NONE,O_NONE,OB_0,P_7
	dw	M_FXSAVE

	db	2,00fh,0aeh,O_M,O_NONE,O_NONE,OB_1,P_7
	dw	M_FXRSTOR

	db	1,0a0h,O_ACC8,O_OFFS1632,0,OB_NONE,P_0
	dw	M_MOV
	db	1,0a1h,O_ACC1632,O_OFFS1632,0,OB_NONE,P_0
	dw	M_MOV
	db	1,0a2h,O_OFFS1632,O_ACC8,0,OB_NONE,P_0
	dw	M_MOV
	db	1,0a3h,O_OFFS1632,O_ACC1632,0,OB_NONE,P_0
	dw	M_MOV
	db	1,088h,O_RM8,O_R8,0,OB_SR,P_0
	dw	M_MOV
	db	1,089h,O_RM1632,O_R1632,0,OB_SR,P_0
	dw	M_MOV
	db	1,08ah,O_R8,O_RM8,0,OB_SR,P_0
	dw	M_MOV
	db	1,08bh,O_R1632,O_RM1632,0,OB_SR,P_0
	dw	M_MOV
	db	1,08ch,O_RM16,O_SEGR,0,OB_SR,P_0
	dw	M_MOV
	db	1,08eh,O_SEGR,O_RM16,0,OB_SR,P_0
	dw	M_MOV
	db	1,0b0h,O_R8,O_OM8,0,OB_R0,P_0
	dw	M_MOV
	db	1,0b1h,O_R8,O_OM8,0,OB_R1,P_0
	dw	M_MOV
	db	1,0b2h,O_R8,O_OM8,0,OB_R2,P_0
	dw	M_MOV
	db	1,0b3h,O_R8,O_OM8,0,OB_R3,P_0
	dw	M_MOV
	db	1,0b4h,O_R8,O_OM8,0,OB_R4,P_0
	dw	M_MOV
	db	1,0b5h,O_R8,O_OM8,0,OB_R5,P_0
	dw	M_MOV
	db	1,0b6h,O_R8,O_OM8,0,OB_R6,P_0
	dw	M_MOV
	db	1,0b7h,O_R8,O_OM8,0,OB_R7,P_0
	dw	M_MOV
	db	1,0b8h,O_R1632,O_OM1632,0,OB_R0,P_0
	dw	M_MOV
	db	1,0b9h,O_R1632,O_OM1632,0,OB_R1,P_0
	dw	M_MOV
	db	1,0bah,O_R1632,O_OM1632,0,OB_R2,P_0
	dw	M_MOV
	db	1,0bbh,O_R1632,O_OM1632,0,OB_R3,P_0
	dw	M_MOV
	db	1,0bch,O_R1632,O_OM1632,0,OB_R4,P_0
	dw	M_MOV
	db	1,0bdh,O_R1632,O_OM1632,0,OB_R5,P_0
	dw	M_MOV
	db	1,0beh,O_R1632,O_OM1632,0,OB_R6,P_0
	dw	M_MOV
	db	1,0bfh,O_R1632,O_OM1632,0,OB_R7,P_0
	dw	M_MOV
	db	1,0c6h,O_RM8,O_OM8,0,OB_0,P_0
	dw	M_MOV
	db	1,0c7h,O_RM1632,O_OM1632,0,OB_0,P_0
	dw	M_MOV

	db	1,090h,O_ACC1632,O_R1632,0,OB_R0,P_0
	dw	M_XCHG
	db	1,091h,O_ACC1632,O_R1632,0,OB_R1,P_0
	dw	M_XCHG
	db	1,092h,O_ACC1632,O_R1632,0,OB_R2,P_0
	dw	M_XCHG
	db	1,093h,O_ACC1632,O_R1632,0,OB_R3,P_0
	dw	M_XCHG
	db	1,094h,O_ACC1632,O_R1632,0,OB_R4,P_0
	dw	M_XCHG
	db	1,095h,O_ACC1632,O_R1632,0,OB_R5,P_0
	dw	M_XCHG
	db	1,096h,O_ACC1632,O_R1632,0,OB_R6,P_0
	dw	M_XCHG
	db	1,097h,O_ACC1632,O_R1632,0,OB_R7,P_0
	dw	M_XCHG
	db	1,086h,O_R8,O_RM8,0,OB_SR,P_0
	dw	M_XCHG
	db	1,087h,O_R1632,O_RM1632,0,OB_SR,P_0
	dw	M_XCHG

	db	1,0ffh,O_M1632,O_NONE,O_NONE,OB_6,P_0
	dw	M_PUSH
	db	1,050h,O_R1632,O_NONE,O_NONE,OB_R0,P_0
	dw	M_PUSH
	db	1,051h,O_R1632,O_NONE,O_NONE,OB_R1,P_0
	dw	M_PUSH
	db	1,052h,O_R1632,O_NONE,O_NONE,OB_R2,P_0
	dw	M_PUSH
	db	1,053h,O_R1632,O_NONE,O_NONE,OB_R3,P_0
	dw	M_PUSH
	db	1,054h,O_R1632,O_NONE,O_NONE,OB_R4,P_0
	dw	M_PUSH
	db	1,055h,O_R1632,O_NONE,O_NONE,OB_R5,P_0
	dw	M_PUSH
	db	1,056h,O_R1632,O_NONE,O_NONE,OB_R6,P_0
	dw	M_PUSH
	db	1,057h,O_R1632,O_NONE,O_NONE,OB_R7,P_0
	dw	M_PUSH
	db	1,06ah,O_OM8EXP,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_PUSH
	db	1,068h,O_OM1632,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_PUSH
	db	1,00eh,O_SEGR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_PUSH
	db	1,016h,O_SEGR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_PUSH
	db	1,01eh,O_SEGR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_PUSH
	db	1,006h,O_SEGR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_PUSH
	db	2,00fh,0a0h,O_SEGR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_PUSH
	db	2,00fh,0a8h,O_SEGR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_PUSH

	db	1,08fh,O_M1632,O_NONE,O_NONE,OB_0,P_0
	dw	M_POP
	db	1,058h,O_R1632,O_NONE,O_NONE,OB_R0,P_0
	dw	M_POP
	db	1,059h,O_R1632,O_NONE,O_NONE,OB_R1,P_0
	dw	M_POP
	db	1,05ah,O_R1632,O_NONE,O_NONE,OB_R2,P_0
	dw	M_POP
	db	1,05bh,O_R1632,O_NONE,O_NONE,OB_R3,P_0
	dw	M_POP
	db	1,05ch,O_R1632,O_NONE,O_NONE,OB_R4,P_0
	dw	M_POP
	db	1,05dh,O_R1632,O_NONE,O_NONE,OB_R5,P_0
	dw	M_POP
	db	1,05eh,O_R1632,O_NONE,O_NONE,OB_R6,P_0
	dw	M_POP
	db	1,05fh,O_R1632,O_NONE,O_NONE,OB_R7,P_0
	dw	M_POP
	db	1,01fh,O_SEGR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_POP
	db	1,007h,O_SEGR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_POP
	db	1,017h,O_SEGR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_POP
	db	2,00fh,0a1h,O_SEGR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_POP
	db	2,00fh,0a9h,O_SEGR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_POP

	db	1,060h,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_PUSHA

	db	1,061h,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_POPA

	db	1,09ch,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_PUSHF

	db	1,09dh,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_POPF

	db	1,08dh,O_R1632,O_M1632,O_NONE,OB_SR,P_0
	dw	M_LEA

	db	1,0c5h,O_R1632,O_M1632,O_NONE,OB_SR,P_0
	dw	M_LDS

	db	1,0c4h,O_R1632,O_M1632,O_NONE,OB_SR,P_0
	dw	M_LES

	db	2,00fh,0b4h,O_R1632,O_M1632,O_NONE,OB_SR,P_3
	dw	M_LFS

	db	2,00fh,0b5h,O_R1632,O_M1632,O_NONE,OB_SR,P_3
	dw	M_LGS

	db	2,00fh,0b2h,O_R1632,O_M1632,O_NONE,OB_SR,P_3
	dw	M_LSS

	db	1,0e4h,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_IN
	db	1,0e5h,O_ACC1632,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_IN
	db	1,0ech,O_ACC8,O_DX,O_NONE,OB_NONE,P_0
	dw	M_IN
	db	1,0edh,O_ACC1632,O_DX,O_NONE,OB_NONE,P_0
	dw	M_IN

	db	1,0e6h,O_OM8,O_ACC8,O_NONE,OB_NONE,P_0
	dw	M_OUT
	db	1,0e7h,O_OM8,O_ACC1632,O_NONE,OB_NONE,P_0
	dw	M_OUT
	db	1,0eeh,O_DX,O_ACC8,O_NONE,OB_NONE,P_0
	dw	M_OUT
	db	1,0efh,O_DX,O_ACC1632,O_NONE,OB_NONE,P_0
	dw	M_OUT

	db	1,0a4h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_MOVSB

	db	1,0a5h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_MOVSW

	db	1,06ch,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_INSB

	db	1,06dh,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_INSW

	db	1,06eh,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_OUTSB

	db	1,06fh,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_OUTSW

	db	1,0a6h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CMPSB

	db	1,0a7h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CMPSW

	db	1,0aeh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_SCASB

	db	1,0afh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_SCASW

	db	1,0ach,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LODSB

	db	1,0adh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LODSW

	db	1,0aah,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_STOSB

	db	1,0abh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_STOSW

	db	1,0f3h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_REPE

	db	1,0f2h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_REPNE

	db	1,0d7h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_XLATB

	db	1,040h,O_R1632,O_NONE,O_NONE,OB_R0,P_0
	dw	M_INC
	db	1,041h,O_R1632,O_NONE,O_NONE,OB_R1,P_0
	dw	M_INC
	db	1,042h,O_R1632,O_NONE,O_NONE,OB_R2,P_0
	dw	M_INC
	db	1,043h,O_R1632,O_NONE,O_NONE,OB_R3,P_0
	dw	M_INC
	db	1,044h,O_R1632,O_NONE,O_NONE,OB_R4,P_0
	dw	M_INC
	db	1,045h,O_R1632,O_NONE,O_NONE,OB_R5,P_0
	dw	M_INC
	db	1,046h,O_R1632,O_NONE,O_NONE,OB_R6,P_0
	dw	M_INC
	db	1,047h,O_R1632,O_NONE,O_NONE,OB_R7,P_0
	dw	M_INC
	db	1,0feh,O_RM8,O_NONE,O_NONE,OB_0,P_0
	dw	M_INC
	db	1,0ffh,O_RM1632,O_NONE,O_NONE,OB_0,P_0
	dw	M_INC

	db	1,048h,O_R1632,O_NONE,O_NONE,OB_R0,P_0
	dw	M_DEC
	db	1,049h,O_R1632,O_NONE,O_NONE,OB_R1,P_0
	dw	M_DEC
	db	1,04ah,O_R1632,O_NONE,O_NONE,OB_R2,P_0
	dw	M_DEC
	db	1,04bh,O_R1632,O_NONE,O_NONE,OB_R3,P_0
	dw	M_DEC
	db	1,04ch,O_R1632,O_NONE,O_NONE,OB_R4,P_0
	dw	M_DEC
	db	1,04dh,O_R1632,O_NONE,O_NONE,OB_R5,P_0
	dw	M_DEC
	db	1,04eh,O_R1632,O_NONE,O_NONE,OB_R6,P_0
	dw	M_DEC
	db	1,04fh,O_R1632,O_NONE,O_NONE,OB_R7,P_0
	dw	M_DEC
	db	1,0feh,O_RM8,O_NONE,O_NONE,OB_1,P_0
	dw	M_DEC
	db	1,0ffh,O_RM1632,O_NONE,O_NONE,OB_1,P_0
	dw	M_DEC

	db	1,0f6h,O_RM8,O_NONE,O_NONE,OB_4,P_0
	dw	M_MUL
	db	1,0f7h,O_RM1632,O_NONE,O_NONE,OB_4,P_0
	dw	M_MUL

	db	1,0f6h,O_RM8,O_NONE,O_NONE,OB_5,P_0
	dw	M_IMUL
	db	1,0f7h,O_RM1632,O_NONE,O_NONE,OB_5,P_0
	dw	M_IMUL
	db	2,00fh,0afh,O_R1632,O_RM1632,O_NONE,OB_SR,P_3
	dw	M_IMUL
	db	1,06bh,O_R1632,O_RM1632,O_OM8EXP,OB_SR,P_3
	dw	M_IMUL
;	 db	 1,06bh,O_R1632,O_OM8EXP,O_NONE,OB_SR,P_3
;	 dw	 M_IMUL
	db	1,069h,O_R1632,O_RM1632,O_OM1632,OB_SR,P_3
	dw	M_IMUL
;	 db	 1,069h,O_R1632,O_OM1632,O_NONE,OB_SR,P_3
;	 dw	 M_IMUL

	db	1,0f6h,O_RM8,O_NONE,O_NONE,OB_6,P_0
	dw	M_DIV
	db	1,0f7h,O_RM1632,O_NONE,O_NONE,OB_6,P_0
	dw	M_DIV

	db	1,0f6h,O_RM8,O_NONE,O_NONE,OB_7,P_0
	dw	M_IDIV
	db	1,0f7h,O_RM1632,O_NONE,O_NONE,OB_7,P_0
	dw	M_IDIV

	db	1,0f6h,O_RM8,O_NONE,O_NONE,OB_3,P_0
	dw	M_NEG
	db	1,0f7h,O_RM1632,O_NONE,O_NONE,OB_3,P_0
	dw	M_NEG

	db	1,014h,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_ADC
	db	1,015h,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_ADC
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_2,P_0
	dw	M_ADC
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_2,P_0
	dw	M_ADC
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_2,P_0
	dw	M_ADC
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_2,P_0
	dw	M_ADC
	db	1,010h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_ADC
	db	1,011h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_ADC
	db	1,012h,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_ADC
	db	1,013h,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_ADC

	db	1,004h,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_ADD
	db	1,005h,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_ADD
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_0,P_0
	dw	M_ADD
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_0,P_0
	dw	M_ADD
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_0,P_0
	dw	M_ADD
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_0,P_0
	dw	M_ADD
	db	1,000h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_ADD
	db	1,001h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_ADD
	db	1,002h,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_ADD
	db	1,003h,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_ADD

	db	1,024h,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_AND
	db	1,025h,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_AND
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_4,P_0
	dw	M_AND
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_4,P_0
	dw	M_AND
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_4,P_0
	dw	M_AND
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_4,P_0
	dw	M_AND
	db	1,020h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_AND
	db	1,021h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_AND
	db	1,022h,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_AND
	db	1,023h,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_AND

	db	1,03ch,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_CMP
	db	1,03dh,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_CMP
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_7,P_0
	dw	M_CMP
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_7,P_0
	dw	M_CMP
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_7,P_0
	dw	M_CMP
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_7,P_0
	dw	M_CMP
	db	1,038h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_CMP
	db	1,039h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_CMP
	db	1,03ah,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_CMP
	db	1,03bh,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_CMP

	db	1,00ch,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_OR
	db	1,00dh,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_OR
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_1,P_0
	dw	M_OR
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_1,P_0
	dw	M_OR
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_1,P_0
	dw	M_OR
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_1,P_0
	dw	M_OR
	db	1,008h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_OR
	db	1,009h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_OR
	db	1,00ah,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_OR
	db	1,00bh,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_OR

	db	1,01ch,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_SBB
	db	1,01dh,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_SBB
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_3,P_0
	dw	M_SBB
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_3,P_0
	dw	M_SBB
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_3,P_0
	dw	M_SBB
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_3,P_0
	dw	M_SBB
	db	1,018h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_SBB
	db	1,019h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_SBB
	db	1,01ah,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_SBB
	db	1,01bh,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_SBB

	db	1,02ch,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_SUB
	db	1,02dh,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_SUB
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_5,P_0
	dw	M_SUB
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_5,P_0
	dw	M_SUB
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_5,P_0
	dw	M_SUB
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_5,P_0
	dw	M_SUB
	db	1,028h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_SUB
	db	1,029h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_SUB
	db	1,02ah,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_SUB
	db	1,02bh,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_SUB

	db	1,034h,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_XOR
	db	1,035h,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_XOR
	db	1,083h,O_RM1632,O_OM8EXP,O_NONE,OB_6,P_0
	dw	M_XOR
	db	1,080h,O_RM8,O_OM8,O_NONE,OB_6,P_0
	dw	M_XOR
	db	1,082h,O_RM8,O_OM8,O_NONE,OB_6,P_0
	dw	M_XOR
	db	1,081h,O_RM1632,O_OM1632,O_NONE,OB_6,P_0
	dw	M_XOR
	db	1,030h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_XOR
	db	1,031h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_XOR
	db	1,032h,O_R8,O_RM8,O_NONE,OB_SR,P_0
	dw	M_XOR
	db	1,033h,O_R1632,O_RM1632,O_NONE,OB_SR,P_0
	dw	M_XOR

	db	1,037h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_AAA

	db	1,027h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_DAA

	db	1,02fh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_DAS

	db	1,03fh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_AAS

	db	1,0d5h,O_OM8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_AAD
	db	2,0d5h,00ah,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_AAD

	db	1,0d4h,O_OM8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_AAM
	db	2,0d4h,00ah,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_AAM


	db	1,0ebh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JMP
	db	1,0e9h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JMP
	db	1,0ffh,O_RM1632,O_NONE,O_NONE,OB_4,P_0
	dw	M_JMP
	db	1,0eah,O_DFAR1632,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JMP
	db	1,0ffh,O_FAR1632,O_NONE,O_NONE,OB_5,P_0
	dw	M_JMP

	db	1,0e8h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CALL
	db	1,09ah,O_DFAR1632,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CALL
	db	1,0ffh,O_RM1632,O_NONE,O_NONE,OB_2,P_0
	dw	M_CALL
	db	1,0ffh,O_FAR1632,O_NONE,O_NONE,OB_3,P_0
	dw	M_CALL

	db	1,0c3h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_RET
	db	1,0c2h,O_OM16,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_RET

	db	1,0cbh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_RETF
	db	1,0cah,O_OM16,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_RETF

	db	1,0a8h,O_ACC8,O_OM8,O_NONE,OB_NONE,P_0
	dw	M_TEST
	db	1,0a9h,O_ACC1632,O_OM1632,O_NONE,OB_NONE,P_0
	dw	M_TEST
	db	1,0f6h,O_RM8,O_OM8,O_NONE,OB_0,P_0
	dw	M_TEST
	db	1,0f7h,O_RM1632,O_OM1632,O_NONE,OB_0,P_0
	dw	M_TEST
	db	1,084h,O_RM8,O_R8,O_NONE,OB_SR,P_0
	dw	M_TEST
	db	1,085h,O_RM1632,O_R1632,O_NONE,OB_SR,P_0
	dw	M_TEST

	db	1,077h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JA
	db	2,00fh,087h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JA
	db	1,073h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JAE
	db	2,00fh,083h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JAE
	db	1,072h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JB
	db	2,00fh,082h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JB
	db	1,076h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JBE
	db	2,00fh,086h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JBE
	db	1,074h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JZ
	db	2,00fh,084h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JZ
	db	1,07fh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JG
	db	2,00fh,08fh,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JG
	db	1,07dh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JGE
	db	2,00fh,08dh,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JGE
	db	1,07ch,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JL
	db	2,00fh,08ch,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JL
	db	1,07eh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JLE
	db	2,00fh,08eh,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JLE
	db	1,075h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNZ
	db	2,00fh,085h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNZ
	db	1,071h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNO
	db	2,00fh,081h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNO
	db	1,07bh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNP
	db	2,00fh,08bh,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNP
	db	1,079h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNS
	db	2,00fh,089h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNS
	db	1,070h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JO
	db	2,00fh,080h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JO
	db	1,07ah,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JP
	db	2,00fh,08ah,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JP
	db	1,078h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JS
	db	2,00fh,088h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JS

	db	1,0e3h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JCXZ

	db	1,0e2h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LOOP

	db	1,0e1h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LOOPE

	db	1,0e0h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LOOPNE

	db	1,0cch,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_INT3
	db	1,0cch,O_3,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_INT

	db	1,0cdh,O_OM8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_INT

	db	1,0ceh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_INTO

	db	1,0cfh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_IRET

	db	1,0fah,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CLI

	db	1,0fbh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_STI

	db	1,0f6h,O_RM8,O_NONE,O_NONE,OB_2,P_0
	dw	M_NOT
	db	1,0f7h,O_RM1632,O_NONE,O_NONE,OB_2,P_0
	dw	M_NOT

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_7,P_0
	dw	M_SAR
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_7,P_0
	dw	M_SAR
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_7,P_2
	dw	M_SAR
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_7,P_0
	dw	M_SAR
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_7,P_0
	dw	M_SAR
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_7,P_2
	dw	M_SAR

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_4,P_0
	dw	M_SHL
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_4,P_0
	dw	M_SHL
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_4,P_2
	dw	M_SHL
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_4,P_0
	dw	M_SHL
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_4,P_0
	dw	M_SHL
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_4,P_2
	dw	M_SHL

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_5,P_0
	dw	M_SHR
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_5,P_0
	dw	M_SHR
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_5,P_2
	dw	M_SHR
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_5,P_0
	dw	M_SHR
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_5,P_0
	dw	M_SHR
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_5,P_2
	dw	M_SHR

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_2,P_0
	dw	M_RCL
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_2,P_0
	dw	M_RCL
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_2,P_2
	dw	M_RCL
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_2,P_0
	dw	M_RCL
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_2,P_0
	dw	M_RCL
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_2,P_2
	dw	M_RCL

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_3,P_0
	dw	M_RCR
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_3,P_0
	dw	M_RCR
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_3,P_2
	dw	M_RCR
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_3,P_0
	dw	M_RCR
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_3,P_0
	dw	M_RCR
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_3,P_2
	dw	M_RCR

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_0,P_0
	dw	M_ROL
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_0,P_0
	dw	M_ROL
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_0,P_2
	dw	M_ROL
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_0,P_0
	dw	M_ROL
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_0,P_0
	dw	M_ROL
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_0,P_2
	dw	M_ROL

	db	1,0d0h,O_RM8,O_1,O_NONE,OB_1,P_0
	dw	M_ROR
	db	1,0d2h,O_RM8,O_CL,O_NONE,OB_1,P_0
	dw	M_ROR
	db	1,0c0h,O_RM8,O_OM8,O_NONE,OB_1,P_2
	dw	M_ROR
	db	1,0d1h,O_RM1632,O_1,O_NONE,OB_1,P_0
	dw	M_ROR
	db	1,0d3h,O_RM1632,O_CL,O_NONE,OB_1,P_0
	dw	M_ROR
	db	1,0c1h,O_RM1632,O_OM8,O_NONE,OB_1,P_2
	dw	M_ROR

	db	2,00fh,0a3h,O_RM1632,O_R1632,O_NONE,OB_SR,P_3
	dw	M_BT
	db	2,00fh,0bah,O_RM1632,O_OM8,O_NONE,OB_4,P_3
	dw	M_BT

	db	2,00fh,0bbh,O_RM1632,O_R1632,O_NONE,OB_SR,P_3
	dw	M_BTC
	db	2,00fh,0bah,O_RM1632,O_OM8,O_NONE,OB_7,P_3
	dw	M_BTC

	db	2,00fh,0b3h,O_RM1632,O_R1632,O_NONE,OB_SR,P_3
	dw	M_BTR
	db	2,00fh,0bah,O_RM1632,O_OM8,O_NONE,OB_6,P_3
	dw	M_BTR

	db	2,00fh,0abh,O_RM1632,O_R1632,O_NONE,OB_SR,P_3
	dw	M_BTS
	db	2,00fh,0bah,O_RM1632,O_OM8,O_NONE,OB_5,P_3
	dw	M_BTS

	db	2,00fh,0bch,O_R1632,O_RM1632,O_NONE,OB_SR,P_3
	dw	M_BSF

	db	2,00fh,0bdh,O_R1632,O_RM1632,O_NONE,OB_SR,P_3
	dw	M_BSR

	db	1,0f8h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CLC

	db	1,0f9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_STC

	db	1,0f5h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CMC

	db	1,0fch,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CLD

	db	1,0fdh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_STD

	db	1,09fh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LAHF

	db	1,09eh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_SAHF

	db	1,0f4h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_HLT

	db	1,0f0h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_LOCK

	db	2,00fh,022h,O_CR,O_R32,O_NONE,OB_SR,P_3
	dw	M_MOV
	db	2,00fh,020h,O_R32,O_CR,O_NONE,OB_SR,P_3
	dw	M_MOV
	db	2,00fh,023h,O_DR,O_R32,O_NONE,OB_SR,P_3
	dw	M_MOV
	db	2,00fh,021h,O_R32,O_DR,O_NONE,OB_SR,P_3
	dw	M_MOV
	db	2,00fh,026h,O_TR,O_R32,O_NONE,OB_SR,P_3
	dw	M_MOV
	db	2,00fh,024h,O_R32,O_TR,O_NONE,OB_SR,P_3
	dw	M_MOV

	db	2,00fh,006h,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_CLTS

	db	2,00fh,001h,O_RM1632,O_NONE,O_NONE,OB_0,P_2
	dw	M_SGDT

	db	2,00fh,001h,O_RM1632,O_NONE,O_NONE,OB_1,P_2
	dw	M_SIDT

	db	2,00fh,000h,O_RM16,O_NONE,O_NONE,OB_1,P_2
	dw	M_STR

	db	2,00fh,000h,O_RM16,O_NONE,O_NONE,OB_3,P_2
	dw	M_LTR

	db	2,00fh,000h,O_RM16,O_NONE,O_NONE,OB_0,P_2
	dw	M_SLDT

	db	2,00fh,000h,O_RM16,O_NONE,O_NONE,OB_2,P_2
	dw	M_LLDT

	db	2,00fh,001h,O_M64,O_NONE,O_NONE,OB_2,P_2
	dw	M_LGDT

	db	2,00fh,001h,O_M64,O_NONE,O_NONE,OB_3,P_2
	dw	M_LIDT

	db	1,063h,O_RM16,O_R16,O_NONE,OB_SR,P_2
	dw	M_ARPL

	db	2,00fh,002h,O_R1632,O_RM1632,O_NONE,OB_SR,P_2
	dw	M_LAR

	db	2,00fh,003h,O_R1632,O_RM1632,O_NONE,OB_SR,P_2
	dw	M_LSL

	db	2,00fh,000h,O_RM16,O_NONE,O_NONE,OB_4,P_2
	dw	M_VERR

	db	2,00fh,000h,O_RM16,O_NONE,O_NONE,OB_5,P_2
	dw	M_VERW

	db	2,00fh,001h,O_RM16,O_NONE,O_NONE,OB_6,P_2
	dw	M_LMSW

	db	2,00fh,001h,O_RM1632,O_NONE,O_NONE,OB_4,P_2
	dw	M_SMSW

	db	2,00fh,0b6h,O_R1632,O_RM8,O_NONE,OB_SR,P_3
	dw	M_MOVZX
	db	2,00fh,0b7h,O_R1632,O_RM16,O_NONE,OB_SR,P_3
	dw	M_MOVZX
	db	2,00fh,0beh,O_R1632,O_RM8,O_NONE,OB_SR,P_3
	dw	M_MOVSX
	db	2,00fh,0bfh,O_R1632,O_RM16,O_NONE,OB_SR,P_3
	dw	M_MOVSX

	db	1,098h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CBW

	db	1,099h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CWD

	db	1,066h,O_NONE,O_NONE,O_NONE,OB_DATASIZE,P_0
	dw	0

	db	1,067h,O_NONE,O_NONE,O_NONE,OB_ADDRESSIZE,P_0
	dw	0

;	 db	 1,026h,O_NONE,O_NONE,O_NONE,OB_ESOVERRIDE,P_0
	db	1,026h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_ESOVERRIDE

;	 db	 1,02eh,O_NONE,O_NONE,O_NONE,OB_CSOVERRIDE,P_0
	db	1,02eh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_CSOVERRIDE

;	 db	 1,036h,O_NONE,O_NONE,O_NONE,OB_SSOVERRIDE,P_0
	db	1,036h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_SSOVERRIDE

;	 db	 1,03eh,O_NONE,O_NONE,O_NONE,OB_DSOVERRIDE,P_0
	db	1,03eh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_DSOVERRIDE

;	 db	 1,064h,O_NONE,O_NONE,O_NONE,OB_FSOVERRIDE,P_0
	db	1,064h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FSOVERRIDE

;	 db	 1,065h,O_NONE,O_NONE,O_NONE,OB_GSOVERRIDE,P_0
	db	1,065h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_GSOVERRIDE

	db	1,062h,O_R1632,O_RM1632,O_NONE,OB_SR,P_2
	dw	M_BOUND

	db	1,0c8h,O_OM16,O_OM8,O_NONE,OB_NONE,P_2
	dw	M_ENTER

	db	1,0c9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_LEAVE

	db	2,00fh,097h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETA
	db	2,00fh,093h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETAE
	db	2,00fh,092h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETB
	db	2,00fh,096h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETBE
	db	2,00fh,094h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETZ
	db	2,00fh,09fh,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETG
	db	2,00fh,09dh,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETGE
	db	2,00fh,09ch,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETL
	db	2,00fh,09eh,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETLE
	db	2,00fh,095h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNZ
	db	2,00fh,091h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNO
	db	2,00fh,09bh,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNP
	db	2,00fh,099h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNS
	db	2,00fh,090h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETO
	db	2,00fh,09ah,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETP
	db	2,00fh,098h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETS

	db	2,00fh,0a4h,O_RM1632,O_R1632,O_OM8,OB_SR,P_3
	dw	M_SHLD
	db	2,00fh,0a5h,O_RM1632,O_R1632,O_CL,OB_SR,P_3
	dw	M_SHLD

	db	2,00fh,0ach,O_RM1632,O_R1632,O_OM8,OB_SR,P_3
	dw	M_SHRD
	db	2,00fh,0adh,O_RM1632,O_R1632,O_CL,OB_SR,P_3
	dw	M_SHRD

	db	2,00fh,0b0h,O_RM8,O_R8,O_NONE,OB_SR,P_4
	dw	M_CMPXCHG
	db	2,00fh,0b1h,O_RM1632,O_R1632,O_NONE,OB_SR,P_4
	dw	M_CMPXCHG

	db	2,00fh,0c0h,O_RM8,O_R8,O_NONE,OB_SR,P_4
	dw	M_XADD
	db	2,00fh,0c1h,O_RM1632,O_R1632,O_NONE,OB_SR,P_4
	dw	M_XADD

	db	2,00fh,0c8h,O_R1632,O_NONE,O_NONE,OB_R0,P_4
	dw	M_BSWAP
	db	2,00fh,0c9h,O_R1632,O_NONE,O_NONE,OB_R1,P_4
	dw	M_BSWAP
	db	2,00fh,0cah,O_R1632,O_NONE,O_NONE,OB_R2,P_4
	dw	M_BSWAP
	db	2,00fh,0cbh,O_R1632,O_NONE,O_NONE,OB_R3,P_4
	dw	M_BSWAP
	db	2,00fh,0cch,O_R1632,O_NONE,O_NONE,OB_R4,P_4
	dw	M_BSWAP
	db	2,00fh,0cdh,O_R1632,O_NONE,O_NONE,OB_R5,P_4
	dw	M_BSWAP
	db	2,00fh,0ceh,O_R1632,O_NONE,O_NONE,OB_R6,P_4
	dw	M_BSWAP
	db	2,00fh,0cfh,O_R1632,O_NONE,O_NONE,OB_R7,P_4
	dw	M_BSWAP

	db	2,00fh,008h,O_NONE,O_NONE,O_NONE,OB_NONE,P_4
	dw	M_INVD

	db	2,00fh,009h,O_NONE,O_NONE,O_NONE,OB_NONE,P_4
	dw	M_WBINVD

	db	2,00fh,001h,O_RM1632,O_NONE,O_NONE,OB_7,P_4
	dw	M_INVLPG

	db	1,0d6h,O_NONE,O_NONE,O_NONE,OB_NONE,P_1
	dw	M_SALC

	db	2,00fh,005h,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_LOADALL286

	db	2,00fh,007h,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_LOADALL386

	db	2,00fh,0c7h,O_M64,O_NONE,O_NONE,OB_1,P_5
	dw	M_CMPXCHG8B

	db	2,00fh,0a2h,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_CPUID

	db	2,00fh,031h,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_RDTSC

	db	2,00fh,032h,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_RDMSR

	db	2,00fh,030h,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_WRMSR

	db	2,00fh,0aah,O_NONE,O_NONE,O_NONE,OB_NONE,P_5
	dw	M_RSM

	db	2,00fh,033h,O_NONE,O_NONE,O_NONE,OB_NONE,P_6
	dw	M_RDPMC

	db	2,00fh,040h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVO
	db	2,00fh,041h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNO
	db	2,00fh,042h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVB
	db	2,00fh,043h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVAE
	db	2,00fh,044h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVZ
	db	2,00fh,045h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNZ
	db	2,00fh,046h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVBE
	db	2,00fh,047h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVA
	db	2,00fh,048h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVS
	db	2,00fh,049h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNS
	db	2,00fh,04ah,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVP
	db	2,00fh,04bh,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNP
	db	2,00fh,04ch,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVL
	db	2,00fh,04dh,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVGE
	db	2,00fh,04eh,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVLE
	db	2,00fh,04fh,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVG


;----------------- FPU ---------------------

	db	2,0dbh,0e4h,O_NONE,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_FSETPM

	db	1,0d9h,O_M32,O_NONE,O_NONE,OB_0,P_0
	dw	M_FLD
	db	1,0ddh,O_M64,O_NONE,O_NONE,OB_0,P_0
	dw	M_FLD
	db	1,0dbh,O_M80,O_NONE,O_NONE,OB_5,P_0
	dw	M_FLD
	db	2,0d9h,0c0h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FLD
	db	2,0d9h,0c1h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FLD
	db	2,0d9h,0c2h,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FLD
	db	2,0d9h,0c3h,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FLD
	db	2,0d9h,0c4h,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FLD
	db	2,0d9h,0c5h,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FLD
	db	2,0d9h,0c6h,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FLD
	db	2,0d9h,0c7h,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FLD

	db	1,0d9h,O_M32,O_NONE,O_NONE,OB_2,P_0
	dw	M_FST
	db	1,0ddh,O_M64,O_NONE,O_NONE,OB_2,P_0
	dw	M_FST
	db	2,0ddh,0d0h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FST
	db	2,0ddh,0d1h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FST
	db	2,0ddh,0d2h,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FST
	db	2,0ddh,0d3h,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FST
	db	2,0ddh,0d4h,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FST
	db	2,0ddh,0d5h,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FST
	db	2,0ddh,0d6h,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FST
	db	2,0ddh,0d7h,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FST

	db	1,0d9h,O_M32,O_NONE,O_NONE,OB_3,P_0
	dw	M_FSTP
	db	1,0ddh,O_M64,O_NONE,O_NONE,OB_3,P_0
	dw	M_FSTP
	db	1,0dbh,O_M80,O_NONE,O_NONE,OB_7,P_0
	dw	M_FSTP
	db	2,0ddh,0d8h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FSTP
	db	2,0ddh,0d9h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FSTP
	db	2,0ddh,0dah,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FSTP
	db	2,0ddh,0dbh,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FSTP
	db	2,0ddh,0dch,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FSTP
	db	2,0ddh,0ddh,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FSTP
	db	2,0ddh,0deh,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FSTP
	db	2,0ddh,0dfh,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FSTP

	db	1,0dfh,O_M16,O_NONE,O_NONE,OB_0,P_0
	dw	M_FILD
	db	1,0dbh,O_M32,O_NONE,O_NONE,OB_0,P_0
	dw	M_FILD
	db	1,0dfh,O_M64,O_NONE,O_NONE,OB_5,P_0
	dw	M_FILD

	db	1,0dfh,O_M16,O_NONE,O_NONE,OB_2,P_0
	dw	M_FIST
	db	1,0dbh,O_M32,O_NONE,O_NONE,OB_2,P_0
	dw	M_FIST

	db	1,0dfh,O_M16,O_NONE,O_NONE,OB_3,P_0
	dw	M_FISTP
	db	1,0dbh,O_M32,O_NONE,O_NONE,OB_3,P_0
	dw	M_FISTP
	db	1,0dfh,O_M64,O_NONE,O_NONE,OB_7,P_0
	dw	M_FISTP

	db	1,0dfh,O_M80,O_NONE,O_NONE,OB_4,P_0
	dw	M_FBLD

	db	1,0dfh,O_M80,O_NONE,O_NONE,OB_6,P_0
	dw	M_FBSTP

	db	2,0d9h,0c8h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FXCH
	db	2,0d9h,0c9h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FXCH
	db	2,0d9h,0cah,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FXCH
	db	2,0d9h,0cbh,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FXCH
	db	2,0d9h,0cch,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FXCH
	db	2,0d9h,0cdh,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FXCH
	db	2,0d9h,0ceh,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FXCH
	db	2,0d9h,0cfh,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FXCH

	db	2,0d9h,0e8h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLD1

	db	2,0d9h,0e9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLDL2T

	db	2,0d9h,0eah,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLDL2E

	db	2,0d9h,0ebh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLDPI

	db	2,0d9h,0ech,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLDLG2

	db	2,0d9h,0edh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLDLN2

	db	2,0d9h,0eeh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FLDZ

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_2,P_0
	dw	M_FCOM
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_2,P_0
	dw	M_FCOM
	db	2,0d8h,0d0h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FCOM
	db	2,0d8h,0d1h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FCOM
	db	2,0d8h,0d2h,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FCOM
	db	2,0d8h,0d3h,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FCOM
	db	2,0d8h,0d4h,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FCOM
	db	2,0d8h,0d5h,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FCOM
	db	2,0d8h,0d6h,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FCOM
	db	2,0d8h,0d7h,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FCOM

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_3,P_0
	dw	M_FCOMP
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_3,P_0
	dw	M_FCOMP
	db	2,0d8h,0d8h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FCOMP
	db	2,0d8h,0d9h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FCOMP
	db	2,0d8h,0dah,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FCOMP
	db	2,0d8h,0dbh,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FCOMP
	db	2,0d8h,0dch,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FCOMP
	db	2,0d8h,0ddh,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FCOMP
	db	2,0d8h,0deh,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FCOMP
	db	2,0d8h,0dfh,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FCOMP

	db	2,0deh,0d9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FCOMPP

	db	2,0ddh,0e0h,O_FPUR,O_NONE,O_NONE,OB_R0,P_3
	dw	M_FUCOM
	db	2,0ddh,0e1h,O_FPUR,O_NONE,O_NONE,OB_R1,P_3
	dw	M_FUCOM
	db	2,0ddh,0e2h,O_FPUR,O_NONE,O_NONE,OB_R2,P_3
	dw	M_FUCOM
	db	2,0ddh,0e3h,O_FPUR,O_NONE,O_NONE,OB_R3,P_3
	dw	M_FUCOM
	db	2,0ddh,0e4h,O_FPUR,O_NONE,O_NONE,OB_R4,P_3
	dw	M_FUCOM
	db	2,0ddh,0e5h,O_FPUR,O_NONE,O_NONE,OB_R5,P_3
	dw	M_FUCOM
	db	2,0ddh,0e6h,O_FPUR,O_NONE,O_NONE,OB_R6,P_3
	dw	M_FUCOM
	db	2,0ddh,0e7h,O_FPUR,O_NONE,O_NONE,OB_R7,P_3
	dw	M_FUCOM

	db	2,0ddh,0e8h,O_FPUR,O_NONE,O_NONE,OB_R0,P_3
	dw	M_FUCOMP
	db	2,0ddh,0e9h,O_FPUR,O_NONE,O_NONE,OB_R1,P_3
	dw	M_FUCOMP
	db	2,0ddh,0eah,O_FPUR,O_NONE,O_NONE,OB_R2,P_3
	dw	M_FUCOMP
	db	2,0ddh,0ebh,O_FPUR,O_NONE,O_NONE,OB_R3,P_3
	dw	M_FUCOMP
	db	2,0ddh,0ech,O_FPUR,O_NONE,O_NONE,OB_R4,P_3
	dw	M_FUCOMP
	db	2,0ddh,0edh,O_FPUR,O_NONE,O_NONE,OB_R5,P_3
	dw	M_FUCOMP
	db	2,0ddh,0eeh,O_FPUR,O_NONE,O_NONE,OB_R6,P_3
	dw	M_FUCOMP
	db	2,0ddh,0efh,O_FPUR,O_NONE,O_NONE,OB_R7,P_3
	dw	M_FUCOMP

	db	2,0dah,0e9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_FUCOMPP

	db	1,0deh,O_M16,O_NONE,O_NONE,OB_2,P_0
	dw	M_FICOM
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_2,P_0
	dw	M_FICOM

	db	1,0deh,O_M16,O_NONE,O_NONE,OB_3,P_0
	dw	M_FICOMP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_3,P_0
	dw	M_FICOMP

	db	2,0d9h,0e4h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FTST

	db	2,0d9h,0e5h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FXAM

	db	2,09bh,0ddh,O_M16,O_NONE,O_NONE,OB_7,P_0
	dw	M_FSTSW
	db	3,09bh,0dfh,0e0h,O_ACC16,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_FSTSW

	db	1,0ddh,O_M16,O_NONE,O_NONE,OB_7,P_0
	dw	M_FNSTSW
	db	2,0dfh,0e0h,O_ACC16,O_NONE,O_NONE,OB_NONE,P_2
	dw	M_FNSTSW

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_0,P_0
	dw	M_FADD
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_0,P_0
	dw	M_FADD
	db	2,0d8h,0c0h,O_ST,O_FPUR,O_NONE,OB_R0,P_0
	dw	M_FADD
	db	2,0d8h,0c1h,O_ST,O_FPUR,O_NONE,OB_R1,P_0
	dw	M_FADD
	db	2,0d8h,0c2h,O_ST,O_FPUR,O_NONE,OB_R2,P_0
	dw	M_FADD
	db	2,0d8h,0c3h,O_ST,O_FPUR,O_NONE,OB_R3,P_0
	dw	M_FADD
	db	2,0d8h,0c4h,O_ST,O_FPUR,O_NONE,OB_R4,P_0
	dw	M_FADD
	db	2,0d8h,0c5h,O_ST,O_FPUR,O_NONE,OB_R5,P_0
	dw	M_FADD
	db	2,0d8h,0c6h,O_ST,O_FPUR,O_NONE,OB_R6,P_0
	dw	M_FADD
	db	2,0d8h,0c7h,O_ST,O_FPUR,O_NONE,OB_R7,P_0
	dw	M_FADD
	db	2,0dch,0c0h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FADD
	db	2,0dch,0c1h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FADD
	db	2,0dch,0c2h,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FADD
	db	2,0dch,0c3h,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FADD
	db	2,0dch,0c4h,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FADD
	db	2,0dch,0c5h,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FADD
	db	2,0dch,0c6h,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FADD
	db	2,0dch,0c7h,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FADD
	db	2,0deh,0c0h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FADDP
	db	2,0deh,0c1h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FADDP
	db	2,0deh,0c2h,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FADDP
	db	2,0deh,0c3h,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FADDP
	db	2,0deh,0c4h,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FADDP
	db	2,0deh,0c5h,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FADDP
	db	2,0deh,0c6h,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FADDP
	db	2,0deh,0c7h,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FADDP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_0,P_0
	dw	M_FIADD
	db	1,0deh,O_M16,O_NONE,O_NONE,OB_0,P_0
	dw	M_FIADD

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_6,P_0
	dw	M_FDIV
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_6,P_0
	dw	M_FDIV
	db	2,0d8h,0f0h,O_ST,O_FPUR,O_NONE,OB_R0,P_0
	dw	M_FDIV
	db	2,0d8h,0f1h,O_ST,O_FPUR,O_NONE,OB_R1,P_0
	dw	M_FDIV
	db	2,0d8h,0f2h,O_ST,O_FPUR,O_NONE,OB_R2,P_0
	dw	M_FDIV
	db	2,0d8h,0f3h,O_ST,O_FPUR,O_NONE,OB_R3,P_0
	dw	M_FDIV
	db	2,0d8h,0f4h,O_ST,O_FPUR,O_NONE,OB_R4,P_0
	dw	M_FDIV
	db	2,0d8h,0f5h,O_ST,O_FPUR,O_NONE,OB_R5,P_0
	dw	M_FDIV
	db	2,0d8h,0f6h,O_ST,O_FPUR,O_NONE,OB_R6,P_0
	dw	M_FDIV
	db	2,0d8h,0f7h,O_ST,O_FPUR,O_NONE,OB_R7,P_0
	dw	M_FDIV
	db	2,0dch,0f8h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FDIV
	db	2,0dch,0f9h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FDIV
	db	2,0dch,0fah,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FDIV
	db	2,0dch,0fbh,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FDIV
	db	2,0dch,0fch,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FDIV
	db	2,0dch,0fdh,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FDIV
	db	2,0dch,0feh,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FDIV
	db	2,0dch,0ffh,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FDIV
	db	2,0deh,0f8h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FDIVP
	db	2,0deh,0f9h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FDIVP
	db	2,0deh,0fah,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FDIVP
	db	2,0deh,0fbh,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FDIVP
	db	2,0deh,0fch,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FDIVP
	db	2,0deh,0fdh,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FDIVP
	db	2,0deh,0feh,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FDIVP
	db	2,0deh,0ffh,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FDIVP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_6,P_0
	dw	M_FIDIV
	db	1,0deh,O_M16,O_NONE,O_NONE,OB_6,P_0
	dw	M_FIDIV

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_7,P_0
	dw	M_FDIVR
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_7,P_0
	dw	M_FDIVR
	db	2,0d8h,0f8h,O_ST,O_FPUR,O_NONE,OB_R0,P_0
	dw	M_FDIVR
	db	2,0d8h,0f9h,O_ST,O_FPUR,O_NONE,OB_R1,P_0
	dw	M_FDIVR
	db	2,0d8h,0fah,O_ST,O_FPUR,O_NONE,OB_R2,P_0
	dw	M_FDIVR
	db	2,0d8h,0fbh,O_ST,O_FPUR,O_NONE,OB_R3,P_0
	dw	M_FDIVR
	db	2,0d8h,0fch,O_ST,O_FPUR,O_NONE,OB_R4,P_0
	dw	M_FDIVR
	db	2,0d8h,0fdh,O_ST,O_FPUR,O_NONE,OB_R5,P_0
	dw	M_FDIVR
	db	2,0d8h,0feh,O_ST,O_FPUR,O_NONE,OB_R6,P_0
	dw	M_FDIVR
	db	2,0d8h,0ffh,O_ST,O_FPUR,O_NONE,OB_R7,P_0
	dw	M_FDIVR
	db	2,0dch,0f0h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FDIVR
	db	2,0dch,0f1h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FDIVR
	db	2,0dch,0f2h,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FDIVR
	db	2,0dch,0f3h,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FDIVR
	db	2,0dch,0f4h,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FDIVR
	db	2,0dch,0f5h,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FDIVR
	db	2,0dch,0f6h,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FDIVR
	db	2,0dch,0f7h,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FDIVR
	db	2,0deh,0f0h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FDIVRP
	db	2,0deh,0f1h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FDIVRP
	db	2,0deh,0f2h,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FDIVRP
	db	2,0deh,0f3h,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FDIVRP
	db	2,0deh,0f4h,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FDIVRP
	db	2,0deh,0f5h,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FDIVRP
	db	2,0deh,0f6h,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FDIVRP
	db	2,0deh,0f7h,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FDIVRP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_7,P_0
	dw	M_FIDIVR
	db	1,0deh,O_M16,O_NONE,O_NONE,OB_7,P_0
	dw	M_FIDIVR

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_1,P_0
	dw	M_FMUL
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_1,P_0
	dw	M_FMUL
	db	2,0d8h,0c8h,O_ST,O_FPUR,O_NONE,OB_R0,P_0
	dw	M_FMUL
	db	2,0d8h,0c9h,O_ST,O_FPUR,O_NONE,OB_R1,P_0
	dw	M_FMUL
	db	2,0d8h,0cah,O_ST,O_FPUR,O_NONE,OB_R2,P_0
	dw	M_FMUL
	db	2,0d8h,0cbh,O_ST,O_FPUR,O_NONE,OB_R3,P_0
	dw	M_FMUL
	db	2,0d8h,0cch,O_ST,O_FPUR,O_NONE,OB_R4,P_0
	dw	M_FMUL
	db	2,0d8h,0cdh,O_ST,O_FPUR,O_NONE,OB_R5,P_0
	dw	M_FMUL
	db	2,0d8h,0ceh,O_ST,O_FPUR,O_NONE,OB_R6,P_0
	dw	M_FMUL
	db	2,0d8h,0cfh,O_ST,O_FPUR,O_NONE,OB_R7,P_0
	dw	M_FMUL
	db	2,0dch,0c8h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FMUL
	db	2,0dch,0c9h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FMUL
	db	2,0dch,0cah,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FMUL
	db	2,0dch,0cbh,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FMUL
	db	2,0dch,0cch,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FMUL
	db	2,0dch,0cdh,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FMUL
	db	2,0dch,0ceh,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FMUL
	db	2,0dch,0cfh,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FMUL
	db	2,0deh,0c8h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FMULP
	db	2,0deh,0c9h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FMULP
	db	2,0deh,0cah,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FMULP
	db	2,0deh,0cbh,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FMULP
	db	2,0deh,0cch,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FMULP
	db	2,0deh,0cdh,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FMULP
	db	2,0deh,0ceh,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FMULP
	db	2,0deh,0cfh,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FMULP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_1,P_0
	dw	M_FIMUL
	db	1,0deh,O_M16,O_NONE,O_NONE,OB_1,P_0
	dw	M_FIMUL

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_4,P_0
	dw	M_FSUB
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_4,P_0
	dw	M_FSUB
	db	2,0d8h,0e0h,O_ST,O_FPUR,O_NONE,OB_R0,P_0
	dw	M_FSUB
	db	2,0d8h,0e1h,O_ST,O_FPUR,O_NONE,OB_R1,P_0
	dw	M_FSUB
	db	2,0d8h,0e2h,O_ST,O_FPUR,O_NONE,OB_R2,P_0
	dw	M_FSUB
	db	2,0d8h,0e3h,O_ST,O_FPUR,O_NONE,OB_R3,P_0
	dw	M_FSUB
	db	2,0d8h,0e4h,O_ST,O_FPUR,O_NONE,OB_R4,P_0
	dw	M_FSUB
	db	2,0d8h,0e5h,O_ST,O_FPUR,O_NONE,OB_R5,P_0
	dw	M_FSUB
	db	2,0d8h,0e6h,O_ST,O_FPUR,O_NONE,OB_R6,P_0
	dw	M_FSUB
	db	2,0d8h,0e7h,O_ST,O_FPUR,O_NONE,OB_R7,P_0
	dw	M_FSUB
	db	2,0dch,0e8h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FSUB
	db	2,0dch,0e9h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FSUB
	db	2,0dch,0eah,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FSUB
	db	2,0dch,0ebh,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FSUB
	db	2,0dch,0ech,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FSUB
	db	2,0dch,0edh,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FSUB
	db	2,0dch,0eeh,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FSUB
	db	2,0dch,0efh,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FSUB
	db	2,0deh,0e8h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FSUBP
	db	2,0deh,0e9h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FSUBP
	db	2,0deh,0eah,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FSUBP
	db	2,0deh,0ebh,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FSUBP
	db	2,0deh,0ech,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FSUBP
	db	2,0deh,0edh,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FSUBP
	db	2,0deh,0eeh,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FSUBP
	db	2,0deh,0efh,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FSUBP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_4,P_0
	dw	M_FISUB
	db	1,0deh,O_M16,O_NONE,O_NONE,OB_4,P_0
	dw	M_FISUB

	db	1,0d8h,O_M32,O_NONE,O_NONE,OB_5,P_0
	dw	M_FSUBR
	db	1,0dch,O_M64,O_NONE,O_NONE,OB_5,P_0
	dw	M_FSUBR
	db	2,0d8h,0e8h,O_ST,O_FPUR,O_NONE,OB_R0,P_0
	dw	M_FSUBR
	db	2,0d8h,0e9h,O_ST,O_FPUR,O_NONE,OB_R1,P_0
	dw	M_FSUBR
	db	2,0d8h,0eah,O_ST,O_FPUR,O_NONE,OB_R2,P_0
	dw	M_FSUBR
	db	2,0d8h,0ebh,O_ST,O_FPUR,O_NONE,OB_R3,P_0
	dw	M_FSUBR
	db	2,0d8h,0ech,O_ST,O_FPUR,O_NONE,OB_R4,P_0
	dw	M_FSUBR
	db	2,0d8h,0edh,O_ST,O_FPUR,O_NONE,OB_R5,P_0
	dw	M_FSUBR
	db	2,0d8h,0eeh,O_ST,O_FPUR,O_NONE,OB_R6,P_0
	dw	M_FSUBR
	db	2,0d8h,0efh,O_ST,O_FPUR,O_NONE,OB_R7,P_0
	dw	M_FSUBR
	db	2,0dch,0e0h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FSUBR
	db	2,0dch,0e1h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FSUBR
	db	2,0dch,0e2h,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FSUBR
	db	2,0dch,0e3h,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FSUBR
	db	2,0dch,0e4h,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FSUBR
	db	2,0dch,0e5h,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FSUBR
	db	2,0dch,0e6h,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FSUBR
	db	2,0dch,0e7h,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FSUBR
	db	2,0deh,0e0h,O_FPUR,O_ST,O_NONE,OB_R0,P_0
	dw	M_FSUBRP
	db	2,0deh,0e1h,O_FPUR,O_ST,O_NONE,OB_R1,P_0
	dw	M_FSUBRP
	db	2,0deh,0e2h,O_FPUR,O_ST,O_NONE,OB_R2,P_0
	dw	M_FSUBRP
	db	2,0deh,0e3h,O_FPUR,O_ST,O_NONE,OB_R3,P_0
	dw	M_FSUBRP
	db	2,0deh,0e4h,O_FPUR,O_ST,O_NONE,OB_R4,P_0
	dw	M_FSUBRP
	db	2,0deh,0e5h,O_FPUR,O_ST,O_NONE,OB_R5,P_0
	dw	M_FSUBRP
	db	2,0deh,0e6h,O_FPUR,O_ST,O_NONE,OB_R6,P_0
	dw	M_FSUBRP
	db	2,0deh,0e7h,O_FPUR,O_ST,O_NONE,OB_R7,P_0
	dw	M_FSUBRP
	db	1,0dah,O_M32,O_NONE,O_NONE,OB_5,P_0
	dw	M_FISUBR
	db	1,0deh,O_M16,O_NONE,O_NONE,OB_5,P_0
	dw	M_FISUBR

	db	2,0ddh,0c0h,O_FPUR,O_NONE,O_NONE,OB_R0,P_0
	dw	M_FFREE
	db	2,0ddh,0c1h,O_FPUR,O_NONE,O_NONE,OB_R1,P_0
	dw	M_FFREE
	db	2,0ddh,0c2h,O_FPUR,O_NONE,O_NONE,OB_R2,P_0
	dw	M_FFREE
	db	2,0ddh,0c3h,O_FPUR,O_NONE,O_NONE,OB_R3,P_0
	dw	M_FFREE
	db	2,0ddh,0c4h,O_FPUR,O_NONE,O_NONE,OB_R4,P_0
	dw	M_FFREE
	db	2,0ddh,0c5h,O_FPUR,O_NONE,O_NONE,OB_R5,P_0
	dw	M_FFREE
	db	2,0ddh,0c6h,O_FPUR,O_NONE,O_NONE,OB_R6,P_0
	dw	M_FFREE
	db	2,0ddh,0c7h,O_FPUR,O_NONE,O_NONE,OB_R7,P_0
	dw	M_FFREE

	db	2,0d9h,0f2h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FPTAN

	db	2,0d9h,0fbh,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_FSINCOS

	db	2,0d9h,0feh,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_FSIN

	db	2,0d9h,0ffh,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_FCOS

	db	2,0d9h,0f3h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FPATAN

	db	2,0d9h,0f0h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_F2XM1

	db	2,0d9h,0f1h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FYL2X

	db	2,0d9h,0f9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FYL2XP1

	db	3,09bh,0dbh,0e3h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FINIT

	db	2,0dbh,0e3h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FNINIT

	db	2,09bh,0d9h,O_M16,O_NONE,O_NONE,OB_7,P_0
	dw	M_FSTCW

	db	1,0d9h,O_M16,O_NONE,O_NONE,OB_7,P_0
	dw	M_FNSTCW

	db	1,0d9h,O_M16,O_NONE,O_NONE,OB_5,P_0
	dw	M_FLDCW

	db	2,0d9h,0f7h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FINCSTP

	db	2,0d9h,0f6h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FDECSTP

	db	2,0d9h,0d0h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FNOP

	db	3,09bh,0dbh,0e2h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FCLEX

	db	2,0dbh,0e2h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FNCLEX

	db	2,09bh,0d9h,O_M,O_NONE,O_NONE,OB_6,P_0
	dw	M_FSTENV

	db	1,0d9h,O_M,O_NONE,O_NONE,OB_6,P_0
	dw	M_FNSTENV

	db	1,0d9h,O_M,O_NONE,O_NONE,OB_4,P_0
	dw	M_FLDENV

	db	2,09bh,0ddh,O_M,O_NONE,O_NONE,OB_6,P_0
	dw	M_FSAVE

	db	1,0ddh,O_M,O_NONE,O_NONE,OB_6,P_0
	dw	M_FNSAVE

	db	1,0ddh,O_M,O_NONE,O_NONE,OB_4,P_0
	dw	M_FRSTOR

	db	2,0d9h,0fah,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FSQRT

	db	2,0d9h,0fdh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FSCALE

	db	2,0d9h,0e1h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FABS

	db	2,0d9h,0e0h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FCHS

	db	2,0d9h,0f8h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FPREM

	db	2,0d9h,0f5h,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_FPREM1

	db	2,0d9h,0fch,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FRNDINT

	db	2,0d9h,0f4h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FXTRACT

	db	3,09bh,0dbh,0e0h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FENI

	db	2,0dbh,0e0h,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_FNENI

	db	2,0dah,0c0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVB
	db	2,0dah,0c1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVB
	db	2,0dah,0c2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVB
	db	2,0dah,0c3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVB
	db	2,0dah,0c4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVB
	db	2,0dah,0c5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVB
	db	2,0dah,0c6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVB
	db	2,0dah,0c7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVB

	db	2,0dah,0c8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVZ
	db	2,0dah,0c9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVZ
	db	2,0dah,0cah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVZ
	db	2,0dah,0cbh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVZ
	db	2,0dah,0cch,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVZ
	db	2,0dah,0cdh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVZ
	db	2,0dah,0ceh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVZ
	db	2,0dah,0cfh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVZ

	db	2,0dah,0d0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVBE
	db	2,0dah,0d7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVBE

	db	2,0dah,0d8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVU
	db	2,0dah,0d9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVU
	db	2,0dah,0dah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVU
	db	2,0dah,0dbh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVU
	db	2,0dah,0dch,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVU
	db	2,0dah,0ddh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVU
	db	2,0dah,0deh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVU
	db	2,0dah,0dfh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVU

	db	2,0dbh,0c0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVAE
	db	2,0dbh,0c7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVAE

	db	2,0dbh,0c8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0c9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0cah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0cbh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0cch,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0cdh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0ceh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVNZ
	db	2,0dbh,0cfh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVNZ

	db	2,0dbh,0d0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVA
	db	2,0dbh,0d7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVA

	db	2,0dbh,0d8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0d9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0dah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0dbh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0dch,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0ddh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0deh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVNU
	db	2,0dbh,0dfh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVNU

	db	2,0dbh,0f0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCOMI
	db	2,0dbh,0f1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCOMI
	db	2,0dbh,0f2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCOMI
	db	2,0dbh,0f3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCOMI
	db	2,0dbh,0f4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCOMI
	db	2,0dbh,0f5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCOMI
	db	2,0dbh,0f6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCOMI
	db	2,0dbh,0f7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCOMI

	db	2,0dfh,0f0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCOMIP
	db	2,0dfh,0f7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCOMIP

	db	2,0dbh,0e8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FUCOMI
	db	2,0dbh,0e9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FUCOMI
	db	2,0dbh,0eah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FUCOMI
	db	2,0dbh,0ebh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FUCOMI
	db	2,0dbh,0ech,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FUCOMI
	db	2,0dbh,0edh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FUCOMI
	db	2,0dbh,0eeh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FUCOMI
	db	2,0dbh,0efh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FUCOMI

	db	2,0dfh,0e8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0e9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0eah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0ebh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0ech,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0edh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0eeh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FUCOMIP
	db	2,0dfh,0efh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FUCOMIP



	db	1,0f1h,O_NONE,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_ICEBP

	db	2,00fh,00bh,O_NONE,O_NONE,O_NONE,OB_NONE,P_6
	dw	M_UD2

	db	2,00fh,0b9h,O_NONE,O_NONE,O_NONE,OB_NONE,P_6
	dw	M_UD2

;-------------------------- MMX --------------------------------------------

	db	2,00fh,06eh,O_MMX32,O_RM32,O_NONE,OB_SR,P_MMX
	dw	M_MOVD
	db	2,00fh,07eh,O_RM32,O_MMX32,O_NONE,OB_SR,P_MMX
	dw	M_MOVD

	db	2,00fh,06fh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_MOVQ
	db	2,00fh,07fh,O_MMXRM64,O_MMX64,O_NONE,OB_SR,P_MMX
	dw	M_MOVQ

	db	2,00fh,0fch,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDB
	db	2,00fh,0fdh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDW
	db	2,00fh,0feh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDD

	db	2,00fh,0ech,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDSB
	db	2,00fh,0edh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDSW

	db	2,00fh,0dch,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDUSB
	db	2,00fh,0ddh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PADDUSW

	db	2,00fh,0f8h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBB
	db	2,00fh,0f9h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBW
	db	2,00fh,0fah,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBD

	db	2,00fh,0e8h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBSB
	db	2,00fh,0e9h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBSW

	db	2,00fh,0d8h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBUSB
	db	2,00fh,0d9h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSUBUSW

	db	2,00fh,0e5h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PMULHW
	db	2,00fh,0d5h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PMULLW

	db	2,00fh,0f5h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PMADDWD

	db	2,00fh,074h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PCMPEQB
	db	2,00fh,075h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PCMPEQW
	db	2,00fh,076h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PCMPEQD

	db	2,00fh,064h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PCMPGTB
	db	2,00fh,065h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PCMPGTW
	db	2,00fh,066h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PCMPGTD

	db	2,00fh,067h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PACKUSWB
	db	2,00fh,063h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PACKSSWB
	db	2,00fh,06bh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PACKSSDW

	db	2,00fh,068h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PUNPCKHBW
	db	2,00fh,069h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PUNPCKHWD
	db	2,00fh,06ah,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PUNPCKHDQ

	db	2,00fh,060h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PUNPCKLBW
	db	2,00fh,061h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PUNPCKLWD
	db	2,00fh,062h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PUNPCKLDQ

	db	2,00fh,0dbh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PAND

	db	2,00fh,0dfh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PANDN

	db	2,00fh,0ebh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_POR

	db	2,00fh,0efh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PXOR

	db	2,00fh,0f1h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSLLW
	db	2,00fh,0f2h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSLLD
	db	2,00fh,0f3h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSLLQ

	db	2,00fh,0d1h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSRLW
	db	2,00fh,0d2h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSRLD
	db	2,00fh,0d3h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSRLQ

	db	2,00fh,0e1h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSRAW
	db	2,00fh,0e2h,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_MMX
	dw	M_PSRAD

	db	2,00fh,077h,O_NONE,O_NONE,O_NONE,OB_NONE,P_MMX
	dw	M_EMMS

	db	3,00fh,071h,0f0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSLLW
	db	3,00fh,071h,0f7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSLLW

	db	3,00fh,071h,0e0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSRAW
	db	3,00fh,071h,0e7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSRAW

	db	3,00fh,071h,0d0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSRLW
	db	3,00fh,071h,0d7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSRLW

	db	3,00fh,072h,0f0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSLLD
	db	3,00fh,072h,0f7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSLLD

	db	3,00fh,072h,0e0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSRAD
	db	3,00fh,072h,0e7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSRAD

	db	3,00fh,072h,0d0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSRLD
	db	3,00fh,072h,0d7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSRLD

	db	3,00fh,073h,0f0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSLLQ
	db	3,00fh,073h,0f7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSLLQ

	db	3,00fh,073h,0d0h,O_MMX64,O_OM8,O_NONE,OB_R0,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d1h,O_MMX64,O_OM8,O_NONE,OB_R1,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d2h,O_MMX64,O_OM8,O_NONE,OB_R2,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d3h,O_MMX64,O_OM8,O_NONE,OB_R3,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d4h,O_MMX64,O_OM8,O_NONE,OB_R4,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d5h,O_MMX64,O_OM8,O_NONE,OB_R5,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d6h,O_MMX64,O_OM8,O_NONE,OB_R6,P_MMX
	dw	M_PSRLQ
	db	3,00fh,073h,0d7h,O_MMX64,O_OM8,O_NONE,OB_R7,P_MMX
	dw	M_PSRLQ

;-------------------------- 3DNow! -----------------------------------------

	db	2,00fh,00fh,O_MMX64,O_MMXRM64,O_NONE,OB_SR,P_3DNOW
	dw	M_3DNOW

	db	2,00fh,00eh,O_NONE,O_NONE,O_NONE,OB_NONE,P_3DNOW
	dw	M_FEMMS

	db	2,00fh,00dh,O_M,O_NONE,O_NONE,OB_SR,P_3DNOW
	dw	M_PREFETCH

;---------------------------------------------------------------------------

	db	2,00fh,034h,O_NONE,O_NONE,O_NONE,OB_NONE,P_7
	dw	M_SYSENTER

	db	2,00fh,035h,O_NONE,O_NONE,O_NONE,OB_NONE,P_7
	dw	M_SYSEXIT

	db	2,00fh,010h,O_RM8,O_R8,0,OB_SR,P_0	     ; what processor?
	dw	M_UMOV
	db	2,00fh,011h,O_RM1632,O_R1632,0,OB_SR,P_0
	dw	M_UMOV
	db	2,00fh,012h,O_R8,O_RM8,0,OB_SR,P_0
	dw	M_UMOV
	db	2,00fh,013h,O_R1632,O_RM1632,0,OB_SR,P_0
	dw	M_UMOV

;---------- AzmIt ----------------------------------------------------------

	db	1,073h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNB
	db	2,00fh,083h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNB
	db	1,073h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNC
	db	2,00fh,083h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNC
	db	1,072h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JC
	db	2,00fh,082h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JC
	db	1,076h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNA
	db	2,00fh,086h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNA
	db	1,074h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JE
	db	2,00fh,084h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JE
	db	1,07dh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNL
	db	2,00fh,08dh,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNL
	db	1,07eh,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNG
	db	2,00fh,08eh,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNG
	db	1,075h,O_REL8,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_JNE
	db	2,00fh,085h,O_REL1632,O_NONE,O_NONE,OB_NONE,P_3
	dw	M_JNE

	db	2,00fh,092h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETC
	db	2,00fh,093h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNC
	db	2,00fh,093h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNB
	db	2,00fh,096h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNA
	db	2,00fh,094h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETE
	db	2,00fh,09dh,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNL
	db	2,00fh,09eh,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNG
	db	2,00fh,095h,O_RM8,O_NONE,O_NONE,OB_0,P_3
	dw	M_SETNE

	db	2,00fh,042h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVC
	db	2,00fh,043h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNC
	db	2,00fh,043h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNB
	db	2,00fh,044h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVE
	db	2,00fh,045h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNE
	db	2,00fh,046h,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNA
	db	2,00fh,04dh,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNL
	db	2,00fh,04eh,O_R1632,O_RM1632,O_NONE,OB_SR,P_6
	dw	M_CMOVNG

	db	2,0dah,0c0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVC
	db	2,0dah,0c1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVC
	db	2,0dah,0c2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVC
	db	2,0dah,0c3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVC
	db	2,0dah,0c4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVC
	db	2,0dah,0c5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVC
	db	2,0dah,0c6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVC
	db	2,0dah,0c7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVC

	db	2,0dah,0c8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVE
	db	2,0dah,0c9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVE
	db	2,0dah,0cah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVE
	db	2,0dah,0cbh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVE
	db	2,0dah,0cch,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVE
	db	2,0dah,0cdh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVE
	db	2,0dah,0ceh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVE
	db	2,0dah,0cfh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVE

	db	2,0dah,0d0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVNA
	db	2,0dah,0d7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVNA

	db	2,0dbh,0c0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVNC
	db	2,0dbh,0c7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVNC

	db	2,0dbh,0c0h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c1h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c2h,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c3h,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c4h,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c5h,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c6h,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVNB
	db	2,0dbh,0c7h,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVNB

	db	2,0dbh,0c8h,O_ST,O_FPUR,O_NONE,OB_R0,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0c9h,O_ST,O_FPUR,O_NONE,OB_R1,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0cah,O_ST,O_FPUR,O_NONE,OB_R2,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0cbh,O_ST,O_FPUR,O_NONE,OB_R3,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0cch,O_ST,O_FPUR,O_NONE,OB_R4,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0cdh,O_ST,O_FPUR,O_NONE,OB_R5,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0ceh,O_ST,O_FPUR,O_NONE,OB_R6,P_6
	dw	M_FCMOVNE
	db	2,0dbh,0cfh,O_ST,O_FPUR,O_NONE,OB_R7,P_6
	dw	M_FCMOVNE

;---------- these must be at the end (other insts use part of their opcodes)

	db	1,0d8h,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0d9h,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0dah,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0dbh,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0dch,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0ddh,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0deh,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC
	db	1,0dfh,O_NONE,O_NONE,O_NONE,OB_ESC,P_0
	dw	M_ESC

	db	1,09bh,O_NONE,O_NONE,O_NONE,OB_NONE,P_0
	dw	M_WAIT

	db	0	; end of list

;--------------- 3DNow! instruction suffixes -------------------------------
; format
;	db	opcode byte
;	dw	mnemonic index
;
suffixes3dnow	label	byte
	db	0bfh
	dw	M_PAVGUSB
	db	09eh
	dw	M_PFADD
	db	09ah
	dw	M_PFSUB
	db	0aah
	dw	M_PFSUBR
	db	0aeh
	dw	M_PFACC
	db	090h
	dw	M_PFCMPGE
	db	0a0h
	dw	M_PFCMPGT
	db	0b0h
	dw	M_PFCMPEQ
	db	094h
	dw	M_PFMIN
	db	0a4h
	dw	M_PFMAX
	db	00dh
	dw	M_PI2FD
	db	01dh
	dw	M_PF2ID
	db	096h
	dw	M_PFRCP
	db	097h
	dw	M_PFRSQRT
	db	0b4h
	dw	M_PFMUL
	db	0a6h
	dw	M_PFRCPIT1
	db	0a7h
	dw	M_PFRSQIT1
	db	0b6h
	dw	M_PFRCPIT2
	db	0b7h
	dw	M_PMULHRW

	db	0	; end of list

;--------------- opcodes end ----------------------------

;--------------- compatible arguments start -------------

compatibleargs	label	byte
	db	O_DX
	db	O_R16
	db	O_R1632
	db	O_RM16
	db	O_RM1632
	db	0

	db	O_R32
	db	O_R1632
	db	0

	db	O_MMX32
	db	O_MMX64
	db	O_MMXRM64
	db	O_MMX32
	db	0

	db	O_1
	db	O_OM8
	db	O_OM8EXP
	db	O_OM16
	db	O_OM32
	db	O_OM1632
	db	O_REL8
	db	O_REL1632
	db	0

	db	O_3
	db	O_OM8
	db	O_OM8EXP
	db	O_OM16
	db	O_OM32
	db	O_OM1632
	db	O_REL8
	db	O_REL1632
	db	0

	db	O_M16
	db	O_M1632
	db	O_RM16
	db	O_RM1632
	db	0

	db	O_M32
	db	O_M1632
	db	O_RM32
	db	O_RM1632
	db	0

	db	O_OFFS
	db	O_OFFS1632
	db	O_M
	db	O_M8
	db	O_RM8
	db	0

	db	O_OFFS
	db	O_OFFS1632
	db	O_M
	db	O_M16
	db	O_RM16
	db	O_M1632
	db	O_RM1632
	db	0

	db	O_OFFS
	db	O_OFFS1632
	db	O_M
	db	O_M32
	db	O_RM32
	db	O_M1632
	db	O_RM1632
	db	0

	db	O_OFFS
	db	O_OFFS1632
	db	O_M
	db	O_M64
	db	O_MMXRM64
	db	0

	db	O_OFFS
	db	O_OFFS1632
	db	O_M
	db	O_M80
	db	0

	db	O_ACC8
	db	O_R8
	db	O_RM8
	db	0

	db	O_CL
	db	O_R8
	db	O_RM8
	db	0

	db	O_ACC16
	db	O_ACC1632
	db	O_R16
	db	O_R1632
	db	O_RM16
	db	O_RM1632
	db	0

	db	O_ACC32
	db	O_ACC1632
	db	O_R32
	db	O_R1632
	db	O_RM32
	db	O_RM1632
	db	0

	db	O_ST
	db	O_FPUR
	db	0

	db	O_FAR16
	db	O_FAR1632
	db	0

	db	O_FAR32
	db	O_FAR1632
	db	0

	db	O_DFAR16
	db	O_DFAR1632
	db	0

	db	O_DFAR32
	db	O_DFAR1632
	db	0

	db	0	; end of list

;--------------- compatible arguments end ---------------

; Thanks for leaving this string untouched in here...
dazmitstr db	'DazmIt ',VERSIONSTRING,' (C) 1997-1998 Mikael Klasson aka '
		db	'Fluff (fluff@geocities.com)$'

dazmitcomments	db	2	; 0 == none, 1 == some, 2 = all
dazmitsegsize	db	SEGSIZE ; 0 == 16, 1 == 32
databits	db	?	; 0 == 16, 1 == 32
addressbits	db	?	; 0 == 16, 1 == 32
opcodetable_x	db	?
opcodetable_y	db	?
addressingbyte	db	?
offsetsize	db	?

operandtypes	label	byte
opr1type	db	?
opr2type	db	?
opr3type	db	?

opcbyte 	db	?
mneword 	dw	?

lastopcodebyte	db	?

mnemoniclength	db	?
dazmitputzeros	db	?

dazmitcpu	db	?	; minimum cpu required for current instruction

startoffset	dd	?	; offset to where this instructions starts
startofinput	dd	?	; ptr to start of instruction
endofinput	dd	?	; ptr to end of inputstream

;----- assembling -----
mneword3dnow	dw	?	; a 3DNow! instruction? 0 == no, mneword == yes
;----------------------

oldedi		dd	?
oldesi		dd	?
longestmatch	dd	?

commentfunc	dd	?	; ptr to comment function
commentdata	dd	?

getxprerr	dd	?
dazmitbuf	db	128+4 dup(?)	; outputbuffer (e.g "mov ax,cx")

;
code32 ends
end

