
.386p
code32 segment para public use32
	assume cs:code32, ds:code32

include pmode.inc
include argc.inc

;
; Gets argument #AL
; _getarg( void );
; In:
;	AL  == argument #
;	EDX -> buffer
; Out:
;	CF = 1 -> error, argument not found
;	CF = 0 -> no error, argument found
;	BL = argument type ( 0 == String )
;			   ( 1 == Switch )
;			   ( 2 == Switch w/ value )
;			   ( 3 == Switch w/ string )
;	BH = switch # if argument is a switch ( 0 == first )
;	Buffer = ASCIZ string or dword value
_getarg:
	pushad
	mov	edi,edx
	mov	esi,_pspa
	add	esi,81h
	movzx	ecx,byte ptr gs:[esi-1]
	cmp	cl,1
	jb	popad&stc&ret
	mov	dl,al
	mov	dashdashfound,0
__getargstr_findlop:
	or	ecx,ecx
	jbe	popad&stc&ret
	push	edx
	call	_parsearg
	pop	edx
	jc	popad&stc&ret
	sub	dl,1
	jnc	__getargstr_findlop
	mov	[esp+4*4],ebx
popad&clc&ret:
	popad
clc&ret:
	clc
	ret

;
; In:
;	DL  != 0 -> don't write argument to [EDI]
;	DL  == 0 -> write argument to [EDI] as ASCIZ string or dword value
;	ECX -> bytes left till the end of cmdline
;	ESI -> argument
;	EDI -> buffer for string / dword value
; Out:
;	CF  == 1 -> error, end of cmdline
;	CF  == 0 -> no error
;	BL  == argument type
;	BH  == switch # if argument is a switch ( 0 == first )
;	ECX -> bytes left till the end of cmdline
;	ESI -> next argument
_parsearg:
	cmp	byte ptr gs:[esi],' '
	jne	__parsearg_initialspacesdone
	inc	esi
	dec	ecx
	jz	stc&ret
	jmp	_parsearg
__parsearg_initialspacesdone:
	cmp	dashdashfound,0
	jne	__parsearg_str
	cmp	word ptr gs:[esi],'--'
	je	__parsearg_dashdash
	cmp	byte ptr gs:[esi],'/'
	je	__parsearg_switch
	cmp	byte ptr gs:[esi],'-'
	je	__parsearg_switch
__parsearg_str:
	mov	bl,ARG_STR
__parsearg_str_lop:
	mov	al,gs:[esi]
	inc	esi
	or	dl,dl
	jnz	__parsearg_str_nowrite
	stosb
__parsearg_str_nowrite:
	dec	ecx
	jz	__parsearg_str_end
	cmp	al,' '
	jne	__parsearg_str_lop
	or	dl,dl
	jnz	__parsearg_str_end
	dec	edi

__parsearg_str_end:
	or	dl,dl
	jnz	clc&ret
	mov	byte ptr [edi],0
	clc
	ret

__parsearg_dashdash:
	mov	dashdashfound,-1
	cmp	ecx,2
	jbe	stc&ret
	cmp	byte ptr gs:[esi+2],' '
	jne	__parsearg_str
	sub	ecx,2
	add	esi,2
	mov	bx,( SWI_DASHDASH shl 8 ) + ARG_SWI
	clc
	ret

__parsearg_switch:
	inc	esi
	dec	ecx
	jz	stc&ret
	push	ecx edi
	lea	edi,switches
	mov	bh,-1
__parsearg_switch_findlop:
	movzx	ecx,byte ptr [edi]
	jecxz	__parsearg_switch_nonefound
	mov	eax,ecx
	mov	bl,[edi+1]
	add	edi,2
	push	eax esi edi
__parsearg_switch_findlop_cmpsb_lop:
	inc	esi
	inc	edi
	mov	al,gs:[esi-1]
	sub	al,[edi-1]
	jne	__parsearg_switch_findlop_cmpsb_ne
	loop	__parsearg_switch_findlop_cmpsb_lop
	jmp	__parsearg_switch_findlop_found
__parsearg_switch_findlop_cmpsb_ne:
	inc	ecx
__parsearg_switch_findlop_found:
	pop	edi esi eax
	add	edi,eax
	inc	bh
	or	ecx,ecx
	jnz	__parsearg_switch_findlop
	pop	edi ecx
	add	esi,eax
	sub	ecx,eax
	ja	__parsearg_switch_skipspaces
	xor	ecx,ecx
	cmp	bl,ARG_SWI
	je	clc&ret
stc&ret:
	stc
	ret

__parsearg_switch_nonefound:
	pop	edi ecx
__parsearg_switch_nonefound_lop:
	cmp	byte ptr gs:[esi],' '
	je	clc&ret
	inc	esi
	dec	ecx
	jnz	__parsearg_switch_nonefound_lop
	stc
	ret

__parsearg_switch_skipspaces:
	cmp	bl,ARG_SWI
	je	clc&ret
__parsearg_switch_skipspaces_lop:
	cmp	byte ptr gs:[esi],' '
	jne	__parsearg_switch_skipspaces_end
	inc	esi
	dec	ecx
	jnz	__parsearg_switch_skipspaces_lop
	stc
	ret
__parsearg_switch_skipspaces_end:
	cmp	bl,ARG_SSTR
	je	__parsearg_str_lop
	or	dl,dl
	jnz	__parsearg_switch_nonefound_lop
	mov	dword ptr [edi],0
	mov	svalbase,10
__parsearg_sval:
	mov	al,gs:[esi]
	cmp	al,'$'
	jne	__parsearg_sval_nothex1
	mov	svalbase,16
	inc	esi
	dec	ecx
	jz	__parsearg_sval_end
__parsearg_sval_nothex1:
	cmp	al,'0'
	jne	__parsearg_sval_nothex2
	cmp	byte ptr gs:[esi+1],'x'
	jne	__parsearg_sval_nothex2
	mov	svalbase,16
	inc	esi
	dec	ecx
	jz	__parsearg_sval_end
	inc	esi
	dec	ecx
	jz	__parsearg_sval_end
__parsearg_sval_nothex2:
	mov	edx,esi
__parsearg_sval_findsuffixlop:
	cmp	byte ptr gs:[edx],' '
	je	__parsearg_sval_suffixfound
	inc	edx
	dec	ecx
	jnz	__parsearg_sval_findsuffixlop
__parsearg_sval_suffixfound:
	cmp	byte ptr gs:[edx-1],'h'
	jne	__parsearg_sval_suffix_noth
	mov	svalbase,16
__parsearg_sval_suffix_noth:
	cmp	esi,edx
	jae	__parsearg_sval_end
	push	edx
	mov	eax,svalbase
	imul	dword ptr [edi]
	mov	[edi],eax
	movzx	eax,byte ptr gs:[esi]
	call	_hex2bin
	add	[edi],eax
	inc	esi
	pop	edx
	jmp	__parsearg_sval_suffix_noth

__parsearg_sval_end:
	movzx	eax,bh
	mov	edx,[edi]
	mov	switchvalues[eax*4],edx
	clc
	ret

popad&stc&ret:
	popad
	stc
	ret

_hex2bin:
	sub	al,41h
	jnc	$+4
	add	al,7
	add	al,10
	ret

;
switches	label	byte
        db      1, ARG_SVAL, 's'        ; segment size ('16' or '32')

        db      1, ARG_SWI, 'a'         ; decode all instructions

	db	1, ARG_SWI, 'm'         ; decode MMX instructions as well

	db	0	; end of list

dashdashfound	db	0

switchvalues	label	dword
switch_s        dd      0
switch_a        dd      0
switch_m	dd	0

svalbase	dd	?	; 10 == dec, 16 == hex

;
code32	ends
end

