(*  Copyright (C) 1998 Dmitry "Silent" Vasiliev  *)
(*      e-mail: silent@paracels.yrh.yar.ru       *)

unit Control;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Grids, StdCtrls, Buttons, Menus, ShellAPI,
  Win95, ComCtrls, Registry, RXShell;

type
  TfrmControl = class(TForm)
    trbHeight: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    trbWidth: TTrackBar;
    lblHeight: TLabel;
    lblWidth: TLabel;
    chbReserve: TCheckBox;
    btnOptimize: TButton;
    btnClose: TButton;
    pmnTrayIcon: TPopupMenu;
    mniOptimize: TMenuItem;
    mniClose: TMenuItem;
    N1: TMenuItem;
    mniProperties: TMenuItem;
    cmpTrayIcon: TRxTrayIcon;
    chbOIRight: TCheckBox;
    chbAuto: TCheckBox;
    timAuto: TTimer;
    Label3: TLabel;
    lblHelp: TLabel;
    trbHelp: TTrackBar;
    chbHelp: TCheckBox;
    mniAbout: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cmeOptimizeClick(Sender: TObject);
    procedure trbHeightChange(Sender: TObject);
    procedure trbWidthChange(Sender: TObject);
    procedure trbHelpChange(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure cmpTrayIconClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mniPropertiesClick(Sender: TObject);
    procedure mniCloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure chbAutoClick(Sender: TObject);
    procedure mniAboutClick(Sender: TObject);
	private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	frmControl: TfrmControl;

implementation

{$R *.DFM}

uses About;

const
  RegName = 'Silent';
  SecName = 'Delphi Desktop Optimizer';

procedure TfrmControl.FormCreate(Sender: TObject);
begin
  with TRegIniFile.Create(RegName) do
  try
    trbWidth.Position:=ReadInteger(SecName,'OIWidth',250);
    trbHeight.Position:=ReadInteger(SecName,'DWHeight',150);
    chbReserve.Checked:=ReadBool(SecName,'ISpace',True);
    chbOIRight.Checked:=ReadBool(SecName,'Mirror',False);
    chbHelp.Checked:=ReadBool(SecName,'Help',False);
    chbAuto.Checked:=ReadBool(SecName,'Auto',False);
  finally
    Free;
  end;
  trbHeightChange(nil);
  trbWidthChange(nil);
end;

procedure TfrmControl.FormDestroy(Sender: TObject);
begin
  with TRegIniFile.Create(RegName) do
  try
    WriteInteger(SecName,'OIWidth',trbWidth.Position);
    WriteInteger(SecName,'DWHeight',trbHeight.Position);
    WriteBool(SecName,'ISpace',chbReserve.Checked);
    WriteBool(SecName,'Mirror',chbOIRight.Checked);
    WriteBool(SecName,'Help',chbHelp.Checked);
    WriteBool(SecName,'Auto',chbAuto.Checked);
  finally
    Free;
  end;
end;

procedure TfrmControl.cmeOptimizeClick(Sender: TObject);
var
  Scr,R: TRect;
  Delphi,ObjInsp,EditWin,Watches,CallSt,BrPoints,Threads,Help,HelpSec: HWnd;
  Special,i,OIH,OIW,OIBottom: Integer;

  function ValidHandle(Wnd: HWnd): Boolean;
  begin
    Result:=(Wnd<>0) and IsWindowVisible(Wnd) and not IsIconic(Wnd);
  end;

  function ResizeWindow(Wnd: HWnd; Rect: TRect): Boolean;
  var
    WndRect: TRect;
  begin
    Result:=ValidHandle(Wnd);
    if Result then
    begin
      if IsZoomed(Wnd) then ShowWindow(Wnd,SW_RESTORE);
      GetWindowRect(Wnd,WndRect);
      if not EqualRect(WndRect,Rect) then
        with Rect do
          SetWindowPos(Wnd,0,Left,Top,Right-Left,Bottom-Top,
            swp_NoZOrder or swp_NoActivate);
    end;
  end;

begin
  Delphi:=FindWindow('TAppBuilder',nil);
  if ValidHandle(Delphi) then
  begin
    ScreenRect(Scr);
    if chbReserve.Checked then Dec(Scr.Bottom,
      GetSystemMetrics(sm_CYMinimized)+1);

    ShowWindow(Delphi,sw_ShowNoActivate);
    with Scr do
    begin
      SetWindowPos(Delphi,0,Left,Top,Right-Left,Top,
        swp_NoZOrder or swp_NoActivate);
      GetWindowRect(Delphi,R);
      Inc(Top,R.Bottom-R.Top);
    end;


    Special:=0;

    Watches:=FindWindow('TWatchWindow',nil);
    if ValidHandle(Watches) then Inc(Special);

    CallSt:=FindWindow('TCallStackWindow',nil);
    if ValidHandle(CallSt) then Inc(Special);

    BrPoints:=FindWindow('TBPWindow',nil);
    if ValidHandle(BrPoints) then Inc(Special);

    Threads:=FindWindow('TThreadStatus',nil);
    if ValidHandle(Threads) then Inc(Special);

    ObjInsp:=FindWindow('TPropertyInspector',nil);
    if ValidHandle(ObjInsp) then
    begin
      R:=Scr;
      case Special of
        2,3: Dec(R.Bottom,trbHeight.Position);
        4: Dec(R.Bottom,2*trbHeight.Position);
      end;
      repeat
        with R do
          if chbOIRight.Checked then
            SetWindowPos(ObjInsp,0,Right-trbWidth.Position,Top,
              trbWidth.Position,Bottom-Top,swp_NoZOrder or swp_NoActivate)
          else
            SetWindowPos(ObjInsp,0,Left,Top,trbWidth.Position,Bottom-Top,
              swp_NoZOrder or swp_NoActivate);
        GetWindowRect(ObjInsp,R);
        if R.Bottom>Scr.Bottom then Dec(R.Bottom,16)
        else Break;
      until False;
      if Special<>1 then OIH:=(Scr.Bottom-Scr.Top)-(R.Bottom-R.Top)
      else OIH:=trbHeight.Position;
      OIW:=trbWidth.Position;
      OIBottom:=R.Bottom;
    end
    else
    begin
      OIBottom:=Scr.Bottom;
      OIH:=trbHeight.Position;
      OIW:=0;
    end;

    EditWin:=FindWindow('TEditWindow',nil);
    if EditWin<>0 then
    begin
      R:=Scr;
      R.Bottom:=OIBottom;
      if OIW=0 then
        case Special of
          1,2: Dec(R.Bottom,OIH);
          3,4: Dec(R.Bottom,2*OIH);
        end
      else
        case Special of
          1,3: Dec(R.Bottom,OIH);
        end;
      with R do
      begin
        ShowWindow(EditWin,sw_ShowNoActivate);
        if chbOIRight.Checked then
          SetWindowPos(EditWin,0,Left,Top,Right-Left-OIW,Bottom-Top,
            swp_NoZOrder or swp_NoActivate)
        else
          SetWindowPos(EditWin,0,Left+OIW,Top,Right-Left-OIW,Bottom-Top,
            swp_NoZOrder or swp_NoActivate);
      end;
    end;

    if Special<>0 then
      if Special=1 then
      begin
        R:=Scr;
        R.Bottom:=OIBottom;
        R.Top:=R.Bottom-OIH;
        if chbOIRight.Checked then Dec(R.Right,OIW)
        else Inc(R.Left,OIW);
        if not ResizeWindow(CallSt,R) then
          if not ResizeWindow(Watches,R) then
            if not ResizeWindow(Threads,R) then
              ResizeWindow(BrPoints,R);
      end
      else
      begin
        R:=Scr;
        if OIW<>0 then R.Top:=R.Bottom-OIH div (Special div 2)
        else R.Top:=R.Bottom-OIH;
        R.Right:=(R.Right-R.Left) div 2;
        for i:=1 to 2 do
        begin
          if ResizeWindow(CallSt,R) then
          begin
            CallSt:=0;
            R.Left:=R.Right;
            R.Right:=Scr.Right;
          end
          else
            if ResizeWindow(Watches,R) then
            begin
              Watches:=0;
              R.Left:=R.Right;
              R.Right:=Scr.Right;
            end
            else
              if ResizeWindow(Threads,R) then
              begin
                Threads:=0;
                R.Left:=R.Right;
                R.Right:=Scr.Right;
              end
              else
                if ResizeWindow(BrPoints,R) then
                begin
                  BrPoints:=0;
                  R.Left:=R.Right;
                  R.Right:=Scr.Right;
                end;
        end;
        if Special=3 then
        begin
          R:=Scr;
          if chbOIRight.Checked then Dec(R.Right,OIW)
          else Inc(R.Left,OIW);
          Dec(R.Bottom,OIH);
          R.Top:=R.Bottom-OIH;
          if not ResizeWindow(CallSt,R) then
            if not ResizeWindow(Watches,R) then
              if not ResizeWindow(Threads,R) then ResizeWindow(BrPoints,R);
        end
        else
        begin
          R:=Scr;
          if OIW=0 then
          begin
            Dec(R.Bottom,OIH);
            R.Top:=R.Bottom-OIH;
          end
          else
          begin
            R.Top:=R.Bottom-OIH;
            Dec(R.Bottom,OIH div 2);
          end;
          R.Right:=(R.Right-R.Left) div 2;
          for i:=1 to 2 do
          begin
            if ResizeWindow(CallSt,R) then
            begin
              CallSt:=0;
              R.Left:=R.Right;
              R.Right:=Scr.Right;
            end
            else
              if ResizeWindow(Watches,R) then
              begin
                Watches:=0;
                R.Left:=R.Right;
                R.Right:=Scr.Right;
              end
              else
                if ResizeWindow(Threads,R) then
                begin
                  Threads:=0;
                  R.Left:=R.Right;
                  R.Right:=Scr.Right;
                end
                else
                  if ResizeWindow(BrPoints,R) then
                  begin
                    BrPoints:=0;
                    R.Left:=R.Right;
                    R.Right:=Scr.Right;
                  end;
          end;
        end;
      end;
  end;
  if chbHelp.Checked then
  begin
    Help:=FindWindow('MS_WINHELP','Delphi Help');
    if not ValidHandle(Help) then
      Help:=FindWindow('MS_WINHELP','Win32 Programmer''s Reference');
    HelpSec:=FindWindow('MS_WINTOPIC_SECONDARY','Properties, Methods, and Events');
    ScreenRect(Scr);
    if chbReserve.Checked then Dec(Scr.Bottom,
      GetSystemMetrics(sm_CYMinimized)+1);
    if ValidHandle(HelpSec) then
    begin
      R:=Scr;
      R.Right:=trbHelp.Position;
      ResizeWindow(HelpSec,R);
      Scr.Left:=R.Right;
    end;
    if ValidHandle(Help) then ResizeWindow(Help,Scr);
  end;
end;

procedure TfrmControl.trbHeightChange(Sender: TObject);
begin
  lblHeight.Caption:=IntToStr(trbHeight.Position);
end;

procedure TfrmControl.trbWidthChange(Sender: TObject);
begin
  lblWidth.Caption:=IntToStr(trbWidth.Position);
end;

procedure TfrmControl.trbHelpChange(Sender: TObject);
begin
  lblHelp.Caption:=IntToStr(trbHelp.Position);
end;

procedure TfrmControl.btnCloseClick(Sender: TObject);
begin
  Hide;
end;

procedure TfrmControl.cmpTrayIconClick(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  btnOptimize.Click;
end;

procedure TfrmControl.mniPropertiesClick(Sender: TObject);
begin
  Show;
end;

procedure TfrmControl.mniCloseClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmControl.FormShow(Sender: TObject);
begin
  trbWidth.SetFocus;
end;

procedure TfrmControl.chbAutoClick(Sender: TObject);
begin
  timAuto.Enabled:=chbAuto.Checked;
  btnOptimize.Enabled:=not chbAuto.Checked;
  mniOptimize.Enabled:=not chbAuto.Checked;
end;

procedure TfrmControl.mniAboutClick(Sender: TObject);
begin
  frmAbout.ShowModal;
end;

end.
