;
; This is just a lame little example that uses DazmIt to decode a
; .com-file and output the disassembled instructions to stdout.
;
; Mikael Klasson
; fluff@geocities.com
; http://mklasson.cjb.net
;

.386p
code32 segment para public use32
	assume cs:code32, ds:code32

include pmode.inc
include dazmit.inc

public	_main

BUFFERSIZE	EQU	65535

TIMEIT		EQU	0


;
; C O D E 
;
_main:
	mov	edi,_pspa
	add	edi,81h
	cmp	byte ptr gs:[edi-1],2
	jb	showhelpmsg
	mov	edx,edi
	mov	al,0dh
_scasblop:
	inc	edi
	cmp	al,gs:[edi-1]
	jne	_scasblop

	mov	byte ptr gs:[edi-1],0
	call	_openfilero
	jc	_end
	lea	edx,buffer
	mov	ecx,BUFFERSIZE
	call	_readfile
	mov	infilesize,eax
	jc	_end
	cmp	infilesize,BUFFERSIZE
	jbe	__filefits
	mov	infilesize,BUFFERSIZE
__filefits:
	call	_closefile

IF	TIMEIT
	db	0fh,31h ;rdtsc
	mov	time1l,eax
	mov	time1h,edx
ENDIF

	lea	esi,buffer
mainlop:
	mov	v86r_ah,1
	mov	al,16h
	int	33h
	jnz	_end
	lea	ecx,buffer
	add	ecx,infilesize
	cmp	ecx,esi
	jbe	_end
	sub	ecx,esi
	mov	ebx,esi
	sub	ebx,offset buffer-100h
	call	_parseinstruction
	jc	_end
	add	esi,ecx

	lea	edi,dazmitbuf
	xor	al,al
	mov	ecx,-1
	repne	scasb
	mov	dword ptr [edi-1],00240a0dh	; 0dh,0ah,'$'
	lea	edx,dazmitbuf
	call	_puts
	jmp	mainlop

showhelpmsg:
	lea	edx,dazmitstr
	call	_puts
	lea	edx,helpstr
	call	_puts

_end:

IF	TIMEIT
	db	0fh,31h ;rdtsc
	mov	time2l,eax
	mov	time2h,edx
	sub	eax,time1l
	jnc	_nc
	dec	time2h
_nc:
	mov	diffl,eax
	mov	edx,time2h
	sub	edx,time1h
	mov	diffh,edx

	mov	eax,diffh
	call	_phd
	mov	eax,diffl
	call	_phd
ENDIF

	jmp	_exit

IF	TIMEIT
time1l	dd	?
time1h	dd	?
time2l	dd	?
time2h	dd	?
diffl	dd	?
diffh	dd	?
ENDIF


;
_phd:
	push	eax
	shr	eax,16
	call	_phw
	pop	eax
_phw:
	push	eax
	shr	eax,8
	call	_phb
	pop	eax
_phb:
	push	eax
	shr	eax,4
	call	_phn
	pop	eax
_phn:
	push	eax
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	mov	v86r_al,al
	mov	al,29h
	int	33h
	pop	eax
	ret

;
_puts:
	pushad
	add	edx,_code32a
	mov	eax,edx
	and	eax,0fh
	shr	edx,4
	mov	v86r_ds,dx
	mov	v86r_dx,ax
	mov	v86r_ah,9
	mov	al,21h
	int	33h
	popad
	ret


;
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error opening file
;   CF=0 - File opened succesfully
;     V86R_BX - file handle
_openfilero:
	pushad
	mov	ax,dx
	shr	edx,4
	and	ax,0fh
	mov	v86r_dx,ax
	mov	v86r_ds,dx
	mov	v86r_ax,3d00h
	mov	al,21h
	int	33h
	mov	ax,v86r_ax
	mov	v86r_bx,ax
	popad
	ret


;
; In:
;   V86R_BX - file handle
;   CF=1 - Error closing file
;   CF=0 - File closed succesfully
_closefile:
	push	ax
	mov	v86r_ax,3e00h
	mov	al,21h
	int	33h
	pop	ax
	ret


;
; In:
;   V86R_BX - file handle
;   EDX -> buffer to read to
;   CX - number of bytes to read
; Out:
;   CF=1 - Error reading file
;     EAX - ?
;   CF=0 - Read went fine
;     EAX - number of bytes read
_readfile:
	pushad
	add	edx,_code32a
	mov	eax,edx
	shr	eax,4
	and	dx,0fh
	mov	v86r_ds,ax
	mov	v86r_dx,dx
	mov	v86r_cx,cx
	mov	v86r_ax,3f00h
	mov	al,21h
	int	33h
	movzx	eax,v86r_ax
	mov	[esp+28],eax
	xor	ebp,ebp
	popad
	ret


;
helpstr 	db	13,10,'Usage: DazmIt FILE.COM [>FILE.ASM]',13,10,10,36

infilesize	dd	?

buffer		db	BUFFERSIZE dup(?)	; filebuffer


;
code32 ends
end

