title DASM
page 72,132

;Program		: DASM
;Version		: 1.53M
;Host processor		: Intel 8086/8088
;Operating system	: MS-DOS rel 2.0
;Authors		: Richard Conn/Bob Ferguson
;Date			: 16 Feb 2000
;Releases	   CP/M	: 1.0 (1 May 82), 1.1 (8 May 82), 1.2 (15 May 82)
;			  1.3 (23 May 82), 1.4 (12 June 82), 1.5 (16 Aug 82)
;			  XDASM86 (1 Jun 84)
;		 MS-DOS : 1.5M (16 Aug 92), 1.51M (10 Oct 93), 
;			: 1.52M (04 Dec 96) 1.53M (16 Feb 00)
;Derived from		: DASM, ZZSOURCE and RESOURCE (CP/M)
;Download		: http://hello.to/ferguson
;E-mail			: j.r.ferguson@iname.com
;
;History:
;DASM version 1.5 (by Richard Conn) was a TDL/ZILOG Disassembler derived from
;Dave Barker's ZZSOURCE and Ward Christensen's RESOURCE.
;A.L.J. Werkers derived an Intel 8086 cross-disassembler from it by adding
;the include file XDASM86.MAC. All these versions ran under CP/M.
;
;Release 1.5M (by Bob Ferguson) is a MS-DOS version of DASM 1.5 + XDASM86,
;and can be used to disassemble 8086/8088 COM files and cross-didassemble
;Z80 and TDL COM files under PC-DOS or MS-DOS.
;The source code has been extensively cleaned up to improve maintainability.
;Major functional changes and bug fixes:
;- The extension for the Comments file was changed from .DOC to .CMT
;- The commands ";ON" and ";OFF", doubling the T(oggle) command, were removed
;- The "$" command was added to invoke a controlled program exit.
;- Special characters '$', '%' and '_' are allowed in symbol names.
;- 8086: RETF instruction disassembled where appropriate.
;- 8086: 8 bit value to 16 bit reg/mem immediate instr is expanded to 16 bit.
;- 8086: some missing entries in OPC4 table added.
;- Start character to identify constant symbol changed from 'C' into '%'.
;- Constant symbols declared as equates in stead of labels.
;
;Release 1.51M has some more bug fixes.
;- 8086: LES, LDS and far CALL use 'DWORD PTR' prefix, not 'WORD PTR'.
;- 8086: OUT port,AL and OUT port,AX were sometimes interchanged.
;
;Release 1.52M is functionally the same as 1.51M, but has all comments and
;accompanying texts (some of which were in Dutch) in the English language.
;
;Release 1.53M is functionally the same as 1.51M and 1.52M again, but has
;a modified Internet download address in its documentation.
;
;Documentation can be found in the on-line help, and with the original
;programs RESOURCE, ZZSOURCE, DASM and XDASM86, which are all in Public
;Domain.

FALSE		=	0
TRUE		=	NOT FALSE

;Set one and ONLY one of the following TRUE
INTEL86		=	TRUE
ZILOG		=	FALSE
TDL		=	FALSE

;Initial values
ILSTLEN		=	20		;NUMBER OF LINES TO DISPLAY VIA L,A,B
IDMPLEN		=	80H		;NUMBER OF BYTES TO DISPLAY VIA D
INITPC		=	100H		;PC VALUE
IXCSW		=	FALSE		;SYMBOL COMMENT FLAG

;Other constants
QRDCOM		=	FALSE		;QUERY USER TO READ COM FILE
					;  WHEN 'ALL' IS FILE TYPE
CPREF		=	'%'		;PREFIX CHARACTER FOR CONSTANT SYMBOLS
STBSIZ		=	600H		;MAX SYMBOL TABLE SIZE
SYMMAX		=	12		;MAX NUMBER OF CHARS/SYMBOL (<= 12)
SYMCNT		=	4		;SYM DUMP ENTRIES PER LINE
CTLCNT		=	8		;CTL DUMP ENTRIES PER LINE
CMTCOL		=	32		;START COLUMN FOR TRAILING COMMENTS
ASCLEN		=	8		;MINIMUM NUMBER OF PRINTABLE CHARS
					;  TO RECOGNIZE ASCII STRING
IBUFLEN		=	80		;LENGTH OF INPUT LINE BUFFER
RECLEN		=	80H		;DISK FILE I/O RECORD LENGTH
SUSKEY		=	13H		;SUSPEND KEY (CTRL-S)
EMRKVAL		=	0FFFFH		;END MARKER VALUE WORD
EMRKCNT		=	0		;END MARKER COUNT BYTE

CR		=	0DH
LF		=	0AH
TAB		=	09H
QUOTE		=	27H

CODE		SEGMENT	PARA 'CODE'
		ASSUME	CS:CODE, DS:CODE, ES:CODE, SS:CODE

		ORG	005CH
FCB		LABEL	BYTE

		ORG	0065H
FCBTYPE		LABEL	BYTE

		ORG	007CH
FCBNR		LABEL	BYTE

		ORG	0080H
DMABUF		LABEL	BYTE


	ORG	0100H

MAIN	PROC	NEAR

	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
	JMP	START

;Include the appropriate file defining the mnemonics for the desired language.
;Choices are:
;	DASMZLG.ASM -- ZILOG Z80 cross-disassembler for MS-DOS
;	DASMTDL.ASM -- TDL 8080 cross-disassembler for MS-DOS
;	DASM86.ASM  -- Intel 8086 native disassembler

IF	ZILOG
	INCLUDE	DASMZLG.ASM
ENDIF

IF	TDL
	INCLUDE	DASMTDL.ASM
ENDIF

IF	INTEL86
	INCLUDE	DASM86.ASM
ENDIF


;PRINT HEADERS
;
START:	MOV	[OLDST],SP
	CLD				;GLOBAL DIRECTION FLAG SETTING UPWARD
	CALL	INIT			;INITIALIZE BUFFERS TO BE REENTRANT
	CALL	REINIT			;CLEANUP INITIALIZATION
	CALL	MSG
	DB	'DASM version 1.5M',CR,0
	MOV	DX,OFFSET HEADER	;PRINT HEADER FROM INCLUDE FILE
	MOV	AH,09H
	INT	21H

;READ IN ALL FILES IF A FILE WAS SPECIFIED
;
	MOV	AL,BYTE PTR[FCB+1]	;GET FIRST LETTER OF FILE NAME
	CMP	AL,' '+1		;SKIP READ IF NOT VALID CHAR
	JB	START2
	CALL	MSG
	DB	CR,'Reading in All Files for ',0
	MOV	SI,OFFSET FCB+1		;PRINT FILE NAME
	MOV	CX,8
START1:	LODSB
	CALL	COUT
	LOOP	START1
	CALL	PCRLF
	CALL	RDALL			;READ ALL FILES
START2:	JMP	STAT			;PRINT STATISTICS, THEN GET COMMAND

;MAIN COMMAND PROCESSING LOOP
;
GETCMD:	MOV	BYTE PTR [WRTENAB],0	;DISABLE OUTPUT TO FILE
	MOV	BYTE PTR [HUSH],0	;DISABLE QUIET MODE
	MOV	SP,[OLDST]		;RESET STACK
	CALL	PROMPT			;INPUT COMMAND LINE AND CAPITALIZE

;PROCESS COMMAND LINE
;
GETCM1:	MOV	AL,[INBUF+2]		;GET FIRST CHAR OF COMMAND
	MOV	BYTE PTR [CMDTBX],AL	;STORE AS SENTINEL
	MOV	DI,OFFSET CMDTBL - 2	;PT TO COMMAND TABLE
GETCM2:	INC	DI
	INC	DI
	SCASB
	JNZ	GETCM2			;LOOP UNTIL MATCH
	JMP	[DI]			;PROCESS COMMAND

;GENERAL ERROR
;
WHAT:	MOV	BYTE PTR [WRTENAB],0
	MOV	BYTE PTR [HUSH],0
	CALL	MSG
	DB	CR,'** Command Error **',CR,0
	JMP	SHORT GETCMD

;COMMAND TABLE
;CONTAINS COMMAND LETTER FOLLOWED BY ADDRESS OF ROUTINE
;LAST ENTRY IS SENTINEL FOR COMMAND ERROR
;
CMDTBL	DB	CR			;EMPTY LINE
	DW	GETCMD
	DB	'$'			;EXIT PROGRAM
	DW	EXIT
	DB	';'			;COMMENTS
	DW	CMNT
	DB	'?'			;STATISTICS DISPLAY
	DW	STAT
	DB	'A'			;BUILD ASCII
	DW	ASCASM
	DB	'B'			;BUILD LABELS
	DW	BLDASM
	DB	'C'			;CONTROL TABLE
	DW	CNTRL
	DB	'D'			;MEMORY DUMP
	DW	DUMP
	DB	'E'			;ENTER SYMBOL
	DW	NTER
	DB	'F'			;FIND LABEL
	DW	FIND
	DB	'H'			;HELP
	DW	HELP
	DB	'I'			;INCREMENT SYMBOL VALUES
	DW	INCSYM
	DB	'K'			;KILL SYMBOL
	DW	KILL
	DB	'L'			;LIST CODE
	DW	LIST
	DB	'O'			;SET OFFSET
	DW	OFSET
	DB	'P'			;GENERATE PROLOG
	DW	PROLOG
	DB	'Q'			;QUIET MODE
	DW	QUIET
	DB	'R'			;READ FILES
	DW	READ
	DB	'S'			;SAVE FILES
	DW	SAVE
	DB	'T'			;TOGGLE COMMENTS FLAG
	DW	TOGGL
	DB	'U'			;SET COMMENTS
	DW	UAREA
	DB	'X'			;PURGE SYMBOLS AND CONTROL
	DW	PURG
	DB	'Z'			;CLOSE ASM FILE
	DW	CLSASM
CMDTBX	DB	0			;END OF COMMAND TABLE (SENTINEL)
	DW	WHAT

;COMMAND: H
;PRINT HELP INFORMATION
;JUST ONE BIG PRINT (LABELS GIVE THE LINE NUMBERS)
;
HELP:	CALL	MSG
HELP01	DB     '			HELP on DASM -- Command Summary',CR
HELP02	DB     ';addr,comment	Enter Comment at addr	'
	DB     ';addr		List comment at addr'			,CR
HELP03	DB     ';		List Comments Table	'
	DB     ';addr,		Delete Comment'				,CR
HELP04	DB     'A (see L)	Attempt to find DBs	'
	DB     'B (see L)	Build Symbol Table'			,CR
HELP05	DB     'C		Dump Control Table	'
	DB     'Cnnnn		Dump Ctrl Table at nnnn'		,CR
HELP06	DB     'Cnnnn,x		Set Ctrl (x=BEHISW)	'
	DB     'Dnnnn		Dump from nnnn on'			,CR
HELP07	DB     'Daaaa,bbbb	Dump over range		'
	DB     'D,bbbb		Dump thru bbbb'				,CR
HELP08	DB     'D		Dump 80H more		'
	DB     'D=nn		Set Dump Size Default'			,CR
HELP09	DB     'DS		Dump the Symbol Table	'
	DB     'DS.symbol	Dump starting at symbol'		,CR
HELP10	DB     'Ennnn,.symbol	Enter symbol into table	'
	DB     'Fnnnn,ssss	Find nnnn after ssss'			,CR
HELP11	DB     'F or Fnnnn	Cont Find or Find nnnn	'
	DB     'Issss,oooo	Inc addrs>=ssss by oooo'		,CR
HELP12	DB     'K.symbol	Kill symbol from table	'
	DB     'L		List next '
	DB     (ILSTLEN/10)+'0'
	DB     (ILSTLEN - (10 * (ILSTLEN/10))) + '0'
	DB				    ' lines'			,CR
HELP13	DB     'Lssss,eeee	List over range		'
	DB     'L,eeee		List to eeee'				,CR
HELP14	DB     'Lssss		List '
	DB     (ILSTLEN/10)+'0'
	DB     (ILSTLEN - (10*(ILSTLEN/10))) + '0'
	DB			      ' lines from ssss	'
	DB     'L=nn[,others]	Set list default'			,CR
HELP15	DB     'O		Print current offset	'
	DB     'Onnnn		Set new offset'				,CR
HELP16	DB     'Pssss,eeee	Generate program prolog	'
	DB     'Q		Quiet prefix'				,CR
HELP17	DB     'Rfilename.COM	Read file @ offset+118H	'
	DB     'Rfilename.CTL	Read Control Table'			,CR
HELP18	DB     'Rfilename.SYM	Read Symbol Table	'
	DB     'Rfilename.CMT	Read Comments Table'			,CR
HELP19	DB     'Rfilename.ALL	Read CTL, SYM, CMT, COM	'
	DB     'Sfilename.ASM	Save ASM File'				,CR
HELP20	DB     'Sfilename.CTL	Save CTL File		'
	DB     'Sfilename.SYM	Save SYM File'				,CR
HELP21	DB     'Sfilename.CMT	Save CMT File		'
	DB     'Sfilename.ALL	CTL, SYM, CMT, ASM'			,CR
HELP22	DB     'T		Toggle Comments Flag  	'
	DB     'Unnnn		Set Comment Table Addr'			,CR
HELP23	DB     'X		Restart DASM		'
	DB     'Z		Write EOF to ASM File'			,CR
HELP24	DB     '?		Print Statisticss	'
	DB     '$		Exit program'				,CR
	DB	0
	JMP	GETCMD

;COMMAND: $
;EXIT PROGRAM AFTER VERIFICATION
;
EXIT:	CALL	MSG			;PROMPT USER
	DB	CR
	DB	'Exit program (Y/N)? '
	DB	0
	CALL	CHIN
	CMP	AL,'Y'
	JNE	EXITX
	MOV	AX,4C00H		;PROGRAM EXIT
	INT	21H
EXITX:	JMP	GETCMD

;COMMAND: X
;PURGE ALL SYMBOLS AND CONTROL
;
PURG:	CALL	MSG			;PROMPT USER
	DB	'Restart DASM (Y/N)? ',0
	CALL	CHIN
	CMP	AL,'Y'
	JNE	PURGX
	CALL	MSG
	DB	'Restarting DASM',CR,0
	CALL	REINIT			;RE-INITIALIZE
PURGX:	JMP	GETCMD

;COMMAND: P
;ENTER PROLOG INTO ASSEMBLY LANGUAGE PROGRAM
;
PROLOG:	MOV	BX,OFFSET INBUF+3	;BX = COMMAND PTR
	CMP	BYTE PTR [BX],CR	;GET START ADDRESS
	JE	PROLOZ
	CALL	CNVRT
	MOV	[ARG1],DX
	CMP	AL,','			;NEED ','
	JNE	PROLOZ
	INC	BX
	CMP	BYTE PTR [BX],CR	;GET END ADDRESS
	JE	PROLOZ
	CALL	CNVRT
	MOV	[ARG2],DX
	CMP	AL,CR			;NEED <CR>
	JNE	PROLOZ
	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
	CALL	XPROLG			;PRINT LANGUAGE DEPENDANT PROLOG

	MOV	CX,[ARG1]		;CX= START ADDRESS
	MOV	DX,[ARG2]		;DX= END ADDRESS
	MOV	BX,OFFSET SYMTBL	;BX= PT TO SYMBOL TABLE

PROLO1:	CMP	BYTE PTR [BX+2],EMRKCNT	;WHILE NOT END OF TABLE
	JE	PROLO4
	CMP	[BX],CX			;  IF SYMBOL ADDRESS < START ADDRESS
	JB	PROLO2
	CMP	[BX],DX			;  OR SYMBOL ADDRESS > END ADDRESS
	JA	PROLO2
	CMP	BYTE PTR [BX+3],CPREF	;  OR SYMBOL IS A CONSTANT
	JNE	PROLO3
PROLO2:	CALL	GENEQU			;  THEN GENERATE EQU
PROLO3:	MOV	AL,[BX+2]		;  SKIP TO THE NEXT SYMBOL
	ADD	AL,3
	XOR	AH,AH
	ADD	BX,AX
	CALL	BRKCHK			;  CHECK FOR BREAK
	JMP	PROLO1			;ENDWHILE

PROLO4:	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
	CALL	PSTG			;PRINT ORG DIRECTIVE
	DB	CR,TAB,'ORG',TAB,0
	MOV	DX,[ARG1]
	CALL	PTWHEX
	CALL	PCRLF
	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	JMP	GETCMD			;NORMAL EXIT
PROLOZ:	JMP	WHAT			;ERROR EXIT

;GENERATE EQUATE
;
;IN :	BX = PTR TO SYMBOL ADDRESS
;OUT:	BX,CX,DX UNCHANGED
;
GENEQU:	PUSH	CX
	PUSH	DX
	MOV	SI,BX			;SI= PTR TO SYMBOL ADDRESS
	INC	SI			;PT TO SYMBOL CHAR COUNT
	INC	SI
	LODSB				;CX=CHAR COUNT
	MOV	CL,AL
	XOR	CH,CH
	PUSH	CX
	PUSH	SI
GENEQ1:	LODSB				;SCAN SYMBOL FOR '+' OR '-'
	CMP	AL,'+'
	JE	GENEQ2
	CMP	AL,'-'
	JE	GENEQ2
	LOOP	GENEQ1
GENEQ2:	POP	SI
	POP	CX
	JZ	GENEQX			;SKIP IF '+' OR '-' FOUND

;PRINT SYMBOL EQUATE; BX PTS TO BYTE BEFORE SYMBOL AND CX=NUMBER OF CHARS
;
	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
GENEQ3:	LODSB				;SYMBOL
	CALL	COUT
	LOOP	GENEQ3
	CALL	PSTG			;'EQU'
	DB	TAB,'EQU',TAB,0
IF INTEL86				;INTEL 8086 VERSION ONLY: 
	CMP	BYTE PTR [BX+3],CPREF	;  IF NOT CONSTANT
	JE	GENEQ4
	CALL	PSTG			;	'$+' PREFIX
	DB	'$+',0
GENEQ4:
ENDIF
	MOV	DX,[BX]			;VALUE
	CALL	PTWHEX
	CALL	PCRLF
	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
GENEQX:	POP	DX
	POP	CX
	RET

;COMMAND: Q PREFIX
;EXECUTE THE COMMAND IN THE QUIET MODE
;
QUIET:	MOV	BYTE PTR [HUSH],1	;TURN ON QUIET MODE
	MOV	DI,OFFSET INBUF+2	;COPY COMMAND LINE LEFT 1 CHARACTER
	MOV	SI,DI
	INC	SI
QUIET1:	LODSB
	STOSB
	CMP	AL,CR
	JNE	QUIET1
	DEC	BYTE PTR [INBUF+1]
	JMP	GETCM1			;RETURN TO MAIN COMMAND PROCESSOR

;COMMAND: D
;DUMP MEMORY/SYMBOL TABLE OR SET DEFAULT DUMP LENGTH
;
;SYNTAX :  DS... 			PROCEED TO DMPSYM
;	   D=length			CHANGE DEFAULT DUMP LENGTH
;	or D[=length,][start][,end]	[CHANGE DFL DMPLEN,] DUMP MEMORY
;
DUMP:	MOV	BX,OFFSET INBUF+3	;BX = COMMAND PTR
	MOV	AL,[BX]			;GET NEXT CHAR
	CMP	AL,'S'			;'DS':	DUMP SYMBOLS
	JNE	DUMP0
	JMP	DMPSYM
DUMP0:	CMP	AL,'='			;OPTIONAL DUMP LENGTH
	JNE	DUMP1
	INC	BX			;	READ LENGTH
	CALL	CNVRT
	MOV	[DMPLEN],DX
	CMP	AL,CR			;	<CR>: EXIT
	JE	DUMPX
	CMP	AL,','			;	ELSE NEED ','
	JNE	DUMPZ
	INC	BX			;	GET NEXT CHAR
	MOV	AL,[BX]
DUMP1:	CMP	AL,','			;OPTIONAL START ADDRESS
	JE	DUMP2
	CMP	AL,CR
	JE	DUMP2
	CALL	CNVRT			;	READ ADDRESS
	MOV	[DMPPTR],DX
DUMP2:	MOV	DX,[DMPPTR]		;SET DEFAULT END ADDRESS
	ADD	DX,[DMPLEN]
	MOV	[DMPEND],DX
	CMP	AL,','			;READ OPTIONAL END ADDRESS
	JNE	DUMP3
	INC	BX			;	READ ADDRESS
	CALL	CNVRT
	MOV	[DMPEND],DX
DUMP3:	CMP	AL,CR			;NEED <CR>
	JNE	DUMPZ
  	CALL	DMPMEM
DUMPX:	JMP	GETCMD			;NORMAL EXIT
DUMPZ:	JMP	WHAT			;ERROR EXIT

;DUMP MEMORY
;
DMPMEM:	CALL	MSG			;PRINT A HEADER FOR THE DUMP
	DB	'Addr  +0   +2    +4   +6     +8   +A    +C   +E      ASCII'
	DB	CR,0
	MOV	SI,[OFFS]
	MOV	BX,[DMPPTR]
DMPME1:	CALL	BRKCHK			;REPEAT	CHECK FOR BREAK
	CALL	PVALUE			;	DUMP 1 LINE
	CALL	PSPACE
	CALL	DMPHEX
	CALL	DMPASC
	MOV	[DMPPTR],BX		;	SAVE NEW START ADDRESS
	CMP	BX,[DMPEND]
	JB	DMPME1			;UNTIL DONE
	RET

;DUMP AS HEX
;IN :	SI	[OFFS]
;	BX	START ADDRESS
;OUT:	BX	UNCHANGED
;
DMPHEX:	PUSH	BX			;SAVE START ADDRESS
DMPHX0:	MOV	AL,[BX+SI]
	INC	BX			;PT TO NEXT
	CALL	PHEX			;PRINT AS HEX
	TEST	BL,01H			;PRINT ONE SPACE FOR EVERY 2 VALUES
	JNZ	DMPHX1
	CALL	PSPACE
DMPHX1:	TEST	BL,03H			;PRINT TWO SPACES EVERY 4
	JNZ	DMPHX2
	CALL	PSPACE
DMPHX2:	TEST	BL,07H			;PRINT THREE SPACES EVERY 8
	JNZ	DMPHX3
	CALL	PSPACE
DMPHX3:	TEST	BL,0FH			;CHECK FOR END OF DUMP LINE (EVERY 16)
	JNZ	DMPHX0
	POP	BX			;RESTORE START ADDRESS
	RET

;DUMP AS ASCII
;IN :	SI	[OFFS]
;	BX	START ADDRESS
;OUT:	BX	POINTS TO BYTE AFTER LAST DISPLAYED ONE
;
DMPASC:	MOV	AL,'!'			;PRINT BEGINNING '!'
	CALL	COUT
DMPAS0:	MOV	AL,[BX+SI]		;GET BYTE
	INC	BX			;PT TO NEXT
	CMP	AL,' '			;REPLACE WITH '.' IF NOT PRINTABLE
	JB	DMPAS1
	CMP	AL,'~'
	JNA	DMPAS2
DMPAS1:	MOV	AL,'.'
DMPAS2:	CALL	COUT			;PRINT CHAR
	TEST	BL,0FH			;END OF LINE?
	JZ	DMPAS4			;DONE IF SO
	TEST	BL,07H			;EXTRA SPACE FOR EVERY 8
	JNZ	DMPAS3
	CALL	PSPACE
DMPAS3:	JMP	SHORT DMPAS0		;CONTINUE ASCII DUMP
DMPAS4:	MOV	AL,'!'			;PRINT ENDING '!' + NEW LINE
	CALL	COUT
	JMP	PCRLF

;DS -- DUMP THE SYMBOL TABLE
;
DMPSYM:	MOV	SI,OFFSET SYMTBL	;ASSUME DUMP FROM START OF TABLE
	INC	BX			;PT TO NEXT COMMAND CHAR
	CMP	BYTE PTR [BX],'.'	;IF SYMBOL
	JNE	DSYM0
	CALL	SYMPRS			;	GET SYMBOL LENGTH
	CALL	SYMFND			;	GET SYMBOL TABLE PTR
	MOV	SI,BX
DSYM0:	MOV	BYTE PTR [ENTCNT],SYMCNT;INIT ENTRY COLUMN COUNT
DSYM1:	CALL	BRKCHK			;CHECK FOR BREAK
	LODSW				;BX= SYMBOL VALUE
	MOV	BX,AX
	LODSB				;AL= SYMBOL NAME LENGTH
	OR	AL,AL			;EXIT ON END OF TABLE
	JZ	DSYMX
	MOV	CH,AL			;CH = SYMBOL NAME LENGTH
	MOV	CL,SYMMAX+1		;CL = NUMBER OF SPACES AFTER SYM
	SUB	CL,CH
	CALL	PVALUE			;PRINT VALUE
	MOV	AL,'='
	CALL	COUT
DSYM2:	LODSB				;PRINT NAME
	CALL	COUT
	DEC	CH
	JNZ	DSYM2
DSYM3:	CALL	PSPACE			;PRINT CL TRAILING SPACES
	LOOP	DSYM3
	DEC	BYTE PTR [ENTCNT]
	JNZ	DSYM1			;NEXT SYMBOL SAME LINE
	CALL	PCRLF			;NEXT SYMBOL NEW LINE
	JMP	SHORT DSYM0

DSYMX:	CALL	PCRLF			;NEW LINE AND EXIT
	JMP	GETCMD

;COMMAND: O
;SET OR PRINT OFFSET ADDRESS
;SYNTAX : O		DISPLAY CURRENT OFFSET
;	  Onnnn		SET OFFSET TO nnnnH
;
OFSET:	MOV	BX,OFFSET INBUF+3
	CMP	BYTE PTR [BX],CR
	JE	OFSPRN
	CALL	CNVRT			;GET VALUE
	CMP	AL,CR			;NEED <CR>
	JNE	OFSETZ
	MOV	[OFFS],DX		;SAVE AS OFFS
;;	JMP	OFSPRN

;PRINT OPFS VALUE
;
OFSPRN:	CALL	MSG
	DB	'Offset = ',0
	MOV	BX,[OFFS]
	CALL	PVALUE
	CALL	PCRLF
OFSETX:	JMP	GETCMD			;NORMAL EXIT
OFSETZ:	JMP	WHAT			;ERROR EXIT

;COMMAND: A
;BUILD ASCII STRINGS USING DB'S
;
ASCASM:	MOV	BYTE PTR [ASCBLD],1	;A FLAG ON
	MOV	BYTE PTR [BUILD],0	;B FLAG OFF
	JMP	SHORT LIST0

;COMMAND: B
;BUILD LABELS
;
BLDASM:	MOV	BYTE PTR [ASCBLD],0	;A FLAG OFF
	MOV	BYTE PTR [BUILD],1	;B FLAG ON
	JMP	SHORT LIST0

;COMMAND: L
;DISASSEMBLE WITH THE 'L' OPTION
;
LIST:	MOV	BYTE PTR [ASCBLD],0	;A FLAG OFF
	MOV	BYTE PTR [BUILD],0	;B FLAG OFF
LIST0:	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	MOV	BYTE PTR [CNTENAB],1	;ENABLE LINE COUNTING
	MOV	AL,[LSTLEN]		;SET LINE COUNT
	MOV	[LINCNT],AL
	MOV	BX,OFFSET INBUF+3	;PT TO CHAR AFTER L, A, OR B COMMAND
	MOV	AL,[BX]			;GET IT
	CMP	AL,CR			;<CR>: USE DEFAULT FOR ALL PARAMETERS
	JE	LILIN
	CMP	AL,','			;',' : USE DEFAULT START ADDRESS
	JE	LIST2
	CMP	AL,'='			;'=' : SET NEW DEFAULT LIST LENGTH
	JNE	LIST1
	INC	BX
	CALL	CNVRT			;GET NEW DEFAULT LIST LENGTH
	AND	DX,DX			;ERROR IF ZERO
	JZ	LISTZ
	MOV	[LSTLEN],DL		;SET COUNTS
	MOV	[LINCNT],DL
	INC	BX			;PT TO NEXT CHAR
	CMP	AL,','			;',' : MORE ARGUMENTS FOLLOW
	JE	LIST1
	CMP	AL,CR			;ELSE NEED <CR>
	JNE	LISTZ
	JMP	GETCMD

LIST1:	CALL	CNVRT			;GET START ADDRESS
	MOV	[PC],DX
	CMP	AL,CR			;<CR>: USE DEFAULT LIST LENGTH
	JE	LILIN
	CMP	AL,','			;ELSE NEED ','
	JE	LIST2
LISTZ:	JMP	WHAT
LIST2:	INC	BX			;GET END ADDRESS
	CALL	CNVRT
	MOV	[ENDLST],DX
	MOV	BYTE PTR [CNTENAB],0	;DISABLE LINE COUNTING

;LIST 1 LINE
;MAIN PROCESSING LOOP FOR L, A, AND B COMMANDS
;
LILIN:	CALL	BRKCHK			;CHECK FOR BREAK
	CMP	BYTE PTR [CNTENAB],0	;IF LINE COUNTING ENABLED
	JE	LILIN1
	CMP	BYTE PTR [LINCNT],0	;  EXIT IF LINE COUNT <= 0
	JG	LILIN2			;  (SIGNED COMPARE)
	JMP	GETCMD
LILIN1:	MOV	AX,[PC]			;ELSE EXIT IF [PC] >= [ENDLST]?
	CMP	AX,[ENDLST]
	JB	LILIN2
	JMP	GETCMD			;ENDIF
LILIN2:	CMP	BYTE PTR [ASCBLD],0	;CHECK ASCII BUILD FLAG
	JE	LICMT
	;
	; TRY TO BUILD ASCII DB'S
	;
	MOV	SI,[PC]			;SI = ABSOLUTE MEMORY POINTRER
	ADD	SI,[OFFS]
	MOV	CX,ASCLEN		;CHECK FOR ASCLEN PRINTABLES IN A ROW
LIASC1:	LODSB
	CALL	ISASC
	JC	LICMT			;IF NOT, SKIP TO NEXT BYTE
	LOOP	LIASC1
LIASC2:	LODSB				;SCAN UNTIL NON-PRINTABLE
	CALL	ISASC
	JNC	LIASC2
	DEC	SI
	SUB	SI,[OFFS]		;SUBTRACT OFFSET
	PUSH	SI			;SAVE PTR FOR 'I' CONTROL
	MOV	DX,[PC]			;SET 'B' CONTROL
	MOV	AL,'B'
	CALL	CTLUPD
	POP	DX
	MOV	[PC],DX			;SET 'I' CONTROL
	MOV	AL,'I'
	CALL	CTLUPD
	;
	; LIST ANY COMMENTS AT THIS ADDRESS
	;
LICMT:	CMP	WORD PTR [CMTBEG],0000H	;COMMENT TABLE IN USE?
	JE	LICTL			;NO: SKIP
	MOV	DX,[PC]
	CALL	CMTSCH			;SEARCH COMMENT
	JC	LICTL			;NO MATCH
	INC	SI
	INC	SI
	MOV	CH,[SI]			;CH=NUMBER OF CHARS IN COMMENT
	MOV	AL,[SI+1]		;AL=FIRST CHAR OF COMMENT
	CMP	AL,';'			;';' COMMENT IS LISTED AFTER OPCODE
	JNE	LICMT1
	MOV	[CMTPTR],SI		;SAVE THE COMMENT ADDRESS
	JMP	SHORT LICTL
LICMT1:	CMP	AL,'*'			;'*' COMMENT REPLACES THE ENTIRE LINE
	JNE	LICMT2
	MOV	[RPLPTR],SI
	JMP	SHORT LICTL
LICMT2:	MOV	BX,SI			;PRINT COMMENT
	CALL	PTCMT
	CALL	PCRLF
	;
	; NOW BRANCH ACCORDING TO CONTROL MODE
	;
LICTL:	MOV	DX,[PC]
	CALL	CTLSCH			;SEARCH CONTROL TABLE
	JNC	LICTL1
	SUB	BX,3			;NO MATCH: TAKE PREVIOUS ENTRY
LICTL1:	MOV	AL,[BX+2]		;GET CONTROL MODE
	CMP	AL,'I'			;'I' : INSTRUCTION
	JE	IMODE
	CMP	AL,'E'			;'E' : END OF PROGRAM
	JNE	LICTL2
	JMP	CLSASM
LICTL2:	CALL	HSYM			;PRINT SYMBOL IF PRESENT
	MOV	DX,[BX+3]		;GET ADDRESS OF NEXT CONTROL MODE
	MOV	[NXTCTL],DX
	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	CMP	AL,'S'			;'S' : DEFINE SPACE
	JE	SMODE
	CMP	AL,'W'			;'W' : DEFINE WORDS
	JE	WMODE
	CMP	AL,'H'			;'H' : DEFINE BYTES HEX
	JE	HMODE
	CMP	AL,'B'			;'B' : DEFINE BYTES ASCII OR HEX
	JE	BMODE
	CALL	COUT			;ERROR OTHERWISE
	CALL	MSG
	DB	': Invalid CTL Entry',CR,0
	JMP	GETCMD

;I MODE -- LIST AS INSTRUCTION
;
IMODE:	CALL	DASM			;INVOKE DISASSEMBLER
	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	JMP	LILIN			;CONTINUE LISTING

;DS MODE -- DEFINE SPACE UP TO NEXT CTL ADDRESS
;ON ENTRY: DX = ADDRESS OF NEXT CONTROL MODE
;
SMODE:	MOV	BX,DX			;BX= ADDRESS OF NEXT CONTROL MODE
	SUB	DX,[PC]			;DX= LENGTH OF SPACE REQUIRED
	MOV	[PC],BX			;SET PC TO NEXT CONTROL ENTRY
	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
IF INTEL86
	CALL	PSTG			;'DB '
	DB	'DB',TAB,0
	CALL	PTWHEX			;SIZE
	CALL	PSTG			;' DUP(?)'
	DB	TAB,'DUP(?)',0
ELSE
	CALL	PSTG			;'DS '
	DB	'DS',TAB,0
	CALL	PTWHEX			;SIZE
ENDIF
	CALL	DCRLF
	JMP	LILIN			;LIST NEXT LINE

;DW MODE -- PROCESS DW AND LOOK FOR LABELS
;
WMODE:	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
	CALL	PSTG			;'DW'
	DB	'DW',TAB,0
	MOV	BX,[PC]			;VALUE
	ADD	BX,[OFFS]
	MOV	DX,[BX]
	CALL	PRNTDE
	CALL	DCRLF			;NEWLINE
	ADD	WORD PTR [PC],2		;ADVANCE PC
	JMP	LILIN			;LIST NEXT LINE

;HEX MODE -- LIST HEX DB'S
;
HMODE:	MOV	BYTE PTR [ASCDB],0	;RESET ASCII DB FLAG
	JMP	SHORT BMODE1

;DB MODE -- LIST DB'S (ASCII IF POSSIBLE)
;
BMODE:	MOV	BYTE PTR [ASCDB],1	;SET ASCII DB FLAG
BMODE1:	MOV	BYTE PTR [DBFLEN],0	;INIT LENGTH TO ZERO
	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
	CALL	PSTG			;'DB'
	DB	'DB',TAB,0
	;
	; PROCESS BYTES OF DB
	;
BMODE2:	MOV	BX,[PC]			;BX = ACTUAL ADDRESS
	ADD	BX,[OFFS]
	MOV	AL,[BX]			;GET BYTE
	CMP	BYTE PTR [ASCDB],0	;ASCII DB FLAG?
	JE	BMHEX			;  NO: 2 DIGIT HEX DB
	CMP	AL,0AH			;LESS THEN 0AH?
	JB	BMHEX1			;  YES: 1 DIGIT HEX NUMBER
	CMP	AL,' '			;OTHER NON-PRINTABLE?
	JB	BMHEX			;  YES: 2 DIGIT HEX NUMBER
	CMP	AL,'~'
	JA	BMHEX
	;
	; DB MODE : QUOTED ASCII STRING
	;
BMASC:	MOV	AH,AL			;SAVE CHAR
	CALL	PQUOTE			;QUOTE
	MOV	AL,AH			;RESTORE CHAR
	INC	BYTE PTR [DBFLEN]	;INC LENGTH
BMASC1:	CALL	COUT			;PRINT CHAR
	CMP	AL,QUOTE		;CHECK FOR QUOTE
	JNE	BMASC2
	CALL	COUT			;IF SO: PRINT TWO QUOTES
BMASC2:	INC	BX			;NEXT CHAR
	INC	WORD PTR [PC]

	MOV	DX,[PC]			;CHECK FOR CONTROL
	CMP	DX,[NXTCTL]
	JE	BMASC4			;IF SO: NEW LINE
	PUSH	BX
	CALL	SYMSCH			;CHECK FOR SYMBOL
	POP	BX
	JNC	BMASC4			;IF SO: NEW LINE
	INC	BYTE PTR [DBFLEN]	;INCR LINE LENGTH
	MOV	AL,[DBFLEN]		;CHECK LINE LENGTH
	CMP	AL,32			;LESS THAN 32: CONTINUE
	JB	BMASC3
	CMP	AL,35			;MORE THAN 35: NEW LINE
	JA	BMASC4

	CMP	BYTE PTR [BX-1],' '	;IN BETWEEN: BREAK AT SPACE
	JE	BMASC4
BMASC3:	MOV	AL,[BX]			;GET NEXT CHAR
	CMP	AL,' '			;CHECK IF PRINTABLE
	JB	BMASC4			;NO: NEW LINE
	CMP	AL,'~'			;CHECK AGAIN
	JBE	BMASC1			;OK: STILL IN ASCII STRING

BMASC4:	CALL	PQUOTE			;WRITE ENDING QUOTE + NEW LINE
	CALL	DCRLF
	JMP	LILIN			;LIST NEXT LINE

;DB MODE : OUTPUT HEX BYTE VALUES
;
BMHEX:	CALL	PASHEX			;PRINT AS 2 DIGIT HEX NUMBER
	MOV	AL,'H'
	CALL	COUT
	ADD	BYTE PTR [DBFLEN],2
	JMP	SHORT BMHEX2

;ALTERNATE ENTRY: 1 DIGIT HEX VALUE
;
BMHEX1:	OR	AL,'0'			;PRINT AS 1 DIGIT HEX NUMBER
	CALL	COUT
BMHEX2:	INC	BX			;ADVANCE TO NEXT BYTE
	INC	WORD PTR [PC]
BMHEX3:	MOV	DX,[PC]
	CMP	DX,[NXTCTL]		;CHECK IF NEXT CONTROL POINT REACHED
	JE	BMHEX5
BMHEX4:	CALL	SYMSCH			;CHECK FOR A SYMBOL'S ADDRESS
	JNC	BMHEX5
	ADD	BYTE PTR [DBFLEN],2	;INCREMENT LINE LENGTH BY 2
	CMP	BYTE PTR [DBFLEN],32
	JAE	BMHEX5			;NEW LINE IF STRING EXCEEDS 32 CHARS
	CALL	PCOMMA			;',' COMMA OTHERWISE
	JMP	BMODE2			;NEXT BYTE

BMHEX5:	CALL	DCRLF			;NEW LINE
	JMP	LILIN			;LIST NEXT LINE

;PRINT REPLACING LINE AS COMMENT (CALLED FROM DASMXXX.ASM INCLUDE FILE)
;
NWLN0:	MOV	BYTE PTR [WRTENAB],1	;ENABLE WRITING
	INC	CH
	CALL	PTCMT4
	MOV	WORD PTR [RPLPTR],0	;MARK REPLACING COMMENT OFF
	RET

;THIS ROUTINE WILL
;PRINT COMMENTS
;LIKE THIS ONE
;
PTCMT:	MOV	BYTE PTR [WRTENAB],1	;ENABLE WRITING
	INC	CH
	JMP	SHORT PTCMT2

PTCMT1:	INC	BX			;GET NEXT CHAR
	MOV	AL,[BX]
	CMP	AL,'\'			;'\' : NEW LINE
	JNE	PTCMT3
	CALL	PCRLF
PTCMT2:	MOV	AL,';'
PTCMT3:	CALL	COUT			;PRINT CHAR
PTCMT4:	DEC	CH			;DECREMENT COUNT
	JNZ	PTCMT1
	RET

;COMMAND: I<address>,<offset>
;INCREMENT SYMBOL TABLE ADDRESSES AFTER AND ON <ADDRESS> BY <OFFS>
;FOR DISASSEMBLY OF NEW VERSIONS OF PROGRAMS
;
INCSYM:	MOV	BX,OFFSET INBUF+3	;BX= CMD PTR
	CMP	BYTE PTR [BX],CR	;GET ADDRESS
	JE	INCSYZ
	CALL	CNVRT
	MOV	[ARG1],DX
	CMP	AL,','			;NEED ','
	JNE	INCSYZ
	INC	BX
	CMP	BYTE PTR [BX],CR	;GET OFFSET
	JE	INCSYZ
	CALL	CNVRT
	CMP	AL,CR			;NEED <CR>
	JNE	INCSYZ
	MOV	CX,DX			;CX=OFFS
	MOV	DX,[ARG1]		;DX=START ADDRESS
	MOV	BX,OFFSET SYMTBL	;BX=SYMBOL TABLE PTR
	XOR	AH,AH			;AH=0
INCSY1:	CMP	[BX],DX			;COMPARE
	JB	INCSY2			;SKIP IF BELOW
	ADD	[BX],CX			;ADD OFFSET
INCSY2:	INC	BX			;SKIP TO NEXT SYMBOL
	INC	BX
	MOV	AL,[BX]			;GET CHAR COUNT
	OR	AL,AL
	JZ	INCSYX			;DONE IF ZERO
	INC	BX			;PT TO FIRST CHAR OF SYMBOL
	ADD	BX,AX			;ADD SYMBOL LENGTH TO BX
	JMP	SHORT INCSY1		;CONTINUE PROCESSING
INCSYX:	JMP	GETCMD			;NORMAL EXIT
INCSYZ:	JMP	WHAT			;ERROR EXIT

;COMMAND: ?
;STATISTIC OUTPUT
;
STAT:	CALL	PCRLF
	CALL	CTLPRM			;'CONTROL TABLE : start end ',cr,lf
	CALL	MSG			;'SYMBOL  TABLE : start end ',cr,lf
	DB	'SYMBOL  TABLE : ',0
	MOV	BX,OFFSET SYMTBL
	CALL	PVALUE
	MOV	BX,[SYMEND]
	ADD	BX,2
	CALL	PVALUE
	CALL	MSG			;'PROGRAM IMAGE : start end '
	DB	CR,'PROGRAM IMAGE : ',0
	MOV	BX,[OFFS]
	PUSH	BX
	ADD	BX,INITPC
	CALL	PVALUE
	POP	BX
	ADD	BX,[RELEND]
	CALL	PVALUE
	CALL	MSG			;  ', RELATIVE : start end '
	DB	', RELATIVE : 0100 ',0
	MOV	BX,[RELEND]
	CALL	PVALUE
	CALL	MSG			;  ', OFFSET = offset ',cr,lf
	DB	', OFFSET = ',0
	MOV	BX,[OFFS]
	CALL	PVALUE
	CALL	PCRLF
	MOV	BX,[CMTBEG]		;COMMENTS ACTIVE?
	OR	BX,BX
	JZ	STAT1			;NO: SKIP
	CALL	MSG			;'COMMENT TABLE : start end ',cr,lf
	DB	'COMMENT TABLE : ',0
	MOV	BX,[CMTBEG]
	CALL	PVALUE
	MOV	BX,[CMTEND]
	ADD	BX,2
	CALL	PVALUE
	CALL	PCRLF
STAT1:	CALL	CMTSTA			;SYMBOL COMMENTS ON/OFF
	CALL	MSG			;HELP REMINDER
	DB	CR,'Type H for Help',CR,0
	JMP	GETCMD

;PRINT THE STATUS MESSAGE OF THE SYMBOL COMMENTS FACILITY
;
CMTSTA:	CALL	MSG			;PRINT STATUS OF SYMBOL COMMENTS
	DB	'Symbol Comments are ',0
	CMP	BYTE PTR [XCSW],0
	JE	CMNTS1
	CALL	MSG
	DB	'ON',0
	JMP	SHORT CMNTS2
CMNTS1:	CALL	MSG
	DB	'OFF',0
CMNTS2:	JMP	PCRLF

;PRINT PARAMETERS OF CONTROL TABLE
;
CTLPRM:	CALL	MSG
	DB	'CONTROL TABLE : ',0
	MOV	BX,OFFSET CTLTBL	;PRINT START ADDRESS
	CALL	PVALUE
	MOV	DX,EMRKVAL		;FIND END MARKER
	CALL	CTLSCH
	ADD	BX,2
	CALL	PVALUE			;PRINT END ADDRESS
	JMP	PCRLF

;COMMAND: T
;TOGGLE EXTENDED COMMENTS FLAG
;
TOGGL:	XOR	BYTE PTR [XCSW],0FFH
	CALL	CMTSTA
	JMP	GETCMD

;COMMAND: F
;FIND WORD VALUE
;
FIND:	MOV	BX,OFFSET INBUF+3
	MOV	AL,[BX]
	CMP	AL,CR			;<CR> : CONTINUE PREVIOUS FIND
	JE	FIND1
	CALL	CNVRT			;GET VALUE TO LOOK FOR
	MOV	[FNDVAL],DX
	MOV	DX,[OFFS]		;SET DEFAULT START ADDRESS
	MOV	[FNDPC],DX
	CMP	AL,CR			;<CR>: START SEARCH
	JE	FIND1
	CMP	AL,','			;NEED ','
	JNE	FINDZ
	INC	BX			;GET START ADDRESS FOR FIND
	CALL	CNVRT
	CMP	AL,CR			;NEED <CR>
	JNE	FINDZ
	ADD	DX,[OFFS]
	MOV	[FNDPC],DX

;FIND WORD VALUE
;
FIND1:	MOV	DX,[FNDVAL]
FIND2:	CALL	BRKCHK			;CHECK FOR BREAK
	MOV	BX,[FNDPC]
	INC	WORD PTR [FNDPC]
	CMP	[BX],DX
	JNE	FIND2			;NO MATCH: CONTINUE
	SUB	BX,[OFFS]		;MATCH	 : PRINT RELATIVE ADDRESS
	CALL	PVALUE
	JMP	SHORT FIND2		;	   THEN CONTINUE
FINDZ:	JMP	WHAT			;ERROR EXIT

;COMMAND: Z
;CLOSE THE FILE
;
CLSASM:	CALL	HSYM			;POSSIBLE END LABEL
	CALL	DCRLF			;POSSIBLE PENDING COMMENT
	CALL	XEPILG			;LANGUAGE DEPENDANT EPILOG
	CALL	PSTG			;END STATEMENT
	DB	TAB,'END',TAB,0
IF INTEL86
	CALL	PSTG
	DB	'CSEG:',0
ENDIF
	MOV	DX,INITPC
	CALL	SYMSCH
	JC	CLSAS1
	CALL	PRTSTR
	CALL	PDERTN
	JMP	SHORT CLSAS2
CLSAS1:	CALL	PTWHEX
CLSAS2:	CALL	PCRLF
	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	CMP	BYTE PTR [ASMOPN],0	;IF FILE WAS OPEN
	JE	CLSASX
	CALL	WRCLS			;  FLUSH AND CLOSE FILE
	MOV	BYTE PTR [ASMOPN],0
	CALL	MSG
	DB	'++ ASM File Closed',CR,0
CLSASX:	JMP	GETCMD

;COMMAND: R
;READ A FILE OR FILES
;
READ:	CALL	SETFCB			;CHECK IF OPEN, SET UP FCB
	MOV	SI,OFFSET TPALL		;ALL ?
	CALL	CMPEXT
	JNZ	READ1
	CALL	RDALL
	JMP	STAT
READ1:	MOV	SI,OFFSET TPCTL		;CTL ?
	CALL	CMPEXT
	JNZ	READ2
	CALL	RDCTL
	JMP	STAT
READ2:	MOV	SI,OFFSET TPCMT		;CMT ?
	CALL	CMPEXT
	JNZ	READ3
	CALL	RDCMT
	JMP	STAT
READ3:	MOV	SI,OFFSET TPSYM		;SYM ?
	CALL	CMPEXT
	JNZ	READ4
	CALL	RDSYM
	JMP	STAT
READ4:	MOV	SI,OFFSET TPCOM		;COM ?
	CALL	CMPEXT
	JNZ	READ5
	CALL	RDCOM
	JMP	STAT
READ5:	JMP	WHAT			;ERROR IF UNKNOWN TYPE

;READ ALL FILES
;
RDALL:	MOV	SI,OFFSET TPCTL
	CALL	RDINIT
	CALL	RDCTL

	CMP	WORD PTR [CMTBEG],0	;READ COMMENTS ONLY IF BUFFER DEFINED
	JE	RDALL1
	MOV	SI,OFFSET TPCMT
	CALL	RDINIT
	CALL	RDCMT

RDALL1:	MOV	SI,OFFSET TPSYM	
	CALL	RDINIT
	CALL	RDSYM

IF	QRDCOM
	CALL	MSG
	DB	'Read in COM File (Y/N)? ',0
	CALL	CHIN
	CMP	AL,'Y'
	JNE	RDALLX
ENDIF
	MOV	SI,OFFSET TPCOM
	CALL	RDINIT
	CALL	RDCOM
RDALLX:	RET

;PREPARE FILE READ
;IN :	SI	ADDRESS OF FILE EXTENT
;
RDINIT:	CALL	CPYEXT			;COPY FILE EXTENT INTO FCB
	CALL	MSG			;TELL USER WHAT IS HAPPENING
	DB	'Reading ',0
	JMP	PTTYPE

;READ CONTROL TABLE
;
RDCTL:	MOV	DI,OFFSET CTLTBL	;DI= TABLE PTR
	CALL	RDOPN			;OPEN FILE
	JNZ	RDCTLX			;RETURN IF FILE NOT FOUND
RDCTL1:	CALL	RDCHR			;READ CHAR
	CMP	AL,1AH			;EXIT IF <EOF>
	JE	RDCTLX
	CMP	AL,CR			;SKIP <CR>,<LF>
	JE	RDCTL1
	CMP	AL,LF
	JE	RDCTL1
	CALL	RDNUM			;READ ADDRESS
	MOV	AX,DX
	STOSW
	CALL	RDCHR			;READ CONTROL CODE CHARACTER
	STOSB
	JMP	SHORT RDCTL1		;NEXT ENTRY
RDCTLX:	MOV	WORD PTR [DI],EMRKVAL	;STORE END MARKER
	RET
ERREOF:	CALL	MSG			;ERROR EXIT
	DB	'++ Unexpected EOF',CR,0
	JMP	GETCMD

;READ COMMENT TABLE
;
RDCMT:	CALL	CMTCHK			;MAKE SURE COMMENTS AREA DEFINED
	MOV	DI,[CMTBEG]		;DI= COMMENT TABLE PTR
	CALL	RDOPN			;OPEN FILE
	JNZ	RDCMT4			;RETURN IF FILE NOT FOUND
RDCMT1:	CALL	RDCHR			;READ CHAR
	CMP	AL,1AH			;RETURN IF EOF
	JE	RDCMT4
	CMP	AL,TAB			;IGNORE <TAB>, <CR>, <LF>
	JE	RDCMT1
	CMP	AL,CR
	JE	RDCMT1
	CMP	AL,LF
	JE	RDCMT1
	CALL	RDNUM			;READ ADDRESS
	MOV	AX,DX
	STOSW
	PUSH	DI			;SAVE PT TO CHAR COUNT
	INC	DI			;SKIP CHAR COUNT
	MOV	CH,0			;COUNT CHARS IN SYMBOL
RDCMT2:	CALL	RDCHR			;GET CHAR
	CMP	AL,CR			;DONE IF <CR>
	JE	RDCMT3
	STOSB				;STORE BYTE
	INC	CH			;INCR CHAR COUNT
	JMP	SHORT RDCMT2		;LOOP
RDCMT3:	POP	BX			;STORE CHAR COUNT
	MOV	[BX],CH
	JMP	RDCMT1
RDCMT4:	MOV	[CMTEND],DI		;SAVE END ADDRESS
	MOV	WORD PTR [DI],EMRKVAL	;STORE END MARKERS
	MOV	BYTE PTR [DI+2],EMRKCNT
	RET

;READ THE SYMBOL TABLE FROM DISK
;
RDSYM:	MOV	DI,OFFSET SYMTBL	;DI = SYMBOL TABLE PTR
	CALL	RDOPN			;OPEN FILE
	JNZ	RDSYM4			;RETURN IF FILE NOT FOUND
RDSYM1:	CALL	RDCHR			;READ CHAR
	CMP	AL,1AH			;RETURN IF EOF
	JE	RDSYM4
	CMP	AL,TAB			;IGNORE <TAB>, <CR>, <LF>
	JE	RDSYM1
	CMP	AL,CR
	JE	RDSYM1
	CMP	AL,LF
	JE	RDSYM1
	CALL	RDNUM			;READ ADDRESS
	MOV	AX,DX
	STOSW
	PUSH	DI			;SAVE PT TO CHAR COUNT
	INC	DI			;SKIP CHAR COUNT
	MOV	CH,0			;COUNT CHARS IN SYMBOL
RDSYM2:	CALL	RDCHR			;GET NEXT BYTE
	CMP	AL,TAB			;DONE IF <TAB> OR <CR>
	JE	RDSYM3
	CMP	AL,CR
	JE	RDSYM3
	STOSB				;STORE CHAR
	INC	CH			;INCR CHAR COUNT
	JMP	SHORT RDSYM2		;LOOP
RDSYM3:	POP	BX			;STORE CHAR COUNT
	MOV	[BX],CH
	JMP	RDSYM1
RDSYM4:	MOV	[SYMEND],DI		;SAVE END ADDRESS
	MOV	BYTE PTR [DI+2],EMRKCNT	;STORE END MARKER
	RET

;READ IN COM FILE
;
RDCOM:	CALL	RDOPN			;OPEN COM FILE FOR READ
	JNZ	RDCOMX			;RETURN IF FILE NOT FOUND
	MOV	DX,[OFFS]		;DX=OFFS
	CMP	DX,OFFSET SYMTBL+STBSIZ	;CHECK FOR OVERWRITE OF SYMBOL TABLE
	JC	RDCOMZ
	ADD	DX,INITPC		;SET DMA ADDRESS TO OFFSET + INITPC
RDCOM2:	PUSH	DX
	MOV	AH,1AH			;SET THE DMA ADDRESS
	INT	21H
	MOV	DX,OFFSET FCB		;READ A RECORD
	MOV	AH,14H
	INT	21H
	POP	DX
	ADD	DX,RECLEN		;PT TO NEXT BLOCK FOR READ
	OR	AL,AL			;DONE?
	JZ	RDCOM2			;  NO: CONTINUE
RDCOM3:	SUB	DX,[OFFS]		;SAVE RELATIVE END ADDRESS
	MOV	[RELEND],DX
	MOV	DX,OFFSET DMABUF	;RESET THE DMA ADDRESS
	MOV	AH,1AH
	INT	21H
RDCOMX:	RET

;ERROR -- ATTEMPT TO OVERLAY THE SYMBOL TABLE OR DISASSEMBLER
;
RDCOMZ:	CALL	MSG
	DB	'++ NO, that would overlay the Disassembler',CR
	DB	'   because the Offset is too small: ',0
	CALL	OFSPRN
	CALL	MSG
	DB	CR,0
	RET

;READ NUMBER FROM DISK FILE (1ST HEX DIGIT IN AL ON ENTRY)
;VALUE RETURNED IN DX
;
RDNUM:	MOV	DX,0			;INIT NUMBER TO ZERO
RDNUM1:	CMP	AL,' '			;DONE IF <SP>
	JE	RDNUMX
	CMP	AL,','			;OR ','
	JE	RDNUMX
	CMP	AL,1AH			;ERROR IF EOF
	JE	RDNUMZ
	CMP	AL,'9'+1		;WITHIN DIGIT RANGE?
	JB	RDNUM2			;IS A DIGIT
	SUB	AL,7			;CONVERT 'A' TO 'F' TO '9'+1 TO 'E'+1
RDNUM2:	SUB	AL,'0'			;CONVERT TO BINARY IN AX
	XOR	AH,AH
	ADD	DX,DX			;*2
	ADD	DX,DX			;*4
	ADD	DX,DX			;*8
	ADD	DX,DX			;*16
	ADD	DX,AX			;+AX
	CALL	RDCHR
	CMP	AL,1AH
	JNE	RDNUM1
RDNUMZ:	JMP	ERREOF			;ERROR EXIT
RDNUMX:	RET				;NORMAL EXIT

;COMMAND: S
;SAVE FILES
;
SAVE:	CALL	SETFCB			;CHECK IF OPEN, SET UP FCB
	MOV	SI,OFFSET TPALL		;ALL ?
	CALL	CMPEXT
	JNZ	SAVE1
	JMP	SVALL
SAVE1:	MOV	SI,OFFSET TPCTL		;CTL ?
	CALL	CMPEXT
	JNZ	SAVE2
	CALL	SVCTL
	JMP	GETCMD
SAVE2:	MOV	SI,OFFSET TPCMT		;CMT ?
	CALL	CMPEXT
	JNZ	SAVE3
	CALL	SVCMT
	JMP	GETCMD
SAVE3:	MOV	SI,OFFSET TPSYM		;SYM ?
	CALL	CMPEXT
	JNZ	SAVE4
	CALL	SVSYM
	JMP	GETCMD
SAVE4:	MOV	SI,OFFSET TPASM		;ASM?
	CALL	CMPEXT
	JNZ     SAVE5
	CALL	SVASM
	JMP	GETCMD
SAVE5:	JMP	WHAT			;ERROR IF NOT ASM AT THIS POINT

;SAVE ALL FILES
;
SVALL:	MOV	SI,OFFSET TPCTL		;SAVE CTL FILE
	CALL	SVINIT
	CALL	SVCTL

	CMP	WORD PTR [CMTBEG],0
	JE	SVALL1
	MOV	SI,OFFSET TPCMT		;SAVE CMT FILE IF TABLE IS DEFINED
	CALL	SVINIT
	CALL	SVCMT

SVALL1:	MOV	SI,OFFSET TPSYM		;SAVE SYM FILE
	CALL	SVINIT
	CALL	SVSYM

	CALL	MSG			;OPTIONALLY SAVE ASM FILE
	DB	'Create a New ASM File (Y/N)? ',0
	CALL	CHIN			;GET CHAR
	CMP	AL,'Y'
	JNE	SVALLX
	MOV	SI,OFFSET TPASM		;SAVE ASM FILE
	CALL	CPYEXT
	CALL	SVASM
SVALLX:	JMP	GETCMD

;PREPARE FILE SAVE
;IN :	SI	ADDRESS OF FILE EXTENT
;
SVINIT:	CALL	CPYEXT			;COPY FILE EXTENT INTO FCB
	CALL	MSG			;TELL USER WHAT IS HAPPENING
	DB	'Saving ',0
	JMP	PTTYPE

;SAVE CONTROL TABLE
;
SVCTL:	CALL	WROPN			;OPEN FILE
	MOV	SI,OFFSET CTLTBL	;PT TO TABLE
SVCTL1:	LODSW				;GET ADDRESS IN DX
	CMP	AX,EMRKVAL		;CHECK FOR END OF TABLE
	JE	SVCTL2
	CALL	WRNUM			;OUTPUT ADDRESS IN DE AS 4 HEX CHARS
	MOV	AL,','			;OUTPUT COMMA
	CALL	WRCHR
	LODSB				;OUTPUT CONTROL MODE CHAR
	CALL	WRCHR
	CALL	WRCRLF			;OUTPUT NEW LINE
	JMP	SHORT SVCTL1
SVCTL2:	JMP	WRCLS			;FLUSH AND CLOSE FILE

;SAVE COMMENTS
;
SVCMT:	CALL	CMTCHK			;CHECK IF TABLE IS DEFINED
	MOV	BX,[CMTEND]		;SET NULL FINAL COMMENT
	MOV	WORD PTR [BX+2],0
	MOV	SI,[CMTBEG]		;PT TO COMMENT TABLE
	JMP	SHORT SVTBL		;SAVE TABLE

;SAVE SYMBOL TABLE
;
SVSYM:	MOV	SI,OFFSET SYMTBL	;PT TO SYMBOL TABLE
;;	JMP	SHORT SVTBL		;SAVE TABLE

;SAVE TABLE AT ADDRESS SI
;
SVTBL:	CALL	WROPN			;OPEN THE FILE
SVTBL1:	LODSW				;GET SYMBOL VALUE
	CMP	BYTE PTR [SI],EMRKCNT	;CHECK END OF TABLE
	JE	SVTBL4
SVTBL2:	CALL	WRNUM			;VALUE
	MOV	AL,' '
	CALL	WRCHR
	LODSB				;CX= SYMBOL NAME LENGTH
	MOV	CL,AL
	XOR	CH,CH
SVTBL3:	LODSB				;SYMBOL NAME
	CALL	WRCHR
	LOOP	SVTBL3
	CALL	WRCRLF			;NEW LINE
	JMP	SHORT SVTBL1
SVTBL4:	JMP	WRCLS			;FLUSH AND CLOSE FILE

;SAVE ASM FILE
;
SVASM:	CALL	WROPN			;OPEN FILE
	MOV	BYTE PTR [ASMOPN],1
	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	CALL	MSG			;PRINT MESSAGE
	DB	'++ Writing ASM Enabled',CR
	DB	'   Use Z Command or E Control to Close File',CR,0
	RET

;COMMAND: C
;CONTROL TABLE ENTRIES ARE MADE HERE
;
CNTRL:	MOV	SI,OFFSET CTLTBL	;ASSUME DUMP OF ENTIRE CTL TABLE
	MOV	BX,OFFSET INBUF+3
	MOV	AL,[BX]
	CMP	AL,CR			;<CR> : DUMP FROM START OF TABLE
	JE	CNTRL1
	CALL	CNVRT			;GET ADDRESS (1ST OPERAND) IN DX
	CMP	AL,','			;',' : READ 2ND OPERAND
	JE	CNTRL2
	CMP	AL,CR			;ELSE NEED <CR>
	JNE	CNTRLZ
	CALL	CTLSCH			;SEARCH FIRST TABLE ENTRY >= DX
	MOV	SI,BX
CNTRL1:	CALL	CTLDMP			;DUMP CONTROL TABLE ON SCREEN
	JMP	SHORT CNTRLX
CNTRL2:	MOV	AL,[BX+1]		;GET CONTROL TYPE (2ND OPERAND) IN AL
	CMP	BYTE PTR [BX+2],CR	;NEED <CR>
	JNE	CNTRLZ
	MOV	DI,OFFSET CMODES	;CHECK IF KNOWN TYPE
	MOV	CX,CMCNT
	REPNE	SCASB
	JNZ	CNTRLZ
	CALL	CTLUPD			;PROCESS COMMAND
CNTRLX:	CALL	CTLPRM			;PRINT CTL TABLE INFO
	JMP	GETCMD			;NORMAL EXIT
CNTRLZ:	JMP	WHAT			;ERROR EXIT

;DUMP CONTROL TABLE STARTING AT ENTRY ADDRESS SI
;
CTLDMP:	MOV	BYTE PTR [ENTCNT],1	;INIT ENTRY COUNT
CTLDM1:	CALL	BRKCHK			;CHECK FOR BREAK
	LODSW				;GET CONTROL ENTRY ADDRESS
	CMP	AX,EMRKVAL		;EXIT ON END OF TABLE
	JE	CTLDMX

	MOV	DX,AX			;SAVE ADDRESS IN DX
	CALL	SYMSCH			;SEARCH FOR SYMBOL
	JC	CTLDM3

	CALL	PCRLF			;MATCH:	PRINT SYMBOL ON NEW LINE
	MOV	BYTE PTR [ENTCNT],CTLCNT
	MOV	CL,SYMMAX+1		;	COMPUTE NR OF TRAILING SPACES
	SUB	CL,CH
	CALL	PRTSTR			;	SYMBOL
	CALL	PCOLON			;	COLON
CTLDM2:	CALL	PSPACE			;	TRAILING SPACES
	LOOP	CTLDM2
	JMP	SHORT CTLDM5

CTLDM3:	MOV	CX,2			;NO MATCH: ASSUME 2 SPACES
	DEC	BYTE PTR [ENTCNT]	;	CHECK IF WE NEED A NEW LINE
	JNZ	CTLDM4
	CALL	PCRLF
	MOV	BYTE PTR [ENTCNT],CTLCNT
	MOV	CX,SYMMAX+2		;	IF SO, SKIP SYMBOL FIELD
CTLDM4:	CALL	PSPACE			;	PRINT CX SPACES
	LOOP	CTLDM4

CTLDM5:	MOV	BX,DX			;PRINT ADDRESS
	CALL	PVALUE
	LODSB				;PRINT CONTROL MODE LETTER
	CALL	COUT
	JMP	SHORT CTLDM1		;NEXT SYMBOL

CTLDMX:	JMP	PCRLF			;DONE

;INSERT, REPLACE OR KILL A CONTROL TABLE ENTRY
;IN:	DX	CONTROL ADDRESS
;	AL	CONTROL MODE CHAR
;
CTLUPD:	CMP	AL,'K'			;KILL?
	JE	CTLDEL			;  YES:	DELETE
	CALL	CTLSCH			;  NO :	MATCH?
	JC	CTLINS			;	NO : INSERT
	MOV	[BX+2],AL		;	YES: REPLACE
	RET

;DELETE THE ENTRY FROM THE CONTROL TABLE
;IN:	DX	CONTROL ADDRESS
;
CTLDEL:	CALL	CTLSCH			;SEARCH CONTROL ENTRY
	JC	CNTRLZ			;NO MATCH: ERROR
	MOV	DI,BX			;DI= TARGET ENTRY PTR
	MOV	SI,DI			;SI= NEXT ENTRY PTR
	ADD	SI,3
	MOV	AX,EMRKVAL		;AX = END OF TABLE MARKER
CTDL1:	CMP	[DI],AX			;WHILE NOT AT END OF TABLE
	JE	CTDL2
	MOV	CX,3			;  COPY 3 BYTES DOWN
	REP	MOVSB
	JMP	SHORT CTDL1		;END WHILE
CTDL2:	RET

;INSERT AN ENTRY INTO THE CONTROL TABLE
;IN :	BX	PT TO CONTROL ENTRY TO INSERT BEFORE
;	DX	CONTROL ADDRESS
;	AL	CONTROL MODE CHARACTER
;
CTLINS:	PUSH	DX			;SAVE CONTROL ADDRESS
	PUSH	AX			;SAVE CONTROL MODE CHARACTER
	MOV	AX,BX			;SAVE ADDRESS TO INSERT AT
	MOV	DX,EMRKVAL		;FIND END OF TABLE
	CALL	CTLSCH
	MOV	SI,BX			;SI = ADDRESS CURRENT TABLE TOP
	ADD	SI,2
	MOV	DI,SI			;DI = ADDRESS NEW TABLE TOP
	ADD	DI,3
	MOV	CX,SI			;CX = NR OF BYTES TO MOVE UP
	INC	CX
	SUB	CX,AX
	STD				;DIRECTION FLAG DOWNWARD
	REP	MOVSB			;MOVE ENTRIES UP TO MAKE ROOM
	POP	AX			;PLACE CONTROL MODE CHARACTER
	STOSB
	POP	AX			;PLACE CONTROL ADDRESS
	DEC	DI
	STOSW
	CLD				;DIRECTION FLAG UPWARD AGAIN
	RET

;SEARCH CONTROL TABLE ENTRY >= DX
;
;IN :	DX	CONTROL ADDRESS
;OUT:	BX	PTS TO FIRST CONTROL TABLE ENTRY MATCHING OR ABOVE DX
;	FLAGS	MATCH	: C=0
;		NO MATCH: C=1
;
CTLSCH:	MOV	BX,OFFSET CTLTBL - 3
CTLSC1:	ADD	BX,3
	CMP	DX,[BX]
	JA	CTLSC1
	RET

;COMMAND: ;
;LIST, ADD/REPLACE OR DELETE COMMENTS
;
CMNT:	CALL	CMTCHK			;VERIFY COMMENTS ARE ACTIVE
	MOV	SI,[CMTBEG]		;ASSUME LIST OF ALL COMMNENTS
	MOV	BX,OFFSET INBUF+3	;BX= COMMAND PTR
	CMP	BYTE PTR [BX],CR	;<CR>: LIST ALL COMMENTS
	JE	CMNT1
	CALL	CNVRT			;DX= ADDRESS
	CMP	AL,','			;',' : ADD/DELETE COMMENT
	JE	CMNT4
	CMP	AL,CR			;ELSE NEED <CR>
	JNE	CMNTZ
	CALL	CMTSCH			;FIND COMMENT ENTRY TO START LISTING
CMNT1:	CALL	CMTLST			;LIST COMMENTS
	JMP	SHORT CMNTX
CMNT4:	INC	BX			;PT TO COMMENT TEXT
	CALL	CMTUPD			;UPDATE COMMENT TABLE
CMNTX:	JMP	GETCMD			;NORMAL EXIT
CMNTZ:	JMP	WHAT			;ERROR EXIT

;DUMP COMMENT TABLE
;
;IN :	SI	PTR TO COMMENT TABLE ENTRY TO START LISTING
;
CMTLST:	CALL	BRKCHK			;CHECK FOR BREAK
	LODSW				;AX= COMMENT ADDRESS
	CMP	AX,EMRKVAL		;EXIT ON END OF TABLE
	JE	CMTLSX
	MOV	BX,AX			;PRINT ADDRESS
	CALL	PVALUE
	LODSB				;CX= CHAR COUNT
	MOV	CL,AL
	XOR	CH,CH
CMTLS1:	LODSB				;PRINT COMMENT TEXT
	CALL	COUT
	LOOP	CMTLS1
	CALL	PCRLF			;PRINT NEW LINE
	JMP	SHORT CMTLST		;NEXT ENTRY
CMTLSX:	RET

;UPDATE COMMENT TABLE
;
;IN :	DX	ADDRESS OF COMMENT
;	BX	PT TO COMMENT TEXT (ENDED WITH <CR>)
;
;DELETES ANY EXISITING COMMENT ENTRY FOR ADDRESS DX
;THEN ADDS NEW ENTRY IF THE COMMENT TEXT IS NOT EMPTY
;
CMTUPD:	CALL	CMTSCH			;SEARCH EXISTING COMMENT ENTRY
	JC	CMTUP1
	CALL	CMTDEL			;DELETE IT IF PRESENT
CMTUP1:	CMP	BYTE PTR [BX],CR	;TEST FOR EMPTY COMMENT TEXT
	JE	CMTUPX
	CALL	CMTADD			;ADD IF NOT EMPTY
CMTUPX:	RET

;DELETE A COMMENT ENTRY
;
;IN :	SI	PTR TO COMMENT ENTRY TO DELETE
;
CMTDEL:	CMP	SI,[CMTEND]		;RETURN IF AT END OF TABLE
	JE	CMTDLX
	MOV	DI,SI			;DI = ADDRESS OF ENTRY TO DELETE
	ADD	SI,2			;SI = ADDRESS OF NEXT ENTRY
	LODSB
	XOR	AH,AH
	ADD	SI,AX
	MOV	CX,[CMTEND]		;CX = NUMBER OF CHARS TO COPY
	ADD	CX,3			;     INCLUDING END MARKER
	SUB	CX,SI
	REP	MOVSB			;COPY DOWN
	SUB	DI,3
	MOV	[CMTEND],DI		;UPDATE TABLE END POINTER
CMTDLX:	RET	

;ADD COMMENT TO COMMENT TABLE
;
;IN :	BX	PTR TO COMMENT TEXT TO ADD
;	DX	COMMENT ADDRESS
;
CMTADD:	MOV	DI,[CMTEND]		;PT TO END OF COMMENT TABLE
	MOV	AX,DX			;STORE COMMENT ADDRESS
	STOSW
	PUSH	DI			;SAVE ADDRESS TO CHAR COUNT OF COMMENT
	INC	DI			;DI=TEXT DESTINATION
	MOV	SI,BX			;SI=TEXT SOURCE
	MOV	CH,0			;INIT CHAR COUNT
CMTAD1:	LODSB				;COPY UP TO BUT NOT INCLUDING <CR>
	CMP	AL,CR
	JE	CMTAD2
	STOSB
	INC	CH
	JMP	SHORT CMTAD1
CMTAD2:	MOV	[CMTEND],DI		;UPDATE TABLE END POINTER
	MOV	WORD PTR [DI],EMRKVAL	;ADD END MARKER
	MOV	BYTE PTR [DI+2],EMRKCNT
	POP	DI			;GET PTR TO COMMENT CHAR COUNT
	MOV	[DI],CH			;SAVE CHAR COUNT
	RET

;SEARCH A COMMENT AT THE ADDRESS IN DX
;
;IN :	DX	ADDRESS TO SEARCH FOR
;OUT:	CARRY	NC = MATCH, C = NO MATCH
;	SI	PTR TO COMMENT ENTRY (PTR TO END MARKER IF NO MATCH)
;
CMTSCH:	MOV	SI,[CMTBEG]		;SI= TABLE PTR
CMTSC1:	LODSW				;GET TABLE ENTRY ADDRESS
	CMP	AX,EMRKVAL		;END OF TABLE: RETURN NO MATCH
	JE	CMTSC2
	CMP	AX,DX			;FOUND: RETURN MATCH
	JE	CMTSC3
	LODSB				;ELSE SKIP TO NEXT ENTRY
	SUB	AH,AH
	ADD	SI,AX
	JMP	SHORT CMTSC1		;NEXT ENTRY
CMTSC2:	STC
CMTSC3:	DEC	SI
	DEC	SI
	RET

;CHECK IF COMMENT AREA IS DEFINED
;ABORT WITH ERROR MESSAGE IF NOT
;
CMTCHK:	CMP	WORD PTR [CMTBEG],0	;BX=START ADDRESS
	JE	CMTCH1			;ERROR IF ZERO
	RET
CMTCH1:	CALL	MSG
	DB	'++ COMMAND IGNORED',CR
	DB	'   Issue Unnnn to tell DASM to use address nnnn',CR
	DB	'   as the start of the comments table',CR,0
	JMP	GETCMD

;COMMAND: U
;DEFINE THE COMMENTS AREA
;
UAREA:	MOV	BX,OFFSET INBUF+3	;CHECK ARGS
	MOV	AL,[BX]
	CMP	AL,CR			;ERROR IF JUST <CR>
	JE	UAREAZ
	CMP	AL,'.'			;ERROR IF SYMBOL
	JE	UAREAZ
	CALL	CNVRT			;GET ADDRESS IN BX
	CMP	AL,CR			;NEED <CR>
	JNE	UAREAZ
	MOV	BX,DX
	AND	BX,BX			;IF ADDRESS=0 : DISABLE COMMENTS
	JZ	UAREA1
	CMP	BX,OFFSET SYMTBL+STBSIZ	;ELSE ALLOW FOR SYMBOL TABLE
	JB	UAREAY			;ERROR IF LESS
	MOV	[CMTEND],BX		;SET END ADDRESS = BEGIN ADDRESS
	MOV	WORD PTR [BX],EMRKVAL	;SET END MARKER
	MOV	BYTE PTR [BX+2],EMRKCNT
UAREA1:	MOV	[CMTBEG],BX		;SET BEGIN ADDRESS
	JMP	GETCMD
UAREAY:	CALL	MSG			;RANGE ERROR
	DB	'NO!! Address must be at least '
	DB	0
	MOV	BX,OFFSET SYMTBL+STBSIZ
	CALL	PVALUE
	CALL	PCRLF
	JMP	GETCMD
UAREAZ:	JMP	WHAT			;COMMAND ERROR

;COMMAND: E
;PLACE A SYMBOL IN THE SYMBOL TABLE
;	
NTER:	MOV	BX,OFFSET INBUF+3	;BX= COMMAND PTR
	CALL	CNVRT			;GET VALUE
	CMP	AL,','			;NEED ','
	JNE	NTERZ
	INC	BX			;GET SYMBOL PTR
	CMP	BYTE PTR [BX],'.'	;CHECK '.'
	JNE	NTERZ
	PUSH	DX			;SAVE THE SYMBOL'S VALUE
	PUSH	BX			;SAVE THE COMMAND PTR
	CALL	SYMSCH			;CHECK IF SYMBOL EXISTS
	JC	NTER2			;NO: NOTHING TO DELETE
	PUSH	BX			;SAVE SYMTBL TEXT PTR
	CALL	PCRLF			;PRINT MESSAGE THAT SYMBOL WAS KILLED
	CALL	PRTSTR
	CALL	MSG
	DB	' was Killed',CR,0
	POP	BX			;BX= SYMTBL TEXT PTR
	SUB	BX,3
	CALL	SYMDEL			;KILL SYMBOL
NTER2:	POP	BX			;BX= COMMAND PTR
	CALL	SYMPRS			;COMPUTE LENGTH OF SYMBOL IN CH
					;BX= START OF SYMBOL TEXT IN COMMAND
	CMP	CH,SYMMAX		;CHECK FOR SYMBOL TOO LONG
	JBE	NTER3
	MOV	BYTE PTR [BX+SYMMAX],0
	MOV	CH,SYMMAX		;CH=SYMMAX
NTER3:	POP	DX			;DX= SYMBOL VALUE
	CALL	SYMINS			;INSERT SYMBOL INTO SYMBOL TABLE
	JMP	GETCMD
NTERZ:	JMP	WHAT			;ERROR EXIT

;COMMAND: K
;DELETE A SYMBOL FROM THE TABLE
;
KILL:	MOV	BX,OFFSET INBUF+3	;BX = COMMAND PTR
	CMP	BYTE PTR [BX],'.'	;NEED '.'
	JNE	KILLZ
	CALL	SYMPRS			;CH= LENGTH OF SYMBOL NAME
	CALL	SYMFND			;FIND SYMBOL
	JC	KILLZ			;ERROR IF NOT FOUND
	CALL	SYMDEL			;KILL SYMBOL
	JMP	GETCMD
KILLZ:	JMP	WHAT			;ERROR EXIT

;DELETE THE SYMBOL FROM SYMTBL
;
;IN :	BX	PTR TO SYMTBL ENTRY
;
SYMDEL:	CMP	BX,[SYMEND]		;RETURN IF AT END OF TABLE
	JE	SYMDLX
	MOV	DI,BX			;DI = ADDRESS OF ENTRY TO DELETE
	MOV	SI,BX
	ADD	SI,2
	LODSB
	XOR	AH,AH
	ADD	SI,AX			;SI = ADDRESS OF NEXT ENTRY
	MOV	CX,[SYMEND]		;CX = NUMBER OF CHARS TO COPY
	ADD	CX,3			;     INCLUDING END MARKER
	SUB	CX,SI
	REP	MOVSB			;COPY DOWN
	SUB	DI,3
	MOV	[SYMEND],DI		;UPDATE TABLE END POINTER
SYMDLX:	RET	

;PARSE SYMBOL NAME
;
;IN :	BX	PTR TO DOT BEFORE SYMBOL NAME IN COMMAND STRING
;OUT:	BX	PTR TO FIRST CHAR OF SYMBOL NAME IN COMMAND STRING
;	CH	SYMBOL NAME LENGTH
;	DX	PTR TO CHAR FOLLOWING SYMBOL NAME IN COMMAND STRING
;
SYMPRS:	INC	BX			;PT TO FIRST CHAR
	MOV	CH,0			;INIT LENGTH
	PUSH	BX
SYMPR1:	MOV	AL,[BX]			;GET CHAR
	INC	BX			;PT TO NEXT
	INC	CH			;INCR LENGTH
	CMP	AL,'+'			;CHECK FOR END OF SYMBOL MARK
	JE	SYMPR1
	CMP	AL,'-'
	JE	SYMPR1
	CMP	AL,'$'
	JE	SYMPR1
	CMP	AL,'%'
	JE	SYMPR1
	CMP	AL,'_'
	JE	SYMPR1
	CMP	AL,'0'
	JB	SYMPR2
	CMP	AL,'9'
	JBE	SYMPR1
	CMP	AL,'A'
	JB	SYMPR2
	CMP	AL,'Z'
	JBE	SYMPR1
SYMPR2:	DEC	CH			;COMPENSATE FOR COUNT
	JZ	SYMPRZ			;ERROR IF NO SYMBOL CHARS
	DEC	BX			;BACK UP
	MOV	DX,BX			;PTR TO NEXT CHAR IN DX
	POP	BX			;PT TO FIRST CHAR IN BX
	RET
SYMPRZ:	JMP	WHAT			;ERROR EXIT

;HANDLE SYMBOLS FOR THE DISASSEMBLER; ADDRESS IN PC
;IF A SYMBOL EXISTS AT THIS ADDRESS, AND IT IS NOT A CONSTANT, PRINT LABEL
;
HSYM:	PUSH	AX
	PUSH	BX
	PUSH	DX
	MOV	BYTE PTR [WRTENAB],1	;ENABLE DISK OUTPUT
	MOV	DX,[PC]			;GET PC ADDRESS
	CALL	SYMSCH			;LOOK FOR SYMBOL
	JC	HSYM2			;SKIP IF NO SYMBOL
	CMP	BYTE PTR [BX],CPREF	;SKIP IF SYMBOL IS A CONSTANT
	JE	HSYM2
	MOV	AH,CH			;SAVE CHAR COUNT
	MOV	SI,BX			;SI = BX = SYMBOL NAME PTR
	MOV	CL,CH			;CX = CHAR COUNT
	XOR	CH,CH
HSYM1:	LODSB				;CHECK FOR '+' OR '-'
	CMP	AL,'+'
	JE	HSYM2			;DON'T PRINT IF FOUND
	CMP	AL,'-'
	JE	HSYM2
	LOOP	HSYM1
	MOV	CH,AH			;RESTORE CHAR COUNT
	CALL	PRTSTR			;PRINT THE SYMBOL (PTR STILL IN BX)
	CALL	PCOLON
	CALL	PTAB
	CALL	PDERTN			;PRINT ADDRESS (IN DX) AS A COMMENT
	CALL	PCRLF
HSYM2:	MOV	BYTE PTR [WRTENAB],0	;DISABLE FILE WRITE
	CALL	PSPACE
	CALL	PSPACE
	MOV	BX,[PC]			;PRINT PC VALUE
	CALL	PVALUE
	MOV	BYTE PTR [WRTENAB],1	;ENABLE FILE WRITE
	CALL	PTAB			;TAB FOR MNEMONIC
	MOV	BYTE PTR [COLCNT],0	;COLUMN COUNT STARTS HERE
	POP	DX
	POP	BX
	POP	AX
	RET

;BUILD A SYMBOL AND INSERT IN INTO THE SYMBOL TABLE
;
;IN :	DX	SYMBOL VALUE
;
;USES INBUF AS TEMPORARY STORAGE FOR THE SYMBOL NAME
;
BLDSYM:	MOV	DI,OFFSET INBUF		;PT TO INBUF
	MOV	AL,'L'			;STORE LEADING 'L'
	STOSB
	MOV	AL,DH			;GET VALUE IN DX
	CALL	TOASC			;STORE AS ASCII CHARS IN BUFFER
	MOV	AL,DL
	CALL	TOASC
	MOV	BX,OFFSET INBUF		;PT TO SYMBOL NAME
	MOV	CH,5			;SYMBOL IS 5 CHARS LONG
;;	JMP	SYMINS

;INSERT A SYMBOL ALPHABETICALLY INTO TABLE
;
;IN :	BX	POINTER TO FIRST CHAR OF SYMBOL NAME
;	CH	LENGTH OF SYMBOL NAME
;	DX	SYMBOL VALUE
;
SYMINS:	AND	CH,CH			;EXIT IF LENGTH = 0
	JZ	SYMINX
	MOV	SI,BX			;SI = PTR TO SYMBOL NAME
	CALL	SYMFND			;BX = TABLE POINTER
	JNC	SYMIN1			;IF NAME EXISTS, JUST SET NEW ADDRESS

	MOV	AL,CH			;AX = LENGTH OF SYMBOL NAME 
	XOR	AH,AH
	PUSH	SI			;SAVE PTR TO SYMBOL NAME

	MOV	SI,[SYMEND]
	ADD	SI,2			;SI = PTR TO CURRENT LAST TABLE BYTE
	MOV	DI,SI
	ADD	DI,AX
	INC	DI
	MOV	[SYMEND],DI		;UPDATE TABLE TAIL POINTER
	ADD	DI,2			;DI = PTR TO NEW LAST TABLE BYTE
	MOV	CX,SI
	INC	CX
	SUB	CX,BX			;CX = BYTE COUNT
	STD
	REP	MOVSB			;COPY UP TO MAKE ROOM
	CLD

	POP	SI			;SI = PTR TO SYMBOL NAME
	MOV	DI,BX			;STORE SYMBOL NAME
	ADD	DI,3
	MOV	CX,AX
	REP	MOVSB

	MOV	BYTE PTR [BX+2],AL	;STORE LENGTH OF SYMBOL NAME
SYMIN1:	MOV	[BX],DX			;STORE SYMBOL VALUE
SYMINX:	RET 

;FIND NAME IN SYMBOL TABLE
;
;IN :	BX	SYMBOL NAME POINTER
;	CH	SYMBOL NAME LENGTH
;OUT:	FLAGS	COND C = NO MATCH, NC = MATCH
;	BX	SYMBOL TABLE POINTER WHERE NAME WAS FOUND OR MUST BE INSERTED
;
;CX,DX UNCHANGED
;
SYMFND:	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	SI,OFFSET SYMTBL
	CMP	CH,1			;IF CH=0 (FIND EMPTY STRING)
	JB	SYMFNX			;  RETURN NO MATCH, BX= PT SYMTBL
	MOV	DI,BX
	MOV	DL,CH
	SUB	AH,AH
SYMFN1:	INC	SI			;SKIP SYMBOL VALUE
	INC	SI
	LODSB				;GET SYMBOL LENGTH
	CMP	AL,EMRKCNT
	JE	SYMFN3			;END OF TABLE: RETURN C (NOMATH)
	CALL	SYMCMP
	JA	SYMFN3			;TABLE NAME > NAME: NO MATCH 
	JE	SYMFN4			;TABLE NAME = NAME: MATCH
	ADD	SI,AX			;ELSE	SKIP TO NEXT ENTRY
	JMP	SHORT SYMFN1		;	AND REPEAT COMPARE
SYMFN3:	STC				;NOMATCH: RETURN C
SYMFN4:	DEC	SI
	DEC	SI
	DEC	SI
SYMFNX:	MOV	BX,SI
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	RET

;COMPARE SYMBOL NAMES
;
;IN :	SI	PT TO NAME 1
;	DI	PT TO NAME 2
;	AL	LENGTH OF NAME 1
;	DL	LENGTH OF NAME 2
;OUT:	FLAGS	ACCORDING TO COMPARE <NAME 1> - <NAME 2>
;
;ALSO CHANGES CX
;
SYMCMP:	PUSH 	AX
	PUSH	SI
	PUSH	DI
	MOV	CL,AL			;SET CL = MINIMUM(AL,DL)
	CMP	CL,DL
	JBE	SYMCM1
	MOV	CL,DL
SYMCM1:	XOR	CH,CH			;CX = LENGTH OF SHORTEST STRING
	REPE	CMPSB
	JNE	SYMCM2			;READY IF NOT EQUAL
	CMP	AL,DL			;ELSE LET THE LENGTHS DECIDE
SYMCM2:	POP	DI
	POP	SI
	POP	AX
	RET
;
;SEARCH FOR A SYMBOL WITH VALUE DX
;
;IN :	DX		VALUE
;OUT:	MATCH		CARRY=0
;			CH = CHAR COUNT
;			BX = ADDRESS OF 1ST SYMBOL CHAR
;	NO MATCH	CARRY=1
;
SYMSCH:	MOV	BX,OFFSET SYMTBL	;PT TO SYMBOL TABLE
	XOR	AH,AH
SYMSC1:	MOV	AL,[BX+2]		;AX = LENGTH OF SYMBOL NAME
	CMP	AL,EMRKCNT		;END OF TABLE : NO MATCH
	JE	SYMSC2
	CMP	DX,[BX]			;COMPARE SYMBOL VALUE
	JE	SYMSC3			;MATCH: RETURN NC
	ADD	BX,3			;PT TO NEXT ENTRY
	ADD	BX,AX
	JMP	SHORT SYMSC1		;LOOP BACK
SYMSC2:	STC				;NO MATCH: RETURN C
SYMSC3:	MOV	CH,AL			;CH = CHAR COUNT
	INC	BX			;BX = NAME PTR	(CARRY UNCHANGED)
	INC	BX
	INC	BX
	RET

;STORE BYTE IN 2 DIGITS HEX ASCII
;
;IN :	AL	BYTE VALUE
;	DI	MEMORY STORAGE POINTER
;OUT:	DI	UPDATED TO POINT AFTER LAST STORED CHARACTER
;
TOASC:	PUSH	AX
	CALL	HINIB			;CONVERT HIGH NYBBLE
	STOSB				;STORE IT
	POP	AX
	CALL	LONIB			;CONVERT LOW NYBBLE
	STOSB				;STORE IT
	RET

;CONVERT THE HIGH NIBBLE OF AL TO ASCII CHAR
;
HINIB:	RCR	AL,1			;ROTATE HIGH NYBBLE TO LOW NYBBLE
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1

;CONVERT THE LOW NYBBLE OF AL TO ASCII CHAR
;
LONIB:	AND	AL,0FH			;MASK OUT NEW HIGH NYBBLE
	CMP	AL,10			;CHECK FOR DIGIT
	JB	LONIB1			;SKIP IF SO
	ADD	AL,7			;ADD OFFSET OF 7 FOR '9' TO 'A'
LONIB1:	ADD	AL,'0'			;CONVERT TO ASCII IN AL
	RET

;PRINT BYTE HEX WITH LEADING ZERO IF NEEDED
;
;IN :	AL	BYTE
;
PASHEX:	CMP	AL,0A0H
	JB	PHEX
	MOV	AH,AL
	MOV	AL,'0'
	CALL	COUT
	MOV	AL,AH
;;	JMP	SHORT PHEX

;PRINT BYTE IN 2 HEX DIGITS
;
;IN :	AL	BYTE
;
PHEX:	PUSH	AX
	PUSHF
	CALL	HINIB			;PRINT HIGH NYBBLE
	CALL	COUT
	POPF
	POP	AX
	CALL	LONIB			;PRINT LOW NYBBLE
	JMP	COUT

;PRINT THE 4 HEX CHARACTERS FOR CONTENTS OF BX
;
PVALUE:	MOV	AL,BH			;PRINT HIGH BYTE
	CALL	PHEX
	MOV	AL,BL			;PRINT LOW BYTE
	CALL	PHEX
	JMP	PSPACE

;READ SYMBOL OR HEX LITERAL VALUE FROM COMMAND LINE
;
;IN :	BX	COMMAND LINE POINTER
;OUT:	BX	POSITIONED AFTER LAST CHAR READ
;	AL	[BX]
;	DX	VALUE READ FROM COMMAND LINE
;
CNVRT:	MOV	AL,[BX]			;GET FIRST CHAR
	CMP	AL,'.'			;IT IS A SYMBOL IF '.'
	JE	CNVRT3
	;
	; HEX LITERAL
	;
	MOV	DX,0			;INIT VALUE TO ZERO
	XOR	AH,AH
CNVRT1:	CMP	AL,'0'			;'0'..'9'?
	JB	CNVRTX
	CMP	AL,'9'
	JBE	CNVRT2
	CMP	AL,'A'			;'A'..'F'?
	JB	CNVRTX
	CMP	AL,'F'
	JA	CNVRTX
	SUB	AL,7			;CONVERT FOR 'A'-'F'
CNVRT2:	SUB	AL,'0'			;CONVERT FROM ASCII TO BINARY
	ADD	DX,DX			;*2
	ADD	DX,DX			;*4
	ADD	DX,DX			;*8
	ADD	DX,DX			;*16
	ADD	DX,AX			;+DIGIT VALUE
	INC	BX			;GET NEXT CHAR
	MOV	AL,[BX]
	JMP	SHORT CNVRT1		;CONTINUE
	;
	; SYMBOL
	;
CNVRT3:	CALL	SYMPRS			;DETERMINE LENGTH OF SYMBOL
	PUSH	DX
	CALL	SYMFND			;FIND IT IN TABLE
	JC	CNVRTZ			;ERROR IF NOT FOUND
	MOV	DX,[BX]			;PUT ITS VALUE IN DX
	POP	BX
	MOV	AL,[BX]
CNVRTX:	RET				;NORMAL EXIT
CNVRTZ:	JMP	WHAT			;ERROR EXIT

;OPEN A FILE FOR READING
;RETURNS COND NZ IF FILE NOT FOUND
;
RDOPN:	MOV	DX,OFFSET DMABUF+RECLEN	;SET DMA PTR AT END OF BUFFER
	MOV	[DMAPTR],DX
	MOV	BYTE PTR [FCBNR],0	;SET NEXT RECORD FIELD TO 0
	MOV	DX,OFFSET FCB		;PT TO FCB
	MOV	AH,0FH			;OPEN THE FILE
	INT	21H
	OR	AL,AL			;CHECK IF FILE EXISTS
	JZ	RDOPNX
	PUSHF
	CALL	MSG			;FILE NOT FOUND
	DB	'++ File Not Found'
	DB	CR,0
	POPF
RDOPNX:	RET

;READ NEXT BYTE FROM DISK
;
RDCHR:	PUSH	SI
	MOV	SI,[DMAPTR]
	CMP	SI,OFFSET DMABUF+RECLEN
	JB	RDCHR1
	CALL	RDREC
	MOV	SI,OFFSET DMABUF
	JZ	RDCHR1
	MOV	AL,1AH
	JMP	SHORT RDCHR2
RDCHR1:	LODSB
	MOV	[DMAPTR],SI
RDCHR2:	POP	SI
	RET

;READ DISK RECORD
;RETURN COND NZ ON EOF
;
RDREC:	PUSH	DX
	MOV	DX,OFFSET DMABUF	;SET DMA POINTER
	MOV	[DMAPTR],DX
	MOV	DX,OFFSET FCB
	MOV	AH,14H			;READ RECORD
	INT	21H
	CMP	AL,2			;RETURNCODE >= 2 ?
	JAE	RDREC1			;  THEN READ ERROR
	OR	AL,AL			;  ELSE COND NZ = END OF FILE
	POP	DX
	RET				;NORMAL RETURN

RDREC1:	JNZ	RDREC2			;RC=2 : SEGMENT OVERFLOW
	CALL	MSG
	DB	'++ Segment overflow reading file'
	DB	CR,0
	JMP	GETCMD
RDREC2:	CALL	MSG			;RC=3 : PARTIAL RECORD READ
	DB	'++ Unexpected end of file'
	DB	CR,0
	JMP	GETCMD

;OPEN FILE PTED TO BY FCB FOR OUTPUT
;
WROPN:	MOV	DX,OFFSET FCB		;CREATE FILE
	MOV	AH,16H
	INT	21H
	INC	AL			;ERROR IN CREATING IT?
	JZ	WROPNZ
	MOV	BYTE PTR [FCBNR],0	;SET RECORD FIELD TO ZERO
	MOV	DX,OFFSET DMABUF	;INIT DMA POINTER
	MOV	[DMAPTR],DX
	RET
WROPNZ:	CALL	MSG			;ERROR EXIT
	DB	'++ Can',QUOTE,'t create file'
	DB	CR,0
	JMP	GETCMD

;WRITE <EOF>, FLUSH BUFFER AND CLOSE OUTPUT FILE
;
WRCLS:	MOV	AL,1AH			;APPEND <EOF> CHARACTER
	CALL	WRCHR
	MOV	AX,[DMAPTR]		;DMA BUFFER EMPTY?
	CMP	AX,OFFSET DMABUF
	JE	WRCLS1
	CALL	WRREC			;FLUSH IF NOT
WRCLS1:	MOV	DX,OFFSET FCB		;CLOSE THE FILE
	MOV	AH,10H
	INT	21H
	INC	AL			;ERROR IN CLOSING?
	JZ	ERRCLS
	RET

;WRITE HEX WORD AX TO DISK
;
WRNUM:	PUSH	AX
	MOV	AL,AH			;WRITE HIGH-ORDER BYTE 
	CALL	WRBYTE
	POP	AX
;;	JMP	WRBYTE			;WRITE LOW-ORDER BYTE

;WRITE HEX BYTE AL TO DISK
;
WRBYTE:	MOV	AH,AL
	CALL	HINIB			;WRITE HIGH NIBBLE
	CALL	WRCHR
	MOV	AL,AH
	CALL	LONIB			;WRITE LOW NIBBLE
	JMP	WRCHR

;WRITE <CR> <LF> TO DISK
;
WRCRLF:	MOV	AL,CR
	CALL	WRCHR
	MOV	AL,LF
;;	JMP	WRCHR

;WRITE CHAR TO FILE
;IN :	AL	CHAR
;
WRCHR:	PUSH	DI
	MOV	DI,[DMAPTR]		;STORE CHAR, INCREMENT BUFFER PTR
	STOSB
	MOV	[DMAPTR],DI
	CMP	DI,OFFSET DMABUF+RECLEN	;IF BUFFER FULL
	JB	WRCHRX
	CALL	WRREC			;	WRITE BUFFER
WRCHRX:	POP	DI
	RET

;WRITE RECORD TO DISK
;
WRREC:	PUSH	AX
	PUSH	DX
	MOV	DX,OFFSET FCB		;DO THE WRITE
	MOV	AH,15H
	INT	21H
	OR	AL,AL			;ERROR?
	JNZ	ERRWRT
	MOV	DX,OFFSET DMABUF	;RESET DMA PTR
	MOV	[DMAPTR],DX
	POP	DX
	POP	AX
	RET

;ERROR DURING A WRITE RECORD ATTEMPT
;
ERRWRT:	CALL	MSG
	DB	'++ Write Error',CR,0
	JMP	GETCMD

;ERROR CLOSING FILE
;
ERRCLS:	CALL	MSG
	DB	'++ Close Error',CR,0
	JMP	GETCMD

;VARIOUS COMMON CHARACTER PRINT ROUTINES
;
PSEMI:	MOV	AL,';'
	JMP	COUT

PCOLON:	MOV	AL,':'
	JMP	COUT

PCOMMA:	MOV	AL,','
	JMP	COUT

PTAB:	MOV	AL,TAB
	JMP	COUT

PQUOTE:	MOV	AL,QUOTE
	JMP	COUT

PSPACE:	MOV	AL,' '
	JMP	COUT

;PRINT <CR> <LF>, AFTER PRINTING ANY TRAILING COMMENT POINTED TO BY [CMTPTR]
;
DCRLF:	MOV	SI,[CMTPTR]		;LOOK FOR A COMMENT ADDRESS
	OR	SI,SI
	JZ	DCRLF3
DCRLF0:	CALL	PTAB			;TABULATE COMMENT
	CMP	BYTE PTR [COLCNT],CMTCOL
	JB	DCRLF0
	LODSB				;GET CHAR COUNT
	MOV	CL,AL
	XOR	CH,CH
	JCXZ	DCRLF2			;CHECK FOR NO COMMENT
DCRLF1:	LODSB				;OUTPUT COMMENT
	CALL	COUT
	LOOP	DCRLF1
DCRLF2:	MOV	WORD PTR [CMTPTR],0	;SET NO COMMENT NOW
DCRLF3:	
;;	JMP	PCRLF

;PRINT <CR> <LF>
;
PCRLF:	MOV	AL,CR
	CALL	COUT
	MOV	AL,LF
;;	JMP	COUT

;PRINT CHARACTER
;
;IN :	AL	CHARACTER
;
;THE FOLLOWING ACTIONS DEPENDEND ON FLAG SETTINGS:
;
; ACTION			CONDITION
; -----------------------	----------------------
; CONSOLE OUTPUT		NOT [HUSH]
; DISK OUTPUT			[ASMOPN] AND [WTRENAB]
; DEC [LINCNT] AFTER <LF>	[CNTENAB]
;
COUT:	PUSH	AX			;SAVE REGS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CALL	UPDCOL			;UPDATE COLUMN COUNT
	CMP	BYTE PTR [HUSH],0	;IF NOT IN QUIET MODE
	JNE	COUT1
	PUSH	AX			;	DO CONSOLE OUTPUT
	MOV	DL,AL
	MOV	AH,02H
	INT	21H
	POP	AX
COUT1:	CMP	BYTE PTR [ASMOPN],0	;IF ASM FILE IS OPEN
	JE	COUT2
	CMP	BYTE PTR [WRTENAB],0	;AND WRITE ENABLE FLAG IS ON 
	JE	COUT2
	CALL	WRCHR			;	DO DISK OUTPUT
COUT2:	CMP	AL,LF			;IF CHAR = <LF>
	JNE	COUT3
	CMP	BYTE PTR [CNTENAB],0	;AND LINE COUNT ANABLE FLAG IS ON
	JE	COUT3
	DEC	BYTE PTR [LINCNT]	;	DECREMENT [LINECNT]
COUT3:	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;UPDATE PRINT COLUMN COUNT
;
UPDCOL:	MOV	AH,[COLCNT]
	CMP	AL,08H			;<BS> ?
	JNE	UPDCO1
	AND	AH,AH			;	IF COL > 0 THEN DECR COL
	JZ	UPDCOX
	DEC	AH
	JMP	SHORT UPDCOX
UPDCO1:	CMP	AL,TAB			;<TAB> ?
	JNE	UPDCO2
	AND	AH,0F8H			;	INCR COL TO NEXT TAB STOP
	ADD	AH,8
	JMP	SHORT UPDCOX
UPDCO2:	CMP	AL,CR			;<CR> ?
	JNE	UPDCO3
	SUB	AH,AH			;	COL= 0
	JMP	SHORT UPDCOX
UPDCO3:	CMP	AL,' '			;PRINTABLE ?
	JB	UPDCOX
	CMP	AL,'~'
	JA	UPDCOX
	INC	AH			;	INCR COL
UPDCOX:	MOV	[COLCNT],AH
	RET

;PROMPT AND READ A COMMAND LINE FROM THE KEYBOARD
;
PROMPT:	MOV	AL,'*'			;PRINT PROMPT
	CALL	COUT
	MOV	DI,OFFSET INBUF
	MOV	BYTE PTR [DI],IBUFLEN	;SET BUFFER SIZE
	MOV	DX,DI
	MOV	AH,0AH			;READ COMMAND LINE INTO BUFFER
	INT	21H
	INC	DI			;PT TO CHAR COUNT
	XOR	CH,CH			;CX = CHAR COUNT
	MOV	CL,[DI]
	INC	DI			;PT TO START OF STRING
	MOV	BX,CX
	MOV	BYTE PTR [BX+DI],CR	;STORE ENDING <CR>
	JCXZ	PROMP2
PROMP1:	MOV	AL,[DI]			;CONVERT TO UPPER CASE
	CALL	UPCASE
	STOSB
	LOOP	PROMP1
PROMP2:	JMP	PCRLF

;PRINT ASCIIZ STRING FOLLOWING CALL INSTRUCTION TO SCREEN
;(<CR> IS PRINTED AS <CR> <LF>)
;
MSG:	MOV	BYTE PTR [WRTENAB],0	;DISABLE DISK OUTPUT
	MOV	BYTE PTR [HUSH],0	;DISABLE QUIET MODE

;PRINT ASCIIZ STRING FOLLOWING CALL INSTRUCTION TO SCREEN AND/OR DISK
;(<CR> IS PRINTED AS <CR> <LF>)
;
PSTG:	POP	AX			;"XCHG [SP],SI"
	PUSH	SI			;  (SAVE SI, PT TO STRING IN SI)
	MOV	SI,AX
PSTG1:	LODSB				;GET CHARACTER
	OR	AL,AL			;TEST FOR END OF STRING
	JZ	PSTG2
	CALL	COUT			;PUT CHAR
	CMP	AL,CR			;IS IT <CR> ?
	JNE	PSTG1
	MOV	AL,LF			;THEN ADD <LF>
	CALL	COUT
	JMP	SHORT PSTG1		;LOOP BACK
PSTG2:	POP	AX			;"XCHG [SP],SI"
	PUSH	SI			;  (RESTORE SI AND SET NEW RET ADDR)
	MOV	SI,AX
	RET

;SET UP THE FILE CONTROL BLOCK.
;
SETFCB:	CMP	BYTE PTR [ASMOPN],0	;ERROR IF ASM FILE IS OPEN
	JNE	ERROPN
SETFC1:	MOV	BYTE PTR [FCB],0	;SET DEFAULT DRIVE
	MOV	BYTE PTR [FCB+12],0	;SET EXTENT NUMBER TO ZERO
	MOV	SI,OFFSET INBUF+3	;PT TO 1ST LETTER OF POSSIBLE FILENAME
	MOV	AL,[SI+1]		;GET SECOND LETTER
	CMP	AL,' '			;ERROR IF JUST <SP>
	JE	ERRCMD
SETFC2:	CMP	AL,':'			;GET AND SET DRIVE IF ':'
	JNE	SETFC3
	LODSB				;GET SPECIFIED DRIVE
	SUB	AL,'@'			;CONVERT IT TO BINARY
	MOV	BYTE PTR[FCB],AL	;SET DRIVE NUMBER IN FCB
	INC	SI
SETFC3:	MOV	DI,OFFSET FCB+1		;PT TO FILE NAME FIELD OF FCB
	MOV	CX,8
	CALL	SETFC4			;PUT FILE NAME
	MOV	CX,3
SETFC4:	MOV	AL,[SI]			;COPY FIELD [DI] <- [SI], MAX CX BYTE
	CMP	AL,CR			;END OF STRING?
	JE	SETFC6			;  YES: BLANK FILL
	INC	SI
	CMP	AL,'.'			;FILE TYPE FOLLOWS?
	JE	SETFC6			;  YES: BLANK FILL
	STOSB				;PUT CHAR
	LOOP	SETFC4
SETFC5:	MOV	AL,[SI]			;SKIP TO END OF FIELD
	CMP	AL,CR
	JE	SETFCX
	INC	SI
	CMP	AL,'.'
	JE	SETFCX
	JMP	SHORT SETFC5
SETFC6:	MOV	AL,' '			;BLANK FILL REMAINDER OF FCB FIELD
	REP	STOSB
SETFCX:	RET
ERRCMD:	JMP	WHAT			;COMMAND ERROR

;ATTEMPT TO OPEN ANOTHER FILE WHILE ASM FILE ALREADY OPENED
;
ERROPN:	CALL	MSG
	DB	'++ No File Access Permitted until ASM Closed',CR,0
	JMP	GETCMD

;COPY 3 BYTES AT [SI] TO OFFSET FCBTYPE
;
CPYEXT:	MOV	DI,OFFSET FCBTYPE
	MOV	CX,3
	REP	MOVSB
	RET

;COMPARE 3 BYTES AT [SI] WITH THOSE AT OFFSET FCBTYPE
;RETURN COND Z ON MATCH
;
CMPEXT:	MOV	DI,OFFSET FCBTYPE
	MOV	CX,3
	REPE	CMPSB
	RET

;INPUT CHARACTER, MAKE UPPER CASE AND ECHO
;OUT:	AL	CHARACTER
;
CHIN:	CALL	GTKEY			;WAIT FOR KEY
	JZ	CHIN
	CALL	UPCASE
	PUSH	AX
	CALL	COUT
	CALL	PCRLF
	POP	AX
	RET

;CONVERT CHAR IN AL TO UPPER CASE
;
UPCASE:	CMP	AL,'a'
	JB	UPCAS1
	CMP	AL,'z'
	JA	UPCAS1
	SUB	AL,'a'-'A'
UPCAS1:	RET

;WATCH THE CONSOLE FOR A BREAK KEY AND ABORT IF SO
;
;CTRL-S IS RECOGNIZED AS A SUSPEND KEY IN CASE MS-DOS DOESN'T CATCH IT
;IF SUSPENDED, ANY NEXT KEYPRESS CONTINUES (DISREGARDING BOTH KEYS)
;
;DESTROYS AX AND FLAGS
;
BRKCHK:	CALL	GTKEY			;CHECK IF KEY PRESSED
	JZ	BRKCHX			;NO KEY: RETURN
	CMP	AL,SUSKEY		;SUSPEND KEY PRESSED?
	JE	BRKCH1			;YES: DISPLAY PAUSE
	CALL	PCRLF			;ANY OTHER KEY: NEW LINE, ABORT
	JMP	GETCMD

BRKCH1:	CALL	GTKEY			;PAUSE: WAIT FOR ANY KEY
	JZ	BRKCH1
BRKCHX:	RET

;CHECK IF KEY IS PRESSED
;OUT :	Z-FLAG	0 (COND NZ) = KEY PRESSED
;		1 (COND  Z) = NO KEY PRESSED
;	AL	CHAR CODE IF KEY WAS PRESSED
;		EXTENDED KEYCODES CONVERTED TO SCANCODE + 80H
;
GTKEY:	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AH,06H			;CHECK FOR KEY PRESS
	MOV	DL,0FFH
	INT	21H
	JZ	GTKEY1			;NO KEY: RETURN Z
	AND	AL,AL			;CHECK FOR EXTENDED KEYCODE
	JNZ	GTKEY1			;  NO :	KEYCODE IN AL, RETURN NZ
	MOV	AH,06H			;  YES:	GET SECOND BYTE
	MOV	DL,0FFH
	INT	21H
	ADD	AL,80H			;	SCANCODE+80H IN AL, RETURN NZ
GTKEY1:	POP	DX
	POP	CX
	POP	BX
	RET

;CHECK FOR A PRINTABLE ASCII CHARACTER IN AL
;RETURNS FLAGS	C	: NON-PRINTABLE AND NO <CR> OR <LF>
;		NC,Z	: <CR> OR <LF>
;		NC,NZ	: PRINTABLE ASCII
;
ISASC:	CMP	AL,CR			;IF AL = <CR>
	JE	ISASC1			;  RETURN NC,Z
	CMP	AL,LF			;IF AL = <LF>
	JE	ISASC1			;  RETURN NC,Z
	CMP	AL,' '			;IF AL < ' ' 
	JB	ISASC1			;  RETURN C
	CMP	AL,'~'+1		;IF AL > '~'
	CMC				;  RETURN C
ISASC1:	RET

;DISPLAY FILE TYPE FROM FCB
;
PTTYPE:	MOV	SI,OFFSET FCBTYPE
	MOV	CX,3
PTTYP1:	LODSB
	CALL	COUT
	LOOP	PTTYP1
	CALL	MSG
	DB	' file...',CR,0
	RET

;PRINT CH CHARACTERS STARTING AT ADDRESS BX
;
PRTSTR:	MOV	AL,[BX]	
	INC	BX
	CALL	COUT
	DEC	CH
	JNZ	PRTSTR
	RET

;OPTIONALLY PRINT WORD VALUE AS A COMMENT
;
;IN :	DE	VALUE
;
PDERTN:	CMP	BYTE PTR [XCSW],0	;IF SYMBOL COMMENTS SWITCH IS ON
	JE	PTWHXX
	CALL	PSTG
	DB	TAB,';',0
;;	JMP	PTWHEX

;PRINT DX AS HEX WORD [0]nnnnH
;
PTWHEX:	PUSH	AX
	MOV	AL,DH
	CALL	PASHEX
	MOV	AL,DL
	CALL	PHEX
	MOV	AL,'H'
	CALL	COUT
	POP	AX
PTWHXX:	RET

;PRINT DATA BYTE [BX]
;
DTABYT:	CALL	PTBYTE			;PRINT BYTE
	JNC	PTBYTX			;IF IT WAS PRINTED AS A QUOTED CHAR
	CMP	BYTE PTR [XCSW],0	;AND SYMNOL COMMENTS ARE ON
	JE	PTBYTX
	CALL	PSTG	 		;  THEN PRINT ITS VALUE AS A COMMENT
	DB	TAB,';',0
	MOV	AL,[BX]
;;	JMP	PTBNUM

;PRINT BYTE NUMERIC
;
;IN :	AL	BYTE
;
PTBNUM:	CMP	AL,10			;IF LESS THEN 10
	JAE	PTBHEX			;	PRINT AS 1 DIGIT
	ADD	AL,'0'
	JMP	COUT

;PRINT BYTE HEX (FORMAT [0]nnH)
;
;IN :	AL	BYTE
;
PTBHEX:	CALL	PASHEX			;ELSE	PRINT HEX BYTE
	MOV	AL,'H'
	JMP	COUT

;PRINT BYTE AS A QUOTED ASCII CHAR (PRINT '' FOR ')
;
;IN :	AL	BYTE
;
PTBASC:	MOV	AH,AL			;SAVE CHAR
	CALL	PQUOTE			;PRINT QUOTE
	MOV	AL,AH			;RESTORE CHAR
	CALL	COUT			;PRINT CHAR
	CMP	AL,QUOTE		;IF IT'S A QUOTE
	JNE	PTBAS1
	CALL	COUT			;   THEN PRINT CHAR AGAIN
PTBAS1:	JMP	PQUOTE			;PRINT QUOTE AND RETURN

;PRINT BYTE AS QUOTED CHAR IF PRINTABLE, ELSE AS A HEX BYTE
;
;IN :	[BX]	BYTE
;OUT:	FLAGS	COND C : PRINTABLE
;
PTBYTE:	MOV	AL,[BX]
	CMP	AL,' '			;TEST IF PRINTABLE
	JB	PTBYT1
	CMP	AL,'~'
	JBE	PTBYT2
PTBYT1:	CALL	PTBNUM			;PRINT AS DATA BYTE
	CLC				;RETURN NC
	RET
PTBYT2:	CALL	PTBASC			;PRINT AS QUOTED CHAR
	STC				;RETURN C
PTBYTX:	RET

;INITIALIZE SPECIAL CONSTANTS SO CODE IS REENTRANT
;
INIT:	MOV	WORD PTR [OFFS],OFFSET INITOFF
	MOV	WORD PTR [DMPLEN],IDMPLEN
	MOV	BYTE PTR [LSTLEN],ILSTLEN
	MOV	WORD PTR [CMTBEG],OFFSET CMTTBL
	MOV	BYTE PTR [ASMOPN],0
	MOV	BYTE PTR [XCSW],IXCSW
	RET

;INITIALIZE TABLES AND CODE POINTERS
;
REINIT:	MOV	BX,OFFSET SYMTBL	;SYMBOL TABLE
	MOV	[SYMEND],BX		; - END POINTER
	MOV	BYTE PTR [BX+2],EMRKCNT	; - END MARKER
	MOV	BX,OFFSET CTLTBL	;CONTROL TABLE
	MOV	BYTE PTR [BX-1],'I'	; - INITIAL INSTRUCTION MODE
	MOV	WORD PTR [BX],EMRKVAL	; - END MARKER VALUE WORD
	MOV	BX,[CMTBEG]		;COMMENT TABLE
	MOV	[CMTEND],BX		; - END POINTER
	AND	BX,BX			; IF TABLE IS ACTIVE
	JZ	REINI1
	MOV	WORD PTR [BX],EMRKVAL	; - END MARKER VALUE WORD
	MOV	BYTE PTR [BX+2],EMRKCNT	; - END MARKER COUNT BYTE
REINI1:	MOV	BX,INITPC		;CODE POINTERS
	MOV	[RELEND],BX
	MOV	[PC],BX
	MOV	[DMPPTR],BX
	XOR	AX,AX
	MOV	WORD PTR [CMTPTR],AX	;COMMENT POINTERS
	MOV	WORD PTR [RPLPTR],AX
	RET

MAIN	ENDP

;FILE TYPES
;
TPALL		DB	'ALL'	;FILE TYPE FOR ALL FILES
				;(CTL, SYM, CMT, COM, AND ASM)
TPASM		DB	'ASM'	;ASM FILE TYPE
TPCOM		DB	'COM'	;COM FILE TYPE
TPCTL		DB	'CTL'	;CTL FILE TYPE
TPSYM		DB	'SYM'	;SYM FILE TYPE
TPCMT		DB	'CMT'	;CMT FILE TYPE

;CONTROL MODE CHARACTERS
;
CMODES		DB	'BEHISWK'
CMCNT		=	THIS BYTE - OFFSET CMODES

;BUFFERS
;
OLDST		DW	?	;INITIAL STACK POINTER OFFSET
RELEND		DW	?	;RELATIVE END ADDRESS OF COM FILE
DMPPTR		DW	?	;STARTING ADDRESS OF DUMP (CURRENT ADDR ALSO)
DMPEND		DW	?	;ENDING ADDRESS OF DUMP
DMPLEN		DW	?	;NUMBER OF BYTES TO DUMP AT ONE TIME - 1
OFFS		DW	?	;OFFSET VALUE
SYMEND		DW	?	;END OF SYMBOL TABLE
PC		DW	?	;CURRENT VALUE OF PC
ENDLST		DW	?	;END OF LISTING PTR
BIASED		DW	?	;BIASED OFFS
CMTBEG		DW	?	;START ADDRESS OF COMMENTS
CMTEND		DW	?	;END ADDRESS OF COMMENTS
FNDPC		DW	?	;TEMP PC FOR FIND FUNCTION
FNDVAL		DW	?	;TEMP ADDRESS FOR FIND FUNCTION
RPLPTR		DW	?	;PTR TO REPLACING COMMENT
CMTPTR		DW	?	;PTR TO TRAILING COMMENT
NXTCTL		DW	?	;PTR TO NEXT CTL ENTRY
DMAPTR		DW	?	;PT TO DMA ADDRESS
ARG1		DW	?	;COMMAND ARGUMENT VALUE 1
ARG2		DW	?	;COMMAND ARGUMENT VALUE 2
ASCDB		DB	?	;FLAG FOR DB BUILD (0=HEX, <>0=ASCII AND HEX)
ENTCNT		DB	?	;TEMP LINE COUNTER
LSTLEN		DB	?	;NUMBER OF LINES FOR LIST
COLCNT		DB	?	;COUNTER FOR PRINT COLUMN
LINCNT		DB	?	;COUNTER FOR LINES
CNTENAB		DB	?	;ENABLE LINE COUNT IF <> 0
WRTENAB		DB	?	;OUTPUT TO FILE IS ENABLED IF <> 0, NOT IF 0
XCSW		DB	? 	;SYMBOL COMMENT FLAG, DISABLED IF 0
ASMOPN		DB	? 	;FILE IS OPEN IF <> 0, NOT OPEN IF 0
HUSH		DB	?	;DON'T PRINT COMMAND RESULT (QUIET MODE) IF 0
DBFLEN		DB	?	;DB VALUE FIELD LENGTH
ASCBLD		DB	?	;FLAG FOR A COMMAND (0=NOT A)
BUILD		DB	?	;FLAG FOR B COMMAND (0=NOT B)

;INPUT LINE BUFFER
;
INBUF		DB	?	;SIZE OF BUFFER
		DB IBUFLEN DUP (?) ;BUFFER CONTENTS
		DB	CR	;ASSURE ENDING <CR> WITH MAX LENGTH INPUT LINE

;TABLES
;
		DB	?		;ALLOW 1 BYTE FOR INITIAL 'I' ENTRY
CTLTBL		DB	STBSIZ DUP (?)	;CONTROL TABLE
SYMTBL		DB	2000H DUP (?)	;SYMBOL TABLE
INITOFF		DB	4000H DUP (?)	;INITIAL OFFSET VALUE
CMTTBL		=	THIS BYTE	;BEGINNING OF COMMENTS

CODE	ENDS

	END	MAIN
