; DASMZLG.ASM -- 16 aug 1992
;
; This is the ZILOG Z80 mnemonic disassembler module for DASM.ASM.
; It is included into DASM during assembly.
;
; Derived from DASM.ZLG v3.0, translated to Intel 8086 code

	DISPLAY	"DASM with Zilog Z80 mnemonics"

;
; This is the Header to be printed for this module
;
HEADER	DB	'Cross-disassembler for Zilog Z80 mnemonics',CR,LF
	DB	'Derived from RESOURCE/ZZSOURCE',CR,LF,'$'

;
; EXTRA PROLOG, TO BE PRINTED BEFORE THE 'ORG' DIRECTIVE
;
XPROLG:	RET

;
; EXTRA EPILOG, TO BE PRINTED BEFORE THE 'END' DIRECTIVE
;
XEPILG:	RET

;
; This is the Disassembler Module -- Instruction to be disassembled
; is pted to by PC
;
DASM:	CALL	HSYM			;WRITE LABEL, DISPLAY [PC]
	MOV	BX,[RPLPTR]		;CHECK IF THIS LINE IS REPLACED
	OR	BX,BX
	JZ	DASM1
	MOV	CH,[BX]
	INC	BX			;IF SO:	SKIP THE '*'
	DEC	CH
	CALL	NWLN0			;	AND PRINT THE REPLACING LINE
;
; DECODE INSTRUCTION TYPE AND PRINT MNEMONIC
;
DASM1:	MOV	BX,[PC]			;COMPUTE [BIASED] = [PC] + [OFFS]
	ADD	BX,[OFFS]
	MOV	[BIASED],BX
	MOV	CH,[BX]			;DECODE FIRST INSTRUCTION BYTE
	INC	WORD PTR [PC]
	MOV	SI,OFFSET OPC
	CALL	DECODE
	CMP	AL,09H			;TYPES 00H-09H ARE 1 BYTE
	JBE	DASM3			; .. SO DON'T CHANGE THE PC
	MOV	BX,1
	CMP	AL,0FH			;TYPES 0AH-0FH ARE 2 BYTE
	JBE	DASM2
	CMP	AL,15H			;TYPES 10H-015H ARE 3 BYTE
	JA	DASM2			;OTHERS (LEAD IN) AT LEAST 2 BYTES
	INC	BX
DASM2:	ADD	WORD PTR [PC],BX
;
; DECODE REMAINDER OF INSTRUCTION VIA INSTRUCTION TYPE JUMP TABLE
;
DASM3:	MOV	SI,OFFSET JMPTBL
	SUB	AH,AH
	ADD	SI,AX			;ADD 2*OPCODE TYPE TO JMPTBL TO GET
	ADD	SI,AX			;.. ROUTINE ADDRESS
	MOV	BX,[BIASED]
	JMP	[SI]			;JUMP TO THE ROUTINE
;
; GET OPCODE TYPE AND PRINT MNEMONIC
;
; IN :	SI	OFFSET CODE TABLE
;	CH	INSTRUCTION BYTE
; OUT:	AL	OPCODE TYPE
;
DECODE:	LODSB
DECOD1:	AND	AL,CH			;MASK OUT VARIABLES
	CMP	AL,[SI]			;COMPARE GENERIC INSTRUCTION
	JZ	DECOD3			;MATCH
	ADD	SI,2
DECOD2:	LODSB				;NO MATCH: SKIP TO NEXT ENTRY
	AND	AL,AL			;  (STARTS WITH NEGATIVE BYTE)
	JNS	DECOD2
	JMP	SHORT DECOD1		;TRY NEXT ENTRY
DECOD3:	INC	SI			;MATCH: SKIP VARIABLE MASK
	LODSB				;GET INSTRUCTION TYPE
	PUSH	AX			;SAVE IT
DECOD4:	LODSB				;PRINT OPCODE
	OR	AL,AL			;STOP AT FIRST NEGATIVE BYTE
	JS	DECOD5
	CALL	COUT
	JMP	SHORT DECOD4
DECOD5:	POP	AX
	RET
;
; ONE BYTE INSTRUCTIONS
;
T00:	JMP	DCRLF			;SIMPLE ONE BYTE INSTRUCTIONS

T01:	CALL	PSREG			;8 BIT REGISTER ARITHMETIC/LOGIC 
	JMP	DCRLF

T02:	CALL	PDREG			;DEC/INC
	JMP	DCRLF

T03:	CALL	PXSREG			;16-BIT REGISTER ARITHMETIC
	JMP	DCRLF

T04:	CALL	LPAR			;'LD A,(BC)' / 'LD A,(DE)'
	CALL	PXSREG
	CALL	RPAR
	JMP	DCRLF

T05:	CALL	LPAR			;'LD (BC),A' / 'LD (DE),A'
	CALL	PXSREG
	CALL	PSTG
	DB	'),A',0
	JMP	DCRLF

T06:	CALL	PXQREG			;PUSH/POP
	JMP	DCRLF

T07:	MOV	AL,[BX]			;CONDITIONAL RETURN
	AND	AL,38H
	CALL	PRCND
	JMP	DCRLF

T08:	MOV	AL,[BX]			;RST
	AND	AL,38H
	CALL	PTBHEX
	JMP	DCRLF

T09:	CALL	PDREG			;REGISTER TO REGISTER LOAD
	CALL	PCOMMA
	MOV	BX,[BIASED]
	CALL	PSREG
	JMP	DCRLF
;
; TWO BYTE INSTRUCTIONS
;
T0A:	CALL	PDREG			;8 BIT IMMEDIATE LOAD
	CALL	PCOMMA
	MOV	BX,[BIASED]
;;	JMP	SHORT T0B

T0B:	INC	BX			;ARITHMETIC/LOGIC IMMEDIATE
	CALL	DTABYT
	JMP	DCRLF

T0C:	CALL	LPAR			;IN A,(n)
	INC	BX
	MOV	AL,[BX]
	CALL	PTBHEX
	CALL	RPAR
	JMP	DCRLF

T0D:	CALL	LPAR			;OUT (n),A
	INC	BX
	MOV	AL,[BX]
	CALL	PTBHEX
	CALL	PSTG
	DB	'),A',0
	JMP	DCRLF

T0E:	MOV	AL,[BX]			;CONDITIONAL RELATIVE JUMP
	AND	AL,18H
	CALL	PRCND
	MOV	BX,[BIASED]
	CALL	PCOMMA
;;	JMP	SHORT T0F

T0F:	MOV	AL,[BX+1]		;UNCONDITIONAL RELATIVE JUMP
	CBW
	ADD	AX,[PC]
	MOV	DX,AX
	CALL	PRNTDE
	JNC	T0F_B
	CALL	PDERTN
T0F_B:	JMP	DCRLF
;
; THREE BYTE INSTRUCTIONS
;
T10:	CALL	PXSREG			;16 BIT LOAD
	CALL	PCOMMA
	MOV	BX,[BIASED]
;;	JMP	SHORT T11

T11:	CALL	PRNN			;JUMP AND CALL
	JNC	T11_A
	CALL	PDERTN
T11_A:	JMP	DCRLF

T12:	CALL	DRADR			;DIRECT LOAD
	JNC	T12_A
	CALL	PDERTN
T12_A:	JMP	DCRLF

T13:	CALL	DRADR			;DIRECT STORE
	PUSHF
	CALL	PSTG
	DB	',HL',0
	POPF
	JNC	T13_A
	CALL	PDERTN
T13_A:	JMP	DCRLF

T14:	CALL	DRADR			;LD (nn),A
	PUSHF
	CALL	PSTG
	DB	',A',0
	POPF
	JNC	T14_A
	CALL	PDERTN
T14_A:	JMP	DCRLF

T15:	MOV	AL,[BX]			;CONDITIONAL JUMP/CALL
	AND	AL,38H
	CALL	PRCND
	CALL	PCOMMA
	MOV	BX,[BIASED]
	CALL	PRNN
	JNC	T15_A
	CALL	PDERTN
T15_A:	JMP	DCRLF
;
; LEAD IN OPCODE BYTES
;
T16:	INC	BX			;0CBH LEAD IN
	MOV	CH,[BX]			;  THE SECOND BYTE OF THE INSTRUCTION
	MOV	[BIASED],BX
	MOV	SI,OFFSET OPC2
	CALL	DECODE			;  FIND THE TYPE OF 'CB' INSTRUCTION
	JMP	DASM3

T17:	MOV	DL,'X'			;0DDH LEAD IN
	JMP	SHORT T18_A

T18:	MOV	DL,'Y'			;0FDH LEAD IN
T18_A:	PUSH	DX
	INC	BX
	MOV	[BIASED],BX
	MOV	CH,[BX]
	MOV	SI,OFFSET OPC3
	CALL	DECODE
	POP	DX
	CMP	AL,1EH
	JC	T18_Y
	CMP	AL,2AH
	JZ	T18_Y
	MOV	BX,1
	CMP	AL,21H
	JC	T18_X
	INC	BX
T18_X:	ADD	WORD PTR [PC],BX
T18_Y:	JMP	DASM3

T19:	INC	BX			;0EDH LEAD IN
	MOV	[BIASED],BX
	MOV	CH,[BX]
	MOV	SI,OFFSET OPC4
	CALL	DECODE
	CMP	AL,28H
	JC	T19_X
	CMP	AL,2AH
	JZ	T19_X
	ADD	WORD PTR [PC],2
T19_X:	JMP	DASM3
;
; 1 BYTE AFTER LEAD IN
;
T1A:	CALL	PBIT			;BIT/RES/SET
	CALL	PCOMMA
	CALL	PSREG
	JMP	DCRLF

T1B:	CALL	PRXX			;IX/IY MOVES
	JMP	DCRLF

T1C:	CALL	LPAR			;'JP (IX)' / 'JP (IY)'
	CALL	PRXX
	CALL	RPAR
	JMP	DCRLF

T1D:	CALL	PRXX			;INDEX REGISTER ADDD
	CALL	PCOMMA
	MOV	AL,[BX]
	MOV	SI,OFFSET IXREGS
	CMP	DL,'X'
	JZ	T1D_A
	MOV	SI,OFFSET IYREGS
T1D_A:	CALL	PXREG
	JMP	DCRLF
;
; 2 BYTES AFTER LEAD IN
;
T1E:	INC	BX			;INDEX REGISTER ARITHMETIC/LOGIC
	CALL	PDISP
	JMP	DCRLF

T1F:	CALL	PDREG			;INDEXED LOAD TO REGISTER
	CALL	PCOMMA
	MOV	BX,[BIASED]
	INC	BX
	CALL	PDISP
	JMP	DCRLF

T20:	INC	BX			;INDEXED REGISTER STORE
	CALL	PDISP
	CALL	PCOMMA
	MOV	BX,[BIASED]
	CALL	PSREG
	JMP	DCRLF
;
; 3 BYTES AFTER 0DDH/0FEH LEAD IN
;
T21:	CALL	PRXX			;LD xx,nn
	CALL	PCOMMA
	CALL	PRNN
	JNC	T21_A
	CALL	PDERTN
T21_A:	JMP	DCRLF

T22:	CALL	LPAR			;LD (nn),xx
	PUSH	DX
	CALL	PRNN
	XCHG	DX,BX			;  BX NOW CONTAINS THE NUMBER
	POP	DX			;  RECOVER THE DL REG.  ['X' OR 'Y']
	PUSHF				;  SAVE THE CARRY FOR A LATER 'PEDRTN'
	CALL	RPAR
	CALL	PCOMMA
	CALL	PRXX
	POPF				;  THE CARRY FLAG IS RESTORED
	XCHG	DX,BX			;  DX AGAIN CONTAINS THE VALUE FOR nn
	JNC	T22_A
	CALL	PDERTN
T22_A:	JMP	DCRLF

T23:	CALL	PRXX			;LD xx,(nn)
	CALL	PCOMMA
	CALL	LPAR
	CALL	PRNN
	PUSHF
	CALL	RPAR
	POPF
	JNC	T23_A
	CALL	PDERTN
T23_A:	JMP	DCRLF

T24:	INC	BX			;LD (xx+d),n
	CALL	PDISP
	CALL	PCOMMA
	JMP	T0B

T25:	MOV	CH,BYTE PTR [BX+2]	;0CBH EXTENSION TO 0DDH/0FDH LEAD IN
	MOV	SI,OFFSET OPC2
	CALL	DECODE
	MOV	AH,CH
	AND	AH,07H
	CMP	AH,06H
	JNZ	T25_Z
	MOV	BX,[BIASED]
	CMP	AL,1AH
	JB	T25_X
	JNE	T25_Z
	INC	BX
	INC	BX
	CALL	PBIT
	CALL	PCOMMA
	DEC	BX
	DEC	BX
T25_X:	JMP	T1E
T25_Z:	SUB	WORD PTR [PC],2		;ILLEGAL INSTRUCTION
	JMP	T2A
;
; 1 BYTE AFTER 0EDH LEAD IN
;
T26:	CALL	PDREG			;IN r,(C)
	CALL	PSTG
	DB	',(C)',0
	JMP	DCRLF

T27:	MOV	AL,'I'			;BLOCK MOVES AND I/O
	TEST	BYTE PTR [BX],08H
	JZ	T27_A
	MOV	AL,'D'			;NO, IT WAS DECREMENTING
T27_A:	CALL	COUT
	TEST	BYTE PTR [BX],10H
	JZ	T27_X
	MOV	AL,'R'			;A REPEATING INSTRUCTION TYPE
	CALL	COUT
T27_X:	JMP	DCRLF
;
; 3 BYTES AFTER 0EDH LEAD IN
;
T28:	CALL	LPAR			;LD (nn),dd
	CALL	PRNN
	PUSHF
	PUSH	DX
	CALL	RPAR
	CALL	PCOMMA
	MOV	BX,[BIASED]
	CALL	PXSREG
	POP	DX
	POPF
	JNC	T28_A
	CALL	PDERTN
T28_A:	JMP	DCRLF

T29:	CALL	PXSREG			;LD dd,(nn)
	CALL	PCOMMA
	MOV	BX,[BIASED]
	CALL	LPAR
	CALL	PRNN
	PUSHF
	CALL	RPAR
	POPF
	JNC	T29_A
	CALL	PDERTN
T29_A:	JMP	DCRLF
;
; ALL UNDEFINED OPCODES COME HERE FOR A 'DB VALUE' TREATMENT
;
T2A:	DEC	WORD PTR [PC]
	CALL	PSTG
	DB	'DB',TAB,0
	MOV	BX,[BIASED]
	DEC	BX
	CALL	DTABYT
	JMP	DCRLF

;-------------------------------------------------------------------------
;
; SUBROUTINES
;
;-------------------------------------------------------------------------

;
; VARIOUS CHARACTERS TO PRINT
;
LPAR:	MOV	AL,'('
	JMP	COUT
RPAR:	MOV	AL,')'
	JMP	COUT
;
; PRINT CONDITION CODE LETTER(S)
; NORMAL SET
;
PRCND:	SHR	AL,1
	SHR	AL,1
	MOV	SI,OFFSET CNDTAB
	SUB	AH,AH
	ADD	SI,AX
	LODSB
	CALL	COUT
	LODSB
	CMP	AL,' '
	JZ	PRCND1
	CALL	COUT
PRCND1:	RET
;
; PRINT 8-BIT SOURCE REGISTER
;
PSREG:	MOV	AL,[BX]
	JMP	SHORT PREG
;
; PRINT 8-BIT DESTINATION REGISTER
;
PDREG:	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
;;	JMP	SHORT PREG
;
; PRINT 8-BIT REGISTER
;
PREG:	MOV	SI,OFFSET REGTAB
	AND	AL,07H
	SUB	AH,AH
	ADD	SI,AX
	LODSB
	CMP	AL,'M'			;FILTER OUT '(HL)' MEMORY REFERENCE
	JZ	PREG1
	JMP	COUT
;
PREG1:	CALL	PSTG
	DB	'(HL)',0
	RET
;
; PRINT A DOUBLE REGISTER PAIR
;
PXSREG:	MOV	AL,[BX]
	MOV	SI,OFFSET DREGS
	JMP	SHORT PXREG
PXQREG:	MOV	AL,[BX]
	MOV	SI,OFFSET DREGQ
PXREG:	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,06H
	SUB	AH,AH
	ADD	SI,AX
	LODSB
	CALL	COUT
	LODSB
	JMP	COUT
;
; PRINT BIT OPERAND
;
PBIT:	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,7
	ADD	AL,'0'
	JMP	COUT
;
; PRINT 'IX'/'IY'
;
; IN :	DL	'X' OR 'Y' 
;
PRXX:	MOV	AL,'I'
	CALL	COUT
	MOV	AL,DL
	JMP	COUT
;
;PRINT A DISPLACEMENT IN THE FORM '(IX+d)'
;
PDISP:	CALL	LPAR
	CALL	PRXX
	MOV	AL,'+'
	CALL	COUT
	MOV	AL,[BX]
	CALL	PTBNUM
	JMP	RPAR
;
; PRINT WORD VALUE IN PARENTHESIS, IF POSSIBLE AS A SYMBOL, OR ELSE IN HEX
;
; IN :	[BX+1]	WORD VALUE
; OUT:	FLAGS	C=1 : VALUE PRINTED AS A SYMBOL
;	BX	INCREMENTED BY 2
;
DRADR:	CALL	LPAR
	CALL	PRNN
	PUSHF
	CALL	RPAR
	POPF
	RET
;
; PRINT WORD VALUE AS A SYMBOL IF POSSIBLE, OR ELSE IN HEX
;
; IN :	[BX+1]	WORD VALUE
; OUT:	FLAGS	C=1 : VALUE PRINTED AS A SYMBOL
;	BX	INCREMENTED BY 2
;
PRNN:	INC	BX
	MOV	DX,[BX]
	INC	BX
;;	JMP	SHORT PRNTDE
;
; PRINT WORD VALUE AS A SYMBOL IF POSSIBLE, OR ELSE IN HEX
;
; IN :	DX	WORD VALUE
; OUT:	FLAGS	C=1 : VALUE PRINTED AS A SYMBOL
;
PRNTDE:	CALL	SYMSCH			;SEARCH SYMBOL
	JC	PRNTD1			;IF FOUND
	CALL	PRTSTR			;	PRINT SYMBOL NAME
	STC				;	RETURN C
	JMP	SHORT PRNTDX
PRNTD1:	CMP	BYTE PTR [BUILD],0	;ELSE	BUILD SYMBOL IF WANTED
	JZ	PRNTD2
	CALL	BLDSYM
PRNTD2:	CALL	PTWHEX			;	PRINT HEX WORD
	CLC				;	RETURN NC
PRNTDX:	RET
;
; OPCODE TABLES
;
OPC	DB	0FFH,0EBH,000H,'EX	DE,HL'
	DB	0FFH,008H,000H,'EX	AF,AF'''
	DB	0FFH,0D9H,000H,'EXX'
	DB	0FFH,0E3H,000H,'EX	(SP),HL'
	DB	0FFH,027H,000H,'DAA'
	DB	0FFH,0F3H,000H,'DI'
	DB	0FFH,0FBH,000H,'EI'
	DB	0FFH,076H,000H,'HALT'
	DB	0FFH,02FH,000H,'CPL'
	DB	0FFH,03FH,000H,'CCF'
	DB	0FFH,000H,000H,'NOP'
	DB	0FFH,037H,000H,'SCF'
	DB	0FFH,0E9H,000H,'JP	(HL)'
	DB	0FFH,007H,000H,'RLCA'
	DB	0FFH,017H,000H,'RLA'
	DB	0FFH,00FH,000H,'RRCA'
	DB	0FFH,01FH,000H,'RRA'
	DB	0FFH,0C9H,000H,'RET'
	DB	0FFH,0F9H,000H,'LD	SP,HL'
	DB	0F8H,088H,001H,'ADC	A,'
	DB	0F8H,080H,001H,'ADD	A,'
	DB	0F8H,0A0H,001H,'AND	'
	DB	0F8H,0B8H,001H,'CP	'
	DB	0F8H,0B0H,001H,'OR	'
	DB	0F8H,098H,001H,'SBC	A,'
	DB	0F8H,090H,001H,'SUB	'
	DB	0F8H,0A8H,001H,'XOR	'
	DB	0C7H,005H,002H,'DEC	'
	DB	0C7H,004H,002H,'INC	'
	DB	0CFH,009H,003H,'ADD	HL,'
	DB	0CFH,00BH,003H,'DEC	'
	DB	0CFH,003H,003H,'INC	'
	DB	0EFH,00AH,004H,'LD	A,'
	DB	0EFH,002H,005H,'LD	'
	DB	0CFH,0C1H,006H,'POP	'
	DB	0CFH,0C5H,006H,'PUSH	'
	DB	0C7H,0C0H,007H,'RET	'
	DB	0C7H,0C7H,008H,'RST	'
	DB	0C0H,040H,009H,'LD	'
	DB	0C7H,006H,00AH,'LD	'
	DB	0FFH,0C6H,00BH,'ADD	A,'
	DB	0FFH,0CEH,00BH,'ADC	A,'
	DB	0FFH,0E6H,00BH,'AND	'
	DB	0FFH,0FEH,00BH,'CP	'
	DB	0FFH,0F6H,00BH,'OR	'
	DB	0FFH,0D6H,00BH,'SUB	'
	DB	0FFH,0DEH,00BH,'SBC	A,'
	DB	0FFH,0EEH,00BH,'XOR	'
	DB	0FFH,0DBH,00CH,'IN	A,'
	DB	0FFH,0D3H,00DH,'OUT	'
	DB	0E7H,020H,00EH,'JR	'
	DB	0FFH,010H,00FH,'DJNZ	'
	DB	0FFH,018H,00FH,'JR	'
	DB	0CFH,001H,010H,'LD	'
	DB	0FFH,0C3H,011H,'JP	'
	DB	0FFH,0CDH,011H,'CALL	'
	DB	0FFH,03AH,012H,'LD	A,'
	DB	0FFH,02AH,012H,'LD	HL,'
	DB	0FFH,022H,013H,'LD	'
	DB	0FFH,032H,014H,'LD	'
	DB	0C7H,0C4H,015H,'CALL	'
	DB	0C7H,0C2H,015H,'JP	'
	DB	0FFH,0CBH,016H
	DB	0FFH,0DDH,017H
	DB	0FFH,0FDH,018H
	DB	0FFH,0EDH,019H

OPC2	DB	0F8H,000H,001H,'RLC	'
	DB	0F8H,008H,001H,'RRC	'
	DB	0F8H,010H,001H,'RL	'
	DB	0F8H,018H,001H,'RR	'
	DB	0F8H,020H,001H,'SLA	'
	DB	0F8H,028H,001H,'SRA	'
	DB	0F8H,038H,001H,'SRL	'
	DB	0C0H,040H,01AH,'BIT	'
	DB	0C0H,080H,01AH,'RES	'
	DB	0C0H,0C0H,01AH,'SET	'
	DB	080H,000H,02AH

OPC3	DB	0FFH,0E3H,01BH,'EX	(SP),'
	DB	0FFH,0E9H,01CH,'JP	'
	DB	0FFH,0F9H,01BH,'LD	SP,'
	DB	0FFH,0E1H,01BH,'POP	'
	DB	0FFH,0E5H,01BH,'PUSH	'
	DB	0CFH,009H,01DH,'ADD	'
	DB	0FFH,023H,01BH,'INC	'
	DB	0FFH,02BH,01BH,'DEC	'
	DB	0FFH,034H,01EH,'INC	'
	DB	0FFH,035H,01EH,'DEC	'
	DB	0FFH,086H,01EH,'ADD	A,'
	DB	0FFH,08EH,01EH,'ADC	A,'
	DB	0FFH,096H,01EH,'SUB	'
	DB	0FFH,09EH,01EH,'SBC	A,'
	DB	0FFH,0A6H,01EH,'AND	'
	DB	0FFH,0AEH,01EH,'XOR	'
	DB	0FFH,0B6H,01EH,'OR	'
	DB	0FFH,0BEH,01EH,'CP	'
	DB	0C7H,046H,01FH,'LD	'
	DB	0F8H,070H,020H,'LD	'
	DB	0FFH,021H,021H,'LD	'
	DB	0FFH,022H,022H,'LD	'
	DB	0FFH,02AH,023H,'LD	'
	DB	0FFH,036H,024H,'LD	'
	DB	0FFH,0CBH,025H
	DB	080H,000H,02AH
	DB	080H,080H,02AH

OPC4	DB	0FEH,070H,02AH			;PREVENTS 'IN (HL),(C)'
	DB	0FFH,044H,000H,'NEG'
	DB	0FFH,045H,000H,'RETN'
	DB	0FFH,046H,000H,'IM	0'
	DB	0FFH,056H,000H,'IM	1'
	DB	0FFH,05EH,000H,'IM	2'
	DB	0FFH,047H,000H,'LD	I,A'
	DB	0FFH,04DH,000H,'RETI'
	DB	0FFH,04FH,000H,'LD	R,A'
	DB	0FFH,057H,000H,'LD	A,I'
	DB	0FFH,05FH,000H,'LD	A,R'
	DB	0FFH,067H,000H,'RRD'
	DB	0FFH,06FH,000H,'RLD'
	DB	0CFH,042H,003H,'SBC	HL,'
	DB	0CFH,04AH,003H,'ADC	HL,'
	DB	0C7H,040H,026H,'IN	'
	DB	0C7H,041H,002H,'OUT	(C),'
	DB	0E7H,0A0H,027H,'LD'
	DB	0E7H,0A1H,027H,'CP'
	DB	0E7H,0A2H,027H,'IN'
	DB	0F7H,0A3H,027H,'OUT'
	DB	0F7H,0B3H,027H,'OT'
	DB	0CFH,043H,028H,'LD	'
	DB	0CFH,04BH,029H,'LD	'
	DB	080H,000H,02AH
	DB	080H,080H,02AH
	DB	0FFH					;SENTINEL
;
; OPCODE TYPE JUMP TABLE
;
JMPTBL	DW	T00		;SIMPLE 1 BYTE INSTRUCTIONS
	DW	T01		;8 BIT, REGISTER ARITHMETIC & LOGICAL
	DW	T02		;DEC & INC
	DW	T03		;DOUBLE REGISTER SINGLE BYTE ARITHMETIC
	DW	T04		;8 BIT LOAD FROM MEMORY
	DW	T05		;8 BIT LOAD TO MEMORY
	DW	T06		;POP's AND PUSH's
	DW	T07		;CONDITIONAL RETURNS
	DW	T08		;THE RST INSTRUCTIONS
	DW	T09		;REGISTER TO REGISTER LOADS
;2 BYTE INSTRUCTIONS
	DW	T0A		;8 BIT LOAD IMMEDIATES
	DW	T0B		;8 BIT IMMEDIATE ARITH. & LOGICAL
	DW	T0C		;IN A,(n)
	DW	T0D		;OUT (n),A
	DW	T0E		;CONDITIONAL, RELATIVE JUMPS
	DW	T0F		;OTHER RELATIVE JUMPS
;3 BYTE INSTRUCTIONS
	DW	T10		;16 BIT LOADS
	DW	T11		;JUMPS & CALLS
	DW	T12		;DIRECT LOADS
	DW	T13		;DIRECT STORES
	DW	T14		;LD (nn),A
	DW	T15		;CONDITIONAL JUMPS & CALLS
;MULTI-BYTE OPCODES
	DW	T16		;THE 'CB' SERIES {1, 1A, 2A}
	DW	T17		;THE 'DD' SERIES {1B thru 25 & 2A}
	DW	T18		;THE 'FD' SERIES {1B thru 25 & 2A}
	DW	T19		;THE 'ED' SERIES {0, 2, 3, 26 thru 2A}
;1 BYTE
	DW	T1A		;THE BIT, RES & SET FOR 'CB'
	DW	T1B		;INDEX REGISTER LOADS
	DW	T1C		;JUMP INDIRECT INDEX REGISTER
	DW	T1D		;INDEX REGISTER ADD
;2 BYTE
	DW	T1E		;INDEX REGISTER ARITH. AND LOGICAL
	DW	T1F		;INDEXED LOAD TO REGISTER
	DW	T20		;INDEXED REGISTER STORE
;3 BYTES AFTER 'DD' OR 'FE'
	DW	T21		;LD xx,nn
	DW	T22		;LD (nn),n
	DW	T23		;LD xx,(nn)
	DW	T24		;LD (xx+d),n
	DW	T25		;THE 'CB' EXTENSIONS TO 'DD' OR 'FD'
;1 BYTE AFTER 'ED'
	DW	T26		;IN r,(C)
	DW	T27		;BLOCK MOVES
;3 BYTES AFTER 'ED'
	DW	T28		;LD (nn),dd
	DW	T29		;LD dd,(nn)
;WHATEVER IS LEFT
	DW	T2A		;UNDEFINED OPCODES
;
; REGISTER NAMES AND CONDITION CODE TABLES
;
REGTAB	DB	'BCDEHLMA'		;'M' IS PRINTED AS '(HL)'
DREGS	DB	'BC','DE','HL','SP'
DREGQ	DB	'BC','DE','HL','AF'
IXREGS	DB	'BC','DE','IX','SP'
IYREGS	DB	'BC','DE','IY','SP'
CNDTAB	DB	'NZ','Z ','NC','C ','PO','PE','P ','M '
