; DASMTDL.ASM - 04 Dec 1996
;
; This is the TDL (extended 8080) cross-disassembler module for DASM.ASM.
; It is included into DASM during assembly.
;
; Derived from DASM.TDL v3.0, translated to Intel 8086 code


	DISPLAY	"DASM with TDL mnemonics"

;
;  This is the Header to be printed for this module by DASM
;
HEADER	DB	'Cross-disassembler for Intel 8080 family TDL Mnemonics'
	DB	CR,LF,'Derived from RESOURCE/ZZSOURCE',CR,LF,'$'

;
; EXTRA PROLOG, TO BE PRINTED BEFORE THE 'ORG' DIRECTIVE
;
XPROLG:	RET

;
; EXTRA EPILOG, TO BE PRINTED BEFORE THE 'END' DIRECTIVE
;
XEPILG:	RET

;
;  This is the main Disassembler module; the instruction to be disassembled
;    is pted to by PC
;
DASM:	CALL	HSYM			;write a symbol if it exists,
					;then put PC
	MOV	BX,[RPLPTR]		;IS THIS ENTIRE LINE TO BE REPLACED?
	AND	BX,BX
	JZ	DASM1
	MOV	CH,[BX]
	INC	BX
	DEC	CH
	CALL	NWLN0
DASM1:	MOV	BX,[PC]
	ADD	BX,[OFFS]
	MOV	[BIASED],BX
	MOV	CH,[BX]			;GET FIRST INSTRUCTION BYTE
	INC	WORD PTR [PC]
	MOV	BX,OFFSET OPC - 6
	CALL	GTCD
	CALL	TYPEOC

	CMP	AL,04H			;TYPE 01,02,03 ARE 1 BYTE INSTRUCTIONS
	JB	OLDPC

	CMP	AL,09H			;TYPE 09, 0A, 0B ARE ALSO 1 BYTE
	JB	DASM2
	CMP	AL,0DH
	JB	OLDPC

DASM2:	INC	BX			;TYPE 04, 05 ARE 2 BYTE
	CMP	AL,06H
	JB	NEWPC

	CMP	AL,09H			;TYPE 0D,0E ETC. ARE 2 BYTES OR MORE
	JAE	NEWPC
	INC	BX			;TYPE 06,07,08 ARE 3 BYTES

NEWPC:	MOV	[PC],BX
OLDPC:	SUB	AH,AH			;AX= JMPTBL INDEX 
	MOV	SI,OFFSET JMPTBL	;FETCH ROUTINE ADDRESS
	ADD	SI,AX
	ADD	SI,AX
	MOV	BX,[BIASED]
	JMP	[SI]			;DO INSTRUCTION TYPE PROCESSING
;
; GET INSTRUCTION TYPE
;
; IN :	CH	FIRST BYTE OF INSTRUCTION CODE
;	BX	START ADDRESS OPCODE TABLE - 6
; OUT:	BX	PT TO INSTRUCTION TYPE IN OPCODE TABLE
;	AL	INSTRUCTION TYPE ( = [BX] )
;	[OPCTP]	= AL ( = [BX] )
;
GTCD:	ADD	BX,6
	MOV	AL,[BX]			;get mask
	INC	BX			;point to compare byte.
	AND	AL,CH
	CMP	AL,[BX]
	JNZ	GTCD
	INC	BX
	MOV	AL,[BX]			;get type
	MOV	[OPCTP],AL
	RET
;
; TYPE THE OPCODE MNEMONIC.
;
; IN :	BX	PT TO OPCODE TYPE
; OUT:	AX	OPCODE TYPE
;	BX	[PC]
;
TYPEOC:	MOV	CX,4			;maximum of 4 characters to type
TYPEC1:	INC	BX
	MOV	AL,[BX]
	CMP	AL,'.'			;do not type '.'
	JZ	TYPEC2
	CALL	COUT
TYPEC2:	LOOP	TYPEC1
	MOV	BX,[PC]
	MOV	AL,[OPCTP]
	RET
;
; ORIGINAL INTEL 8080 OPCODES
;
T00:	JMP	DCRLF			;SIMPLE ONE-BYTE INSTRUCTIONS

T01:	CALL	PTAB			;ARITHMETIC/LOGIC
	CALL	PREG0
	JMP	DCRLF

T02:	CALL	PTAB			;DCR/INR
	CALL	PREG1
	JMP	DCRLF

T03:	CALL	PTAB			;DOUBLE REG NON-IMMED
	MOV	DL,'H'
	CALL	PXREG
	JMP	DCRLF

T04:	CALL	PTAB			;MVI
	CALL	PREG1
T04_A:	CALL	PCOMMA
	JMP	SHORT T05_A

T05:	CALL	PTAB			;REG IMMED (EXCEPT MVI), IN/OUT
T05_A:	MOV	BX,[BIASED]
	INC	BX
	MOV	[BIASED],BX
	CALL	DTABYT
	JMP	DCRLF

T06:	CALL	PTAB			;LXI
	MOV	DL,'H'
	CALL	PXREG
T06_A:	CALL	PCOMMA
	MOV	BX,[BIASED]
	CALL	PRNN
	JMP	DCRLF

T08:	MOV	DL,0EH			;CONDITIONAL CALL AND JUMP
	CALL	PRNCND
	MOV	BX,[BIASED]
;;	JMP	SHORT T07

T07:	CALL	PTAB			;JMP AND OTHER 3-BYTES WITH ADDRESS
	MOV	BX,[BIASED]
	CALL	PRNN
	JMP	DCRLF

T09:	MOV	DL,0EH			;CONDITIONAL RETURN
	CALL	PRNCND
	JMP	DCRLF

T0A:	CALL	PTAB			;RST
	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,7
	OR	AL,'0'
	CALL	COUT
	JMP	DCRLF

T0B:	CALL	PTAB
	CALL	PREG1
T0B_A:	CALL	PCOMMA
	MOV	BX,[BIASED]
	MOV	AL,[BX]
	CALL	PREG0
	JMP	DCRLF
;
; ADDED ZILOG Z-80 OPCODES
;
T0C:	CALL	PTAB			;BIT/RES/SET
	CALL	PBIT
	JMP	SHORT T0B_A

T0E:	MOV	DL,6			;CONDITIONAL RELATIVE JUMPS
	CALL	PRNCND
	MOV	BX,[BIASED]
;;	JMP	SHORT T0D

T0D:	CALL	PTAB			;DJNZ/JMPR
	MOV	AL,[BX+1]		;  GET REPLACEMENT
	CBW				;  SIGN EXTEND INTO AX
	ADD	AX,[PC]			;  COMPUTE DESTINATION ADDRESS
	MOV	DX,AX			;    INTO DX
	CALL	PRNTDE
	JMP	DCRLF

T0F:	INC	BX			;THE 'CB' SERIES
	MOV	CH,[BX]
	MOV	[BIASED],BX		;  new current byte
	MOV	BX,OFFSET OPC2 - 6
	CALL	GTCD			;  octyp is either 1, 10h or 0ch
	CALL	TYPEOC
	JMP	OLDPC

T10:	DEC	WORD PTR [PC]			;ILLEGAL OPCODE, PRINT AS 'DB n'
	MOV	BX,[BIASED]
	DEC	BX
	CALL	PSTG
	DB	'DB',TAB,0
	CALL	DTABYT
	JMP	DCRLF
;
; THE 'DD'/'FD'/'ED' PREFIX SERIES
;
T11:	MOV	DL,'X'			;THE 'DD' SERIES
	JMP	SHORT T12_A

T12:	MOV	DL,'Y'			;THE 'FD' SERIES
T12_A:	PUSH	DX
	INC	BX
	MOV	[BIASED],BX		;  second byte of instruction
	MOV	CH,[BX]
	MOV	BX,OFFSET OPC3 - 6
	CALL	GTCD
	CALL	TYPEOC
	POP	DX
	CMP	AL,23
	JC	T12_Y
	INC	BX
	CMP	AL,26
	JC	T12_X
	INC	BX
T12_X:	JMP	NEWPC
T12_Y:	JMP	OLDPC

T13:	INC	BX			;THE 'ED' SERIES
	MOV	[BIASED],BX
	MOV	CH,[BX]
	MOV	BX,OFFSET OPC4 - 6
	CALL	GTCD
	CALL	TYPEOC
	CMP	AL,1FH
	JC	T12_Y
	INC	BX
	INC	BX
	JMP	NEWPC
;
; 2 BYTE 'DD'/'FD'
;
T14:	MOV	AL,DL			;XTIX, ETC.
	CALL	COUT
	JMP	DCRLF

T15:	CALL	PTAB			;PUSH/POP X
	JMP	SHORT T14

T16:	MOV	AL,DL
	CALL	COUT
	CALL	PTAB
	CALL	PXREG
	JMP	DCRLF
;
; 3 BYTE 'DD'/'FD'
;
T17:	CALL	PTAB
	JMP	SHORT T18_A

T18:	CALL	PTAB			;MOV r,d(x)
	CALL	PREG1
	CALL	PCOMMA
	MOV	BX,[BIASED]
T18_A:	CALL	PINDX
	JMP	DCRLF

T19:	CALL	PTAB			;MOV d(x),r
	CALL	PINDX
	JMP	T0B_A
;
;
;
T1A:	CALL	PTAB			;LXIx nn
	MOV	AL,DL
	CALL	COUT
	JMP	T06_A

T1B:	MOV	AL,DL			;LXxD, SIxxD
	CALL	COUT
	MOV	AL,'D'
	CALL	COUT
	JMP	T07

T1C:	CALL	PTAB			;MVI d(x),n
	CALL	PINDX
	MOV	[BIASED],BX
	JMP	T04_A
;
; 4 BYTE 'CB' SERIES
;
T1D:	INC	BX
	INC	BX
	MOV	CH,[BX]
	MOV	BX,OFFSET OPC2 - 6
	PUSH	DX
	CALL	GTCD
	POP	DX
	MOV	AL,CH			;get o.c.
	AND	AL,07H
	CMP	AL,06H
	JNZ	T1D_A
	CALL	TYPEOC
	MOV	BX,[BIASED]
	CMP	AL,0CH
	JC	T17
	JNZ	T1D_A
	CALL	PTAB
	INC	BX
	INC	BX
	CALL	PBIT
	CALL	PCOMMA
	DEC	BX
	DEC	BX
	JMP	T18_A

T1D_A:	SUB	WORD PTR [PC],2		;ILLEGAL INSTRUCTION
	JMP	T10

T1E:	MOV	AL,'I'			;AUTO-INC/DEC (BLOCK) MOVE/COMPARE
	TEST	BYTE PTR [BX],08H
	JZ	T1E_A
	MOV	AL,'D'
T1E_A:	CALL	COUT
	TEST	BYTE PTR [BX],10H
	JZ	T1E_X
	MOV	AL,'R'
	CALL	COUT
T1E_X:	JMP	DCRLF

T1F:	MOV	DL,'H'			;4 BYTE DIRECT STORE
	CALL	PXREG
	ROR	DH,1
	MOV	AL,'C'
	DEC	DH
	JS	T1F_A
	MOV	AL,'E'
	DEC	DH
	JS	T1F_A
	MOV	AL,'L'
	DEC	DH
T1F_A:	JZ	T1F_C
	CALL	COUT
T1F_C:	MOV	AL,'D'
	CALL	COUT
	JMP	T07
;---------------------------------------------------------------------
;
; GENERAL ROUTINES
;
;---------------------------------------------------------------------

;
; PRINT BIT NUMBER
;
PBIT:	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,7
	ADD	AL,'0'
	JMP	COUT
;
; PRINT CONDITION CODE LETTERS
;
PRNCND:	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	AND	AL,DL
	MOV	BX,OFFSET CNDTAB
	SUB	AH,AH
	ADD	BX,AX
	MOV	AL,[BX]
	CALL	COUT
	MOV	AL,[BX+1]
	CMP	AL,'.'
	JZ	PRNCN1
	CALL	COUT
PRNCN1:	RET
;
; PRINT INDEXED MEMORY REFERENCE 'nnH(x)'
;
PINDX:	INC	BX			;PRINT DISPLACEMENT
	MOV	AL,[BX]
	CALL	PASHEX
	CALL	PSTG
	DB	'H(',0
	MOV	AL,DL
	CALL	COUT
	MOV	AL,')'
	JMP	COUT
;
; PRINT THE VALUE FOR A DOUBLE REGISTER.
;
PXREG:	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,06H
	MOV	DH,AL
	CMP	AL,04H
	JNZ	PXREG1
	MOV	AL,DL
	JMP	COUT

PXREG1:	CMP	AL,06H
	JNZ	PREG

	MOV	AL,[BX]			;POP?
	AND	AL,0CFH
	CMP	AL,0C1H
	JZ	PXREG2

	CMP	AL,0C5H			;PUSH?
	JZ	PXREG2

	CALL	PSTG
	DB	'SP',0
	RET

PXREG2:	CALL	PSTG
	DB	'PSW',0
	RET
;
; READ A BYTE AND PRINT ITS SOURCE REGISTER.
;
PREG0:	MOV	AL,[BX]
	JMP	SHORT PREG
;
; READ A BYTE AND PRINT ITS DEST. REGISTER.
;
PREG1:	MOV	AL,[BX]
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
PREG:	MOV	BX,OFFSET REGTAB
	AND	AL,07H
	SUB	AH,AH
	ADD	BX,AX
	MOV	AL,[BX]
	JMP	COUT
;
; PRINT WORD VALUE AS A SYMBOL IF POSSIBLE, OR ELSE IN HEX
;
; IN :	[BX+1]	WORD VALUE
; OUT:	FLAGS	C=1 : VALUE PRINTED AS A SYMBOL
;	BX	INCREMENTED BY 2
;
PRNN:	INC	BX
	MOV	DX,[BX]
	INC	BX
;;	JMP	SHORT PRNTDE
;
; PRINT WORD VALUE AS A SYMBOL IF POSSIBLE, OR ELSE IN HEX
;
; IN :	DX	WORD VALUE
; OUT:	FLAGS	C=1 : VALUE PRINTED AS A SYMBOL
;
PRNTDE:	CALL	SYMSCH			;SEARCH SYMBOL
	JC	PRNTD1			;IF FOUND
	CALL	PRTSTR			;	PRINT SYMBOL NAME
	STC				;	RETURN C
	JMP	SHORT PRNTDX
PRNTD1:	CMP	BYTE PTR [BUILD],0	;ELSE	BUILD SYMBOL IF WANTED
	JZ	PRNTD2
	CALL	BLDSYM
PRNTD2:	CALL	PTWHEX			;	PRINT HEX WORD
	CLC				;	RETURN NC
PRNTDX:	RET
;
;  OPCODE TABLES
;
OPC	DB	0FFH,02FH,000H,'CMA.'
	DB	0FFH,03FH,000H,'CMC.'
	DB	0FFH,027H,000H,'DAA.'
	DB	0FFH,0F3H,000H,'DI..'
	DB	0FFH,0FBH,000H,'EI..'
	DB	0FFH,008H,000H,'EXAF'
	DB	0FFH,0D9H,000H,'EXX.'
	DB	0FFH,076H,000H,'HLT.'
	DB	0FFH,000H,000H,'NOP.'
	DB	0FFH,0E9H,000H,'PCHL'
	DB	0FFH,017H,000H,'RAL.'
	DB	0FFH,01FH,000H,'RAR.'
	DB	0FFH,0C9H,000H,'RET.'
	DB	0FFH,007H,000H,'RLC.'
	DB	0FFH,00FH,000H,'RRC.'
	DB	0FFH,0F9H,000H,'SPHL'
	DB	0FFH,037H,000H,'STC.'
	DB	0FFH,0EBH,000H,'XCHG'
	DB	0FFH,0E3H,000H,'XTHL'
	DB	0F8H,088H,001H,'ADC.'
	DB	0F8H,080H,001H,'ADD.'
	DB	0F8H,0A0H,001H,'ANA.'
	DB	0F8H,0B8H,001H,'CMP.'
	DB	0F8H,0B0H,001H,'ORA.'
	DB	0F8H,098H,001H,'SBB.'
	DB	0F8H,090H,001H,'SUB.'
	DB	0F8H,0A8H,001H,'XRA.'
	DB	0C7H,005H,002H,'DCR.'
	DB	0C7H,004H,002H,'INR.'
	DB	0CFH,009H,003H,'DAD.'
	DB	0CFH,00BH,003H,'DCX.'
	DB	0CFH,003H,003H,'INX.'
	DB	0EFH,00AH,003H,'LDAX'
	DB	0CFH,0C1H,003H,'POP.'
	DB	0CFH,0C5H,003H,'PUSH'
	DB	0EFH,002H,003H,'STAX'
	DB	0C7H,006H,004H,'MVI.'
	DB	0FFH,0CEH,005H,'ACI.'
	DB	0FFH,0C6H,005H,'ADI.'
	DB	0FFH,0E6H,005H,'ANI.'
	DB	0FFH,0FEH,005H,'CPI.'
	DB	0FFH,0DBH,005H,'IN..'
	DB	0FFH,0F6H,005H,'ORI.'
	DB	0FFH,0D3H,005H,'OUT.'
	DB	0FFH,0DEH,005H,'SBI.'
	DB	0FFH,0D6H,005H,'SUI.'
	DB	0FFH,0EEH,005H,'XRI.'
	DB	0CFH,001H,006H,'LXI.'
	DB	0FFH,0CDH,007H,'CALL'
	DB	0FFH,0C3H,007H,'JMP.'
	DB	0FFH,03AH,007H,'LDA.'
	DB	0FFH,02AH,007H,'LHLD'
	DB	0FFH,022H,007H,'SHLD'
	DB	0FFH,032H,007H,'STA.'
	DB	0C7H,0C4H,008H,'C...'
	DB	0C7H,0C2H,008H,'J...'
	DB	0C7H,0C0H,009H,'R...'
	DB	0C7H,0C7H,00AH,'RST.'
	DB	0C0H,040H,00BH,'MOV.'
	DB	0FFH,010H,00DH,'DJNZ'
	DB	0FFH,018H,00DH,'JMPR'
	DB	0E7H,020H,00EH,'JR..'
	DB	0FFH,0CBH,00FH,'....'	;THE 'CB' SERIES
	DB	0FFH,0DDH,011H,'....'	; "  'DD'    "
	DB	0FFH,0FDH,012H,'....'	; "  'FD'    "
	DB	0FFH,0EDH,013H,'....'	; "  'ED'    "

OPC2	DB	0F8H,010H,001H,'RALR'
	DB	0F8H,018H,001H,'RARR'
	DB	0F8H,000H,001H,'RLCR'
	DB	0F8H,008H,001H,'RRCR'
	DB	0F8H,020H,001H,'SLAR'
	DB	0F8H,028H,001H,'SRAR'
	DB	0F8H,038H,001H,'SRLR'
	DB	0C0H,040H,00CH,'BIT.'
	DB	0C0H,080H,00CH,'RES.'
	DB	0C0H,0C0H,00CH,'SET.'
	DB	000H,000H,010H,'....'	;SENTINEL: ILLEGAL INSTRUCTION

OPC3	DB	0FFH,0E9H,014H,'PCI.'
	DB	0FFH,0F9H,014H,'SPI.'
	DB	0FFH,0E3H,014H,'XTI.'
	DB	0FFH,02BH,015H,'DCX.'
	DB	0FFH,023H,015H,'INX.'
	DB	0FFH,0E1H,015H,'POP.'
	DB	0FFH,0E5H,015H,'PUSH'
	DB	0CFH,009H,016H,'DAD.'
	DB	0FFH,08EH,017H,'ADC.'
	DB	0FFH,086H,017H,'ADD.'
	DB	0FFH,0A6H,017H,'ANA.'
	DB	0FFH,0BEH,017H,'CMP.'
	DB	0FFH,035H,017H,'DCR.'
	DB	0FFH,034H,017H,'INR.'
	DB	0FFH,0B6H,017H,'ORA.'
	DB	0FFH,09EH,017H,'SBB.'
	DB	0FFH,096H,017H,'SUB.'
	DB	0FFH,0AEH,017H,'XRA.'
	DB	0C7H,046H,018H,'MOV.'
	DB	0F8H,070H,019H,'MOV.'
	DB	0FFH,021H,01AH,'LXI.'
	DB	0FFH,02AH,01BH,'LI..'
	DB	0FFH,022H,01BH,'SI..'
	DB	0FFH,036H,01CH,'MVI.'
	DB	0CBH,0CBH,01DH,'....'
	DB	000H,000H,010H,'....'	;SENTINEL: ILLEGAL INSTRUCTION

OPC4	DB	0FEH,070H,010H,'....'	;PREVENTS 'INP M'
	DB	0FFH,046H,000H,'IM0.'
	DB	0FFH,056H,000H,'IM1.'
	DB	0FFH,05EH,000H,'IM2.'
	DB	0FFH,057H,000H,'LDAI'
	DB	0FFH,05FH,000H,'LDAR'
	DB	0FFH,044H,000H,'NEG.'
	DB	0FFH,04DH,000H,'RETI'
	DB	0FFH,045H,000H,'RETN'
	DB	0FFH,06FH,000H,'RLD.'
	DB	0FFH,067H,000H,'RRD.'
	DB	0FFH,047H,000H,'STAI'
	DB	0FFH,04FH,000H,'STAR'
	DB	0C7H,040H,002H,'INP.'
	DB	0C7H,041H,002H,'OUTP'
	DB	0CFH,04AH,003H,'DADC'
	DB	0CFH,042H,003H,'DSBC'
	DB	0E7H,0A1H,01EH,'CC..'
	DB	0E7H,0A2H,01EH,'IN..'
	DB	0E7H,0A0H,01EH,'LD..'
	DB	0E7H,0A3H,01EH,'OUT.'
	DB	0CFH,04BH,01FH,'L...'
	DB	0CFH,043H,01FH,'S...'
	DB	000H,000H,010H,'....'	;SENTINEL: ILLEGAL INSTRUCTION
;
; INSTRUCTION TYPE HANDLING VECTOR TABLE
;
JMPTBL	DW T00,T01,T02,T03,T04,T05,T06,T07,T08,T09,T0A,T0B,T0C,T0D,T0E,T0F
	DW T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T1A,T1B,T1C,T1D,T1E,T1F
;
; CONDITIONS AND REGISTER NAMES
;
CNDTAB	DB	'NZZ.NCC.POPEP.M.'
REGTAB	DB	'BCDEHLMA'
;
; FLAGS AND BUFFERS
;
OPCTP	DB	?
