; DASM86.ASM - 04 Dec 1996
;
; This is the 8086 disassembler module for DASM.ASM.
; It is included into DASM during assembly.

	DISPLAY	"DASM with 8086 mnemonics"
	
;
; This is the Header to be printed for this module
;
HEADER	DB	'Disassembler for Intel 8086/8088 mnemonics',CR,LF
	DB	'Derived from RESOURCE',CR,LF,'$'

;
; EXTRA PROLOG, TO BE PRINTED BEFORE THE EQUATES AND THE 'ORG' DIRECTIVE
;
XPROLG:	CALL	PSTG
	DB	'CSEG',TAB,'SEGMENT BYTE PUBLIC ',QUOTE,'CODE',QUOTE,CR
	DB	TAB,'ASSUME',TAB,'CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG',CR
	DB	CR
	DB	TAB,'ORG',TAB,'0000H',CR
	DB	0
	RET

;
; EXTRA EPILOG, TO BE PRINTED BEFORE THE 'END' DIRECTIVE
;
XEPILG:	CALL	PSTG
	DB	'CSEG',TAB,'ENDS',CR,0
	RET

;
; This is the Disassembler Module -- Instruction to be disassembled
; is pointed to by PC
;
DASM:	MOV	BYTE PTR [SEGOVR],0	;INIT SEGMENT OVERRIDE FLAG
	CALL	HSYM			;WRITE LABEL, DISPLAY [PC]
	MOV	BX,[RPLPTR]		;CHECK IF THIS LINE IS REPLACED
	OR	BX,BX
	JZ	DASM1
	MOV	CH,[BX]
	INC	BX			;IF SO:	SKIP THE '*'
	DEC	CH
	CALL	NWLN0			;	AND PRINT THE REPLACING LINE
;
; DECODE INSTRUCTION TYPE AND PRINT MNEMONIC
;
DASM1:	MOV	BX,[PC]			;COMPUTE [BIASED] = [PC] + [OFFS]
	ADD	BX,[OFFS]
	MOV	[BIASED],BX
	MOV	CH,[BX]			;DECODE FIRST INSTRUCTION BYTE
	INC	WORD PTR [PC]
	MOV	SI,OFFSET OPC
	CALL	DECODE
	CMP	AL,05H			;TYPES 0 THRU 4 ARE 1 BYTE
	JB	DASM2			; .. SO DON'T CHANGE THE PC
	INC	WORD PTR [PC]
;
; DECODE REMAINDER OF INSTRUCTION VIA INSTRUCTION TYPE JUMP TABLE
;
DASM2:	MOV	DL,AL
	XOR	DH,DH
	MOV	BX,OFFSET JMPTBL
	ADD	BX,DX			;ADD 2*OPCODE TYPE TO JMPTBL TO GET
	ADD	BX,DX			;.. ROUTINE ADDRESS
	MOV	DX,[BX]			;GET THE ROUTINE ADDRESS
	PUSH	DX			;PUSH IT ON STACK
	MOV	BX,[BIASED]
	RET				;'RETURN' TO THE ROUTINE
;
; GET OPCODE TYPE AND PRINT MNEMONIC
;
; IN :	SI	OFFSET CODE TABLE
;	CH	INSTRUCTION BYTE
; OUT:	AL	OPCODE TYPE
;
DECODE:	LODSB
DECOD1:	AND	AL,CH			;MASK OUT VARIABLES
	CMP	AL,[SI]			;COMPARE GENERIC INSTRUCTION
	JZ	DECOD3			;MATCH
	ADD	SI,2
DECOD2:	LODSB				;NO MATCH: SKIP TO NEXT ENTRY
	AND	AL,AL			;  (STARTS WITH NEGATIVE BYTE)
	JNS	DECOD2
	JMP	SHORT DECOD1		;TRY NEXT ENTRY
DECOD3:	INC	SI			;MATCH: SKIP VARIABLE MASK
	LODSB				;GET INSTRUCTION TYPE
	PUSH	AX			;SAVE IT
DECOD4:	LODSB				;PRINT OPCODE
	OR	AL,AL			;STOP AT FIRST NEGATIVE BYTE
	JS	DECOD5
	CALL	COUT
	JMP	SHORT DECOD4
DECOD5:	POP	AX
	RET
;
; ONE BYTE SIMPLE INSTRUCTIONS
;
T00:	JMP	DCRLF
;
; MNEMONIC + DOUBLE REG
;
T01:	MOV	AL,[BX]
	AND	AL,07H			;ISOLATE REG CODING
	CALL	PDREG			;PRINT THE  REG
	JMP	DCRLF
;
; MNEMONIC + SEGMENT REG
;
T02:	MOV	AL,[BX]
	CALL	DSREG
	JMP	DCRLF
;
; SEGMENT OVERRIDE
;
T03:	MOV	BYTE PTR [SEGOVR],1
	MOV	AL,[BX]
	MOV	[ATSEG],AL
;;	JMP	SHORT T04
;
; PREFIXES
;
T04:	JMP	DASM1			;STAY ON THE SAME LINE
;
; REG - REG/MEM OPERATIONS
;
T05:	MOV	AL,[BX]
	AND	AL,01H			;WORD SIZE BIT
	MOV	[WRDBIT],AL
	TEST	BYTE PTR [BX],02H	;DESTINATION BIT
	JNZ	T07_A			;FIRST REG, THEN R-M
	CALL	REGMEM			;FIRST R-M, THEN REG
	CALL	PCOMMA
	CALL	TREG
	JMP	PTSYM
;
; IDEM, NO DIRECTION BIT
;
T06:	MOV	AL,[BX]
	AND	AL,01H
	MOV	[WRDBIT],AL
	JMP	SHORT T07_A
;
; IDEM, ALWAYS 16 BIT (LEA)
;
T07:	MOV	BYTE PTR [WRDBIT],1
T07_A:	CALL	TREG			;FIRST REG THEN R-M
	CALL	PCOMMA
	CALL	REGMEM
	JMP	PTSYM
;
; MOVE IMMED TO REG [8/16 BIT, 2/3 BYTES]
;
T08:	TEST	BYTE PTR [BX],08H	;WORD SIZE BIT
	JNZ	T08_W
	MOV	AL,[BX]			;8-BIT
	AND	AL,07H
	CALL	PREG
	CALL	PCOMMA
	MOV	BX,[BIASED]
	INC	BX
	CALL	DTABYT
	JMP	DCRLF
;
T08_W:	INC	WORD PTR [PC]		;16 BIT
	MOV	AL,[BX]
	AND	AL,07H
	CALL	PDREG
	CALL	PCOMMA
	MOV	BYTE PTR [IMMFL],1
	MOV	BX,[BIASED]
	CALL	PRNN
	JNC	T08_W1
	CALL	PDERTN
T08_W1:	JMP	DCRLF
;
; IMMED ARITM/LOGIC WITH ACCU [8/16 BIT, 2/3 BYTES]
;
T09:	TEST	BYTE PTR [BX],01H	;WORD SIZE BIT
	JNZ	T09_W
	CALL	PSTG			;8 BIT
	DB	'AL,',0
	INC	BX
	CALL	DTABYT
	JMP	SHORT T09_X
T09_W:	INC	WORD PTR [PC]		;16 BIT
	CALL	PSTG
	DB	'AX,',0
	MOV	BYTE PTR [IMMFL],1
	CALL	PRNN
	JNC	T09_X
	CALL	PDERTN
T09_X:	JMP	DCRLF
;
; MNEMONIC + 8 BIT DATA / NEVER PRINTED AS ASCII
;
T0A:	MOV	AL,[BX+1]
	CALL	PTBNUM
	JMP	DCRLF
;
; MOVE SEGMENT REG TO REG/MEM
;
T0B:	MOV	BYTE PTR [WRDBIT],1
	CALL	REGMEM
	CALL	PCOMMA
	INC	BX
	MOV	AL,[BX]
	CALL	DSREG
	JMP	PTSYM
;
; MOVE REG/MEM TO SEGMENT REG
;
T0C:	INC	BX
	MOV	AL,[BX]
	CALL	DSREG
	CALL	PCOMMA
	MOV	BYTE PTR [WRDBIT],1
	CALL	REGMEM
	JMP	PTSYM
;
; OUT PORT, ACCU
;
T0D:	INC	BX			;POINT TO BYTE
	MOV	AL,[BX]
	CALL	PTBHEX
	TEST	BYTE PTR [BX-1],01H	;WORD SIZE BIT
	JNZ	T0D_W
	CALL	PSTG			;8 BIT
	DB	',AL',0
	JMP	DCRLF
T0D_W:	CALL	PSTG			;16 BIT
	DB	',AX',0
	JMP	DCRLF
;
; CONDITIONAL RELATIVE JUMPS
;
T0E:	CALL	PRCND
	MOV	BX,[BIASED]
	CALL	PTAB
;
; SHORT JUMP AND LOOPS
;
T0F:	MOV	AL,[BX]
	CMP	AL,0EBH			;JUMP SHORT
	JNZ	T0F_A
	CALL	PSPACE
T0F_A:	MOV	AL,[BX+1]		;GET DESTINATION OFFSET
	CBW				;SIGN EXTEND INTO AX
	ADD	AX,[PC]			;ADD [PC]
	MOV	DX,AX			;PRINT DESTINATION
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNTDE
	JNC	T0F_B
	CALL	PDERTN
T0F_B:	JMP	DCRLF
;
; ESCAPE
;
T10:	MOV	AL,[BX]
	AND	AL,07H			;HIGH 3 BITS OF ESC NUMBER
	RCL	AL,1
	RCL	AL,1
	RCL	AL,1
	MOV	AH,AL
	INC	BX
	MOV	AL,[BX]
	AND	AL,38H			;LOW 3 BITS
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	OR	AL,AH
	CALL	PTBNUM
	CALL	PCOMMA
	MOV	BYTE PTR [WRDBIT],1
	CALL	REGMEM
	JMP	PTSYM
;
; RETURN WITH STACK THROW-AWAY
;
T11:	INC	WORD PTR [PC]
	INC	BX
	MOV	DX,[BX]
	INC	BX
	CALL	PTWHEX
	JMP	DCRLF
;
; NEAR JUMPS AND CALLS
;
T12:	INC	WORD PTR [PC]
	MOV	DX,[BX+1]
	ADD	DX,[PC]
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNTDE
	JNC	T12_A
	CALL	PDERTN
T12_A:	JMP	DCRLF
;
; MOVE MEM FROM/TO ACCU
;
T13:	INC	WORD PTR [PC]
	MOV	AL,[BX]
	AND	AL,01H
	MOV	[WRDBIT],AL
	CALL	OVRRID			;CONDITIONAL 'BYTE PTR'/'WORD PTR'
	CALL	PSOVR			;CONDITIONAL SEGMENT OVERRIDE
	CALL	PLBRAC			;'['
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNN			;VALUE
	PUSHF
	CALL	PRBRAC			;']'
	POPF
	JNC	T13_A
	CALL	PDERTN
T13_A:	JMP	DCRLF
;
; MEM FROM ACCU (8/16 BIT)
;
T14:	INC	WORD PTR [PC]
	MOV	AL,[BX]
	AND	AL,01H
	MOV	[WRDBIT],AL
	CALL	OVRRID			;CONDITIONAL 'BYTE PTR'/'WORD PTR'
	CALL	PSOVR			;CONDITIONAL SEGMENT OVERRIDE
	CALL	PLBRAC			;'['
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNN			;VALUE
	PUSHF
	PUSH	DX
	MOV	BX,[BIASED]
	TEST	BYTE PTR [BX],01H	;WORD SIZE BIT
	JNZ	T14_W
	CALL	PSTG			;8 BIT
	DB	'],AL',0
	JMP	SHORT T14_X
T14_W:	CALL	PSTG			;16 BIT
	DB	'],AX',0
T14_X:	POP	DX
	POPF
	JNC	T14_X1
	CALL	PDERTN
T14_X1:	JMP	DCRLF
;
; MOVE REG/MEM IMMED [8/16 BIT, 3/4 BYTES]
; [ENTERED AS 2-BYTE INSTRUCTION]
;
T15:	TEST	BYTE PTR [BX+1],38H
	JZ	T15_A
	JMP	T26			;ILLEGAL SECOND BYTE
T15_A:	MOV	AL,[BX]
	AND	AL,01H
	MOV	[WRDBIT],AL
	JMP	RGIM
;
; FAR JUMP/CALL [5 BYTES]
;
T16:	ADD	WORD PTR [PC],3
	CALL	PSTG
	DB	'FAR PTR ',0
	MOV	BYTE PTR [IMMFL],0	;PRINT OFFSET
	CALL	PRNN
	RCR	AL,1			;SAVE CARRY FLAG
	AND	AL,80H
	MOV	[ADRFLG],AL
	MOV	[VALUE],DX		;SAVE OFFSET VALUE
	CALL	PTAB
	CALL	PSEMI
	CALL	PSTG			;PRINT SEGMENT AS COMMENT
	DB	'SEGMENT ',0
	MOV	BX,[BIASED]
	INC	BX
	INC	BX
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNN
	JC	T16_A
	CMP	BYTE PTR [ADRFLG],0
	JZ	T16_X
T16_A:	MOV	BYTE PTR [ADRFLG],0
	CMP	BYTE PTR [XCSW],0
	JZ	T16_X
	PUSH	DX
	CALL	PCRLF			;PRINT SYMBOL COMMENTS ON NEXT LINE
	CALL	PTAB
	CALL	PTAB
	CALL	PTAB
	CALL	PSEMI
	POP	DX
	CALL	PTWHEX			;PRINT SEGMENT
	CALL	PCOLON
	MOV	DX,[VALUE]		;RESTORE OFFSET VALUE
	CALL	PTWHEX			;PRINT IT
T16_X:	JMP	DCRLF
;
; SIMPLE 2-BYTE INSTRUCTIONS
;
T17:	JMP	DCRLF
;
; INSTRUCTIONS WITH SECONDARY OPCODE SPACE
;
; 80H-81H LEAD-IN
; ARITHM/LOGIC IMMED WITH REG/MEM
;
T18:	MOV	CH,[BX+1]		;GET SECOND CODE BYTE
	AND	CH,38H			;MASK FOR ALL SECONDARY CODES
	MOV	SI,OFFSET OPC3
	CALL	DECODE
	JMP	DASM2
;
; 83H LEAD-IN
; IDEM WITH SIGN-EXTENSION
;
T19:	MOV	CH,[BX+1]
	AND	CH,38H
	MOV	SI,OFFSET OPC4
	CALL	DECODE
	JMP	DASM2
;
; 8FH LEAD-IN
; POP REG/MEM
;
T1A:	TEST	BYTE PTR [BX+1],38H
	JZ	T1A_A
	JMP	T26			;UNDEFINED OPCODE
T1A_A:	CALL	PSTG
	DB	'POP',TAB,0
	JMP	T23
;
; D0H-D03H LEAD-IN
; SHIFT/ROTATE REG/MEM
;
T1B:	MOV	CH,[BX+1]
	AND	CH,38H
	MOV	SI,OFFSET OPC2
	CALL	DECODE
	JMP	DASM2
;
; 0F6H-0F7H LEAD-IN
; MULT/DIV
;
T1C:	MOV	CH,[BX+1]
	AND	CH,38H
	MOV	SI,OFFSET OPC5
	CALL	DECODE
	JMP	DASM2
;
; 0FEH LEAD-IN
; INC/DEC
;
T1D:	MOV	AL,[BX+1]
	AND	AL,38H
	JNZ	T1D_A
	CALL	PSTG			;INC
	DB	'INC',TAB,0
	JMP	T24
T1D_A:	CMP	AL,08H			;DEC
	JZ	T1D_B
	JMP	T26			;UNDEFINED OPCODE
T1D_B:	CALL	PSTG
	DB	'DEC',TAB,0
	JMP	T24
;
; 0FFH LEAD-IN
; INDIRECT JUMPS AND INC/DEC
;
T1E:	MOV	CH,[BX+1]
	AND	CH,38H
	MOV	SI,OFFSET OPC6
	CALL	DECODE
	JMP	DASM2
;
;
; DECODE SECONDARY OPCODE
;
; SHIFT/ROTATE
;
T1F:	MOV	AL,[BX]
	MOV	AH,AL
	AND	AH,01H			;WORD SIZE BIT
	MOV	[WRDBIT],AH
	AND	AL,02H			;'V' BIT
	PUSH	AX			;SAVE V
	CALL	REGMEM
	CALL	PCOMMA
	POP	AX			;RESTORE V
	OR	AL,AL
	JNZ	T1F_A
	MOV	AL,'1'			;SHIFT/ROTATE REG IMMED
	CALL	COUT
	JMP	PTSYM
T1F_A:	CALL	PSTG			;SHIFT/ROTATE REG REG
	DB	'CL',0
	JMP	PTSYM
;
; ARITH/LOGIC IMMED WITH REG/MEM
;
T20:	MOV	AL,[BX]
	AND	AL,01H			;WORD SIZE BIT
	MOV	[WRDBIT],AL
	JMP	RGIM
;
; 16-BIT OPERATION WITH 8-BIT DATA BYTE
;
T21:	MOV	BYTE PTR [WRDBIT],1
	CALL	REGMEM
	CALL	PCOMMA
	JMP	RGIMBW
;
; MNEMONIC + REG/MEM
;
T22:	MOV	AL,[BX]
	AND	AL,01H
	MOV	[WRDBIT],AL
	CALL	REGMEM
	JMP	PTSYM
;
; IDEM, ALWAYS 16-BIT
;
T23:	MOV	BYTE PTR [WRDBIT],1
	CALL	REGMEM
	JMP	PTSYM
;
; IDEM, WITH OVERRIDE
;
T24:	MOV	AL,[BX]
	AND	AL,01H
	MOV	[WRDBIT],AL
	CALL	REGMEM
	JMP	PTSYM
;
; FAR INDIRECT JUMPS AND CALLS
;
T25:	MOV	AL,'D'			;PRINT 'D' FOR 'DWORD PTR'
	CALL	COUT
	JMP	SHORT T23
;
; ALL UNDEFINED OPCODES COME HERE FOR A 'DB VALUE' TREATMENT
;
T26:	DEC	WORD PTR [PC]
	CALL	PSTG
	DB	'DB',TAB,0
	MOV	BX,[BIASED]
	CALL	DTABYT
	JMP	DCRLF
;
; NEAR INDIRECT JUMP/CALL
;
T27:	MOV	BYTE PTR [WRDBIT],1
	CALL	REGMEM
	JMP	PTSYM

;
; LDS AND LES
;
T28:	MOV	BYTE PTR [WRDBIT],1
	CALL	TREG			;FIRST REG THEN R-M
	CALL	PCOMMA
	JMP	T25			;2ND OPERAND IS 'DWORD PTR'

;
;---------------------------------------------------------------------------
;
; SUBROUTINES
;
;---------------------------------------------------------------------------

;
; PRINT THE CONDITION CODE LETTERS FOR THIS INSTRUCTION.
;
PRCND:	MOV	AL,[BX]
	AND	AL,0FH			;ISOLATE CONDITION CODE
	MOV	BX,OFFSET CNDTAB	;PT TO TABLE
;;	JMP	P2CTBL			;PRINT CONDITION CHARS
;
; PRINT 2 CHARS FROM TABLE
;
; IN :	BX	PT TO START OF TABLE
;	AL	TABLE INDEX
;
; THE SECOND CHARACTER IS NOT PRINTED IF IT IS A SPACE
;
P2CTBL:	XOR	AH,AH
	ADD	BX,AX
	ADD	BX,AX
	MOV	AL,[BX]
	CALL	COUT
	MOV	AL,[BX+1]
	CMP	AL,' '
	JZ	OVRRIX
	JMP	COUT
	RET
;
; PRINT 'WORD PTR'/'BYTE PTR' OVERRIDING OPERATOR
;
OVRRID:	CMP	BYTE PTR [WRDBIT],0
	JNZ	OVRRIW
	CALL	PSTG			;BYTE PTR
	DB	'BYTE PTR ',0
	RET
OVRRIW:	CALL	PSTG			;WORD PTR
	DB	'WORD PTR ',0
OVRRIX:	RET
;
; PRINT SEGMENT OVERRIDING OPERATOR
;
PSOVR:	CMP	BYTE PTR [SEGOVR],0
	JZ	PSOVR1
	MOV	AL,[ATSEG]
	CALL	DSREG
	CALL	PCOLON
	MOV	BYTE PTR [SEGOVR],0		;RESET SEMAPHORE
PSOVR1:	RET
;
; REG/MEM IMMED (8/16 BIT)
;
RGIM:	CALL	REGMEM
	CALL	PCOMMA
	CMP	BYTE PTR [WRDBIT],0
	JNZ	RMIMW
;
; 2ND OPERAND REG/MEM IMMED 8 BIT
;
RGIMB:	INC	WORD PTR [PC]		;8 BIT
	MOV	AL,[DTBOFF]
	XOR	AH,AH
	ADD	BX,AX
	INC	BX
	CALL	PTBYTE
	PUSH	BX			;SAVE DATA
	PUSHF				;SAVE FLAG
	JC	RGIMB1
	CMP	BYTE PTR [ADRFLG],80H
	JNE	RGIMB2
RGIMB1:	CMP	BYTE PTR [XCSW],0
	JNZ	RGIMB3
RGIMB2:	POPF				;CLEAN STACK
	POP	BX
	JMP	DCRLF
;
RGIMB3:	CALL	PTAB
	CALL	PSEMI
	MOV	AL,[ADRFLG]
	OR	AL,AL
	JZ	RGIMB4
	CMP	AL,01H
	JZ	RGIMB6			;NO ADDRESS INFO
	MOV	DX,[VALUE]		;RESTORE ADRESS
	CALL	PTWHEX
	JMP	SHORT RGIMB5
RGIMB4:	CALL	PMINUS
RGIMB5:	CALL	PCOMMA
RGIMB6:	POPF				;RESTORE FLAG
	POP	BX			;RESTORE DATA
	JNC	RGIMB7
	MOV	AL,[BX]
	CALL	PTBNUM
	JMP	SHORT RGIMB8
RGIMB7:	CALL	PMINUS
RGIMB8:	JMP	DCRLF
;
; 2ND OPERAND REG/MEM IMMED 8 BIT AS 16 BIT VALUE
;
RGIMBW:	INC	WORD PTR [PC]		;8 BIT
	MOV	BYTE PTR [IMMFL],1	;IMMEDIATE
	MOV	AL,[DTBOFF]
	XOR	AH,AH
	ADD	BX,AX
	INC	BX
	MOV	AL,[BX]			;GET VALUE
	CBW				;SIGN EXTEND
	MOV	DX,AX			;INTO DX
	CALL	PRNTDE			;PRINT VALUE 
	JMP	SHORT RMIMW0 
;
; 2ND OPERAND REG/MEM IMMED 16 BIT
;
RMIMW:	ADD	WORD PTR [PC],2		;16 BIT
	MOV	BYTE PTR [IMMFL],1
	MOV	AL,[DTBOFF]
	XOR	AH,AH
	ADD	BX,AX
	CALL	PRNN
RMIMW0:	PUSH	DX			;SAVE DATA
	PUSHF				;SAVE FLAG
	JC	RMIMW1
	MOV	BYTE PTR [ADRFLG],80H
	JNZ	RMIMW2
RMIMW1:	CMP	BYTE PTR [XCSW],0
	JNZ	RMIMW3
RMIMW2:	POPF
	POP	DX			;CLEAN STACK
	JMP	DCRLF
;
RMIMW3:	CALL	PTAB
	CALL	PSEMI
	MOV	AL,[ADRFLG]
	CMP	AL,80H
	JZ	RMIMW4
	CMP	AL,01H
	JZ	RMIMW6
	CALL	PMINUS
	JMP	SHORT RMIMW5
RMIMW4:	MOV	DX,[VALUE]		;RESTORE ADDRESS
	CALL	PTWHEX			;PRINT IT
RMIMW5:	CALL	PCOMMA
RMIMW6:	POPF				;RESTORE FLAG
	POP	DX			;RESTORE DATA
	JC	RMIMW7
	CALL	PMINUS
	JMP	DCRLF
RMIMW7:	CALL	PTWHEX
	JMP	DCRLF
;
; DECODE AND PRINT R-M OPERAND
;
; IN :	Registers : don't care
;	[WRDBIT] and [SEGOVR]/[ATSEG] should be initialised by the caller
; OUT:	BX = [BIASED]
;	[ADRFLG]	Ternary flag	00H = address value printed
;					80H = address label printed
;					01H = no address info
;	[VALUE]		Address value IF ADRFLG is 80H or 00H
;	[DTBOFF]	Distance - 1 between [BIASED] and Data bytes if any
;	[PC]		Updated exclusive of data bytes if any
;
REGMEM:	MOV	AL,1
	MOV	[DTBOFF],AL		;AT LEAST TWO BYTES
	MOV	[ADRFLG],AL		;ASSUME NO ADDRESS INFO
	MOV	BX,[BIASED]
	MOV	AL,[BX+1]		;GET SECOND BYTE OF INSTRUCTION
	MOV	CL,AL
	ROL	AL,1
        ROL	AL,1
	AND	AL,03H			;MODE FIELD
	MOV	[MODE],AL
	CMP	AL,3
	JNZ	MEM
	MOV	AL,CL
	AND	AL,07H			;R-M FIELD DECODED AS REG
	CMP	BYTE PTR [WRDBIT],0
	JNZ	REGME1
	JMP	PREG			;8 BIT REG
REGME1:	JMP	PDREG			;16 BIT REG

MEM:	PUSH	CX			;R-M FIELD DECODED AS MEM
	MOV	AL,[BX+1]		;R/M BYTE
	AND	AL,0C0H			;MODE FIELD
	CMP	AL,0C0H
	JZ	MEM0			;REGISTER: NO OVERRIDE
	CALL	OVRRID			;OPTIONAL 'BYTE PTR'/'WORD PTR'
MEM0:	CALL	PSOVR			;OPTIONAL SEGMENT OVERRIDE
	POP	CX
	MOV	CH,CL
	AND	CH,07H
	CMP	CH,06H
	JNZ	MEM1
	CMP	BYTE PTR [MODE],0
	JNZ	MEM1
;MODE = 00 AND R-M = 110 --> ADDRESS FOLLOWS
	ADD	WORD PTR [PC],2		;2 EXTRA BYTES
	ADD	BYTE PTR [DTBOFF],2
	CALL	PLBRAC			;'['
	PUSH	BX
	INC	BX			;SKIP R/M BYTE
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNN
	MOV	[VALUE],DX
	POP	BX
	RCR	AL,1
	AND	AL,80H			;SAVE CARRY FLAG
	MOV	[ADRFLG],AL
	JMP	PRBRAC			;']'
;
MEM1:	MOV	AL,CH			;RESTORE R-M
	CMP	AL,00H
	JNZ	MEM2
	CALL	PSTG
	DB	'[BX+SI',0
	JMP	SHORT MEMX
MEM2:	CMP	AL,01H
	JNZ	MEM3
	CALL	PSTG
	DB	'[BX+DI',0
	JMP	SHORT MEMX
MEM3:	CMP	AL,02H
	JNZ	MEM4
	CALL	PSTG
	DB	'[BP+SI',0
	JMP	SHORT MEMX
MEM4:	CMP	AL,03H
	JNZ	MEM5
	CALL	PSTG
	DB	'[BP+DI',0
	JMP	SHORT MEMX
MEM5:	CMP	AL,04H
	JNZ	MEM6
	CALL	PSTG
	DB	'[SI',0
	JMP	SHORT MEMX
MEM6:	CMP	AL,05H
	JNZ	MEM7
	CALL	PSTG
	DB	'[DI',0
	JMP	SHORT MEMX
MEM7:	CMP	AL,06H
	JNZ	MEM8
	CALL	PSTG
	DB	'[BP',0
	JMP	SHORT MEMX
MEM8:	CALL	PSTG
	DB	'[BX',0
MEMX:	MOV	AL,[MODE]
	CMP	AL,00H
	JZ	MEMX3
	CMP	AL,01H
	JNZ	MEMX2
	INC	WORD PTR [PC]		;8 BIT DISPLACEMENT
	INC	BYTE PTR [DTBOFF]
	CALL	DIS8
	JMP	SHORT MEMX3
MEMX2:	ADD	WORD PTR [PC],2		;16 BIT DISPLACEMENT
	ADD	BYTE PTR [DTBOFF],2
	CALL	DIS16
MEMX3:	JMP	PRBRAC
;
; DECODE AND PRINT REG FIELD
;
TREG:	MOV	BX,[BIASED]
	MOV	AL,[BX+1]		;GET SECOND BYTE
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,07H			;REG BITS
	CMP	BYTE PTR [WRDBIT],0
	JZ	TREG1
	JMP	PDREG
TREG1:	JMP	PREG
;
; PRINT '+' OR '-', FOLLOWED BY 8 BIT DISPLACEMENT
;
DIS8:	MOV	AH,[BX+2]		;GET DISPLACEMENT IN AH
	MOV	AL,'+'			;ASSUME '+'
	OR	AH,AH			;TEST SIGN
	JGE	DIS8A
	NEG	AH			;MAKE IT '-'
	MOV	AL,'-'
DIS8A:	CALL	COUT
	MOV	AL,AH
	PUSH	BX
	CALL	PTBNUM
	POP	BX
	RET
;
; PRINT '+' FOLLOWED BY 16 BIT DISPLACEMENT
;
DIS16:	CALL	PPLUS
	PUSH	BX
	INC	BX
	MOV	BYTE PTR [IMMFL],0
	CALL	PRNN
	MOV	[VALUE],DX
	POP	BX
	RCR	AL,1
	AND	AL,80H			;SAVE CARRY FLAG
	MOV	[ADRFLG],AL
	RET
;
; PRINT 8 BIT REG
;
; IN :	AL	RANK OF REGISTER
;
PREG:	PUSH	BX
	MOV	BX,OFFSET REGTAB
	CALL	P2CTBL
	POP	BX
	RET
;
; PRINT 16 BIT REG
;
; IN :	AL	RANK OF REGISTER
;
PDREG:	PUSH	BX
	MOV	BX,OFFSET DREGTAB
	CALL	P2CTBL
	POP	BX
	RET
;
; DECODE AND PRINT SEGMENT REG
;
; IN : AL	INSTRUCTION CODE BYTE
;
DSREG:	PUSH	BX
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	AND	AL,03H
	MOV	BX,OFFSET SREGTAB
	CALL	P2CTBL
	POP	BX
	RET
;
; PRINT OPTIONAL SYMBOL COMMENT + NEWLINE
;
PTSYM:	CMP	BYTE PTR [XCSW],0
	JZ	PTSYM1
	CMP	BYTE PTR [ADRFLG],80H
	JNZ	PTSYM1
	MOV	DX,[VALUE]
	CALL	PDERTN
PTSYM1:	JMP	DCRLF
;
; PRINT THE NEXT 2 BYTES AS A SYMBOL (AND RETURN CARRY=1) IF POSSIBLE
;
; [IMMFL] IS SET IF IN IMMED MODE. UNLESS STARTING WITH CPREF FOR
; CONSTANT, A SYMBOLIC LABEL IS PRECEDED BY 'OFFSET'
;
PRNN:	INC	BX
	MOV	DX,[BX]
	INC	BX
;;	JMP	SHORT PRNTDE
;
; PRINT DX AS A SYMBOL (AND RETURN CARRY=1) IF POSSIBLE
;
; [IMMFL] IS SET IF IN IMMED MODE. UNLESS STARTING WITH CPREF FOR
; CONSTANT, A SYMBOLIC LABEL IS PRECEDED BY 'OFFSET '
;
PRNTDE:	CALL	SYMSCH			;SEARCH SYMBOL
	JC	PRNTD2			;IF FOUND
	CMP	BYTE PTR [IMMFL],0	;	IF NOT IMMEDIATE
	JZ	PRNTD1
	CMP	BYTE PTR [BX],CPREF	;	AND FIRST CHARACTER <> CPREF
	JZ	PRNTD1
	CALL	PSTG			;		PRINT 'OFFSET ' PREFIX
	DB	'OFFSET ',0
PRNTD1:	CALL	PRTSTR			;	PRINT SYMBOL NAME
	STC				;	RETURN C
	JMP	SHORT PRNTDX
PRNTD2:	CMP	BYTE PTR [BUILD],0	;ELSE	BUILD SYMBOL IF WANTED
	JZ	PRNTD3
	CALL	BLDSYM
PRNTD3:	CALL	PTWHEX			;	PRINT HEX WORD
	CLC				;	RETURN NC
PRNTDX:	RET
;
; VARIOUS COMMON CHARACTER PRINT ROUTINES
;
PLBRAC:	MOV	AL,'['
	JMP	COUT
;
PRBRAC:	MOV	AL,']'
	JMP	COUT
;
PPLUS:	MOV	AL,'+'
	JMP	COUT
;
PMINUS:	MOV	AL,'-'
	JMP	COUT
;
; DECODE JUMP TABLE
;
JMPTBL:	DW	T00			;MNEMONIC ONLY
	DW	T01			;MNEMONIC + 16 BIT REG
	DW	T02			;MNEMONIC + SEGMENT REG
	DW	T03			;PREFIXES
	DW	T04			;SEGMENT OVERRIDE
	;
	; INSTRUCTIONS WITH AT LEAST 2 BYTES
	;
	DW	T05			;REG - REG/MEM OPERAND
	DW	T06
	DW	T07
	DW	T08			;IMMED MOVE TO REG
	DW	T09			;IMMED ARIT/LOGIC WITH ACCU
	DW	T0A			;8 BIT DATA, NEVER AS SYMBOL
	DW	T0B			;SEGMENT REG MOVE
	DW	T0C
	DW	T0D			;OUT
	DW	T0E			;CONDITIONAL, RELATIVE JUMPS
	DW	T0F			;LOOPS AND JUMP SHORT
	DW	T10			;ESCAPE
	DW	T11			;RETURN WITH STACK THROW-AWAY
	DW	T12			;NEAR JUMP/CALL
	DW	T13			;MOVE MEM <=> ACCU
	DW	T14
	DW	T15			;MOVE REG/MEM IMMED
	DW	T16			;FAR JUMP/CALL
	DW	T17			;SIMPLE 2-BYTE INSTRUCTIONS
	;
	; SECONDARY OPCODE SPACE LEAD-IN'S
	;
	DW	T18
	DW	T19
	DW	T1A
	DW	T1B
	DW	T1C
	DW	T1D
	DW	T1E
	;
	; MULTI-BYTE OPCODES
	;
	DW	T1F			;SHIFT/ROTATE
	DW	T20			;ARITHM/LOGIC IMMED WITH R/M
	DW	T21
	DW	T22			;MNEMONIC + R/M
	DW	T23
	DW	T24
	DW	T25
	DW	T26			;UNDEFINED OPCODES
	DW	T27			;NEAR INDIRECT JMP/CALL
	DW	T28			;LDS AND LES
;
; OPCODE TABLES
;
OPC	DB	0FFH,027H,000H,'DAA'
	DB	0FFH,02FH,000H,'DAS'
	DB	0FFH,037H,000H,'AAA'
	DB	0FFH,03FH,000H,'AAS'
	DB	0FFH,090H,000H,'NOP'
	DB	0FFH,098H,000H,'CBW'
	DB	0FFH,099H,000H,'CWD'
	DB	0FFH,09BH,000H,'WAIT'
	DB	0FFH,09CH,000H,'PUSHF'
	DB	0FFH,09DH,000H,'POPF'
	DB	0FFH,09EH,000H,'SAHF'
	DB	0FFH,09FH,000H,'LAHF'
	DB	0FFH,0A4H,000H,'MOVSB'
	DB	0FFH,0A5H,000H,'MOVSW'
	DB	0FFH,0A6H,000H,'CMPSB'
	DB	0FFH,0A7H,000H,'CMPSW'
	DB	0FFH,0AAH,000H,'STOSB'
	DB	0FFH,0ABH,000H,'STOSW'
	DB	0FFH,0ACH,000H,'LODSB'
	DB	0FFH,0ADH,000H,'LODSW'
	DB	0FFH,0AEH,000H,'SCASB'
	DB	0FFH,0AFH,000H,'SCASW'
	DB	0FFH,0C3H,000H,'RET'
	DB	0FFH,0CBH,000H,'RETF'
	DB	0FFH,0CEH,000H,'INTO'
	DB	0FFH,0CCH,000H,'INT	3'
	DB	0FFH,0CFH,000H,'IRET'
	DB	0FFH,0D7H,000H,'XLAT'
	DB	0FFH,0ECH,000H,'IN	AL,DX'
	DB	0FFH,0EDH,000H,'IN	AX,DX'
	DB	0FFH,0EEH,000H,'OUT	DX,AL'
	DB	0FFH,0EFH,000H,'OUT	DX,AX'
	DB	0FFH,0F4H,000H,'HLT'
	DB	0FFH,0F5H,000H,'CMC'
	DB	0FFH,0F8H,000H,'CLC'
	DB	0FFH,0F9H,000H,'STC'
	DB	0FFH,0FAH,000H,'CLI'
	DB	0FFH,0FBH,000H,'STI'
	DB	0FFH,0FCH,000H,'CLD'
	DB	0FFH,0FDH,000H,'STD'
	DB	0F8H,040H,001H,'INC	'
	DB	0F8H,048H,001H,'DEC	'
	DB	0F8H,050H,001H,'PUSH	'
	DB	0F8H,058H,001H,'POP	'
	DB	0F8H,090H,001H,'XCHG	AX,'
	DB	0E7H,006H,002H,'PUSH	'
	DB	0E7H,007H,002H,'POP	'
	DB	0E7H,026H,003H
	DB	0FFH,0F2H,004H,'REPNZ	'
	DB	0FFH,0F3H,004H,'REPZ	'
	DB	0FFH,0F0H,004H,'LOCK	'
	DB	0FCH,000H,005H,'ADD	'
	DB	0FCH,008H,005H,'OR	'
	DB	0FCH,010H,005H,'ADC	'
	DB	0FCH,018H,005H,'SBB	'
	DB	0FCH,020H,005H,'AND	'
	DB	0FCH,028H,005H,'SUB	'
	DB	0FCH,030H,005H,'XOR	'
	DB	0FCH,038H,005H,'CMP	'
	DB	0FCH,088H,005H,'MOV	'
	DB	0FEH,086H,006H,'XCHG	'
	DB	0FEH,084H,006H,'TEST	'
	DB	0FFH,08DH,007H,'LEA	'
	DB	0FFH,0C4H,028H,'LES	'
	DB	0FFH,0C5H,028H,'LDS	'
	DB	0F0H,0B0H,008H,'MOV	'
	DB	0FEH,004H,009H,'ADD	'
	DB	0FEH,00CH,009H,'OR	'
	DB	0FEH,014H,009H,'ADC	'
	DB	0FEH,01CH,009H,'SBB	'
	DB	0FEH,024H,009H,'AND	'
	DB	0FEH,02CH,009H,'SUB	'
	DB	0FEH,034H,009H,'XOR	'
	DB	0FEH,03CH,009H,'CMP	'
	DB	0FEH,0A8H,009H,'TEST	'
	DB	0FFH,0CDH,00AH,'INT	'
	DB	0FFH,0E4H,00AH,'IN	AL,'
	DB	0FFH,0E5H,00AH,'IN	AX,'
	DB	0FFH,08CH,00BH,'MOV	'
	DB	0FFH,08EH,00CH,'MOV	'
	DB	0FEH,0E6H,00DH,'OUT	'
	DB	0F0H,070H,00EH,'J'
	DB	0FFH,0E0H,00FH,'LOOPNZ	'
	DB	0FFH,0E1H,00FH,'LOOPZ	'
	DB	0FFH,0E2H,00FH,'LOOP	'
	DB	0FFH,0E3H,00FH,'JCXZ	'
	DB	0FFH,0EBH,00FH,'JMP	SHORT'
	DB	0F8H,0D8H,010H,'ESC	'
	DB	0FFH,0C2H,011H,'RET	'	;RET  nn
	DB	0FFH,0CAH,011H,'RETF	'	;RETF nn
	DB	0FFH,0E8H,012H,'CALL	'
	DB	0FFH,0E9H,012H,'JMP	'
	DB	0FFH,0A0H,013H,'MOV	AL,'
	DB	0FFH,0A1H,013H,'MOV	AX,'
	DB	0FEH,0A2H,014H,'MOV	'
	DB	0FEH,0C6H,015H,'MOV	'
	DB	0FFH,09AH,016H,'CALL	'	;CALL FAR PTR
	DB	0FFH,0EAH,016H,'JMP	'	;JMP FAR PTR
	DB	0FFH,0D4H,017H,'AAM'
	DB	0FFH,0D5H,017H,'AAD'
	DB	0FEH,080H,018H
	DB	0FFH,083H,019H
	DB	0FFH,08FH,01AH
	DB	0FCH,0D0H,01BH
	DB	0FEH,0F6H,01CH
	DB	0FFH,0FEH,01DH
	DB	0FFH,0FFH,01EH
	DB	0FFH,00FH,026H			;UNDEFINED OPCODES
	DB	0F0H,060H,026H
	DB	0FFH,082H,026H
	DB	0FFH,0C0H,026H
	DB	0FFH,0C1H,026H
	DB	0FFH,0C8H,026H
	DB	0FFH,0C9H,026H
	DB	0FFH,0D6H,026H
	DB	0FFH,0F1H,026H
;
OPC2	DB	0FFH,000H,01FH,'ROL	'
	DB	0FFH,008H,01FH,'ROR	'
	DB	0FFH,010H,01FH,'RCL	'
	DB	0FFH,018H,01FH,'RCR	'
	DB	0FFH,020H,01FH,'SHL	'
	DB	0FFH,028H,01FH,'SHR	'
	DB	0FFH,030H,026H
	DB	0FFH,038H,01FH,'SAR	'
;
OPC3	DB	0FFH,000H,020H,'ADD	'
	DB	0FFH,008H,020H,'OR	'
	DB	0FFH,010H,020H,'ADC	'
	DB	0FFH,018H,020H,'SBB	'
	DB	0FFH,020H,020H,'AND	'
	DB	0FFH,028H,020H,'SUB	'
	DB	0FFH,030H,020H,'XOR	'
	DB	0FFH,038H,020H,'CMP	'
;
OPC4	DB	0FFH,000H,021H,'ADD	'
	DB	0FFH,008H,021H,'OR	'
	DB	0FFH,010H,021H,'ADC	'
	DB	0FFH,018H,021H,'SBB	'
	DB	0FFH,020H,021H,'AND	'
	DB	0FFH,028H,021H,'SUB	'
	DB	0FFH,030H,021H,'XOR	'
	DB	0FFH,038H,021H,'CMP	'
;
OPC5	DB	0FFH,000H,020H,'TEST	'
	DB	0FFH,008H,026H
	DB	0FFH,010H,024H,'NOT	'
	DB	0FFH,018H,024H,'NEG	'
	DB	0FFH,020H,022H,'MUL	'
	DB	0FFH,028H,022H,'IMUL	'
	DB	0FFH,030H,022H,'DIV	'
	DB	0FFH,038H,022H,'IDIV	'
;
OPC6	DB	0FFH,000H,024H,'INC	'
	DB	0FFH,008H,024H,'DEC	'
	DB	0FFH,010H,027H,'CALL	'
	DB	0FFH,018H,025H,'CALL	'
	DB	0FFH,020H,027H,'JMP	'
	DB	0FFH,028H,025H,'JMP	'
	DB	0FFH,030H,023H,'PUSH	'
	DB	0FFH,038H,026H
	DB	0FFH					;SENTINEL
;
; REG AND CONDITION DECODE TABLES
;
REGTAB		DB	'AL','CL','DL','BL','AH','CH','DH','BH'
DREGTAB		DB	'AX','CX','DX','BX','SP','BP','SI','DI'
SREGTAB		DB	'ES','CS','SS','DS'
CNDTAB		DB	'O ','NO','B ','NB','Z ','NZ','BE','A '
		DB	'S ','NS','PE','PO','L ','GE','LE','G '
;
; VARIOUS FLAGS AND BUFFERS
;
MODE	DB	0
WRDBIT	DB	0
DTBOFF	DB	0
ADRFLG	DB	0	;00h = value, 80h = label, 01h = no address info
VALUE	DW	0
SEGOVR	DB	0
ATSEG	DB	0
IMMFL	DB	0
