#!/usr/local/bin/perl
#
# Detect "Endian Ploblem"
# 
# 
# Copyright(C) 1997,1998 SES,Inc.
# Programmed by ShiGe & J.Adachi
#
# history: 1997/10/30 created  By ShiGe
# 
# History  : 1998/08/28 J.Adachi	Create English Version.
#

require "sbfppmsg.pl";				# Include Assosiative Array.

$PNAME = "pfle";

sub pattern1 {
	local($line) = @_;
	return $line =~ /[^\w]memcpy\s*/;
}

sub pattern2 {
	local($line) = @_;
	return $line =~ /\*\s*\(\s*(unsigned|signed)\s+(int|long|short)\s*\*\s*\)/;
}

sub pattern3 {
	local($line) = @_;
	return $line =~ /(unsigned|signed)\s+(char|int|long|short)\s*\w+\s*:\s*\d+/;
}

sub pattern4 {
	local($line) = @_;
	return $line =~ /(char|int|long|short)\s*\w+\s*:\s*\d+/;
}

sub pattern5 {
	local($line) = @_;
	return $line =~ /(\.|->)sin_/;
}

{
	# Arg. Check
	if ((($insrcfile, $listfile) = @ARGV) != 2) {
		printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
		print STDERR "Usage: sbfppfle.pl InputSrcFile OutputListFile\n";
		exit(1);
	}
	
	# Open Outputfile
	# 
	if ( -e $listfile ) {						# Outputfile already exists.
		if(!open(LISTFILE, ">>$listfile")) {	# Append to Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "outputfile";
			exit(1);
		}
	} else {									# Outputfile not exists 
		if(!open(LISTFILE, ">$listfile")) {		# Create Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "outputfile";
			exit(1);
		}
	}

	# Open inputfile
	# 
	if(!open(INSRCFILE, "$insrcfile")) {
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		printf LISTFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		close(LISTFILE);
		exit(1);
	}


	undef(@ENDIANLINE);					# Detected Endianline
	
	$COMSW = "OFF";						# Comment Swich
		
	while(<INSRCFILE>) {
		chop($_);						# Chop CRLF
		$Line = $_;						# Set to Buffer
		undef(@left);					# Temp-Array

		if ($COMSW eq "ON") {			# Commentline
			if (/\*\//) {				# Detect End of Commentline
				$_ = $';				# Add buffer Rightside.
				$COMSW = "OFF";			# 
			} else {					# 
				next;					# Read Nextline.
			}
		}

		while(/\/\*/) { 				# Detect Comentlineve Array.# 
			push(@left, $`);			# Add buffer to Leftside.
			$COMSW = "ON";				# 
			$_ = $';					# Set Nextpart
			if (/\*\//) {				# Detect End of Commentline
				$COMSW = "OFF";			# 
				$_ = $';				# Add buffer Rightside.
			}
		}

		$_ = (@left ? join(" ", @left) : $Line);

		if (/(=\s*$|[^\w]memcpy\s*$)/) {
			$prevline = $Line;
			next;
		} else {
			$prevline = "";
		}
		
		if($prevline) {
			$_ = sprintf "%s%s", $prevline, $Line;
		}
		
		if (&pattern1($_)) {			# pattern 1: memcpy
			push(@ENDIANLINE, sprintf "line %d:%s\n", $., $Line);
		} elsif (&pattern2($_)) {		# pattern 2: = *(int  *)  
										#         or = *(unsigned int *)
										#   	  or = *(signed int *)
										#         or = *(long *)  
										#		  or = *(unsigned long *)
										#		  or = *(signed long *)
										#         or = *(short *) 
										# 		  or = *(unsigned short *)
										#		  or = *(signed short *)
			if ($prevline) {
				push(@ENDIANLINE, sprintf "line %d:%s\n", $.-1, $prevline);
			}
			push(@ENDIANLINE, sprintf "line %d:%s\n", $., $Line);
		} elsif (&pattern3($_)) {		# pattern 3: unsigned char flag:1 
			if ($prevline) {
				push(@ENDIANLINE, sprintf "line %d:%s\n", $.-1, $prevline);
			}
			push(@ENDIANLINE, sprintf "line %d:%s\n", $., $Line);
		} elsif (&pattern4($_)) {		# pattern 4: char flag:1
			if ($prevline) {
				push(@ENDIANLINE, sprintf "line %d:%s\n", $.-1, $prevline);
			}
			push(@ENDIANLINE, sprintf "line %d:%s\n", $., $Line);
		} elsif (&pattern5($_)) {
			if ($prevline) {
				push(@ENDIANLINE, sprintf "line %d:%s\n", $.-1, $prevline);
			}
			push(@ENDIANLINE, sprintf "line %d:%s\n", $., $Line);	
		}	

	}
	
	foreach (@ENDIANLINE) {
#		print STDOUT $_;
		print LISTFILE $_;
	}
	
	close(LISTFILE);
	close(INSRCFILE);

}

