#!/usr/local/bin/perl
#
# Detect errno
# Usage : sbfppfen.pl SourceFile OutPutFile
#
# Copyright(C) 1998, SES, Inc.
# All Rights reserved.
#
# Programmed by J.Adachi.
#
# History  : 1998/08/28 J.Adachi	Create English Version.
#
#

require "sbfppmsg.pl";			# Include Assosiative Array.

$PNAME = "pfen";				# Module Name
$USAGE = "Usage: sbfppfen.pl InputSrcFile OutputListFile\n";

{
	# Arg. Check
	if ((($insrcfile, $listfile) = @ARGV) != 2) {
		printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
		print STDERR $USAGE;
		exit(1);
	}
	
	# Open Outputfile
	# 
	if ( -e $listfile ) {						# Outputfile already exists.
		if(!open(LISTFILE, ">>$listfile")) {	# Append to Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "outputfile";
			exit(1);
		}
	} else {									# Outputfile not exists 
		if(!open(LISTFILE, ">$listfile")) {		# Create Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "outputfile";
			exit(1);
		}
	}

	# Open Inputfile
	# 
	if(!open(INSRCFILE, "$insrcfile")) {
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		printf LISTFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		close(LISTFILE);
		exit(1);
	}


	undef(@ERRNOLINE);					# errno Line
	
	$COMSW = "OFF";						# Initiate Comment-Detect Switch
	$idx = 1;							# Line Counter
		
	while(<INSRCFILE>) {
		chop($_);						# Chop CRLF
		$Line = $_;						# Set to Buffer
		undef(@left);					# Temp-Array

		if ($COMSW eq "ON") {			# Commentline
			if (/\*\//) {				# Detect End of Commentline
				$_ = $';				# Add buffer Rightside.
				$COMSW = "OFF";			# 
			} else {					# 
				next;					# Read Nextline.
			}
		}

		while(/\/\*/) { 				# Detect Comentline
			push(@left, $`);			# Add buffer to Leftside.
			$COMSW = "ON";				# 
			$_ = $';					# Set Nextpart
										# 
			if (/\*\//) {				# Detect End of Commentline
				$COMSW = "OFF";			# 
				$_ = $';				# Add buffer Rightside.
										# 
			}
		}

		$_ = (@left ? join(" ", @left) : $Line);

										# Ckech errno
										# 1) A-Z,a-z,0-9,_ Not found Before and After
										# 2) . Not found Before and After
										# 3) -> Not found Before and After
										
		if (/([^\w.]*|->)errno([^\w.]*|->)/) {	# Detect "errno"
			push(@ERRNOLINE, sprintf("line %d:%s\n", int($idx), $Line));
		}
	
		$idx++;		
	}

	foreach (@ERRNOLINE) {
		# Output Error Message to STDOUT and Logfile
#		print STDOUT $_;
		print LISTFILE $_;
	}
	
	close(LISTFILE);
	close(INSRCFILE);

}
