#!/perl/bin/perl
#
# Detect Define.
# Usage : sbfppcdn.pl Define SourceFile LogFile
#
# Copyright(C) 1998, SES, Inc.
# All Rights reserved.
#
# Programmed by J.Adachi.
#
# History  : 1998/08/28 J.Adachi	Create English Version.

require "sbfppmsg.pl";				# Include Assosiative Array.

$PNAME  = "pcdn";					# Module Name
$USAGE  = "Usage: sbfppcdn.pl Define SourceFile LogFile\n";

#
# Delete Commentline
#
sub tosscomment
{
	local($input, $logfile, $srcfile) = @_;

	$left = "";					# Temp Buffer

	$_ = $input;				# 
	
	# Loop to Line-End
	while (/\/\*/) {			# Commentline
		$left .= $`;			# Add buffer Leftside.
		$_ = $';				# 
		unless (/\*\//) {		# CommentLine Not Close
			# Output ErrorMessage
			printf STDERR $ERRMSG{"COM_NOEND"}, $PNAME, $srcfile;
			printf $logfile $ERRMSG{"COM_NOEND"}, $PNAME, $srcfile;
			close($logfile);
			exit(1);
		}
		
		$_ = $';				# Check Nextline.
	}

	# Add buffer
	local($retline) = "$left$_";

	return $retline				# return Line without commentpart.
}

#
# Main Part.
#
{
	# Arg. Check
	if ((($define, $insrcfile, $logfile) = @ARGV) != 3) {
		printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
		print STDERR $USAGE;
		exit(1);
	}
	
	# Open Outputfile
	# 
	if ( -e $logfile ) {						# Outputfile already exists.
		if(!open(LOGFILE, ">>$logfile")) {		# Append to Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "logfile";
			exit(1);
		}
	} else {									# Outputfile not exists 
		if(!open(LOGFILE, ">$logfile")) {		# Create Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "logfile";
			exit(1);
		}
	}

	# Open inputfile
	# 
	if(!open(INSRCFILE, "$insrcfile")) {
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		printf LOGFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		close(LOGFILE);
		exit(1);
	}


	undef(@SRCLINES);					# Sourcecode line

	while(<INSRCFILE>) {
		$Buffer .= $_;					# Read line to buffer
	}

	close(INSRCFILE);					# Close Sourcecode file

	# Delete Commentpart
	$_ = &tosscomment($Buffer, LOGFILE, $insrcfile);

	# Split to line.
	@SRCLINES = split("\n", $_);

	$DEFSW = 0;							# Define-Detect Switch

	foreach $SRCLINE (@SRCLINES) {

		# Detect #ifdef line or #ifndef line
		if (($SRCLINE =~ /^#ifdef\s*([\w].*)\s*/)
			||($SRCLINE =~ /^#ifndef\s*([\w].*)\s*/)) {
				if ($1 eq $define) {	# Define Name Already Exists
					$DEFSW = 1;
					last;				# Check end
				}
		} else {
			next;						# Nextline
		}
	}

	if ($DEFSW) {						# Define Name Already Exists
		# Output Warning to Logfine And STDOUT
		printf LOGFILE $ERRMSG{"DEF_USE"}, $PNAME, $define;
#		printf STDOUT $ERRMSG{"DEF_USE"}, $PNAME, $define, $insrcfile;
	} 
	
	close(LOGFILE);

}
