#!/usr/local/bin/perl
#
# Detect LineNo.
# Usage : sbfppccn.pl SourceFile LogFile
#
# Copyright(C) 1998, SES, Inc.
# All Rights reserved.
#
# Programmed by J.Adachi.
#
# History  : 1998/08/28 J.Adachi	Create English version.

require "sbfppmsg.pl";				# Include Assosiative Array. 

$PNAME  = "pccn";					# Module Name
$USAGE = "Usage: sbfppccn.pl SourceFile LogFile\n";
									# Usage
$LIMIT=72;							# Line Limit
$Tab = "        ";					# Space*8 replace to Tab.

#
# Main Part.
#
{
	# Arg. Check 
	if ((($insrcfile, $logfile) = @ARGV) != 2) {
		printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
		print STDERR $USAGE;
		exit(1);
	}
	
	# Open Output File
	#
	if ( -e $logfile ) {						# Outputfile already exists
		if(!open(LOGFILE, ">>$logfile")) {		# Append to Outputfile.
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "logfile";
			exit(1);
		}
	} else {									# Outputfile didnot exists
		if(!open(LOGFILE, ">$logfile")) {		# Create Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "logfile";
			exit(1);
		}
	}

	# Open inputfile
	# 
	if(!open(INSRCFILE, "$insrcfile")) {
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		printf LOGFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		exit(1);
		close(LOGFILE);
	}

	undef(@SRCLINES);					# SourceCode Line

	while(<INSRCFILE>) {
		chop($_);
		$linebuf = $_;
		s/(\t)/$Tab/g;					# Replace from Tab to Space*8
		if(length($_) > $LIMIT)	{
#			printf STDOUT "line %d:%s\n", $., $linebuf;
			printf LOGFILE "line %d:%s\n", $., $linebuf;
		}
	}

	close(INSRCFILE);					# Close Inputfile
	
	close(LOGFILE);

}
