#!/usr/local/bin/perl
#
# Add History to SourceCode
# 
# Usage : sbfppadh.pl InputSrcFile OutputSrcFile LogFile ConvFile [ Commentfile ] 
#														[ -k nkf-Path ]
#
# Copyright(C) 1998, SES, Inc.
# All Rights reserved.
#
# Programmed by J.Adachi.
# 
# History  : 1998/05/14 J.Adachi	Create
#          : 1998/05/18 J.Adachi    Modify Detect Banner-End
#
#
#          : 1998/05/27 J.Adachi	add require sbfppmsg.pl.
#
#          : 1998/06/01 J.Adachi	Add check NKF Command
#
#          : 1998/08/28 J.Adachi    Delete NKF Comamnd Check Routine.
#                                   (Call system() to nkf)
#                                   Because system() Return value not same on Windows 98
#                                   or on Windows NT.(Ver.1.1.1)
#          : 1998/09/07 J.Adachi    Abandon PIPE-Use.(Ver.1.1.2)

require "sbfppmsg.pl";			# Include Assosiative Array.

undef(@COMMENT);				# History which Add to sourcecode.
undef(@HEADER);					# Head-bunner of sourcecode 

$USAGE = "Usage : sbfppadh.pl InputSrcFile OutputSrcFile LogFile ConvFile [ Commentfile ] [ -k nkf-Path ]\n";

$PNAME = "padh";				# Module Name
$KCONV = "nkf32";				# Network Kanji-Code convert Filter(For Windows)
$CONVSW = 0;					# Knaji-Code Convert Switch
								# 1 = Convert with nkf.
								# 0 = Convert LF Only. (For English Version)

sub ReadCommentFile {

	local($fname, $logfile) = @_;
	
	if(!open(CMTFILE, "$fname")) {
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, $fname;
		printf $logfile $ERRMSG{"FILE_OPEN"}, $PNAME, $fname;
		return(1);
	}
	
	while(<CMTFILE>) {
		push(@COMMENT, $_);
	}
	
	close(CMTFILE);

	return(0);
}
		
{

	$COMFSW = 0;				# CommentFile Switch.
	$NKFPATH = "";				# Path for NKF.
	
	# Arg. Check.
	# 1. Arg.Number Check
	if ((@ARGV < 3) || (@ARGV > 7)) {
		printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
		print STDERR $USAGE;
		exit(1);
	}
	
	local($idx) = 0;

	$insrcfile  = $ARGV[$idx];		# Input SourceCode
	$idx++;
	$outsrcfile = $ARGV[$idx];		# Output SourceCode
	$idx++;
	$logfile    = $ARGV[$idx];		# Logfile
	$idx++;
	$convfile    = $ARGV[$idx];		# Convfile
	$idx++;

	if ($ARGV[$idx]) {
		if($ARGV[$idx] eq "-k") {		# -k Option
			if(@ARGV <= $idx+1) {		# Error if user not specified Fullpath
				printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
				print STDERR $USAGE;
				exit(1);
			} else {					# After -k, NKF-Path
				$idx++;
				$NKFPATH = $ARGV[$idx];
				$idx++;
			}
		} else {						# if Option is't -k, this option is commentfile.
			$comfile = $ARGV[$idx];
			$COMFSW = 1;
			$idx++;
			if ($ARGV[$idx] eq "-k") {	# Next arg. is -k
			if(@ARGV <= $idx+1) {		# Error if user not specified Fullpath
					printf STDERR $ERRMSG{"ARG_INVAL"}, $PNAME;
					print STDERR $USAGE;
					exit(1);
				} else {				# After -k, NKF-Path
					$idx++;
					$NKFPATH = $ARGV[$idx];
				}
			}
		}
	}
	
	# Open Logfile
	# 
	if ( -e $logfile ) {						# Outputfile already exists.
		if(!open(LOGFILE, ">>$logfile")) {		# Append to Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "logfile";
			exit(1);
		}
	} else {									# Outputfile not exists
		if(!open(LOGFILE, ">$logfile")) {		# Create Outputfile
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "logfile";
			exit(1);
		}
	}

	# Error if inputfile did'nt exists
	if(!( -e $insrcfile)) {
		printf LOGFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
		close(LOGFILE);
		exit(1);
	}
	
	# Check NKF-Path.
	if($NKFPATH) {				# Specified NKF-Path
								# Check User-Specified Path First
		$KCONV = $NKFPATH;		# Set User-Specified Command.
	}
								# Check NFK
	if ($CONVSW) {
		# Open inputfile with NKF.
		# 

		if(system("$KCONV -s -O $insrcfile $convfile")) {		# Convert is Failure
			printf LOGFILE $ERRMSG{"NKF_NOEXT"}, $PNAME;
			printf STDERR $ERRMSG{"NKF_NOEXT"}, $PNAME;
			close(LOGFILE);
			exit(1);
		}

		if(!open(INSRCFILE, "$convfile")) {
			printf LOGFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
			close(LOGFILE);
			exit(1);
		}
		
	} else {

		# Open inputfile
		# 
		if(!open(INSRCFILE, "$insrcfile")) {
			printf LOGFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
			printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "inputfile";
			close(LOGFILE);
			exit(1);
		}
	}

	# Open Outputfile
	# 
	if(!open(OUTSRCFILE, ">$outsrcfile")) {
		printf LOGFILE $ERRMSG{"FILE_OPEN"}, $PNAME, "outputfile";
		printf STDERR $ERRMSG{"FILE_OPEN"}, $PNAME, "outputfile";
		close(LOGFILE);
		close(INSRCFILE);
		exit(1);
	}

	if ($COMFSW) {								# Specified CommentFile
		# Set @COMMENT to value of CommentFile
		# 

		if (&ReadCommentFile($comfile, LOGFILE)) {
			close(INSRCFILE);
			close(OUTSRCFILE);
			close(LOGFILE);
			exit(1);
		}

		# Header-Detect Swich ON.
		$HeadSW = "ON";
	}
		
	while(<INSRCFILE>) {

		# Set buffer to readline.
		$Line = $_;
		
		if($COMFSW) {						# Specified Commentfile.
			# check to Header-Detect Swich
			if ($HeadSW eq "ON") {
				# throw away comment-line.
				# 
				# 
			
				if ($Line =~ /^(\/\*|\/\/)/) {

					# set commentline to buffer
					push(@HEADER, $Line);
					next;

				} else {

					# pickup the last bunner.
					$tmpline = pop(@HEADER);
				
					# Add comment to Bunner
					foreach $Comline (@COMMENT) {
						push(@HEADER, $Comline);
					}
				
					# put back last bunner
					push(@HEADER, $tmpline);

					# output bunner
					print OUTSRCFILE $Val while defined($Val = shift(@HEADER));

					# output message to LogFile
					printf LOGFILE $ERRMSG{"ADD_HIST"}, $PNAME;
					
					# turn off Header switch
					$HeadSW = "OFF";
				}
			}
		}								# Specified Comment
		
		# output readline
		print OUTSRCFILE $Line;

	}
	# output message (Only Kanji-Convert)
	if (!$COMFSW) {
		printf LOGFILE $ERRMSG{"KANJI_CV"}, $PNAME;
	}

	# Close	files
	close(LOGFILE);
	close(INSRCFILE);
	close(OUTSRCFILE);

	
}
