/**************************************************************************
 * CuT v1.12                Copyright (c) 1998-99 by Joergen Ibsen / Jibz *
 *                                                    All Rights Reserved *
 *                                                                        *
 * For data and executable compression software:    http://apack.cjb.net/ *
 *                                                  jibz@hotmail.com      *
 **************************************************************************/

#include <string.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <conio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>

#define BUFSIZE (1024*1024) /* 1 MB */

FILE *infile = NULL, *outfile = NULL;

unsigned char buffer[BUFSIZE];

int nr = 1, first = 1;

convert(unsigned char *buffer, unsigned long len, FILE *ofile, int style, int last)
{
   unsigned int dist = len;

   switch (style)
   {
      case 0  : fwrite(buffer, len, 1, ofile); break;
      case 1  : if (first)
                {
                   first = 0;
                   fprintf(ofile, "   db 0%02Xh", *(buffer++));
                   dist--;
                }
                if (dist)
                {
                   for (; dist; dist--)
                   {
                      fprintf(ofile, nr?", 0%02Xh":"\n   db 0%02Xh", *(buffer++));
                      nr = (nr + 1) % 10;
                   }
                }
                if (last) fprintf(ofile, "\n");
                break;
      case 2  : if (first)
                {
                   first = 0;
                   fprintf(ofile, "   0x%02X", *(buffer++));
                   dist--;
                }
                if (dist)
                {
                   for (; dist; dist--)
                   {
                      fprintf(ofile, nr?", 0x%02X":",\n   0x%02X", *(buffer++));
                      nr = (nr + 1) % 10;
                   }
                }
                if (last) fprintf(ofile, "\n");
   }
}

/* some I/O error handler :) */
void error(int n)
{
   printf("\n\n\007ERR: ");
   switch (n)
   {
      case 1  : printf("Trying to copy negative length!\n"); break;
      case 2  : printf("Unable to open input file!\n");      break;
      case 3  : printf("Unable to open output file!\n");     break;
      case 4  : printf("Pointers exceed file size!\n");      break;
      case 5  : printf("Unknown switch!\n");                 break;
      default : printf("An unknown error occured!\n");
   }
   if (infile  != NULL) fclose(infile);
   if (outfile != NULL) fclose(outfile);
   exit(n);
}

main (int argc, char *argv[])
{
   unsigned long length, copy_length;
   unsigned long start_point, end_point;
   int datastyle;

   printf("-------------------------------------------------------------------------------\n"\
          "CuT v1.12                         Copyright (c) 1998-99 by Joergen Ibsen / Jibz\n"\
          "                                                            All Rights Reserved\n"\
          "-------------------------------------------------------------------------------\n\n");

   if (argc < 3) {
      printf("  Syntax:  CuT [option] <Input-file> <Output-file> [Start] [End]\n"
             "\n  Options: (default output is binary)\n"
               "    -a : Output as assembler style data\n"
               "    -c : Output as C style data\n\n"
               "  If no positions are given, CuT will process the whole file.\n"
               "  If only one position is given, it will be used as the starting position.\n\n");
      exit (0);
   };

   /* check for option */
   datastyle = 0;
   if ((argv[1][0] == '-') || (argv[1][0] == '/'))
   {
      switch (argv[1][1])
      {
         case 'a' :
         case 'A' : datastyle = 1; break;
         case 'c' :
         case 'C' : datastyle = 2; break;
         default  : error(5);
      }
   }

   /* calculate start and end */
   start_point = 0;
   if (argc > 3 + (datastyle?1:0)) start_point = strtoul(argv[3 + (datastyle?1:0)], NULL, 0);
   end_point = 0;
   if (argc > 4 + (datastyle?1:0)) end_point = strtoul(argv[4 + (datastyle?1:0)], NULL, 0);

   if ((end_point != 0) && (start_point >= end_point)) error(1);

   printf(" - Opening files\n");

   /* open input and output files */
   if ((infile  = fopen(argv[1 + (datastyle?1:0)], "rb")) == NULL) error(2);
   if ((outfile = fopen(argv[2 + (datastyle?1:0)], "wb")) == NULL) error(3);

   fseek(infile, 0, SEEK_END);
   length = ftell(infile);

   if ((start_point > length) || (end_point > length)) error(4);
   if (end_point == 0) end_point = length;

   copy_length = end_point - start_point;

   printf("   - Start point = %-10lu (%lXh)\n"
          "   - End point   = %-10lu (%lXh)\n"
          "   - Total bytes = %-10lu (%lXh)\n",
          start_point, start_point,
          end_point, end_point,
          copy_length, copy_length);

   fseek(infile, start_point, SEEK_SET);

   printf(" - Copying data ");

   switch (datastyle)
   {
      case 0 : printf("(BIN)"); break;
      case 1 : printf("(ASM)"); break;
      case 2 : printf("(C)");
   }

   while(copy_length > BUFSIZE)
   {
      fread(buffer, BUFSIZE, 1, infile);
      convert(buffer, BUFSIZE, outfile, datastyle, 0);
      copy_length -= BUFSIZE;
   }

   if (copy_length)
   {
      fread(buffer, copy_length, 1, infile);
      convert(buffer, copy_length, outfile, datastyle, 1);
   }

   /* close in and out files */
   printf("\n - Closing files\n");
   if (infile  != NULL) fclose(infile);
   if (outfile != NULL) fclose(outfile);

   return(0);
}
