/* Copyright (c) 1999, 2002 by Hard Wisdom (hw@darkland.cjb.net)
 *
 * spatch -- frk apply tool.
 *
 * You may distribute spatch under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */

/*-----------------------------------------------------------------*/
/*       "Scan And Patch" v1.0 (C) 10-Apr-1999y by Hard Wisdom     */
/*                        v1.1 (C) 24-Apr-1999y by Hard Wisdom     */
/* - support for /R (reversing)                                    */
/*                        v1.2 (C) 13-Mar-2002y by Hard Wisdom     */
/* - support for $0 .. $9 macroses                                 */
/*-----------------------------------------------------------------*/

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#define max_pattern 0x800

#define sNoState       0
#define sSearchState   1
#define sReplaceState  2
#define sFileState     3
#define sCommentState  4

/*-----------------------------------------------------------------*/
int mymemcmp(char *m, char *s, char *c, int how)
{
    int i;

    for (i = 0; i < how; i++, m++, c++, s++)
        if ((*m & *c) != *s)
            return i + 1;
    return 0;
}

void mymemcpy(char *m, char *r, char *cc, int how,
    FILE * diff, unsigned long diffpos)
{
    int i, old;

    for (i = 0; i < how; i++, m++, cc++, r++)
    {
        old = *m;
        *m = (*m & *cc) | *r;
        if (old != *m && diff)
        {
            fprintf(diff, "%.8lX: %.2X %.2X\n", diffpos, (old & 0xFF), (*m & 0xFF));
        }
        diffpos++;
    }
}

/* porting */

#define min(a,b)  ((a) < (b) ? (a) : (b))

int mystrnicmp(const char *s1, const char *s2, size_t n)
{
    if (n == 0)
        return 0;
    do
    {
        if (tolower((unsigned char) *s1) != tolower((unsigned char) *s2++))
            return (int) tolower((unsigned char) *s1) - (int) tolower((unsigned char) *--s2);
        if (*s1++ == 0)
            break;
    } while (--n != 0);
    return 0;
}

int mystricmp(const char *s1, const char *s2)
{
    while (tolower((unsigned char) *s1) == tolower((unsigned char) *s2))
    {
        if (*s1 == 0)
            return 0;
        s1++;
        s2++;
    }
    return (int) tolower((unsigned char) *s1) - (int) tolower((unsigned char) *s2);
}

/*-----------------------------------------------------------------*/
#define buf_len 0x8000

int DoSearchReplace(char *target, char *s, char *r,
    char *c, char *cc, int HowMuch,
    char *crkfile)
{
    static char Buf[buf_len];
    unsigned long sz, p, fpos;
    int q, qq, l, cnt = 0;
    FILE *f;
    FILE *lst;

    if (!HowMuch)
        return 0;

    f = fopen(target, "rb+");
    if (!f)
    {
        printf("Unable to open - '%s' !\n", target);
        return 0;
    }

    if (strlen(crkfile))
        lst = fopen(crkfile, "a");
    else
        lst = NULL;
    if (lst)
        fprintf(lst, "%s\n", target);

    fseek(f, 0, SEEK_END);
    sz = ftell(f);
    fseek(f, 0, SEEK_SET);

    p = q = 0;

    while ((p + q) != sz)
    {
        printf(" Scanning %.8lXh\r", p);
        fread(&Buf[q], l = min(buf_len - q, (int) (sz - p - q)), 1, f);
        qq = l + q;
        for (q = 0; q < qq - HowMuch + 1; q++)
        {
            if (!mymemcmp(&Buf[q], s, c, HowMuch))
            {
                printf(" at %.8lXh - ", p + q);
                cnt++;
                fpos = ftell(f);
                mymemcpy(&Buf[q], r, cc, HowMuch, lst, p + q);
                fseek(f, p + q, SEEK_SET);
                fwrite(&Buf[q], HowMuch, 1, f);
                fseek(f, fpos, SEEK_SET);
                printf("%s\n", ferror(f) ? "ERROR" : "OK   ");
                q += HowMuch - 1;
            }
        }
        p += q;
        memcpy(Buf, &Buf[q], qq - q);
        q = qq - q;
    }

    fclose(f);
    printf("Processed - '%s' (%d) %s\n\n\n", target, cnt,
        ferror(f) ? "ERROR" : "OK");
    if (lst)
        fclose(lst);
    return cnt;
}

/*-----------------------------------------------------------------*/
char *defext(char *name, char *ext)
{
    if (!strrchr(name, '.'))
        return strcat(name, ext);
    else
        return name;
}

/*-----------------------------------------------------------------*/
#define Error(q) { puts(q); return 1; }
#define Spc(i) (((i) & 0xF) != 0xF)

#define GETC(c) if (*macro) c = *macro++; else c = fgetc(pattern);

int main(int argc, char *argv[])
{
    unsigned char s_pattern[max_pattern], r_pattern[max_pattern], c_pattern[max_pattern], cc_pattern[max_pattern], p;

    int c, i;
    FILE *pattern, *lst = NULL;
    int slen, rlen, state, tmp_pos, first_arg;
    char TargetN[0x100], Tmp[0x100], s[0x100], patchfile[0x100], *macro;
    int key_reverse = 0;
    char key_crkfile[0x100] = "";

    puts("(C) 13-Mar-2002y by Hard Wisdom 'Scan-And-Patch utility' v1.2\n" \
         "                                ~~~~~~~~~~~~~~~~~~~~~~~~");
    if (argc < 2)
    {
        puts("USAGE: SPATCH.EXE PatternFile[.FRK] [/r] [/c:CrkFileName] [Additional Params]\n" \
            "       - to patch some files, pattern file has simple structure :-)\n" \
            "         You may add key /r to perform reverse patching or(and)\n" \
            "         add key /c:CrkFileName to make a .CRK file with name\n" \
            "         CrkFileName So, now we will talk about the pattern file.\n" \
            "\n" \
            "Look at this:\n" \
            "   ; Strange        - will define some comment\n" \
            "   # Really strage  - will define some comment too\n" \
            "   %Mumbo-Yumbo     - will output data into .CRK file\n" \
            "   %                  (I hope You know CornerCrackers ;-)\n" \
            "   %Crack something\n" \
            "   <7E ?? B0 ??     - will define string for search\n" \
            "   >90 90 B3 ??     - will define string for replace\n" \
            "   =DUMBO.EXE       - will begin operations for target file\n" \
            "   =$0              - will begin operations for argv[$0]\n" \
            "                      where $0 points to first argv after\n" \
            "                      the last cmdline param\n" \
            );
        return 1;
    }

    defext(strcpy(patchfile, argv[1]), ".FRK");

    pattern = fopen(argv[1], "r");
    if (!pattern)
    {
        printf("Unable to open pattern '%s' !\n", patchfile);
        return 1;
    }

    for (first_arg = i = 2; i < argc; i++)
    {
        if (*argv[i] == '-' || *argv[i] == '/')
        {
            if (!mystricmp(argv[i] + 1, "R"))
                key_reverse = 1;
            else if (!mystrnicmp(argv[i] + 1, "C:", 2))
                strcpy(key_crkfile, argv[i] + 3);
            else
            {
                printf("Invalid key - '%s' !\n", argv[i]);
                return 1;
            }
        } else
        {
            first_arg = i;
            break;
        }
    }

    tmp_pos = rlen = slen = 0;
    macro = "";
    state = sNoState;
    TargetN[0] = 0;

    do
    {
        unsigned u;
        int R;

        GETC(c);

        if (c == '$')
        {
            GETC(c);
            if (isdigit(c))
            {
                i = c - '0' + first_arg;
                if (i >= argc)
                {
                    printf("Nonexistent argv[] - %d .ge. %d !\n", i, argc);
                    return 1;
                }
                macro = argv[i];
                GETC(c);
            } else if (c != '$')
            {
                printf("Invalid param for argv[] - '%c' !\n", c);
                return 1;
            }
        }
        if (state == sCommentState)
        {
            if (lst)
                fputc(c, lst);
            if (c == '\n')
            {
                state = sNoState;
                if (lst)
                    fclose(lst);
            }
        } else
        {
            if (key_reverse && c == '<')
                c = '>';
            else if (key_reverse && c == '>')
                c = '<';
            switch (c)
            {
                case '<':
                    state = sSearchState;
                    slen = 0;
                    break;
                case '>':
                    state = sReplaceState;
                    rlen = 0;
                    break;
                case '=':
                    state = sFileState;
                    TargetN[0] = 0;
                    break;
                case ';':
                case '#':
                case '%':
                    state = sCommentState;
                    if (c == '%' && strlen(key_crkfile))
                        lst = fopen(key_crkfile, "a");
                    else
                        lst = NULL;
                    break;
                case ' ':
                case '\t':
                case '\n':
                case EOF:
                    if (tmp_pos == 0)
                        break;  /* No data - nothing to do */
                    Tmp[tmp_pos] = 0;

                    switch (state)
                    {
                        case sSearchState:
                            if (slen >= max_pattern)
                                Error("Search pattern overflow !");
                            for (p = i = 0; i < (int)strlen(Tmp); i++)
                            {
                                p <<= 4;
                                p |= (Tmp[i] == '?') ? 0x0 : 0xF;
                                if (Tmp[i] == '?')
                                    Tmp[i] = '0';
                            }
                            if ((R = sscanf(Tmp, "%X", &u), s_pattern[slen] = (char)u, R) != 1)
                            {
                                printf("Bad search item - '%s' !\n", Tmp);
                                return 1;
                            }
                            c_pattern[slen++] = p;
                            break;

                        case sReplaceState:
                            if (rlen >= max_pattern)
                                Error("Replace pattern overflow !");
                            for (p = i = 0; i < (int)strlen(Tmp); i++)
                            {
                                p <<= 4;
                                p |= (Tmp[i] == '?') ? 0xF : 0x0;
                                if (Tmp[i] == '?')
                                    Tmp[i] = '0';
                            }
                            if ((R = sscanf(Tmp, "%X", &u), r_pattern[rlen] = (char)u, R) != 1)
                            {
                                printf("Bad replace item - '%s' !\n", Tmp);
                                return 1;
                            }
                            cc_pattern[rlen++] = p;
                            break;

                        case sFileState:
                            if (slen != rlen)
                                Error("Search and replace patterns has different length !");
                            strcpy(TargetN, Tmp);
                            state = sNoState;
                            if (strlen(key_crkfile))
                                printf("Making .CRK file '%s'\n", key_crkfile);
                            printf("Processing file '%s' with:\n\n  Search Pattern = ", TargetN);
                            for (i = 0; i < slen; i++)
                            {
                                sprintf(s, "%.2X", s_pattern[i]);
                                s[1] = (c_pattern[i] & 0x0F) ? s[1] : '?';
                                s[0] = (c_pattern[i] & 0xF0) ? s[0] : '?';
                                printf("%s%s", s, Spc(i) ? " " : "\n                   ");
                            }
                            printf("%sReplace Pattern = ", Spc(slen - 1) ? "\n " : "\r ");
                            for (i = 0; i < rlen; i++)
                            {
                                sprintf(s, "%.2X", r_pattern[i]);
                                s[1] = (cc_pattern[i] & 0x0F) ? '?' : s[1];
                                s[0] = (cc_pattern[i] & 0xF0) ? '?' : s[0];
                                printf("%s%s", s, Spc(i) ? " " : "\n                   ");
                            }
                            printf("%s", Spc(rlen - 1) ? "\n\n" : "\n");
                            DoSearchReplace(TargetN, (char*)s_pattern, (char*)r_pattern,
                                (char*)c_pattern, (char*)cc_pattern, min(slen, rlen),
                                key_crkfile);
                            break;

                        default:;
                    }
                    tmp_pos = 0;
                    break;

                default:
                    if (state == sNoState)
                    {
                        printf("Invalid character in pattern file - '%c' !\n", c);
                        return 1;
                    }
                    if (tmp_pos < 0xFF)
                        Tmp[tmp_pos++] = toupper(c);
            }
        }
    } while (c != EOF);

    fclose(pattern);
    if (!ferror(pattern))
        Error("Patern file was processed normally !")
    else
        Error("Error processing pattern file !");
}
