/* Copyright (c) 2002 Alex Derbeev (derbeev2@tut.by)
 * Portions (C)Eugene Roshal
 *
 * crx -- flexible crx/xck/etc apply utility
 *
 * You may distribute crx under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */

#ifndef CRX_H
#define CRX_H

#include <stdio.h>
#include <string.h>
#include <assert.h>
/* Perl-compatible regular expressions. */
/* Copyright (c) 1997-2001 University of Cambridge. */
/* ftp://ftp.csx.cam.ac.uk/pub/software/programming/pcre/pcre-xxx.tar.gz */
#include "pcre.h"

#define PROG_NAME "crx"
#define PROG_AUTHOR "alex derbeev"
#define PROG_WHO_COMPILES "alex derbeev"
#define PROG_VERSION "0.12b"
#define AUTHOR_EMAIL "derbeev2@tut.by"

#define Z extern

/* START OF PLATFORM SPECIFIC STUFF */

#if defined(__GNUC__)
#define INLINE __inline__
#elif defined(__CCDL__)
#define INLINE
#else
#define INLINE
/*#define const*/
#endif

typedef unsigned char BOOL;

#define FALSE ((BOOL)0)
#define TRUE ((BOOL)1)

#if defined(linux)
#define NULL_DEV "/dev/null"
#else
#define NULL_DEV "nul"
#endif

typedef char const *const const_ptr;
typedef unsigned char byte;

#ifndef LITTLE_ENDIAN
# define LITTLE_ENDIAN
#endif

#if defined(__64BIT__)

#error "Swell!"

typedef unsigned short word;
typedef unsigned int dword;
#if defined(JIBZ_CRC)
#undef JIBZ_CRC
#endif

#else
typedef unsigned short word;
typedef unsigned int dword;
#endif

#if defined(JIBZ_CRC)
Z word JibzCRC_asm(word StartCRC, byte const *buf, int buflen);
#endif

#if defined(__GNUC__)&&defined(__i386__)
#define JIBZ_CRC_INLINE
INLINE word JibzCRC_inline(word StartCRC, byte const *buf, int buflen)
{
    word r = 0;
    __asm__ volatile (
        "movw %3,%%ax\n\t"
        "movl %2,%%ebx\n\t"
        "movl %1,%%edi\n\t"
        "1:xorb (%%edi),%%ah\n\t"
        "incl %%edi\n\t"
        "movl $8,%%ecx\n\t"
        "2:addw %%ax,%%ax\n\t"
        "jnc 3f\n\t"
        "xorw $0x1021,%%ax\n\t"
        "3:loopw 2b\n\t"
        "decl %%ebx\n\t"
        "jnz 1b\n\t"
        "movw %%ax,%0\n\t"
        : "=g" (r)
        : "g" (buf), "g" (buflen), "g" (StartCRC)
        : "cc", "%ax", "%ebx", "%ecx", "%edi"
    );
    return r;
}
#endif

/* END OF PLATFORM SPECIFIC STUFF */

Z FILE* GLOB_LOG;

Z void InitCRC(void);
Z dword CalcCRC32(dword StartCRC, byte const *Addr, int Size);
#if !defined(JIBZ_CRC)
Z word JibzCRC(word StartCRC, byte const *buf, int buflen);
#endif

Z dword CRCTab[256];

Z int CalculateCRC(const_ptr fileName, int ct, char* CRC);
enum {CRC_OK = 0, CRC_IO = 1};

Z void quit(char const *msg, int code);
Z void myabort(int);
Z void sanity_check(void);
Z void init_task(void);

Z int mygetopt(int argc, char **argv);
Z void usage(void);

Z const_ptr license;
Z BOOL o_deactivate, o_check_crc, o_fuzzy_test_only, o_quiet, o_verbose, o_abort, o_calc_crc;
enum {ctCRC32 = 0, ctJibz};
Z int Crc_type;

Z const_ptr NO_FILE;

enum {RC_EXCEPT = 1, RC_USAGE, RC_ABORT, RC_BAD_FMT, RC_REVISION,
    RC_LICENSE, RC_BAD_OPTION};

typedef struct
{
    dword offset;
    byte oldbyte, newbyte;
}PATCH_DATA;

enum {crcNO_CRC = -1, crcCRC32 = 0};

typedef struct
{
    char* file;
    dword crc;
    int crct;
    int size; /*-1 means no size*/
}CRC_DATA;

typedef struct
{
    int c;
    void *data;
}JIBZ_CMD;

typedef struct
{
    int sz, *v;
}IVEC;

typedef struct
{
    int sz_patch_data;
    PATCH_DATA* patch_data;
    int sz_cont_src, sz_cont_dst;
    IVEC *cont_src, *cont_dst;
    BOOL q;
    int sz_cmd;
    JIBZ_CMD* cmd;
    char * file;
}FILE_DATA;

#define OVECCOUNT 300   /* should be a multiple of 3 */
#define REG_COUNT 11

enum {
    REG_CHECK_SIZE_CRC32 = 0, REG_CHECK_SIZE, REG_OFFSET_OLD_NEW,
    REG_SEARCH_FRK, REG_SEARCH_SP, REG_FUZZY_BLANK, REG_PLUS_FRK, REG_CHANGE_FRK,
    REG_JIBZ_FILE, REG_JIBZ_BLANK, REG_PATTERN
};

Z const_ptr my_regs[REG_COUNT];

Z pcre* pcre_data[REG_COUNT];
Z pcre_extra* pcre_extra_data[REG_COUNT];

typedef struct
{
    char const* file;
    byte *extended_info;
    char** crx_data;
    FILE_DATA* file_data;
    CRC_DATA* crc_data;
    int sz_crx_data, sz_file_data, sz_crc_data;
    int linecount;
    int filecount;
    BOOL fuzzy, frk_here, sp_here, jibz_here;
    int ovector[OVECCOUNT];
}Crx_parser_data;

Z Crx_parser_data *init_crx_parser_data(Crx_parser_data *p);

Z void init_regexp(void);
Z void print_fuzzy_matrix(FILE *s, const_ptr prefix, int* x, int sz_x, const_ptr suffix, char blank);

#define NUM_PREF 2
enum {PX_DSK = 0, PX_CHR};
Z const_ptr PREFIX[NUM_PREF];

dword const
    crx_fVerbose = 1;
Z dword crx_flags;

#define Jibz_Magic 18

enum {
    jbGetkey = 0, jbPrint, jbCls, jbFile, jbFilecl, jbSize, jbCrc, jbBackup,
    jbCompare = 8, jbSearch, jbTest, jbReplace, jbWrite, jbGoto, jbGoto_plus, jbGoto_minus,
    jbExit = 16, jbEnd = 17
};

Z const_ptr Jibz_commands[Jibz_Magic];

Z void crx_read_file(Crx_parser_data *this);
Z void crx_parse(Crx_parser_data *this);

Z int make_fuzzy_matrix(char const *asc_src, char const *asc_dst, int** src, int** dst, int *sz_src, int *sz_dst);
Z int make_fuzzy_matrix_single(char const *asc_src, int** src, int *sz_src);

enum {FUZZY_NO_SYNC = -99};

Z char *apply_error_bad_file;
Z dword apply_error_offset;
Z byte apply_error_b;
Z int apply_error_fuzzy_blocks_patched;
Z BOOL apply_error_Jibz_exit;

enum {APPLY_OK = 0, APPLY_FILE_NOT_FOUND = 100, APPLY_SEEK_ERROR, APPLY_BAD_BYTE, APPLY_NOTHING_TODO,
    APPLY_WRITE_ERROR, APPLY_FUZZY_IO, APPLY_JIBZ_EXIT};

enum {CHECKCRC_OK = 0, CHECKCRC_BADCRC = 200, CHECKCRC_IO,
    CHECKCRC_BAD_SIZE};

Z int apply_patch(FILE_DATA fd, BOOL get_back, BOOL fuzzy, BOOL jibz, BOOL test_only);
Z int check_crc(CRC_DATA crc);

Z int search_pattern(int* src, int sz_src, char const *ptr, int size);
Z int test_pattern(int* src, int sz_src, char const *ptr, int size);
Z int write_pattern(int* src, int sz_src, char *ptr, int size);

Z int apply_dummy_patch(FILE_DATA fd, BOOL get_back, BOOL test_only);
Z int apply_fuzzy_patch(FILE_DATA fd, BOOL get_back, BOOL test_only);
Z int apply_jibz_patch(FILE_DATA fd, BOOL get_back, BOOL test_only);

#undef Z

#endif
