/* FONTEDIT - Edits DOS character font files (.FNT)                 */
/* Freeware version                                                 */
/* By Marcio Afonso Arimura Fialho                                  */
/* http://pessoal.iconet.com.br/jlfialho                            */
/* e-mail: jlfialho@iconet.com.br or (alternate) jlfialho@yahoo.com */

//To select edited files, use FONTSEL

#include <stdio.h>
#include <crt.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <setjmp.h>
#include <dos.h>

#define EGA 3 //EGA color adapters
#define VGA 9 //VGA/SVGA+ color adapters

#define intm(intnum) asm int intnum

typedef unsigned char byte;
typedef unsigned int  word;
typedef unsigned long dword;

//Disables CTRL-C

jmp_buf ctrl_c;

int c_break(void)
 {
	longjmp (ctrl_c,1);
	return 1;
 }

//Mouse routines:

int  mouserst (int *nbuttons); //resets and checks for mouse
void mouseon (void); //turns on mouse pointer
void mouseread(int *collum, int *line, int *buttom); //reads mouse position and button
void mousewrite (int collum, int line); //changes mouse pointer position
void mouseoff(void); //switch off mouse pointer

//Miscellaneous routines:
int  getchx(); //enhaced version of getch, reads extended characters
void readfname (char *target, char *source, char *ext);
	//reads filename and appends extension (ext) if none is given.

//Global variables
byte *buffer;
byte *aux,*aux2;
byte schar=0;
int c_height;
FILE *source;
byte bufchar[32]; //used by cut and paste tool
int prog_flags=0; //bit0 => if set redraws miniature

#define target source  //the source file is also the target file

//Specific program routines
void redraw();
void redrawmin();
void filesave(char *name);
void copychr();
void pastechr();
void invertchr();
void cleanchr();
void movepos(int dir);


#define E_XI 10
#define E_YI 5
#define M_XI 60
#define M_YI 10

void main (int n, char *ent[3])
  {
	int c0,c1;
	int a0,a1,a2;
	int inpkey, mouseb, mousex, mousey;
	int mouseb2,mousex2, mousey2;
	char *path;
	char *msg_about="\nType FONTEDIT with no parameters to obtain help\n";
	char licos[128];
	int cont;

	//Disables CTRL-C and assings for it a new function
	ctrlbrk(c_break);
	if(setjmp(ctrl_c))
	 {
		crt_gotoxy (0,0);
		fillbar ('',0,0,2,2,0x19);
		copychr ();
		goto pula2;
	 }

	if (n<2)
	 {
		printf ("FONTEDIT ver 1.1 - EDITS DOS CHARACTER FONT FILES (.FNT)\n\n\
Usage:   FONTEDIT <font name[.FNT]> [height]\n\n\
\theight is the character height in pixels (default = 16)\n\n\
By Marcio Afonso Arimura Fialho\nhttp://pessoal.iconet.com.br\n\
e-mail: jlfialho@iconet.com.br\n");
		return;
	 }

	if (n>=3) //reads the character height
	 {
		c_height=atoi(ent[2]);
		if((unsigned)c_height>32u)
		 {
			printf ("ERROR: Incorrect input parameters.%s",msg_about);
			return;
		 }
	 }
	 else
		c_height=16;

	readfname (licos,ent[1],".FNT");//appends the .FNT extension to licos
	  //if none is given

	source=fopen (licos,"rb");
	if(source==NULL)
	 {
		printf ("ERROR: File \"%s\" doesn't exist or couldnt be read.%s",licos,msg_about);
		fcloseall();
		return;
	 }

	buffer=(byte *)malloc(256*c_height); //allocates memory for character font

	if (buffer==NULL) //if not possible to allocate memory
	 {     //displays error message and returns
		printf ("ERROR: Not enough memory to store font.%s",msg_about);
		fcloseall ();
		return;
	 }
	for (aux=buffer,cont=0;cont<c_height*256;cont++) //loads character font into buffer
	 {
		*aux=(byte)fgetc (source);
		aux++;
	 }
	fclose (source);

 //Set mode and draws the background
	setcrtmode (3);
	textmode (64);
	crt_init (VGA); //if your monitor is EGA, replace crt_init argument
	fillscr ('',0x19);

  //Display messages on screen
	printsj ("* * * FONTEDIT ver 1.1 * * *",0,0x1e);
	printsj ("DOS character font editor for EGA/VGA/SVGA+ videos",2,0x17);

	printx ("ESC\06\27 - Exit \06\37F2\06\27 - Saves \06\37  PG UP/DN and CTRL PG UP/DN\06\27 - Selects Character\n\
\t\06\37Ctrl C/Ins\06\27 - Copies character    \06\37Ctrl V\06\27 - Paste character\n\
\t\06\37Alt I \06\27 - Inverts caractere    \06\37ALT-C\06\27 - Clears character\n\
\t\06\37Ctrl \06\36(arrow for up, down, sides)\06\27 - Moves character pattern\n\
\t\06\37Alt R \06\27(Switch On/Off miniature display",5,44,0x1f);

	moldurad (E_XI,E_YI,E_XI+9,E_YI+1+c_height,0x1f);
	printc ('1',E_XI+2,E_YI,0x1f);
	redraw();

	mouseon ();
	do
	 {
		if (kbhit()) //if is there a keystroke available and the control is not
			inpkey=getchx (); //exclusive of mouse
		 else
			inpkey=0;

		mouseb2=mouseb;
		mousex2=mousex;
		mousey2=mousey;
		switch (inpkey)
		 {
			case 0x1b: goto fim;
			case 0x3c00: filesave(licos); break;
			case 0x4800: mousey--; goto pula1;
			case 0x5000: mousey++; goto pula1;
			case 0x4b00: mousex--; goto pula1;
			case 0x4d00: mousex++; goto pula1;

			case 0x1300: prog_flags^=0x01; redraw(); goto pula2;
			case 0x4900: schar++; goto pula2; //PG UP
			case 0x5100: schar--; goto pula2; //PG DN
			case 0x8400: schar+=16; goto pula2; //CTRL PG UP
			case 0x7600: schar-=16; goto pula2; //CTRL PG DN
			case 0x9200: copychr(); goto pula2; //CTRL INS
			case 0x16  : pastechr(); goto pula2; //CTRL-V
			case 0x1700: invertchr(); goto pula2; //ALT-I
			case 0x2e00: cleanchr(); goto pula2;  //ALT-C
			case 0x8d00: movepos(2); goto pula2;  //CTRL up
			case 0x7400: movepos(0); goto pula2;  //CTRL right
			case 0x9100: movepos(3); goto pula2;  //CTRL down
			case 0x7300: movepos(1); goto pula2;  //CTRL left

			pula1: mousewrite (mousex*8, mousey*8); break;
			pula2: redraw();
		 }
		mouseread (&mousex,&mousey,&mouseb);
		mousex=mousex/8;
		mousey=mousey/8;
		a0=0;
		if ( (!mouseb2 && mouseb) || inpkey=='+' || inpkey=='-' || inpkey==0x0d || (mouseb && (mousex!=mousex2 || mousey!=mousey2)))
			a0++; //indicates that is to change something
		if (a0 && mousex>E_XI && mousex<(E_XI+9) && mousey>E_YI && mousey<=(E_YI+c_height))
		 {
			a0=mousey-E_YI-1;
			a1=E_XI+8-mousex;
			a2=1;
			for(c0=0;c0<a1;c0++,a2*=2);
			aux=buffer + schar * c_height + a0;
			if (inpkey=='+' || mouseb==0x01)
				(*aux)|=a2;
			if (inpkey=='-' || mouseb==0x02)
				(*aux)&=~a2;
			if (inpkey==0x0d || mouseb==0x03)
				(*aux)^=a2;
			redraw();
		 }
	 }
	while (1);

  fim: //end of the program
	mouseoff ();
	setcrtmode (3);
	fcloseall();
 }

void redraw()
 {
	int a0,a2;
	int c0,c1,c2;
	mouseoff ();
	for (c0=0;c0<c_height;c0++)
		for (c1=0;c1<8;c1++)
		 {
			a2=1;
			for(c2=0;c2<c1;c2++,a2*=2); //a2=2^c1
			a0=(*(buffer + schar * c_height + c0))&a2;
			if (a0)
				printc('',E_XI+8-c1,E_YI+1+c0,0x1f);
			else
				printc ('',E_XI+8-c1,E_YI+1+c0,0x1f);
		 }
	printsf (50,5,0x1f,"1 - Character => %02Xh = %03d",schar,schar);
	if (prog_flags&0x01)
		redrawmin();
	 else
		fillbar ('',M_XI-2,M_YI-2,M_XI+7,M_YI+4+(c_height-1)/8,0x19);
	mouseon ();
 }

void redrawmin()
 {
	int c0;
	int a0;
	char chrdisp[32];
	a0=(c_height-1)/8;
	prints ("Miniature:",M_XI-2,M_YI-2,0x1f);
	moldurad (M_XI,M_YI,M_XI+4,M_YI+4+a0,0x1f);
	fillbar (' ',M_XI+1,M_YI+1,M_XI+3,M_YI+3+a0,0x1f);

	for (c0=0;c0<c_height;c0++)
		chrdisp[c0]=*(buffer+schar*c_height+c0);
	for (;c0<32;c0++)
		chrdisp[c0]=0;
	changechar_height=8;
	changechar (chrdisp,0xe0,4);
	for (c0=0;c0<=a0;c0++)
		printc (0xe0+c0,M_XI+2,M_YI+2+c0,0x1f);
 }

void filesave(char *name)
 {
	int c0;
	target=fopen (name,"wb");
	if(target==NULL)
	 {
		prints ("ERROR: File can't be open for writing.",15,30,0x9e);
		putchar (0x07);
		getch ();
		fillbar ('',0,30,79,30,0x19);
		fcloseall();
		return;
	 }
	aux=buffer;
	for (c0=0;c0<c_height*256;c0++,aux++)
		fputc(*aux,target);
	fseek (target,-1,SEEK_END);
	fclose(target);
 }

void copychr()
 {
	int c0;
	aux=buffer + schar * c_height;
	aux2=bufchar;
	for (c0=0;c0<c_height;c0++,aux2++,aux++)
		*aux2=*aux;
 }

void pastechr()
 {
	int c0;
	aux=buffer + schar * c_height;
	aux2=bufchar;
	for (c0=0;c0<c_height;c0++,aux2++,aux++)
		*aux=*aux2;
 }

void invertchr()
 {
	int c0;
	aux=buffer + schar * c_height;
	for (c0=0;c0<c_height;c0++,aux++)
		*aux=~(*aux);
 }

void cleanchr()
 {
	int c0;
	aux=buffer + schar * c_height;
	for (c0=0;c0<c_height;c0++,aux++)
		*aux=0;
 }

void movepos(int dir)
 {
	int c0;
	aux=buffer + schar * c_height;
	if (dir<4)
		for (c0=0;c0<c_height;c0++,aux++)
		 {
			if (dir==0)	//moves to the right
				*aux=(*aux)/2;
			else if (dir==1) //moves to the left
				*aux=(*aux)*2;
			else if (dir==2) //moves to up
			 {
				if (c0!=(c_height-1))
					*aux=*(aux+1);
				else
					*aux=0;
			 }
		  }
	if(dir==3) //moves to down
	 {
		aux--;
		for (c0=c_height-1;c0>=0;c0--,aux--)
		 {
			if (c0)
				*aux=*(aux-1);
			else
				*aux=0;
		 }
	 }
 }

int mouserst (int *nbuttons)
 {
	int i,j;
	_AX=0;
	intm(0x33);
	i=_AX;
	j=_BX;
	*nbuttons=j;
	return i;
 }

void mouseon (void)
 {
	_AX=1;
	intm(0x33);
 }

void mouseread(int *collum, int *line, int *buttom)
 {
	int i,j,k;
	_AX=3;
	intm (0x33);
	i=_CX;
	j=_DX;
	k=_BX;
	*collum=i;
	*line=j;
	*buttom=k;
 }

void mousewrite (int collum, int line)
 {
	_CX=collum;
	_DX=line;
	_AX=4;
	intm (0x33);
 }

void mouseoff(void)
 {
	_AX=2;
	intm (0x33);
 }

int getchx()
 {
	int i;
	_AH=0x07;
	intm(0x21);
	i=_AL;
	if (i==0)
	 {
		_AH=0x07;
		intm(0x21);
		i=_AL*0x100;
	 }
	return i;
 }

#include "readname.cpp"