;*****
;***** (c) 1999 by crayzee
;***** do not modify and distribute for your own purposes
;***** you are allowed to use some parts in your code but mention my name there
;***** if you'll make this code better, or comment it, send it to me please
;***** crayzee@mailbox.sk
;*****

;...........................................................................................
;******************************* create registry associations ******************************
.data
CreateFileAssocSuccess	db 'Registry file associations',13,10
			db 'successfully created.',0
CreateFileAssocError	db 'Some error occured when',13,10
			db 'creating the registry',13,10
			db 'file associations.',0
DeleteFileAssocSuccess	db 'Registry file associations',13,10
			db 'successfully removed.',0
DeleteFileAssocError	db 'Some error occured when',13,10
			db 'removing the registry',13,10
			db 'file associations.',0

reg_folder		db 'folder',0
reg_default		db ,0

key_croot_pth		db '.pth',0
key_croot_pth_dv	db 'crayzeesPatchScriptFile',0
key_croot_pth_dv_L	equ $-key_croot_pth_dv

key_croot_cpsfile	equ key_croot_pth_dv
key_croot_cpsfile_dv	db 'crayzee''s patcher''s patch script file',0
key_croot_cpsfile_dv_L	equ $-key_croot_cpsfile_dv

key_croot_cpsfile_di	db 'DefaultIcon',0
key_croot_cpsfile_diext	db ',1',0

key_croot_shell		db 'shell',0

key_croot_s_open	db 'open',0
key_croot_s_open_dv	db '&Use patch script',0
key_croot_s_open_dv_L	equ $-key_croot_s_open_dv

key_croot_s_o_cmd	db 'command',0
key_croot_s_o_cmd_dvext	db ' u "%1"',0

.code
reg_createfileassoc proc
	xor	eax, eax
	mov	[error], eax
;....get the program name from the command line....
	mov	esi, offset progfilename
	mov	edi, [prognamelength]
	dec	edi
	mov	eax, [cmdline]
	sub	eax, [prognamelength]
	cmp	byte ptr [eax], '"'
	jne	aftersub
	sub	edi, 2
aftersub:
	mov	ecx, edi
	add	edi, offset progfilename
	mov	byte ptr [edi], 0

	mov	edi, offset key_croot_cpsfile_di_dv
	mov	eax, edi
	push	esi
	push	ecx
;..use it for DefaultIcon @ value
	rep	movsb

	mov	esi, offset key_croot_cpsfile_diext
	mov	ecx, 3
	rep	movsb

	;compute the length of the string
	sub	eax, edi
	xor	ebx, ebx
	dec	ebx
	xor	eax, ebx
	mov	key_croot_cpsfile_di_dv_L, eax
;..use it for shell-open-command @ value
	pop	ecx
	pop	esi
	mov	edi, offset key_croot_s_o_cmd_dv
	mov	edx, edi
	mov	al, '"'
	stosb
	rep	movsb
	stosb

	mov	esi, offset key_croot_s_o_cmd_dvext
	mov	ecx, 8
	rep	movsb

	;compute the length of the string
	sub	edx, edi
	xor	edx, ebx
	mov	key_croot_s_o_cmd_dv_L, edx

;....write the .pth registry section....
	push	offset key_opened		;lpdwDisposition
	push	offset hkey_croot_pth		;phkResult
	push	0				;lpSecurityAttributes
	push	00006h ;KEY_WRITE		;samDesired
	push	0				;fdwOptions
	push	offset reg_folder		;lpszClass
	push	0				;dwReserved
	push	offset key_croot_pth		;lpszSubKey
	push	HKEY_CLASSES_ROOT		;hKey
	call	RegCreateKeyExA
	add	error, eax

	push	key_croot_pth_dv_L		;cbData
	push	offset key_croot_pth_dv		;lpData
	push	1;REG_SZ			;dwType
	push	0				;dwReserved
	push	offset reg_default		;lpValueName
	push	hkey_croot_pth			;hKey
	call	RegSetValueExA
	add	error, eax

;....write the crayzeesPatchScriptFile registry section....
	push	offset key_opened
	push	offset hkey_croot_cpsfile
	push	0
	push	00006h ;KEY_WRITE
	push	0
	push	offset reg_folder
	push	0
	push	offset key_croot_cpsfile
	push	HKEY_CLASSES_ROOT
	call	RegCreateKeyExA
	add	error, eax

	push	key_croot_cpsfile_dv_L
	push	offset key_croot_cpsfile_dv
	push	1;REG_SZ
	push	0
	push	offset reg_default
	push	hkey_croot_cpsfile
	call	RegSetValueExA
	add	error, eax
;....write the .../DefaultIcon section....
	push	offset key_opened
	push	offset hkey_croot_cpsfile_di
	push	0
	push	00006h ;KEY_WRITE
	push	0
	push	offset reg_folder
	push	0
	push	offset key_croot_cpsfile_di
	push	hkey_croot_cpsfile
	call	RegCreateKeyExA
	add	error, eax

	push	key_croot_cpsfile_di_dv_L
	push	offset key_croot_cpsfile_di_dv
	push	1;REG_SZ
	push	0
	push	offset reg_default
	push	hkey_croot_cpsfile_di
	call	RegSetValueExA
	add	error, eax
;....write the .../shell section....
	push	offset key_opened
	push	offset hkey_croot_shell
	push	0
	push	00006h ;KEY_WRITE
	push	0
	push	offset reg_folder
	push	0
	push	offset key_croot_shell
	push	hkey_croot_cpsfile
	call	RegCreateKeyExA
	add	error, eax
;....write the .../shell/open section....
	push	offset key_opened
	push	offset hkey_croot_s_open
	push	0
	push	00006h ;KEY_WRITE
	push	0
	push	offset reg_folder
	push	0
	push	offset key_croot_s_open
	push	hkey_croot_shell
	call	RegCreateKeyExA
	add	error, eax

	push	key_croot_s_open_dv_L
	push	offset key_croot_s_open_dv
	push	1;REG_SZ
	push	0
	push	offset reg_default
	push	hkey_croot_s_open
	call	RegSetValueExA
	add	error, eax
;....write the .../shell/open/command section....
	push	offset key_opened
	push	offset hkey_croot_s_o_cmd
	push	0
	push	00006h ;KEY_WRITE
	push	0
	push	offset reg_folder
	push	0
	push	offset key_croot_s_o_cmd
	push	hkey_croot_s_open
	call	RegCreateKeyExA
	add	error, eax

	push	key_croot_s_o_cmd_dv_L
	push	offset key_croot_s_o_cmd_dv
	push	1;REG_SZ
	push	0
	push	offset reg_default
	push	hkey_croot_s_o_cmd
	call	RegSetValueExA
	add	error, eax
;....close all registry keys....
	push	hkey_croot_pth
	call	RegCloseKey

	push	hkey_croot_s_o_cmd
	call	RegCloseKey
	push	hkey_croot_s_open
	call	RegCloseKey
	push	hkey_croot_shell
	call	RegCloseKey

	push	hkey_croot_cpsfile_di
	call	RegCloseKey

	push	hkey_croot_cpsfile
	call	RegCloseKey

	mov	eax, error

	push	MB_OK
	or	eax, eax
	je	regcreatefassoc_noerror
	push	offset ErrorCaption
	push	offset CreateFileAssocError
	jmp	afterregcreatefassoc_noerror
regcreatefassoc_noerror:
	push	offset MessageCaption
	push	offset CreateFileAssocSuccess
afterregcreatefassoc_noerror:
	push	[hconfigwnd]
	call	MessageBoxA

	ret
reg_createfileassoc endp
public reg_createfileassoc

;...........................................................................................
;******************************* delete registry associations ******************************
reg_deletefileassoc proc
	push	offset key_croot_pth
	push	HKEY_CLASSES_ROOT
	call	RegDeleteKeyA
	add	error, eax

	push	offset hkey_croot_cpsfile
	push	6;KEY_WRITE
	push	0
	push	offset key_croot_cpsfile
	push	HKEY_CLASSES_ROOT
	call	RegOpenKeyExA
	add	error, eax

	push	offset key_croot_cpsfile_di
	push	hkey_croot_cpsfile
	call	RegDeleteKeyA
	add	error, eax

	push	offset hkey_croot_shell
	push	6
	push	0
	push	offset key_croot_shell
	push	hkey_croot_cpsfile
	call	RegOpenKeyExA
	add	error, eax

	push	offset hkey_croot_s_open
	push	6
	push	0
	push	offset key_croot_s_open
	push	hkey_croot_shell
	call	RegOpenKeyExA
	add	error, eax

	push	offset key_croot_s_o_cmd
	push	hkey_croot_s_open
	call	RegDeleteKeyA
	add	error, eax

	push	hkey_croot_s_open
	call	RegCloseKey
	add	error, eax

	push	offset key_croot_s_open
	push	hkey_croot_shell
	call	RegDeleteKeyA
	add	error, eax

	push	hkey_croot_shell
	call	RegCloseKey
	add	error, eax

	push	offset key_croot_shell
	push	hkey_croot_cpsfile
	call	RegDeleteKeyA
	add	error, eax

	push	hkey_croot_cpsfile
	call	RegCloseKey
	add	error, eax

	push	offset key_croot_cpsfile
	push	HKEY_CLASSES_ROOT
	call	RegDeleteKeyA
	add	error, eax

	mov	eax, error

	push	MB_OK
	or	eax, eax
	je	regdeletefassoc_noerror
	push	offset ErrorCaption
	push	offset DeleteFileAssocError
	jmp	afterregdeletefassoc_noerror
regdeletefassoc_noerror:
	push	offset MessageCaption
	push	offset DeleteFileAssocSuccess
afterregdeletefassoc_noerror:
	push	[hconfigwnd]
	call	MessageBoxA

	ret
reg_deletefileassoc endp
public reg_deletefileassoc



;...........................................................................................
;************************ retrieve actual settings from the registry ***********************
.data
reg_cu_scp	db 'Software\crayzee\patcher',0
reg_cu_scp_setv	db 'settings',0
reg_cu_scp_bl1v	db 'b1',0
reg_cu_scp_bl2v	db 'b2',0
.code
reggetsettings proc
	push	offset hkey_cu_scp
	push	19h;KEY_READ
	push	0
	push	offset reg_cu_scp
	push	HKEY_CURRENT_USER
	call	RegOpenKeyExA
	or	eax, eax
	jne	reggetsettingserror

	mov	bytesread, 4
	push	offset bytesread
	push	offset settings
	push	offset sth
	push	0
	push	offset reg_cu_scp_setv
	push	hkey_cu_scp
	call	RegQueryValueExA
	or	eax, eax
	jne	reggetsettingserror
	cmp	[sth], 4;REG_DWORD
	jne	reggetsettingserror
	cmp	[bytesread], 4
	jne	reggetsettingserror

	jmp	reggetbl1

reggetsettingserror:
	xor	eax, eax
	dec	eax
	mov	[settings], eax


reggetbl1:
	mov	bytesread, 4
	push	offset bytesread
	push	offset BLOCKSIZE1
	push	offset sth
	push	0
	push	offset reg_cu_scp_bl1v
	push	hkey_cu_scp
	call	RegQueryValueExA
	or	eax, eax
	jne	reggetbl1error
	cmp	[sth], 4;REG_DWORD
	jne	reggetbl1error
	cmp	[bytesread], 4
	jne	reggetbl1error

	jmp	reggetbl2

reggetbl1error:
	mov	[BLOCKSIZE1], DEFAULTBLOCKSIZE1



reggetbl2:
	mov	bytesread, 4
	push	offset bytesread
	push	offset BLOCKSIZE2
	push	offset sth
	push	0
	push	offset reg_cu_scp_bl2v
	push	hkey_cu_scp
	call	RegQueryValueExA
	or	eax, eax
	jne	reggetbl2error
	cmp	[sth], 4;REG_DWORD
	jne	reggetbl2error
	cmp	[bytesread], 4
	jne	reggetbl2error

	jmp	reggetsettingsquit

reggetbl2error:
	mov	[BLOCKSIZE2], DEFAULTBLOCKSIZE2



reggetsettingsquit:
	push	hkey_cu_scp
	call	RegCloseKey
	ret

reggetsettings endp
public reggetsettings



;...........................................................................................
;************************** store actual settings to the registry **************************
.data
.code
regstoresettings proc
	push	offset key_opened
	push	offset hkey_cu_scp
	push	0
	push	6;KEY_WRITE
	push	0
	push	offset reg_folder
	push	0
	push	offset reg_cu_scp
	push	HKEY_CURRENT_USER
	call	RegCreateKeyExA

	push	4
	push	offset settings
	push	4;REG_DWORD
	push	0
	push	offset reg_cu_scp_setv
	push	hkey_cu_scp
	call	RegSetValueExA

	push	4
	push	offset BLOCKSIZE1
	push	4;REG_DWORD
	push	0
	push	offset reg_cu_scp_bl1v
	push	hkey_cu_scp
	call	RegSetValueExA

	push	4
	push	offset BLOCKSIZE2
	push	4;REG_DWORD
	push	0
	push	offset reg_cu_scp_bl2v
	push	hkey_cu_scp
	call	RegSetValueExA

	push	hkey_cu_scp
	call	RegCloseKey
	
	ret
regstoresettings endp
public regstoresettings

;...........................................................................................
;******************************** remove all from the registry *****************************
.data
RegRemoveAllMessage	db 'By pushing OK all registry entries previously',13,10
			db 'created by crayzee''s patcher (except of the .pth',13,10
			db 'file association) will be removed.',13,10,10
			db 'If you''ll push save the configuration button',13,10
			db 'later, they will be created again.',0
.code
regremoveall proc		;remove all except the file associations
	mov	esi, offset reg_cu_scp
	mov	edi, offset reg_cu_sc
	xor	ecx, ecx
	mov	cl, 16
	rep	movsb

	push	MB_ICONWARNING or MB_OKCANCEL
	push	offset WarningCaption
	push	offset RegRemoveAllMessage
	push	[hconfigwnd]
	call	MessageBoxA
	cmp	eax, IDOK
	je	$+3
	ret

	push	offset reg_cu_scp
	push	HKEY_CURRENT_USER
	call	RegDeleteKeyA

	;find out if there is any other subkey (other my apps can have their settings there)
	push	offset sth2
	push	19h;KEY_READ
	push	0
	push	offset reg_cu_sc
	push	HKEY_CURRENT_USER
	call	RegOpenKeyExA

	push	offset somestruct2
	push	0
	push	0
	push	0
	mov	[sth], 256
	push	offset sth
	push	offset somestruct
	push	0
	push	[sth2]
	call	RegEnumKeyExA
	cmp	eax, 259;ERROR_NO_MORE_ITEMS
	jne	rra_skip_cusc

	push	offset reg_cu_sc
	push	HKEY_CURRENT_USER
	call	RegDeleteKeyA
	
rra_skip_cusc:
	ret
regremoveall endp
public regremoveall
