;*****
;***** (c) 1999 by crayzee
;***** do not modify and distribute for your own purposes
;***** you are allowed to use some parts in your code but mention my name there
;***** if you'll make this code better, or comment it, send it to me please
;***** crayzee@mailbox.sk
;*****

;************************************************************************************
;************************************************************************************
;************************************************************************************
;*				Proc of Main Window				    *
;************************************************************************************
;************************************************************************************
;************************************************************************************
.code
WndProc proc uses ebx edx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
	mov	eax, [wmsg]
	cmp	eax, TRAYICONMSG
	jne	tryWM_SYSCOMMAND
	cmp	[lparam], WM_LBUTTONDBLCLK
	jne	defwp
	setne	dl
	jmp	doSC_RESTORE
    tryWM_SYSCOMMAND:
	cmp	eax, WM_SYSCOMMAND
	je	wmsyscommand
        cmp     eax, WM_CREATE
        je      wmcreate
        cmp	eax, WM_CLOSE
        je 	wmclose
	cmp	eax, WM_PAINT
	je	wmpaint
	cmp	eax, WM_COMMAND
	jne	defwp

	mov	eax, [wparam]
	shr	eax, 16
	cmp	ax, EN_CHANGE
	je	enupdate

	cmp	mode, 0010b
	je	mode2selections
mode1selections:
	mov	eax, [lparam]
	cmp	eax, [htext1]
	je	getfile1
	cmp	eax, [htext2]
	je	getfile2
	cmp	eax, [hbutton]
	je	makepatchfile

	mov	eax, [wparam]
	cmp	eax, IDM_OPEN1
	je	getfile1
	cmp	eax, IDM_OPEN2
	je	getfile2
	cmp	eax, IDM_WRITE
	je	makepatchfile
	jmp	otherselections
mode2selections:
	mov	eax, [lparam]
	cmp	eax, [htext1]
	je	getfile1_
	cmp	eax, [htext2]
	je	getfile2_
	cmp	eax, [hbutton]
	je	patchfile

	mov	eax, [wparam]
	cmp	eax, IDM_OPEN1
	je	getfile1_
	cmp	eax, IDM_OPEN2
	je	getfile2_
	cmp	eax, IDM_WRITE
	je	patchfile
otherselections:			;if other menu items were selected
	mov	eax, [wparam]
	cmp	eax, IDM_EXIT
	je	wmclose
	cmp	eax, IDM_ABOUT
	je	about
	cmp	eax, IDM_GREETZ
	je	greetz
	cmp	eax, IDM_HELP
	jne	notIDM_HELP
	call	helpproc
	jmp	_noexit ;ret
	notIDM_HELP:
	cmp	eax, IDM_CONFIG
	jne	notIDM_CONFIG
	call	configproc
	jmp	_noexit ;ret
	notIDM_CONFIG:
	cmp	eax, IDM_MODE1
	je	modechange
	cmp	eax, IDM_MODE2
	je	modechange
	jmp	defwp

wmsyscommand:				;if a system menu command received		
	mov	eax, [wparam]
	cmp	eax, SC_MINIMIZE
	jne	trySC_RESTORE

	push	offset TitleMinimized
	push	[hwnd]
	call	SetWindowTextA
	jmp	defwp
	
    trySC_RESTORE:
	cmp	eax, SC_RESTORE
	jne	defwp
	sete	dl
    doSC_RESTORE:
	push	offset TitleName
	push	[hwnd]
	call	SetWindowTextA

	push	SW_RESTORE
	push	[hwnd]
	call	ShowWindow

	push	[hwnd]
	call	SetForegroundWindow

	mov	eax, [somedialog]
	mov	ebx, eax
	and	ebx, ACTIVEDIALOG_CONFIG
	je	tryAD_ABOUT			;if the config window is active, call its loop

	or	dl, dl
	je	call_beforeconfig_msg_loop
	jmp	_noexit;beforeconfig_msg_loop
    call_beforeconfig_msg_loop:
	call	beforeconfig_msg_loop
	jmp	_noexit ;ret
    tryAD_ABOUT:
	mov	ebx, eax
	and	ebx, ACTIVEDIALOG_ABOUT
	je	tryAD_GREETZ

	or	dl, dl
	je	call_beforeabout_msg_loop
	jmp	_noexit
    call_beforeabout_msg_loop:
	call	beforeabout_msg_loop
	jmp	_noexit ;ret
    tryAD_GREETZ:
	mov	ebx, eax
	and	ebx, ACTIVEDIALOG_GREETZ
	je	defwp

	or	dl, dl
	je	call_beforegreetz_msg_loop
	jmp	_noexit;beforegreetz_msg_loop
    call_beforegreetz_msg_loop:
	call	beforegreetz_msg_loop
	jmp	_noexit ;ret

enupdate:				;if some of the edit boxes were changed
	mov	eax, [lparam]
	cmp	eax, [hstatic1]
	jne	try_hstatic2
    go_enupdate1:
	push	256	;nMaxCount
	cmp	mode, 0010b
	je	mode2edit1
	push	offset szFile1
	push	eax
	call	GetWindowTextA
		mov	eax, [settings]
		and	eax, SET_USESAMENAMES
		je	aftercopy1to1_
			mov	ecx, 256
			mov	esi, offset szFile1
			mov	edi, offset szFile1_
			rep	movsb
		aftercopy1to1_:
	cmp	byte ptr [szFile1], 0
	jne	okwtext1
	and	canwrite, 0010b
	or	canwrite, 1100b
	jmp	noexit
    okwtext1:
	or	canwrite, 1101b
	jmp	noexit
    mode2edit1:
	push	offset szFile1_
	push	eax
	call	GetWindowTextA
		mov	eax, [settings]
		and	eax, SET_USESAMENAMES
		je	aftercopy1_to1
			mov	ecx, 256
			mov	esi, offset szFile1_
			mov	edi, offset szFile1
			rep	movsb
		aftercopy1_to1:
	cmp	byte ptr [szFile1_], 0
	jne	okwtext1_
	and	canwrite_, 0010b
	or	canwrite_, 1100b
	jmp	noexit_
    okwtext1_:
	or	canwrite_, 1101b
	jmp	noexit_
try_hstatic2:
	cmp	eax, [hstatic2]
	jne	defwp
    go_enupdate2:
	push	256	;nMaxCount
	cmp	mode, 0010b
	je	mode2edit2
	push	offset szFile2
	push	eax
	call	GetWindowTextA
		mov	eax, [settings]
		and	eax, SET_USESAMENAMES
		je	aftercopy2to2_
			mov	ecx, 256
			mov	esi, offset szFile2
			mov	edi, offset szFile2_
			rep	movsb
		aftercopy2to2_:
	cmp	byte ptr [szFile2], 0
	jne	okwtext2
	and	canwrite, 0001b
	or	canwrite, 1100b
	jmp	noexit
    okwtext2:
	or	canwrite, 1110b
	jmp	noexit
    mode2edit2:
	push	offset szFile2_
	push	eax
	call	GetWindowTextA
		mov	eax, [settings]
		and	eax, SET_USESAMENAMES
		je	aftercopy2_to2
			mov	ecx, 256
			mov	esi, offset szFile2_
			mov	edi, offset szFile2
			rep	movsb
		aftercopy2_to2:
	cmp	byte ptr [szFile2_], 0
	jne	okwtext2_
	and	canwrite_, 0001b
	or	canwrite_, 1100b
	jmp	noexit_
    okwtext2_:
	or	canwrite_, 1110b
	jmp	noexit_

wmdropfiles:
	mov	eax, [msg.msHWND]
	cmp	mode, 0010b
	je	mode2drop	
mode1drop:
	cmp	eax, [hstatic1]
	je	drop1
	cmp	eax, [hstatic2]
	je	drop2
	jmp	continuemsgloop
mode2drop:
	cmp	eax, [hstatic1]
	je	drop1_
	cmp	eax, [hstatic2]
	je	drop2_
	jmp	continuemsgloop

;if none of the above
defwp:					;if none of the above
        push    [lparam]
        push    [wparam]
        push    [wmsg]
        push    [hwnd]
        call    DefWindowProcA
	jmp	_noexit ;ret

;***********************************mode 1 function parts***********************************
;1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
;if a file was dropped in the static box 1
drop1:
	mov	eax, offset szFile1
	mov	ebx, [msg.msWPARAM]
	push	eax
	push	[hstatic1]
	push	ebx
	push	256		;cch
	push	eax		;lpszFile
	push	0		;iFile
	push	ebx		;hDrop
	call	DragQueryFileA
	call	DragFinish
	call	SetWindowTextA

	or	canwrite, 1101b
	jmp	drop_noexit
;if a file was dropped in the static box 2
drop2:
	mov	eax, offset szFile2
	mov	ebx, [msg.msWPARAM]
	push	eax
	push	[hstatic2]
	push	ebx
	push	256		;cch
	push	eax		;lpszFile
	push	0		;iFile
	push	ebx		;hDrop
	call	DragQueryFileA
	call	DragFinish
	call	SetWindowTextA

	or	canwrite, 1110b
	jmp	drop_noexit
;get the name of the old file
getfile1:
	mov	eax, [hInst]
	mov	[_file1.hInstance], eax
	mov	eax, [hwnd]
	mov	[_file1.hwndOwner], eax
	push	offset _file1
	push	0
	push	[hwnd]
	call	EnableWindow	
	call	GetOpenFileNameA
	or	eax, eax
	je	nofile1

	push	offset szFile1
	push	[hstatic1]
	call	SetWindowTextA
	or	canwrite, 1101b
nofile1:
	push	1
	push	[hwnd]
	call	EnableWindow	
	push	[htext1]
	call	SetFocus
	jmp	noexit
;get the name of the new file
getfile2:
	mov	eax, [hInst]
	mov	[_file2.hInstance], eax
	mov	eax, [hwnd]
	mov	[_file2.hwndOwner], eax
	push	offset _file2
	push	0
	push	[hwnd]
	call	EnableWindow	
	call	GetOpenFileNameA
	or	eax, eax
	je	nofile2

	push	offset szFile2
	push	[hstatic2]
	call	SetWindowTextA
	or	canwrite, 1110b
nofile2:
	push	1
	push	[hwnd]
	call	EnableWindow
	push	[htext2]
	call	SetFocus
	jmp	noexit
;---make the final patch file---
makepatchfile:
	cmp	byte ptr [szFile1], 0
	je	noexit
	cmp	byte ptr [szFile2], 0
	je	noexit
;----------------------------------------Open Old File-----------------------------------
openfile1:
	push	0					
	push	FILE_ATTRIBUTE_NORMAL		
	push	OPEN_EXISTING
	push	0	
	push	FILE_SHARE_READ
	push	GENERIC_READ	
	push	offset szFile1
	call	CreateFileA
	cmp	eax,0FFFFFFFFh
	je	cantopenfile1
	mov	[hfile1], eax
	push	0
	push	eax
	call	GetFileSize
	mov	[f_size1], eax
	mov	[Head.fsize1], eax

;----------------------------------------Open New File-------------------------------------
openfile2:
	push	0					
        push	FILE_ATTRIBUTE_NORMAL		
        push	OPEN_EXISTING
        push	0	
        push	FILE_SHARE_READ
        push	GENERIC_READ	
        push	offset szFile2
        Call	CreateFileA
	cmp	eax,0FFFFFFFFh
	je	cantopenfile2
	mov	[hfile2], eax
	push	0
	push	eax
	call	GetFileSize
	mov	[f_size2], eax
;	cmp	eax, f_size1	;if different sizes, jump
;	jne	difsizes

	mov	[Head.fsize2], eax

;--------------------------------get the name of the patch script file
getfile3:
	mov	eax, [hInst]
	mov	[_file3.hInstance], eax
	mov	eax, [hwnd]
	mov	[_file3.hwndOwner], eax
	push	offset _file3
	push	0
	push	[hwnd]
	call	EnableWindow	
	call	GetSaveFileNameA
	or	eax, eax
	jne	yfile3

	push	1
	push	[hwnd]
	call	EnableWindow
	push	hfile1
	call	CloseHandle
	push	hfile2
	call	CloseHandle
	jmp	noexit
yfile3:
	push	1
	push	[hwnd]
	call	EnableWindow		

	mov	esi, offset Ext1
	mov	[ismp], 0
	cmp	[_file3.nFilterIndex], 2
	jne	filter1
	mov	esi, offset Ext2
	mov	[ismp], 1
    filter1:
	mov	edi, offset szFile3
	xor	eax, eax
	mov	ax, [_file3.nFileExtension]
	add	edi, eax
	cmp	byte ptr [edi-1], '.'
	jne	addextension
	dec	edi
    addextension:
	movsd
	movsb

;open the patch script file
	push	0					
        push	FILE_ATTRIBUTE_NORMAL		
        push	OPEN_ALWAYS
        push	0
        push	0
        push	GENERIC_READ or GENERIC_WRITE	
        push	offset szFile3
        call	CreateFileA
	mov	hfile3, eax
	cmp	eax, 0FFFFFFFFh
	jne	generateps
cantopenfile3:
	push	MB_ICONHAND or MB_OKCANCEL
	push	offset ErrorCaption
	push	offset CantOpen3
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDCANCEL
	jne	getfile3
	je	noexit

;---------------------------------generate patch script file--------------------------------
generateps:
	call	createprogressbar

	push	BLOCKSIZE1
	push	0		;MEM_FIXED
	call	GlobalAlloc
	mov	allocadr1, eax

	push	BLOCKSIZE1
	push	0
	call	GlobalAlloc
	mov	allocadr2, eax

	xor	edx, edx
	mov	eax, f_size2
	mov	ebx, BLOCKSIZE1
	div	ebx
	mov	ecx, eax
	inc	ecx

	xor	esi, esi
	mov	[Head.crc1], esi
	mov	[Head.crc2], esi
	mov	[Head.crc3], esi
	mov	[Head.entries], esi
	mov	edi, offset DATACHUNK

	cmp	[ismp], 1
	je	mp_writestart
	pusha
	push	0
	push	offset bytesread
	push	SIZE_OF_HEADER
	push	offset Head
	push	hfile3
	call	WriteFile
	test	eax, eax
	popa
	jz	diskerror
	jmp	startcomparing
mp_writestart:
	pusha
	push	0
	push	offset bytesread
	push	minipatcher_codesize
	push	offset minipatcher_codestart
	push	hfile3
	call	WriteFile
	test	eax, eax
	popa
	jz	diskerror

	pusha
	push	0
	push	offset bytesread
	push	MPSIZE_OF_HEADER
	push	offset MPHead
	push	hfile3
	call	WriteFile
	test	eax, eax
	popa
	jz	diskerror

startcomparing:
	mov	chunkend, 1
	mov	overlayed, 0
;*******************************block compare loop code START
blockcompareloop:
	mov	eax, BLOCKSIZE1
	cmp	ecx, 1
	jne	aftermoveaxedx1
	mov	eax, edx
	or	eax, eax
	je	aftercompareloopcode
    aftermoveaxedx1:
	pushad
	push	0
	push	offset bytesread
	push	eax
	push	[allocadr1]
	push	hfile1
	call	ReadFile          	
	popad

	pushad
	push	0
	push	offset bytesread
	push	eax
	push	[allocadr2]
	push	hfile2
	call	ReadFile          	
	popad

	push	ecx
	push	edx
	mov	ecx, eax
	mov	eax, allocadr1
	mov	ebx, allocadr2

	jmp	compareloop
    aftercompareloop:

	jmp	setprogress
    aftersetprogress:

	pop	edx
	pop	ecx



	loop	blockcompareloop
;*******************************block compare loop code END
	jmp	aftercompareloopcode
setprogress:
	pushad
	xor	edx, edx
	mov	eax, esi
	mov	ebx, [Head.fsize2]
	mov	ecx, 100
	mul	ecx
	div	ebx
	push	0
	push	eax
	push	PBM_SETPOS
	push	[hprogress]
	call	SendMessageA
	popad
	jmp	aftersetprogress
;*******************************compare loop code START
compareloop:
	cmp	esi, f_size1
	je	prepareforoverlay
	ja	writeoverlayonly
	xor	edx, edx
	mov	dh, byte ptr [eax]
	add	[Head.crc1], edx
	mov	dh, 0
	mov	dl, byte ptr [ebx]
	add	[Head.crc2], edx
	mov	dh, byte ptr [eax]
	cmp	dh, dl
	je	chunkended

	cmp	chunkend, 1
	jne	chunknotended
	setne	chunkend	;set to 0
	mov	pos, esi
	mov	dif, -1
	add	dword ptr [Head.entries], 5
	mov	edi, offset difdata
	jmp	chunknotended

chunkended:
	mov	dl, chunkend
	sete	chunkend	;set to 1
	test	dl, dl
	je	writedata	;if was previously 0, write chunk to the file
    afterwritedata:
nextcl:	
	inc	eax
	inc	ebx
	inc	esi
	loop	compareloop
	jmp	aftercompareloop
;*******************************compare loop code END
    chunknotended:
	mov	[edi], dh
	mov	[edi+1], dl
	add	[Head.crc3], edx
	add	[Head.crc3], esi
	inc	dif
	add	edi, 2
	add	dword ptr [Head.entries], 2
	cmp	dif, -1
	je	chunkended
	jmp	nextcl
	
writedata:
	sub	edi, offset DATACHUNK
	pushad
	;write the data
	push	0		;addr. of structure needed for overlapped I/O  
	push	offset bytesread;bytes written
	push	edi		;bytes to write
	push	offset DATACHUNK ;addr. of data
	push	hfile3		;file handle
	call	WriteFile
	test	eax, eax
	popad
	jz	godiskerror
	mov	edi, offset DATACHUNK
	jmp	afterwritedata

prepareforoverlay:
	sete	overlayed	;always set 1
	sub	edi, offset DATACHUNK
	pushad
	;write unwritten data
	push	0
	push	offset bytesread
	push	edi
	push	offset DATACHUNK
	push	hfile3
	call	WriteFile
	test	eax, eax
	popad
	jz	godiskerror

	mov	allocated, 40000h ;=256kb
	pushad
	push	allocated
	push	0
	call	GlobalAlloc
	mov	allocadr3, eax
	popad
	mov	edi, allocadr3
	mov	eax, -1
	stosd
	add	dword ptr [Head.entries], 4

writeoverlayonly:
	xor	edx, edx
	mov	dl, byte ptr [ebx]
	add	[Head.crc2], edx
	add	[Head.crc3], edx
	add	[Head.crc3], esi
	mov	byte ptr [edi], dl
	inc	edi
	inc	dword ptr [Head.entries]
	mov	edx, edi
	sub	edx, allocadr3
	cmp	allocated, edx
	ja	nextcl
	sub	edi, allocadr3
	pushad
	;write the data
	push	0		;addr. of structure needed for overlapped I/O  
	push	offset bytesread;bytes written
	push	edi		;bytes to write
	push	allocadr3	;addr. of data
	push	hfile3		;file handle
	call	WriteFile
	test	eax, eax
	popad
	jz	godiskerror
	mov	edi, allocadr3
	jmp	nextcl


aftercompareloopcode:
	push	0		;addr. of structure needed for overlapped I/O  
	push	offset bytesread;bytes written
   cmp	overlayed, 1
   je	filewasoverlayed
	sub	edi, offset DATACHUNK
	push	edi		;bytes to write
	push	offset DATACHUNK ;addr. of data
   jmp	after_filewasoverlayed
   filewasoverlayed:
	sub	edi, allocadr3
	push	edi		;bytes to write
	push	allocadr3	;addr. of data
   after_filewasoverlayed:
	push	hfile3		;file handle
	call	WriteFile
	test	eax, eax
	jz	diskerror

	push	hfile3
	call	SetEndOfFile

	mov	eax, [Head.entries]
	test	eax, eax
	jz	filessame

	mov	ebx, SIZE_OF_HEADER
	cmp	[ismp], 0
	je	isnormalpth
	mov	ebx, minipatcher_codesize
	add	ebx, MPSIZE_OF_HEADER

    isnormalpth:
	add	eax, ebx
	cmp	f_size2, eax
	ja	finishfile3

	mov	ebx, [settings]
	and	ebx, SET_SCRIPTBIGGER
	je	finishfile3

	push	MB_ICONWARNING or MB_YESNO or MB_DEFBUTTON2
	push	offset WarningCaption
	push	offset ScriptBigger
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDYES
	je	finishfile3

	call	closefreeall
	push	offset szFile3
	call	DeleteFileA
	push	[hbutton]
	call	SetFocus
	jmp	noexit


finishfile3:
	cmp	[ismp], 1
	je	finishmp

;*******finish the classic pth patch script file*******;

	;write the head of patch script file
	push	0
	call	set_hfile3_pointer

	push	0
	push	offset bytesread
	push	SIZE_OF_HEADER
	push	offset Head
	push	hfile3
	call	WriteFile
	test	eax, eax
	jz	diskerror
	jmp	finishend


;*******finish the minipatcher .exe file*******;
    finishmp:

    ;write the minipth header
	;copy the necessary data to the section
	mov	esi, afterHeadtitle
	mov	edi, afterMPHeadtitle
	mov	ecx, afterHeaddatasize
	rep	movsb

	;set to the replace position (end of code)
	push	minipatcher_codesize
	call	set_hfile3_pointer

	;write the minipth header
	push	0
	push	offset bytesread
	push	MPSIZE_OF_HEADER
	push	offset MPHead
	push	hfile3
	call	WriteFile
	test	eax, eax
	jz	diskerror

    ;write the minipth section aligned size
	;set to the replace position
	push	minipatcher_pthalignedsize_replacepos
	call	set_hfile3_pointer

	;compute the aligned size
	xor	edx, edx
	mov	eax, [MPHead.mpentries]
	mov	ebx, 200h
	div	ebx
	xor	edx, edx
	inc	eax
	mul	ebx
	mov	[sth], eax

	;write the aligned size
	call	write_sth_to_hfile3
	test	eax, eax
	jz	diskerror

    ;write the block size and xored settings variable
	;set to the replace position
	push	minipatcher_allsettings_replacepos
	call	set_hfile3_pointer

	;write the block size
	mov	eax, BLOCKSIZE2
	mov	[sth], eax
	call	write_sth_to_hfile3
	test	eax, eax
	jz	diskerror

	;xor the settings
	mov	eax, [settings]
	xor	ebx, ebx
	dec	ebx
	xor	eax, ebx
	mov	[sth], eax	

	;write the xored settings
	call	write_sth_to_hfile3
	test	eax, eax
	jz	diskerror

;*******cleanup and message*******;

finishend:
	call	closefreeall

	mov	eax, [settings]
	and	eax, SET_WRITTENINFO
	je	afterwrittenmessage
	push	MB_ICONINFORMATION
	push	offset MessageCaption
	push	offset WrittenMessage
	push	[hwnd]
	call	MessageBoxA
    afterwrittenmessage:
	push	[hbutton]
	call	SetFocus
	jmp	noexit

filessame:
	call	closefreeall
	push	offset szFile3
	call	DeleteFileA

	push	MB_ICONHAND or MB_OK
	push	offset ErrorCaption
	push	offset FilesAreSame
	push	[hwnd]
	call	MessageBoxA
	and	canwrite, 1011b
	or	canwrite, 1000b
	jmp	noexit
;toobig:
;	push	MB_ICONHAND or MB_OK
;	push	offset ErrorCaption
;	push	offset FileTooBigMessage
;	push	[hwnd]
;	call	MessageBoxA
;	jmp	noexit
godiskerror:
	pop	eax
	pop	eax
diskerror:
	call	closefreeall
	push	offset szFile3
	call	DeleteFileA

	push	MB_ICONHAND or MB_OK
	push	offset ErrorCaption
	push	offset DiskWriteErrorMessage
	push	[hwnd]
	call	MessageBoxA
	jmp	noexit
cantopenfile1:
	push	MB_ICONHAND or MB_RETRYCANCEL
	push	offset ErrorCaption
	push	offset CantOpen1
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDCANCEL
	jne	openfile1

	jmp	noexit
cantopenfile2:
	push	MB_ICONHAND or MB_RETRYCANCEL
	push	offset ErrorCaption
	push	offset CantOpen2
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDCANCEL
	jne	openfile2

	call	closefreeall
	jmp	noexit
;***********************************mode 2 function parts***********************************
;2222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222
;if a file was dropped in the static box 1
drop1_:
	mov	eax, offset szFile1_
	mov	ebx, [msg.msWPARAM]
	push	eax
	push	[hstatic1]
	push	ebx
	push	256		;cch
	push	eax		;lpszFile
	push	0		;iFile
	push	ebx		;hDrop
	call	DragQueryFileA
	call	DragFinish
	call	SetWindowTextA
	or	canwrite_, 1101b
	jmp	drop_noexit_
;if a file was dropped in the static box 2
drop2_:
	mov	eax, offset szFile2_
	mov	ebx, [msg.msWPARAM]
	push	eax
	push	[hstatic2]
	push	ebx
	push	256		;cch
	push	eax		;lpszFile
	push	0		;iFile
	push	ebx		;hDrop
	call	DragQueryFileA
	call	DragFinish
	call	SetWindowTextA

	or	canwrite_, 1110b
	jmp	drop_noexit_
;get the name of the patch script file
getfile1_:
	mov	eax, [hInst]
	mov	[_file1_.hInstance], eax
	mov	eax, [hwnd]
	mov	[_file1_.hwndOwner], eax
	push	offset _file1_
	push	0
	push	[hwnd]
	call	EnableWindow	
	call	GetOpenFileNameA
	or	eax, eax
	je	nofile1_

	push	offset szFile1_
	push	[hstatic1]
	call	SetWindowTextA
	or	canwrite_, 1101b
nofile1_:
	push	1
	push	[hwnd]
	call	EnableWindow	
	push	[htext1]
	call	SetFocus
	jmp	noexit_
;get the name of the old file
getfile2_:
	mov	eax, [hInst]
	mov	[_file2_.hInstance], eax
	mov	eax, [hwnd]
	mov	[_file2_.hwndOwner], eax
	push	offset _file2_
	push	0
	push	[hwnd]
	call	EnableWindow	
	call	GetOpenFileNameA
	or	eax, eax
	je	nofile2_

	push	offset szFile2_
	push	[hstatic2]
	call	SetWindowTextA
	or	canwrite_, 1110b
nofile2_:
	push	1
	push	[hwnd]
	call	EnableWindow
	push	[htext2]
	call	SetFocus
	jmp	noexit_
;---patch the old file---
patchfile:
;-------------------------------------Open Patch Script File--------------------------------
	cmp	byte ptr [szFile1_], 0
	je	noexit
	cmp	byte ptr [szFile2_], 0
	je	noexit
openfile1_:
	push	0					
	push	FILE_ATTRIBUTE_NORMAL		
	push	OPEN_EXISTING
	push	0	
	push	FILE_SHARE_READ
	push	GENERIC_READ	
	push	offset szFile1_
	call	CreateFileA
	cmp	eax, 0FFFFFFFFh
	je	cantopenfile1_
	mov	[hfile1_], eax

	push	0
	push	offset bytesread
	push	63
	push	offset Headold
	push	hfile1_
	call	ReadFile

;check if it is a minipatcher .exe file
	mov	esi, offset Headold.o_title
	lodsd
	cmp	eax, 00505a4dh ;'MZP\0'
	jne	itmustbeclassicpth

	mov	ecx, 1f8h	;section headers start at this address
	mov	ebx, 40		;the size of a section header
    findpatchscriptsection:
	push	ecx
	call	set_hfile1__pointer
	call	read_hfile1__to_edx
	test	eax, eax
	jz	badheader
	test	edx, edx
	jz	badheader
	cmp	edx, 'csp.'	;'.psc'	- first 4 bytes of the section name we're looking for
	jne	nextsection
	call	read_hfile1__to_edx
	test	eax, eax
	jz	badheader
	cmp	edx, 'tpir'	;'ript' - last 4 bytes of that section name
	jne	nextsection
	xor	ecx, ecx
	mov	cl, 4
    sectionheaderdatareadloop:
	call	read_hfile1__to_edx
	test	eax, eax
	jz	badheader
	loop	sectionheaderdatareadloop
	;we should have now in sth the position of section's data in the file
	jmp	sectionfound
    nextsection:
	add	ecx, ebx
	jmp	findpatchscriptsection

    sectionfound:
	push	edx
	call	set_hfile1__pointer

	push	0
	push	offset bytesread
	push	MPSIZE_OF_HEADER
	push	offset MPHead_
	push	hfile1_
	call	ReadFile

	mov	ecx, 17
    mpheadercompareloop:
	mov	edi, offset MPHead_.mpident
	mov	esi, offset mp_ident_text
	repe	cmpsb
	or	ecx, ecx
	jnz	badheader
	setnz	pscriptold	;set to 0

	mov	edi, offset afterHead_title
	mov	esi, offset afterMPHead_title
	mov	ecx, afterHeaddatasize
	rep	movsb
	jmp	versioncompare

itmustbeclassicpth:
	mov	[ismp], 0
;find out if we can use the patch script file
	mov	ecx, 40
headercompareloop:
	mov	edi, offset Headold.o_title
	mov	esi, offset head_title
	repe	cmpsb
	or	ecx, ecx
	jnz	badheader

	cmp	[Headold.o_nverh], 1
	sete	pscriptold
	jne	testifpsnewer
	cmp	[Headold.o_nverl], 7
	sete	pscriptold
	je	patchit

testifpsnewer:
	push	0
	call	set_hfile1__pointer

	push	0
	push	offset bytesread
	push	SIZE_OF_HEADER
	push	offset Head_
	push	hfile1_
	call	ReadFile
    versioncompare:
	cmp	[Head_.nverh], NEEDEDVER_MAJVALUE	;header needed version major testing
	ja	badversion
	cmp	[Head_.nverl], NEEDEDVER_MINVALUE	;header needed version minor testing
	ja	badversion


;*******************************************************************************************
patchit:
	mov	eax, [Headold.o_entries]
       cmp	pscriptold, 1
       je	allocmemforscript
	mov	eax, [Head_.entries]
       allocmemforscript:
	add	eax, 6
	push	eax			;read the psfile data section
	push	40h;GMEM_FIXED or GMEM_ZEROINIT
	call	GlobalAlloc
	mov	allocadr1, eax

	push	0
	push	offset bytesread
       mov	eax, [Headold.o_entries]
       cmp	pscriptold, 1
       je	readscript
	mov	eax, [Head_.entries]
       readscript:
	push	eax
	push	[allocadr1]
	push	hfile1_
	call	ReadFile          	

	push	hfile1_
	call	CloseHandle

	xor	eax, eax
	mov	crc_3, eax
	mov	esi, allocadr1
       cmp	pscriptold, 1
       jne	gocrccheckloop
	mov	ecx, [Headold.o_entries]
old_crccheckloop:
	xor	edx, edx
	mov	dl, byte ptr [esi+1]
	mov	dh, byte ptr [esi]
	add	crc_3, edx
	mov	ebx, dword ptr [esi+2]
	add	crc_3, ebx
	sub	ecx, 6
	add	esi, 6
	test	ecx, ecx
	jne	old_crccheckloop
	jmp	checkifcrcbad

gocrccheckloop:
	mov	ecx, [Head_.entries]
	xor	ebx, ebx
	xor	edi, edi
crccheckloop:
	xor	edx, edx
	cmp	bl, 0
	jne	crc_chunkactive
	lodsd
	sub	ecx, 4
	mov	edi, eax
	cmp	eax, -1
	jne	readdif
	mov	edi, [Head_.fsize1]
	mov	bl, 1
	jmp	crc_overlay
    readdif:
	mov	bh, byte ptr [esi]
	inc	esi
	dec	ecx
    crc_chunkactive:
	cmp	eax, -1
	je	crc_overlay
	mov	dh, byte ptr [esi]
	inc	esi
	dec	ecx
	sub	bh, 1	;dec doesn't affect the carry flag
	setnc	bl
    crc_overlay:
	add	crc_3, edi
	mov	dl, byte ptr [esi]
	inc	esi
	dec	ecx
	add	crc_3, edx
	inc	edi
	test	ecx, ecx
	jne	crccheckloop

checkifcrcbad:
	mov	eax, [crc_3]			
	mov	ebx, [Headold.o_crc3]
       cmp	pscriptold, 1
       je	crccompare3
	mov	ebx, [Head_.crc3]
       crccompare3:
	cmp	eax, ebx
	je	below3
	mov	eax, [settings]
	and	eax, SET_BADCRCPCONFIRM
	je	below3
	push	MB_ICONWARNING or MB_YESNO or MB_DEFBUTTON2
	push	offset WarningCaption
	push	offset BadCRCpMessage
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDYES
	je	below3
	push	allocadr1
	call	GlobalFree

	and	canwrite_, 1011b
	or	canwrite_, 1000b
	jmp	noexit_
below3:

;----------------------------------------Open Old File-------------------------------------
openfile2_:
	push	0					
        push	FILE_ATTRIBUTE_NORMAL or FILE_FLAG_WRITE_THROUGH
        push	OPEN_EXISTING
        push	0	
        push	FILE_SHARE_WRITE or FILE_SHARE_READ
        push	GENERIC_READ	
        push	offset szFile2_
        Call	CreateFileA
	cmp	eax, 0FFFFFFFFh
	je	cantopenfile2_
	mov	[hfile2_], eax

	push	0	;for GetFileSize
	push	eax	;for GetFileSize
	;get the old file's time if wanted
	mov	ebx, [settings]
	and	ebx, SET_USEOLDFILETIME
	jz	dontwantfiletime
	push	offset fLastWriteTime
	push	offset fLastAccessTime
	push	offset fCreationTime
	push	eax
	call	GetFileTime
    dontwantfiletime:
	;get the old file's attributes if wanted
	mov	ebx, [settings]
	and	ebx, SET_USEOLDATTRIBS
	jz	dontwantattribs
	push	offset szFile2_
	call	GetFileAttributesA
	mov	[fAttributes], eax
    dontwantattribs:
	call	GetFileSize


       cmp	pscriptold, 1
       jne	gobadsize
	cmp	eax, [Headold.o_fsize1]	;if bad size
	je	afterbadsize
	mov	[Headold.o_fsize1], eax
	jmp	callbadsizeproc
       gobadsize:
	mov	ebx, [Head_.fsize2]
	mov	f_size2, ebx
	mov	f_size1, eax
	cmp	eax, [Head_.fsize1] ;compare the real and stored size of old file
	je	afterbadsize
	mov	f_size2, eax	;if stored size is bad, we will use the old file's real size
       callbadsizeproc:
	call	badsizeproc
	test	eax, eax
	jnz	noexit_
afterbadsize:	
;---------------------------------------Open new file--------------------------------------
;get the name of the new file
getfile3_:
	mov	eax, [hInst]
	mov	[_file3_.hInstance], eax
	mov	eax, [hwnd]
	mov	[_file3_.hwndOwner], eax
	push	offset _file3_
	push	0
	push	[hwnd]
	call	EnableWindow	
	call	GetSaveFileNameA
	or	eax, eax
	jne	yfile3_

	push	1
	push	[hwnd]
	call	EnableWindow
	push	hfile2_
	call	CloseHandle
	jmp	noexit_
yfile3_:
	push	1
	push	[hwnd]
	call	EnableWindow		

;write the new file
	push	0					
        push	FILE_ATTRIBUTE_NORMAL or FILE_FLAG_WRITE_THROUGH
        push	OPEN_ALWAYS
        push	0
        push	FILE_SHARE_READ
        push	GENERIC_READ or GENERIC_WRITE	
        push	offset szFile3_
        call	CreateFileA
	cmp	eax, 0FFFFFFFFh
	je	cantopenfile3_
	mov	hfile3_, eax

;------------------------------------Patch the file (mem)----------------------------------
	call	createprogressbar

	push	BLOCKSIZE2
	push	0;GMEM_FIXED
	call	GlobalAlloc
	mov	allocadr2, eax

	push	BLOCKSIZE2
	push	0
	call	GlobalAlloc
	mov	allocadr3, eax

	cmp	pscriptold, 1
	je	old_patch






	xor	edx, edx
	mov	eax, [f_size2]
	mov	ebx, BLOCKSIZE2
	div	ebx
	mov	ecx, eax
	inc	ecx

	xor	eax, eax
	mov	crc_1, eax
	mov	crc_2, eax
	mov	skipdifdata, eax
	mov	edi, eax
	mov	esi, allocadr1
	mov	chunkend, 1
	mov	overlayed, 0
;*******************************block patch loop code START
blockpatchloop:
	mov	eax, BLOCKSIZE2
	cmp	ecx, 1
	jne	aftermoveaxedx
	mov	eax, edx
	or	eax, eax
	je	after_patch
    aftermoveaxedx:
	pushad
	push	0
	push	offset bytesread
	push	eax
	push	[allocadr2]
	push	hfile2_
	call	ReadFile          	
	popad

	push	eax
	push	ecx
	push	edx
	mov	ecx, eax
	mov	eax, allocadr2
	mov	ebx, allocadr3

	jecxz	afterpatchloop
	jmp	patchloop
    afterpatchloop:

	pop	edx
	pop	ecx
	pop	eax

	;write the data
	pushad
	jmp	writepatcheddata
	afterwritepatcheddata:
	test	eax, eax
	pop	edi
	push	edi
	pushfd

	xor	edx, edx
	mov	eax, edi
	mov	ebx, [f_size2]
	mov	ecx, 100
	mul	ecx
	div	ebx
	push	0
	push	eax
	push	PBM_SETPOS
	push	[hprogress]
	call	SendMessageA
	
	popfd	
	popad		
	jz	diskerror_

	loop	blockpatchloop
;*******************************block patch loop code END
	jmp	after_patch
writepatcheddata:
	push	0		;addr. of structure needed for overlapped I/O  
	push	offset bytesread;bytes written
	push	eax		;bytes to write
	push	allocadr3	;addr. of data
	push	hfile3_		;file handle
	call	WriteFile
	jmp	afterwritepatcheddata
;*******************************patch loop code START
patchloop:
	cmp	edi, [f_size1]
	jae	patchoverlayonly
	xor	edx, edx
	mov	dh, byte ptr [eax]
	mov	byte ptr [ebx], dh
	add	crc_1, edx
	xchg	dl, dh	

	mov	[sth], edx

	sub	esi, allocadr1
	cmp	esi, [Head_.entries]
	pushfd
	add	esi, allocadr1
	popfd
	jnb	nextpl

	cmp	chunkend, 1
	jne	chunknotended_
	setne	chunkend	;set to 0
	push	eax
	lodsd
	mov	pos, eax
	cmp	eax, -1
	je	dontloaddif
	lodsb
	mov	dif, al
    dontloaddif:
	pop	eax

	jmp	chunknotended_
	
nextpl:	
	mov	edx, [sth]
	add	crc_2, edx

	inc	edi
	inc	eax
	inc	ebx
	loop	patchloop
	jmp	afterpatchloop
;*******************************patch loop code END
    chunknotended_:
	cmp	pos, edi
	jne	nextpl

	setne	chunkend	;set to 0
	mov	dl, byte ptr [esi]	;check if the byte is in the old file
	mov	dh, byte ptr [eax]

	cmp	dh, dl
	je	belowbaddata

	jmp	baddata

    belowbaddata:
	xor	edx, edx
	mov	dl, byte ptr [esi+1]
	mov	byte ptr [ebx], dl
	mov	dh, byte ptr [esi]

	add	crc_3, edx
	add	crc_3, edi

	add	esi, 2
	mov	dh, 0
	mov	[sth], edx
	sub	dif, 1		;dec doesn't affect the carry flag
	setc	chunkend
	inc	pos
	jmp	nextpl

patchoverlayonly:
	setae	overlayed	;set to 1

	cmp	pos, -1
	je	gopatchoverlayonly
	lodsd
	mov	pos, eax
    gopatchoverlayonly:
	xor	edx, edx
	mov	dl, byte ptr [esi]
	add	crc_3, edx
	add	crc_3, edi
	mov	[sth], edx
	mov	byte ptr [ebx], dl
	inc	esi
	jmp	nextpl

baddata:
	cmp	skipdifdata, 0
	jne	belowbaddata

	pushad
	mov	eax, [settings]
	and	eax, SET_BADDATACONFIRM
	je	afterbaddatamessage
	push	MB_ICONWARNING or MB_YESNO or MB_DEFBUTTON2
	push	offset WarningCaption
	push	offset BadDataMessage
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDYES
	jne	freeit
    afterbaddatamessage:
	popad
	mov	skipdifdata, 1
	jmp	belowbaddata











    after_patch:

	push	hfile3_
	call	SetEndOfFile

	mov	eax, [crc_1]			;compare the computed crcs with stored ones
	mov	ebx, [Headold.o_crc1]
       cmp	pscriptold, 1
       je	crccompare1
	mov	ebx, [Head_.crc1]
       crccompare1:
	cmp	eax, ebx
	je	below1
	mov	eax, [settings]
	and	eax, SET_BADCRCOCONFIRM
	je	below1
	push	MB_ICONWARNING or MB_YESNO or MB_DEFBUTTON2
	push	offset WarningCaption
	push	offset BadCRCoMessage
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDYES
	jne	freeit
below1:
	mov	eax, [crc_2]
	mov	ebx, [Headold.o_crc2]
       cmp	pscriptold, 1
       je	crccompare2
	mov	ebx, [Head_.crc2]
       crccompare2:
	cmp	eax, ebx
	je	below2
	mov	eax, [settings]
	and	eax, SET_BADCRCNCONFIRM
	je	below2
	push	MB_ICONWARNING or MB_YESNO or MB_DEFBUTTON2
	push	offset WarningCaption
	push	offset BadCRCnMessage
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDYES
	jne	freeit
below2:

;-----------------------------------Finish the file (disk)----------------------------------
	;set the new file's time to the time of the old file if wanted
	mov	ebx, [settings]
	and	ebx, SET_USEOLDFILETIME
	jz	donthavefiletime
	push	offset fLastWriteTime
	push	offset fLastAccessTime
	push	offset fCreationTime
	push	[hfile3_]
	call	SetFileTime
    donthavefiletime:

	call	closefreeall

	;set the new file's attributes to the ones of the old file if wanted
	mov	ebx, [settings]
	and	ebx, SET_USEOLDATTRIBS
	jz	donthaveattribs
	push	[fAttributes]
	push	offset szFile2_
	call	SetFileAttributesA
    donthaveattribs:


	mov	eax, [settings]
	and	eax, SET_WRITTEN_INFO
	je	afterwritten_message
	push	MB_ICONINFORMATION
	push	offset MessageCaption
	push	offset FWrittenMessage
	push	[hwnd]
	call	MessageBoxA
    afterwritten_message:
	push	[hbutton]
	call	SetFocus
	jmp	noexit_

diskerror_:
	call	closefreeall
	push	offset szFile3_
	call	DeleteFileA

	push	MB_ICONHAND or MB_OK
	push	offset ErrorCaption
	push	offset DiskWriteErrorMessage
	push	[hwnd]
	call	MessageBoxA
	jmp	noexit_

cantopenfile1_:
	push	MB_ICONHAND or MB_RETRYCANCEL
	push	offset ErrorCaption
	push	offset CantOpen1_
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDCANCEL
	jne	openfile1_

	jmp	noexit_
cantopenfile2_:
	push	MB_ICONHAND or MB_RETRYCANCEL
	push	offset ErrorCaption
	push	offset CantOpen2_
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDCANCEL
	jne	openfile2_

	call	closefreeall
	jmp	noexit_
cantopenfile3_:
	push	MB_ICONHAND or MB_OKCANCEL
	push	offset ErrorCaption
	push	offset CantOpen3_
	push	[hwnd]
	call	MessageBoxA
	cmp	eax, IDCANCEL
	jne	getfile3_

	call	closefreeall
	jmp	noexit_

badheader:
	push	hfile1_
	call	CloseHandle

	push	MB_ICONHAND or MB_OK
	push	offset ErrorCaption
	push	offset BadHeaderMessage
	push	[hwnd]
	call	MessageBoxA
	and	canwrite_, 1011b
	or	canwrite_, 1000b
	jmp	noexit_

badversion:
	push	hfile1_
	call	CloseHandle

	push	MB_ICONHAND or MB_OK
	push	offset ErrorCaption
	push	offset BadVersionMessage
	push	[hwnd]
	call	MessageBoxA
	and	canwrite_, 1011b
	or	canwrite_, 1000b
	jmp	noexit_

freeit:
	call	closefreeall
	push	offset szFile3_
	call	DeleteFileA

	and	canwrite_, 1011b
	or	canwrite_, 1000b
	jmp	noexit_
noexit:					;(un)graying for mode 1
	mov	ecx, offset canwrite
	jmp	noexit_do
noexit_:				;(un)graying for mode 2
	mov	ecx, offset canwrite_
noexit_do:
	mov	eax, [ecx]
	and	eax, 1000b
	or	eax, eax
	je	_noexit

	xor	dword ptr [ecx], 1000b

	mov	eax, MF_ENABLED
	xor	ebx, ebx
	inc	ebx		;enable
	cmp	dword ptr [ecx], 0111b
	je	enabled
	mov	eax, MF_GRAYED
	dec	ebx		;disable
enabled:
	or	eax, MF_STRING
	push	ebx
	push	hbutton
	push	eax
	push	IDM_WRITE
	push	hfilemenu
	call	EnableMenuItem
	call	EnableWindow
_noexit:
	ret
;noexit for dropfiles calling
drop_noexit:
	xor	canwrite, 1000b
	mov	ebx, canwrite
	jmp	drop_noexit_do
drop_noexit_:				;(un)graying for mode 2
	xor	canwrite_, 1000b
	mov	ebx, canwrite_
drop_noexit_do:
	cmp	ebx, 0111b
	jne	drop__noexit

	push	MF_ENABLED or MF_STRING
	push	IDM_WRITE
	push	hfilemenu
	call	EnableMenuItem

	push	1
	push	hbutton
	call	EnableWindow

drop__noexit:
	jmp	continuemsgloop

WndProc          endp
public WndProc
